/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.esign.ESignConfigService;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.ObtainSignLink;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.ResultUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SignTaskClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.SignTaskActorGetUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.SignTaskActorGetUrlRes;

public class FddObtainSignLink
extends FddBaseService<FddConfig>
implements ObtainSignLink {
    @Override
    public SignRespParam getHandSignUrl(String contractNo, SignReqParam signReqParam) {
        SignRespParam signRespParam = new SignRespParam(contractNo);
        DynamicObject contTplDyo = ESignConfigService.getDynamiTplDyo(signReqParam);
        String signType = contTplDyo.getString("signtype");
        if ("2".equals(signType) || "3".equals(signType)) {
            SignFlowService signFlowService = new SignFlowService();
            DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
            Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
            String signUrl = signFlowExtMap.get("personSignUrl");
            if (!HRStringUtils.isEmpty((String)signUrl)) {
                signRespParam.setHandSignUrl(signUrl);
            } else {
                signUrl = this.getPersonSignUrl(signType, signFlowExtMap.get("signTaskId"), signReqParam);
                if (!HRStringUtils.isEmpty((String)signUrl)) {
                    signRespParam.setHandSignUrl(signUrl);
                    signFlowExtMap.put("personSignUrl", signUrl);
                    signFlowService.saveExtMap(contractNo, signFlowExtMap);
                }
            }
        }
        return signRespParam;
    }

    private String getPersonSignUrl(String signType, String signTaskId, SignReqParam signReqParam) {
        if ("2".equals(signType) || "3".equals(signType)) {
            OpenApiClient openApiClient = this.getOpenApiClientByContractNo(signReqParam.getContractNo());
            SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
            String accessToken = FddServiceHelper.getAccessToken(openApiClient);
            SignTaskActorGetUrlReq signTaskActorGetUrlReq = new SignTaskActorGetUrlReq();
            signTaskActorGetUrlReq.setActorId("person");
            signTaskActorGetUrlReq.setRedirectUrl(signReqParam.getHandSignFrontUrl());
            signTaskActorGetUrlReq.setSignTaskId(signTaskId);
            signTaskActorGetUrlReq.setAccessToken(accessToken);
            BaseRes res = signTaskClient.signTaskActorGetUrl(signTaskActorGetUrlReq);
            ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
            if (res.isSuccess()) {
                return ((SignTaskActorGetUrlRes)res.getData()).getActorSignTaskUrl();
            }
            throw new KDBizException("get getHandSignUrl error, " + res.getMsg());
        }
        return null;
    }
}

