/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.mock.FddMock;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.DealUtil;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.SealUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.ServiceClient;
import kd.hr.hrcs.esign3rd.fadada.v51.res.service.AccessTokenRes;

public class FddServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(FddServiceHelper.class);
    private static final int CACHE_TIMEOUT = 600;

    public static String getAccessToken(OpenApiClient openApiClient) throws KDBizException {
        String cacheKey = FddServiceHelper.getCacheKey(openApiClient);
        String accessToken = (String)HRAppCache.get((String)"hrcs").get(cacheKey, String.class);
        if (HRStringUtils.isEmpty((String)accessToken)) {
            ResponseData accessTokenResp = FddServiceHelper.getAccessTokenResp(openApiClient);
            if (accessTokenResp.isFail()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7535\u5b50\u7b7e\u670d\u52a1\u5546\u96c6\u6210\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u5148\u5230\u83dc\u5355\u201cHR\u901a\u7528\u670d\u52a1>HR\u7535\u5b50\u7b7e\u7ba1\u7406\u5e73\u53f0>\u7535\u5b50\u7b7e\u670d\u52a1\u5546\u201d\u68c0\u67e5\u53c2\u6570\u914d\u7f6e\u3002", (String)HrcsBusinessRes.FddServiceHelper_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            accessToken = (String)accessTokenResp.getData();
            HRAppCache.get((String)"hrcs").put(cacheKey, (Object)accessToken, 600);
        }
        return accessToken;
    }

    public static ResponseData getAccessTokenResp(OpenApiClient openApiClient) {
        try {
            ServiceClient serviceClient = new ServiceClient(openApiClient);
            if (SealUtil.IS_DEV_LOCAL_ENV) {
                ResponseData<String> responseData = ResponseData.success(FddMock.getAccessToken(openApiClient));
                return responseData;
            }
            ResponseData responseData = DealUtil.execute("getAccessToken", null, () -> serviceClient.getAccessToken(), openApiClient);
            if (responseData.isFail()) {
                return responseData;
            }
            BaseRes res = (BaseRes)responseData.getData();
            responseData.setData(((AccessTokenRes)res.getData()).getAccessToken());
            return responseData;
        }
        catch (Exception e) {
            ResponseData responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u83b7\u53d6accessToken\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)HrcsBusinessRes.FddServiceHelper_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd getAccessToken execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    private static String getCacheKey(OpenApiClient openApiClient) {
        return "fdd" + openApiClient.getAppId();
    }
}

