/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.esign3rd.fadada.enums.seal.SealCategoryTypeEnum;

public enum SealTypeMappingEnum {
    OFFICIAL_SEAL(SealCategoryTypeEnum.OFFICIAL_SEAL, "1010_S"),
    CONTRACT_SEAL(SealCategoryTypeEnum.CONTRACT_SEAL, "1020_S"),
    HR_SEAL(SealCategoryTypeEnum.HR_SEAL, "1030_S"),
    FINANCIAL_SEAL(SealCategoryTypeEnum.FINANCIAL_SEAL, "1040_S"),
    LEGAL_REPRESENTATIVE_SEAL(SealCategoryTypeEnum.LEGAL_REPRESENTATIVE_SEAL, "1060_S"),
    OTHER(SealCategoryTypeEnum.OTHER, "1050_S");

    private final SealCategoryTypeEnum fddSealTypeEnum;
    private final String sealType;
    private static final Set<String> sealTypes;
    private static Map<String, Long> sealTypeMappingIds;

    public static Set<String> getAllSealTypes() {
        return sealTypes;
    }

    public static Long getSealTypeId(String number) {
        return sealTypeMappingIds.get(number);
    }

    private SealTypeMappingEnum(SealCategoryTypeEnum fddSealTypeEnum, String sealType) {
        this.fddSealTypeEnum = fddSealTypeEnum;
        this.sealType = sealType;
    }

    public static SealCategoryTypeEnum findFddSealTypeEnum(String sealType) {
        for (SealTypeMappingEnum enu : SealTypeMappingEnum.values()) {
            if (!enu.sealType.equals(sealType)) continue;
            return enu.fddSealTypeEnum;
        }
        throw new KDBizException(new ErrorCode("findFddSealTypeError", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u83b7\u53d6\u6cd5\u5927\u5927SealCategoryTypeEnum\u5931\u8d25\uff0c\u672a\u627e\u5230sealType\u201c%s\u201d\u5bf9\u5e94\u5173\u7cfb\u3002", (String)HrcsBusinessRes.SealTypeMappingEnum_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), sealType)), new Object[0]);
    }

    public static String tranSealType(String fddSealType) {
        for (SealTypeMappingEnum enu : SealTypeMappingEnum.values()) {
            if (!enu.fddSealTypeEnum.getCategoryType().equals(fddSealType)) continue;
            return enu.sealType;
        }
        throw new KDBizException(new ErrorCode("tranSealTypeError", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8f6c\u6362\u5370\u7ae0\u7c7b\u578b\u5931\u8d25\uff0cfddSealType\u3010%s\u3011\u5bf9\u5e94\u5173\u7cfb\uff01", (String)HrcsBusinessRes.SealTypeMappingEnum_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), fddSealType)), new Object[0]);
    }

    public static boolean isLegalRepresentativeSeal(String sealType) {
        return SealTypeMappingEnum.LEGAL_REPRESENTATIVE_SEAL.fddSealTypeEnum.getCategoryType().equals(sealType);
    }

    static {
        sealTypes = new HashSet<String>(6);
        sealTypeMappingIds = new HashMap<String, Long>(6);
        for (SealTypeMappingEnum enu : SealTypeMappingEnum.values()) {
            sealTypes.add(enu.sealType);
        }
        Object[] dynamicObjects = ESignDBServiceUtil.hrSealType.queryOriginalArray("id,number", new QFilter[]{new QFilter("number", "in", sealTypes)});
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            sealTypeMappingIds = Arrays.stream(dynamicObjects).collect(Collectors.toMap(item -> item.getString("number"), item -> item.getLong("id")));
        }
    }
}

