/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.res;

import java.io.Serializable;
import kd.hr.hrcs.bussiness.service.esign.res.ResCodeEnum;
import org.apache.commons.lang3.StringUtils;

public class ResponseData<T>
implements Serializable {
    private static final long serialVersionUID = -385342406219296699L;
    private static int invokeFailCode = 99999;
    private static int resFailCode = 99998;
    private int code;
    private String msg;
    private Long timestamp;
    private String callBackKey;
    private String callBackKeyDetail;
    private T data;

    public ResponseData(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.timestamp = System.currentTimeMillis();
        this.data = data;
    }

    public ResponseData(int code, String msg, T data, String callBackKey, String callBackKeyDetail) {
        this(code, msg, data);
        this.callBackKey = callBackKey;
        this.callBackKeyDetail = callBackKeyDetail;
    }

    public static <T> ResponseData<T> success() {
        return ResponseData.success(null);
    }

    public static <T> ResponseData<T> success(T data) {
        return new ResponseData<T>(ResCodeEnum.SUCCESS.getCode(), ResCodeEnum.SUCCESS.getMsg(), data);
    }

    public static <T> ResponseData<T> success(T data, String callBackKey, String callBackKeyDetail) {
        return new ResponseData<T>(ResCodeEnum.SUCCESS.getCode(), ResCodeEnum.SUCCESS.getMsg(), data, callBackKey, callBackKeyDetail);
    }

    public static <T> ResponseData<T> fail() {
        return ResponseData.fail(null);
    }

    public static <T> ResponseData<T> fail(T data) {
        return new ResponseData<T>(ResCodeEnum.FAIL.getCode(), ResCodeEnum.FAIL.getMsg(), data);
    }

    public static <T> ResponseData<T> fail(int code, String message) {
        return ResponseData.fail(code, message, null);
    }

    public static <T> ResponseData<T> fail(int code, String message, T data) {
        return new ResponseData<T>(code, message, data);
    }

    public static <T> ResponseData<T> invokeFail(String message) {
        return ResponseData.fail(invokeFailCode, message);
    }

    public static <T> ResponseData<T> resFail(String message, T data) {
        return new ResponseData<T>(resFailCode, message, data);
    }

    public static <T> ResponseData<T> fail(String code, String message, T data) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new ResponseData<T>(resFailCode, message, data);
        }
        return new ResponseData<T>(Integer.parseInt(code), message, data);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return ResCodeEnum.SUCCESS.getCode() == this.code;
    }

    public boolean isFail() {
        return !this.isSuccess();
    }

    public String getMsg() {
        return this.msg;
    }

    public String getCallBackKey() {
        return this.callBackKey;
    }

    public void setCallBackKey(String callBackKey) {
        this.callBackKey = callBackKey;
    }

    public String getCallBackKeyDetail() {
        return this.callBackKeyDetail;
    }

    public void setCallBackKeyDetail(String callBackKeyDetail) {
        this.callBackKeyDetail = callBackKeyDetail;
    }
}

