/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignAppCfgEditPage;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOAuthUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignSPMgrUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ESignAppCfgUtil
implements ESignAppCfgEditPage {
    private static final Log LOGGER = LogFactory.getLog(ESignAppCfgUtil.class);

    public static String getOwnerOpenCorpId(Long spId, Long corporateId) {
        LOGGER.info("getOwnerOpenCorpId reqParams:spId={}  corporateId={}", (Object)spId, (Object)corporateId);
        DynamicObject appCfgDyn = ESignAppCfgUtil.getAppCfgDyn(spId, corporateId);
        if (ObjectUtils.isEmpty((Object)appCfgDyn)) {
            LOGGER.warn("getTargetAppCfgDyn\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7535\u5b50\u7b7e\u7ae0\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u3002reqParams: spId={} corporateId={}", (Object)spId, (Object)corporateId);
            DynamicObject coAuthDyn = ESignCOAuthUtil.getCOAuthDyn(spId, corporateId);
            if (ObjectUtils.isEmpty((Object)coAuthDyn)) {
                LOGGER.warn("getTargetAppCfgDyn\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5df2\u6388\u6743\u4f01\u4e1a\u4fe1\u606f\u3002reqParams: spId={} corporateId={}", (Object)spId, (Object)corporateId);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u6388\u6743\uff1a\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e0b\u672a\u5b8c\u6210\u4f01\u4e1a\u4fe1\u606f\u6ce8\u518c\u53ca\u5e94\u7528\u6388\u6743\uff0c\u65e0\u6cd5\u8fdb\u884c\u7535\u5b50\u5408\u540c\u7b7e\u7f72\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)HrcsBusinessRes.ESignAppCfgUtil_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), ESignSPMgrUtil.getCorpName(corporateId), ESignSPMgrUtil.getSpName(spId)));
            }
            return coAuthDyn.getString("thirdcompanyid");
        }
        return appCfgDyn.getString("thirdcorpid");
    }

    public static ESignAppInfo getOnlineAppInfoByCorpId(Long corporateId) {
        DynamicObject onlineESignSP = ESignSPMgrUtil.getOnlineESignSPThrowNonExist();
        return ESignAppCfgUtil.obtainESignSPAppInfo(onlineESignSP.getLong("id"), corporateId);
    }

    public static ESignAppInfo getESignAppInfo(Object configId) {
        DynamicObject appCfgDyn = ESignDBServiceUtil.eSignAppCfgService.loadSingle(configId);
        return ESignAppCfgUtil.getESignAppInfo("", "", String.valueOf(configId), appCfgDyn);
    }

    public static ESignAppInfo obtainESignSPAppInfo(Long spId, Long corporateId) {
        DynamicObject appCfgDyn = ESignAppCfgUtil.getTargetAppCfgDyn(spId, corporateId);
        return ESignAppCfgUtil.getESignAppInfo(String.valueOf(spId), String.valueOf(corporateId), "", appCfgDyn);
    }

    private static DynamicObject getAppCfgDyn(Long spId, Long corporateId) {
        LOGGER.warn("obtainESignSPAppInfo reqParams: spId={} corporateId={}", (Object)spId, (Object)corporateId);
        QFilter spIdQFilter = new QFilter("esignsp", "=", (Object)spId);
        QFilter corporateIdQFilter = new QFilter("corporate", "=", (Object)corporateId);
        return ESignDBServiceUtil.eSignAppCfgService.loadDynamicObject(new QFilter[]{spIdQFilter, corporateIdQFilter});
    }

    public static DynamicObject getTargetAppCfgDyn(Long spId, Long corporateId) {
        DynamicObject appCfgDyn = ESignAppCfgUtil.getAppCfgDyn(spId, corporateId);
        if (ObjectUtils.isEmpty((Object)appCfgDyn)) {
            LOGGER.warn("getTargetAppCfgDyn\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7535\u5b50\u7b7e\u7ae0\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u3002reqParams: spId={} corporateId={}", (Object)spId, (Object)corporateId);
            DynamicObject coAuthDyn = ESignCOAuthUtil.getCOAuthDyn(spId, corporateId);
            if (ObjectUtils.isEmpty((Object)coAuthDyn)) {
                LOGGER.warn("getTargetAppCfgDyn\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5df2\u6388\u6743\u4f01\u4e1a\u4fe1\u606f\u3002reqParams: spId={} corporateId={}", (Object)spId, (Object)corporateId);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u6388\u6743\uff1a\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e0b\u672a\u5b8c\u6210\u4f01\u4e1a\u4fe1\u606f\u6ce8\u518c\u53ca\u5e94\u7528\u6388\u6743\uff0c\u65e0\u6cd5\u8fdb\u884c\u7535\u5b50\u5408\u540c\u7b7e\u7f72\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)HrcsBusinessRes.ESignAppCfgUtil_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), ESignSPMgrUtil.getCorpName(corporateId), ESignSPMgrUtil.getSpName(spId)));
            }
            appCfgDyn = ESignAppCfgUtil.getAppCfgDyn(spId, coAuthDyn.getLong("authapp.corporate.id"));
        }
        return appCfgDyn;
    }

    private static ESignAppInfo getESignAppInfo(String spId, String corporateId, String configId, DynamicObject appCfgDyn) {
        if (ObjectUtils.isEmpty((Object)appCfgDyn)) {
            LOGGER.warn("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7535\u5b50\u7b7e\u7ae0\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u3002reqParams: spId={} corporateId={} configId={}", new Object[]{spId, corporateId, configId});
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7535\u5b50\u7b7e\u670d\u52a1\u8fd8\u672a\u7ef4\u62a4\u8be5\u96c6\u6210\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u83dc\u5355\u201cHR\u901a\u7528\u670d\u52a1>HR\u7535\u5b50\u7b7e\u7ba1\u7406\u5e73\u53f0>\u7535\u5b50\u7b7e\u670d\u52a1\u5546>\u96c6\u6210\u5e94\u7528\u914d\u7f6e\u201d\u5b8c\u6210\u7ef4\u62a4\u7535\u5b50\u7b7e\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u518d\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)HrcsBusinessRes.ESignAppCfgUtil_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)spId)) {
            spId = appCfgDyn.getString("esignsp.id");
        }
        if (ObjectUtils.isEmpty((Object)corporateId)) {
            corporateId = appCfgDyn.getString("corporate.id");
        }
        if (ObjectUtils.isEmpty((Object)configId)) {
            configId = appCfgDyn.getString("id");
        }
        ESignAppInfo eSignAppInfo = ESignAppInfo.build(spId, corporateId, appCfgDyn.getString("appid"), appCfgDyn.getString("appsecret"), appCfgDyn.getString("serverurl"), appCfgDyn.getString("thirdcorpid"), configId, appCfgDyn.getDate("modifytime").getTime(), appCfgDyn.getString("appsecreten"));
        DynamicObjectCollection entryExtParams = appCfgDyn.getDynamicObjectCollection("entryentity");
        if (entryExtParams != null && entryExtParams.size() > 0) {
            Map<String, String> extParams = entryExtParams.stream().collect(Collectors.toMap(dyn -> dyn.getString("key"), dyn -> dyn.getString("value")));
            eSignAppInfo.setExtParams(extParams);
        }
        return eSignAppInfo;
    }

    public static Long getESignAppId(String appNumber) {
        DynamicObject dynamicObject = ESignDBServiceUtil.eSignAppCfgService.queryOriginalOne("id", new QFilter("number", "=", (Object)appNumber));
        return dynamicObject.getLong("id");
    }

    public static String getCorporateNumber(String appNumber) {
        Object[] corporateDyns = ESignDBServiceUtil.eSignAppCfgService.query("corporate.number", new QFilter[]{new QFilter("number", "=", (Object)appNumber)});
        if (ArrayUtils.isNotEmpty((Object[])corporateDyns)) {
            return ((String[])Arrays.stream(corporateDyns).map(item -> item.getString("corporate.number")).distinct().toArray(String[]::new))[0];
        }
        return "";
    }

    public static Long getCorpIdByAppNumber(String appNumber) {
        Object[] corporateDyns = ESignDBServiceUtil.eSignAppCfgService.query("corporate.id", new QFilter[]{new QFilter("number", "=", (Object)appNumber)});
        if (ArrayUtils.isNotEmpty((Object[])corporateDyns)) {
            return ((Long[])Arrays.stream(corporateDyns).map(item -> item.getLong("corporate.id")).distinct().toArray(Long[]::new))[0];
        }
        return null;
    }

    public static Long getCorporateId(Long configId) {
        Object[] corporateDyns = ESignDBServiceUtil.eSignAppCfgService.query("corporate.id", new QFilter[]{new QFilter("id", "=", (Object)configId)});
        if (ArrayUtils.isNotEmpty((Object[])corporateDyns)) {
            return ((Long[])Arrays.stream(corporateDyns).map(item -> item.getLong("corporate.id")).distinct().toArray(Long[]::new))[0];
        }
        return null;
    }

    public static Long getFddCorpIdByAppId(String appId) {
        QFilter fddSpIdQFilter = HRQFilterHelper.buildEql((String)"esignsp", (Object)1732802837861139456L);
        QFilter appIdQFilter = HRQFilterHelper.buildEql((String)"appid", (Object)appId);
        QFilter enableQFilter = HRQFilterHelper.buildEnable();
        DynamicObject corporateDyn = ESignDBServiceUtil.eSignAppCfgService.queryOriginalOne("corporate.id", new QFilter[]{fddSpIdQFilter, appIdQFilter, enableQFilter});
        if (ObjectUtils.isEmpty((Object)corporateDyn)) {
            return null;
        }
        return corporateDyn.getLong("corporate.id");
    }

    public static String getEnableAppNumber(String appId, Object spId) {
        DynamicObject appCfgDyn = ESignDBServiceUtil.eSignAppCfgService.queryOriginalOne("number", new QFilter[]{new QFilter("appid", "=", (Object)appId), new QFilter("esignsp", "=", spId), new QFilter("enable", "=", (Object)appId)});
        if (ObjectUtils.isNotEmpty((Object)appCfgDyn)) {
            return appCfgDyn.getString("number");
        }
        return "";
    }

    public static Set<Long> getCorporateIdsByTempSPId(String tempRelSpId) {
        Object[] corporateDyns = ESignDBServiceUtil.eSignAppCfgService.query("corporate.number", new QFilter[]{HRQFilterHelper.buildEql((String)"temprelspid", (Object)tempRelSpId)});
        if (ArrayUtils.isNotEmpty((Object[])corporateDyns)) {
            return Arrays.stream(corporateDyns).map(item -> item.getLong("corporate.id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }

    public static Set<Long> getCorporateIdsBySPId(Long spId) {
        Object[] corporateDyns = ESignDBServiceUtil.eSignAppCfgService.query("corporate.number", new QFilter[]{HRQFilterHelper.buildEql((String)"esignsp", (Object)spId)});
        if (ArrayUtils.isNotEmpty((Object[])corporateDyns)) {
            return Arrays.stream(corporateDyns).map(item -> item.getLong("corporate.id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }
}

