/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.util;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignCOSealEditPage;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOAuthUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ESignCOSealMgrUtil
implements ESignCOSealEditPage {
    private static final Log LOGGER = LogFactory.getLog(ESignCOSealMgrUtil.class);

    public static boolean isExistsSeal(Object spId, Object corporateId) {
        QFilter spQFilter = new QFilter("esignsp", "=", spId);
        QFilter corpQFilter = new QFilter("corporate", "=", corporateId);
        return ESignDBServiceUtil.eSignCOSealService.isExists(new QFilter[]{spQFilter, corpQFilter});
    }

    public static Long getCorporateId(String corporateNumber) {
        DynamicObject dynamicObject = ESignDBServiceUtil.hbssLawentityService.queryOriginalOne("id", new QFilter("number", "=", (Object)corporateNumber));
        return dynamicObject.getLong("id");
    }

    public static DynamicObject[] queryAllSeal(Object spId, Object corporateId) {
        QFilter spQFilter = new QFilter("esignsp", "=", spId);
        QFilter corpQFilter = new QFilter("corporate_id", "=", corporateId);
        QFilter enableQFilter = new QFilter("enable", "in", (Object)new String[]{"1", "0"});
        return ESignDBServiceUtil.eSignCOSealService.loadDynamicObjectArray(new QFilter[]{spQFilter, corpQFilter, enableQFilter});
    }

    public static DynamicObject querySealBySealType(Object spId, Object corporateId, String sealType) {
        QFilter spQFilter = new QFilter("esignsp", "=", spId);
        QFilter corpQFilter = new QFilter("corporate", "=", corporateId);
        QFilter sealTypeQFilter = new QFilter("sealtype.number", "=", (Object)sealType);
        DynamicObject dynamicObject = ESignDBServiceUtil.eSignCOSealService.queryOriginalOne(new QFilter[]{spQFilter, corpQFilter, sealTypeQFilter});
        if (dynamicObject == null) {
            throw new KDBizException("please cofig seal");
        }
        return dynamicObject;
    }

    public static DynamicObject querySealBySealType(Object spId, Object corporateId, Long sealTypeId) {
        QFilter spQFilter = new QFilter("esignsp", "=", spId);
        QFilter corpQFilter = new QFilter("corporate", "=", corporateId);
        QFilter sealTypeQFilter = new QFilter("sealtype.id", "=", (Object)sealTypeId);
        QFilter enableQFilter = HRQFilterHelper.buildEnable();
        DynamicObject dynamicObject = ESignDBServiceUtil.eSignCOSealService.queryOriginalOne(new QFilter[]{spQFilter, corpQFilter, sealTypeQFilter, enableQFilter});
        if (dynamicObject == null) {
            throw new KDBizException("please cofig seal");
        }
        return dynamicObject;
    }

    public static Pair<String, Set<String>> getCorporateNumbers(Long spId, String appNumber) {
        String mainCorporateNumber = ESignAppCfgUtil.getCorporateNumber(appNumber);
        if (StringUtils.isNotBlank((CharSequence)mainCorporateNumber)) {
            HashSet<String> corporateNumbers = new HashSet<String>(8);
            corporateNumbers.add(mainCorporateNumber);
            DynamicObjectCollection eSignCOAuthDyns = ESignCOAuthUtil.getCOAuthDyns(spId, appNumber);
            if (ObjectUtils.isNotEmpty((Object)eSignCOAuthDyns)) {
                eSignCOAuthDyns.forEach(item -> corporateNumbers.add(item.getString("lawentity.number")));
            }
            return Pair.of((Object)mainCorporateNumber, corporateNumbers);
        }
        return Pair.of((Object)"", new HashSet(0));
    }

    /*
     * Exception decompiling
     */
    public static String uploadUrl(String picFileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream getInputStream(String netUrl) {
        try {
            URL url = new URL(netUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            return conn.getInputStream();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("get InputStream fail", "get InputStream fail, netUrl=" + netUrl), new Object[0]);
        }
    }

    public static DynamicObject[] queryAuthAllSeals(Long spId, Long corporateId, Long mainCorporateId) {
        QFilter spQFilter = new QFilter("esignsp", "=", (Object)spId);
        QFilter authCorpQFilter = new QFilter("authcompany", "=", (Object)mainCorporateId);
        QFilter corpQFilter = new QFilter("seal.corporate.id", "=", (Object)corporateId);
        return ESignDBServiceUtil.eSignSealAuthService.loadDynamicObjectArray(new QFilter[]{spQFilter, authCorpQFilter, corpQFilter});
    }

    public static Map<String, DynamicObject> getAuthAllSeals(Long spId, Long corporateId, Long mainCorpId, String openCorpId, String businessId) {
        Object[] authedSeals = ESignCOSealMgrUtil.queryAuthAllSeals(spId, corporateId, mainCorpId);
        HashMap<String, DynamicObject> dbFreeSignInfos = new HashMap<String, DynamicObject>(0);
        if (ArrayUtils.isNotEmpty((Object[])authedSeals)) {
            for (Object authedSeal : authedSeals) {
                String key = ESignCOSealMgrUtil.buildFreeSignInfoKey(openCorpId, authedSeal.getString("seal.sealid"), businessId);
                DynamicObject preDyn = (DynamicObject)dbFreeSignInfos.get(key);
                if (ObjectUtils.isNotEmpty((Object)preDyn)) {
                    Date endDate = authedSeal.getDate("endtime");
                    Date preEndDate = preDyn.getDate("endtime");
                    if (ObjectUtils.isEmpty((Object)preEndDate) || ObjectUtils.isEmpty((Object)endDate)) {
                        if (ObjectUtils.isEmpty((Object)preEndDate)) continue;
                        dbFreeSignInfos.put(key, (DynamicObject)authedSeal);
                        continue;
                    }
                    if (endDate.getTime() - preEndDate.getTime() <= 0L) continue;
                    dbFreeSignInfos.put(key, (DynamicObject)authedSeal);
                    continue;
                }
                dbFreeSignInfos.put(key, (DynamicObject)authedSeal);
            }
        }
        return dbFreeSignInfos;
    }

    public static Map<String, DynamicObject> getAuthSeals(Long spId, Long corporateId, Long mainCorpId, String openCorpId, String businessId, Set<String> targetSealIds) {
        if (CollectionUtils.isEmpty(targetSealIds)) {
            return new HashMap<String, DynamicObject>(0);
        }
        Object[] authedSeals = ESignCOSealMgrUtil.queryAuthAllSeals(spId, corporateId, mainCorpId);
        HashMap<String, DynamicObject> dbFreeSignInfos = new HashMap<String, DynamicObject>(0);
        if (ArrayUtils.isNotEmpty((Object[])authedSeals)) {
            for (Object authedSeal : authedSeals) {
                if (!targetSealIds.contains(authedSeal.getString("seal.sealid"))) continue;
                String key = ESignCOSealMgrUtil.buildFreeSignInfoKey(openCorpId, authedSeal.getString("seal.sealid"), businessId);
                DynamicObject preDyn = (DynamicObject)dbFreeSignInfos.get(key);
                if (ObjectUtils.isNotEmpty((Object)preDyn)) {
                    Date endDate = authedSeal.getDate("endtime");
                    Date preEndDate = preDyn.getDate("endtime");
                    if (ObjectUtils.isEmpty((Object)preEndDate) || ObjectUtils.isEmpty((Object)endDate)) {
                        if (ObjectUtils.isEmpty((Object)preEndDate)) continue;
                        dbFreeSignInfos.put(key, (DynamicObject)authedSeal);
                        continue;
                    }
                    if (endDate.getTime() - preEndDate.getTime() <= 0L) continue;
                    dbFreeSignInfos.put(key, (DynamicObject)authedSeal);
                    continue;
                }
                dbFreeSignInfos.put(key, (DynamicObject)authedSeal);
            }
        }
        return dbFreeSignInfos;
    }

    public static Set<String> queryAuthAllSealIds(Long spId, Long corporateId, Long mainCorporateId) {
        Object[] authedSeals = ESignCOSealMgrUtil.queryAuthAllSeals(spId, corporateId, mainCorporateId);
        Set<String> authedSealIds = new HashSet<String>(0);
        if (ArrayUtils.isNotEmpty((Object[])authedSeals)) {
            authedSealIds = Arrays.stream(authedSeals).map(item -> item.getString("seal.sealid")).collect(Collectors.toSet());
        }
        return authedSealIds;
    }

    public static int countAuthSeal(String sealId) {
        QFilter sealIdQFilter = HRQFilterHelper.buildEql((String)"seal.sealid", (Object)sealId);
        QFilter authedQFilter = new QFilter("authstatus", "=", (Object)"1");
        int count = ESignDBServiceUtil.eSignSealAuthService.count("hrcs_esignsealauth", new QFilter[]{sealIdQFilter, authedQFilter});
        return count;
    }

    @Deprecated
    public static String buildFreeSignInfoKey(String openCorpId, String sealId, String businessId, Date startTime, Date endTime) {
        return openCorpId.concat("&").concat(sealId).concat("&").concat(businessId).concat("&").concat(HRDateTimeUtils.format((Date)startTime, (String)DatePattern.YYYY_MM_DD_PURE.getValue())).concat("&").concat(HRDateTimeUtils.format((Date)endTime, (String)DatePattern.YYYY_MM_DD_PURE.getValue()));
    }

    public static String buildFreeSignInfoKey(String openCorpId, String sealId, String businessId) {
        return openCorpId.concat("&").concat(sealId).concat("&").concat(businessId);
    }
}

