/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.util;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignSPMgrEditPage;
import kd.hr.hrcs.bussiness.service.esign.enu.ServiceEnum;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ESignSPMgrUtil
implements ESignSPMgrEditPage {
    private static final Log LOGGER = LogFactory.getLog(ESignSPMgrUtil.class);
    public static final long CLOUD_FADADA_MASTER_ID = 1732814414484112384L;
    public static final long FADADA_MASTER_ID = 1732802837861139456L;
    public static final Set<Long> ignoreAppCfgApp = new HashSet<Long>();

    public static void registerIgnoreAppCfgApp(Long spPkId) {
        ignoreAppCfgApp.add(spPkId);
    }

    public static void doDebug(String name, DynamicObjectCollection entryEntitys, IFormView view) {
        boolean isFddCloud;
        if (view instanceof ListView) {
            BillList billList = (BillList)view.getControl("billlistap");
            Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
            isFddCloud = ESignSPMgrUtil.isFddCloud((Long)primaryKeyValues[0]);
        } else {
            isFddCloud = ESignSPMgrUtil.isFddCloud(view.getModel());
        }
        if (isFddCloud) {
            view.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u5728\u7ebf\u8c03\u8bd5\u3002", (String)HrcsBusinessRes.ESignSPMgrUtil_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), name));
            return;
        }
        LinkedHashMap<String, Boolean> debugResult = new LinkedHashMap<String, Boolean>(14);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)entryEntitys.get(i);
            String mustFlag = entryEntity.getString("mustflag");
            String plugin = entryEntity.getString("plugin");
            String srvName = entryEntity.getLocaleString("srvname").getLocaleValue();
            debugResult.put(srvName, true);
            if (!"1".equals(mustFlag) && !StringUtils.isNotBlank((CharSequence)plugin)) continue;
            String interfaceClas = entryEntity.getString("interface");
            if (StringUtils.isBlank((CharSequence)plugin)) {
                debugResult.put(srvName, false);
                continue;
            }
            try {
                Object obj = ReflectUtil.newInstance((String)plugin);
                Class classByInterFace = ServiceEnum.findClassByInterFace(interfaceClas);
                if (classByInterFace != null && classByInterFace.isAssignableFrom(obj.getClass())) continue;
                debugResult.put(srvName, false);
                continue;
            }
            catch (Exception e) {
                debugResult.put(srvName, false);
            }
        }
        ESignSPMgrUtil.showDebugResult(name, debugResult, view);
    }

    private static void showDebugResult(String spName, Map<String, Boolean> debugResult, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_esigndebug");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        Map customParams = showParameter.getCustomParams();
        customParams.put("spname", spName);
        customParams.put("results", JSON.toJSONString(debugResult));
        view.showForm(showParameter);
    }

    public static boolean isFdd(long pkId) {
        return 1732802837861139456L == pkId;
    }

    public static boolean isFddCloud(IDataModel model) {
        return ESignSPMgrUtil.isFddCloud((Long)model.getValue("id"));
    }

    public static boolean isFddCloud(long pkId) {
        return 1732814414484112384L == pkId;
    }

    public static boolean onlineSPIsFddCloud() {
        DynamicObject onlineESignSP = ESignSPMgrUtil.getOnlineESignSP();
        return onlineESignSP == null || ESignSPMgrUtil.isFddCloud((Long)onlineESignSP.getPkValue());
    }

    public static DynamicObject getOnlineESignSP() {
        return ESignDBServiceUtil.eSignSPMgrService.loadDynamicObject(HRQFilterHelper.buildEnable());
    }

    public static DynamicObject getOnlineESignSPThrowNonExist() {
        DynamicObject eSignOnlineSpDyn = ESignSPMgrUtil.getOnlineESignSP();
        if (eSignOnlineSpDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7535\u5b50\u7b7e\u670d\u52a1\u8fd8\u672a\u7ef4\u62a4\u7535\u5b50\u7b7e\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u83dc\u5355\u201cHR\u901a\u7528\u670d\u52a1>HR\u7535\u5b50\u7b7e\u7ba1\u7406\u5e73\u53f0>\u7535\u5b50\u7b7e\u53c2\u6570\u914d\u7f6e\u201d\u5b8c\u6210\u7ef4\u62a4\u7535\u5b50\u7b7e\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u518d\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)HrcsBusinessRes.ESignSPMgrUtil_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return eSignOnlineSpDyn;
    }

    public static Map<String, String> getESignSPSrvClazzInfos(Object eSignSPPkId) {
        DynamicObject spDyn = ESignSPMgrUtil.getSPDyn(eSignSPPkId);
        ESignSPMgrUtil.checkSPExist(eSignSPPkId, spDyn);
        DynamicObjectCollection eSignSPSrvClazzs = spDyn.getDynamicObjectCollection("entryentity");
        if (eSignSPSrvClazzs == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5382\u5546\u670d\u52a1\u7c7b\u6ce8\u518c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)HrcsBusinessRes.ESignSPMgrUtil_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return eSignSPSrvClazzs.stream().collect(Collectors.toMap(it -> it.getString("interface"), it -> it.getString("plugin")));
    }

    public static DynamicObjectCollection getESignSPAppInfos(Object eSignSPPkId) {
        DynamicObject spDyn = ESignSPMgrUtil.getSPDyn(eSignSPPkId);
        ESignSPMgrUtil.checkSPExist(eSignSPPkId, spDyn);
        return spDyn.getDynamicObjectCollection("entryentity1");
    }

    public static DynamicObjectCollection getESignSPEnableAppInfos(Object eSignSPPkId) {
        DynamicObject spDyn = ESignDBServiceUtil.eSignSPMgrService.loadDynamicObject(new QFilter[]{new QFilter("id", "=", eSignSPPkId), new QFilter("entryentity1.enable1", "=", (Object)"1")});
        if (ObjectUtils.isEmpty((Object)spDyn)) {
            return null;
        }
        DynamicObjectCollection dyns = spDyn.getDynamicObjectCollection("entryentity1");
        dyns.removeIf(item -> !"1".equals(item.getString("enable1")));
        return dyns;
    }

    public static Pair<ESignAppInfo, Map<String, String>> fetchESignSPCfg(Long eSignSPPkId, Long corporateId) {
        DynamicObject spDyn = ESignSPMgrUtil.getSPDyn(eSignSPPkId);
        ESignSPMgrUtil.checkSPExist(eSignSPPkId, spDyn);
        DynamicObjectCollection eSignSPSrvClazzs = spDyn.getDynamicObjectCollection("entryentity");
        if (eSignSPSrvClazzs == null) {
            LOGGER.warn("\u670d\u52a1\u7c7b\u6ce8\u518c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002eSignSPPkId={}", (Object)eSignSPPkId);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5382\u5546\u670d\u52a1\u7c7b\u6ce8\u518c\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)HrcsBusinessRes.ESignSPMgrUtil_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        Map<String, String> instanceMap = eSignSPSrvClazzs.stream().collect(Collectors.toMap(it -> it.getString("interface"), it -> it.getString("plugin")));
        ESignAppInfo eSignSPAppInfo = ESignAppCfgUtil.obtainESignSPAppInfo(eSignSPPkId, corporateId);
        return Pair.of((Object)eSignSPAppInfo, instanceMap);
    }

    private static DynamicObject getSPDyn(Object eSignSPPkId) {
        DynamicObject spDyn = ESignDBServiceUtil.eSignSPMgrService.queryOne(eSignSPPkId);
        ESignSPMgrUtil.checkSPExist(eSignSPPkId, spDyn);
        return spDyn;
    }

    private static void checkSPExist(Object eSignSPPkId, DynamicObject spDyn) {
        if (spDyn == null) {
            LOGGER.warn("\u5382\u5546\u4fe1\u606f\u4e0d\u5b58\u5728\u3002eSignSPPkId={}", eSignSPPkId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u5382\u5546\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)HrcsBusinessRes.ESignSPMgrUtil_4.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    public static Long getSpId(String spNumber) {
        DynamicObject dynamicObject = ESignDBServiceUtil.eSignSPMgrService.queryOriginalOne("id", new QFilter("number", "=", (Object)spNumber));
        return dynamicObject.getLong("id");
    }

    public static String getSpName(Object eSignSPPkId) {
        DynamicObject spDyn = ESignSPMgrUtil.getSPDyn(eSignSPPkId);
        ESignSPMgrUtil.checkSPExist(eSignSPPkId, spDyn);
        return spDyn.getString("name");
    }

    public static String getCorpName(Object corporateId) {
        DynamicObject corpDyn = ESignDBServiceUtil.hbssLawentityService.queryOne(corporateId);
        if (corpDyn == null) {
            LOGGER.warn("\u6cd5\u5f8b\u5b9e\u4f53\uff08\u4f01\u4e1a\uff09\u4fe1\u606f\u4e0d\u5b58\u5728\u3002corporateId={}", corporateId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)HrcsBusinessRes.ESignSPMgrUtil_5.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return corpDyn.getString("name");
    }

    public static Set<String> getExistAppESignSP() {
        Object[] eSignSPMgrDyn = ESignDBServiceUtil.eSignSPMgrService.query(new QFilter[]{QFilter.isNotNull((String)"entryentity1")});
        if (ArrayUtils.isNotEmpty((Object[])eSignSPMgrDyn)) {
            return Arrays.stream(eSignSPMgrDyn).map(item -> item.getString("id")).collect(Collectors.toSet());
        }
        return null;
    }

    public static Long getOnlineSpId() {
        DynamicObject eSignSPMgrDyn = ESignDBServiceUtil.eSignSPMgrService.queryOne(new QFilter[]{HRQFilterHelper.buildEnable()});
        if (ObjectUtils.isNotEmpty((Object)eSignSPMgrDyn)) {
            return eSignSPMgrDyn.getLong("id");
        }
        return null;
    }

    public static DynamicObjectCollection getAllEnableAppInfos() {
        DynamicObject[] spDynColl = ESignDBServiceUtil.eSignSPMgrService.loadDynamicObjectArray(new QFilter[0]);
        if (ObjectUtils.isEmpty((Object)spDynColl)) {
            return null;
        }
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        for (DynamicObject spDyn : spDynColl) {
            DynamicObjectCollection dyns = spDyn.getDynamicObjectCollection("entryentity1");
            dyns.removeIf(item -> "1".equals(item.getString("enable1")));
            dynColl.addAll((Collection)dyns);
        }
        return dynColl;
    }

    static {
        ignoreAppCfgApp.add(1732814414484112384L);
    }
}

