/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.formula;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.service.formula.enums.ScopeTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.function.DynCollHandler;
import kd.hr.hbp.common.util.HRListUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hrcs.bussiness.formula.FormulaDBHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class FuctionTypeHelper {
    private static final Log logger = LogFactory.getLog(FuctionTypeHelper.class);
    private static final HRBaseServiceHelper hrcsFunctiontypeDBHelper = HRBaseServiceHelper.create((String)"hrcs_functiontype");

    public static void dealHistoryData() {
        List<Long> needInitFunctionTypeIds = FuctionTypeHelper.queryNeedInitFunctionTypeIds();
        if (CollectionUtils.isEmpty(needInitFunctionTypeIds)) {
            logger.warn("\u9700\u8981\u5904\u7406\u7684\u51fd\u6570\u5206\u7c7b\u4e3a\u7a7a\uff0c\u9000\u51fa\u65b9\u6cd5");
            return;
        }
        Map<String, Set<String>> functiontypeMapBusinessfieldMap = FormulaDBHelper.queryFunctiontypeMapBusinessfield();
        if (MapUtils.isEmpty(functiontypeMapBusinessfieldMap)) {
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])needInitFunctionTypeIds.stream().map(item -> {
                DynamicObject dynamicObject = hrcsFunctiontypeDBHelper.generateEmptyDynamicObject();
                dynamicObject.set("id", item);
                dynamicObject.set("rgfscopetype", (Object)ScopeTypeEnum.GENERAL.getValue());
                return dynamicObject;
            }).distinct().toArray(DynamicObject[]::new)));
            return;
        }
        Map<String, Set<String>> businessFieldMapAppMap = FormulaDBHelper.queryBusinessFieldMapApp();
        if (MapUtils.isEmpty(businessFieldMapAppMap)) {
            logger.warn("\u51fd\u6570\u5206\u7c7b\u67e5\u8be2\u4e1a\u52a1\u9886\u57df\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u51fa\u65b9\u6cd5");
            return;
        }
        FuctionTypeHelper.dealHistoryData(functiontypeMapBusinessfieldMap, businessFieldMapAppMap);
    }

    public static void dealHistoryData(Map<String, Set<String>> functiontypeMapBusinessfieldMap, Map<String, Set<String>> businessFieldMapAppMap) {
        if (MapUtils.isEmpty(functiontypeMapBusinessfieldMap) || MapUtils.isEmpty(businessFieldMapAppMap)) {
            logger.warn("\u51fd\u6570\u5206\u7c7b\u67e5\u8be2\u4e1a\u52a1\u9886\u57df\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005\u51fd\u6570\u5206\u7c7b\u67e5\u8be2\u4e1a\u52a1\u9886\u57df\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u51fa\u65b9\u6cd5");
            return;
        }
        List<Long> hrComFunctionTypeIds = FuctionTypeHelper.queryHRComFunctionTypeIds();
        functiontypeMapBusinessfieldMap.forEach((pkId, value) -> {
            HashSet appIds;
            Throwable throwable;
            TXHandle txHandle;
            block17: {
                block18: {
                    block19: {
                        txHandle = TX.requiresNew();
                        throwable = null;
                        appIds = new HashSet(8);
                        value.forEach(businessFieldId -> {
                            Set subAppIds = (Set)businessFieldMapAppMap.get(businessFieldId);
                            Optional.ofNullable(subAppIds).ifPresent(apps -> appIds.addAll(subAppIds));
                        });
                        if (!CollectionUtils.isEmpty(appIds)) break block17;
                        logger.warn("\u51fd\u6570\u5206\u7c7b\u3010{}\u3011\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e2d\u65ad\u6b64\u6b21\u5faa\u73af\uff0c\u7ee7\u7eed\u5904\u7406\u4e0b\u4e2a\u51fd\u6570\u5206\u7c7b", pkId);
                        if (txHandle == null) break block18;
                        if (throwable == null) break block19;
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block18;
                    }
                    txHandle.close();
                }
                return;
            }
            try {
                try {
                    DynCollHandler dynCollHandler = () -> {
                        HashMap params = HRMapUtils.newHashMap((int)3);
                        List mainEntityParams = HRListUtils.newArrayList((int)1);
                        HashMap mainEntityObj = Maps.newHashMapWithExpectedSize((int)1);
                        mainEntityParams.add(mainEntityObj);
                        params.put("MAIN_ENTITY_PARAMS", mainEntityParams);
                        if (!hrComFunctionTypeIds.contains(Long.parseLong(pkId))) {
                            List appscopeParamList = HRListUtils.newArrayList((int)appIds.size());
                            appIds.forEach(appId -> {
                                HashMap dealObj = Maps.newHashMapWithExpectedSize((int)1);
                                dealObj.put("fbasedataid_id", appId);
                                appscopeParamList.add(dealObj);
                            });
                            params.put("appscope", appscopeParamList);
                            mainEntityObj.put("rgfscopetype", ScopeTypeEnum.CUSTOMIZE.getValue());
                        }
                        return params;
                    };
                    hrcsFunctiontypeDBHelper.updateMultDynObjColl(pkId, dynCollHandler, new String[]{"appscope", "businessfield"});
                    logger.warn("\u51fd\u6570\u5206\u7c7b\u3010{}\u3011\u5904\u7406\u6210\u529f", pkId);
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logger.warn("\u51fd\u6570\u5206\u7c7b\u3010{}\u3011\u5904\u7406\u5931\u8d25\uff0cerrMsg:{}", new Object[]{pkId, e.getMessage(), e});
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (txHandle != null) {
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        });
    }

    public static List<Long> queryHRComFunctionTypeIds() {
        return hrcsFunctiontypeDBHelper.queryTranPropList("id", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("rgfscopetype", "=", (Object)ScopeTypeEnum.GENERAL.getValue())}, "id", Long.class);
    }

    public static List<Long> queryNeedInitFunctionTypeIds() {
        return hrcsFunctiontypeDBHelper.queryTranPropList("id", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("rgfscopetype", "not in", (Object)ImmutableSet.of((Object)ScopeTypeEnum.CUSTOMIZE.getValue(), (Object)ScopeTypeEnum.GENERAL.getValue()))}, "id", Long.class);
    }

    public static HRBaseServiceHelper getDBService() {
        return hrcsFunctiontypeDBHelper;
    }
}

