/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.hismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.hr.metadata.field.HisModelBasedataField;
import kd.bos.ext.hr.metadata.field.MulHisModelBasedataField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSynDataStatusServicerHelper;
import kd.hr.hbp.business.domain.model.newhismodel.task.bo.HisEntitySyncStatusValidateResultBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.bo.HisEntityValidateErrorMsgBo;
import kd.hr.hbp.business.domain.repository.HisSyncDataStatusRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.hismodel.HisEntityDependentService;
import kd.hr.hrcs.bussiness.servicehelper.hismodel.HisEntityDependentServiceHelper;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityConditionVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityRelVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityVO;
import kd.hr.hrcs.common.model.hismodel.HisEntityDependentVO;

public class HisEDTaskService
implements HisFieldNameConstants {
    private static final Log LOGGER = LogFactory.getLog(HisEDTaskService.class);

    public static Map<String, HisEntitySyncStatusValidateResultBo> execute() {
        DynamicObject[] entities = HisEntityDependentServiceHelper.getEntities(new QFilter[0]);
        DynamicObject[] entityRel = HisEntityDependentServiceHelper.getEntityRel(new QFilter[0]);
        HisEntityDependentService service = new HisEntityDependentService();
        List<HisEntityDependentVO> hisEntityDependentVOList = service.buildHisEntityDependentVOList(entities, entityRel);
        return HisEDTaskService.executeByDependent(hisEntityDependentVOList);
    }

    private static Map<String, HisEntitySyncStatusValidateResultBo> executeByDependent(List<HisEntityDependentVO> hisEntityDependentVOList) {
        Map<String, Set<HisEDEntityRelVO>> dependentMap = HisEDTaskService.getDependentMap(hisEntityDependentVOList);
        HashMap validateResultBoMap = Maps.newHashMapWithExpectedSize((int)dependentMap.size());
        HisEDTaskService.process(dependentMap, validateResultBoMap);
        HisSynDataStatusServicerHelper.writeErrorLog((Map)validateResultBoMap);
        return validateResultBoMap;
    }

    private static Map<String, Set<HisEDEntityRelVO>> getDependentMap(List<HisEntityDependentVO> hisEntityDependentVOList) {
        HashMap dependentMap = Maps.newHashMapWithExpectedSize((int)hisEntityDependentVOList.size());
        for (HisEntityDependentVO hisEntityDependentVO : hisEntityDependentVOList) {
            List edEntityList = hisEntityDependentVO.getEdEntityList();
            for (int i = 1; i < edEntityList.size(); ++i) {
                String leftEntityNum;
                HisEDEntityVO hisEDEntityVO = (HisEDEntityVO)edEntityList.get(i);
                HisEDEntityRelVO edEntityRel = hisEDEntityVO.getEdEntityRel();
                if (edEntityRel != null) {
                    leftEntityNum = edEntityRel.getLeftEntityNum();
                } else {
                    edEntityRel = new HisEDEntityRelVO();
                    leftEntityNum = ((HisEDEntityVO)edEntityList.get(i - 1)).getEntity();
                    edEntityRel.setLeftEntityNum(leftEntityNum);
                    edEntityRel.setRightEntityNum(hisEDEntityVO.getEntity());
                }
                Set relList = dependentMap.getOrDefault(leftEntityNum, Sets.newHashSetWithExpectedSize((int)edEntityList.size()));
                relList.add(edEntityRel);
                dependentMap.put(leftEntityNum, relList);
            }
            HisEDEntityVO hisEDEntityVOEnd = (HisEDEntityVO)edEntityList.get(edEntityList.size() - 1);
            String laseEntity = hisEDEntityVOEnd.getEntity();
            dependentMap.computeIfAbsent(laseEntity, k -> Sets.newHashSetWithExpectedSize((int)edEntityList.size()));
        }
        for (Map.Entry entry : dependentMap.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            dependentMap.put(entry.getKey(), null);
        }
        return dependentMap;
    }

    private static void process(Map<String, Set<HisEDEntityRelVO>> dependentMap, Map<String, HisEntitySyncStatusValidateResultBo> validateResultBoMap) {
        if (dependentMap.isEmpty()) {
            return;
        }
        HashSet dependentEmptySet = Sets.newHashSetWithExpectedSize((int)dependentMap.size());
        dependentMap.forEach((key, value) -> {
            if (value == null) {
                dependentEmptySet.add(key);
            }
        });
        dependentEmptySet.forEach(dependentMap::remove);
        for (Map.Entry<String, Set<HisEDEntityRelVO>> next : dependentMap.entrySet()) {
            Set<HisEDEntityRelVO> value2 = next.getValue();
            for (HisEDEntityRelVO hisEDEntityRelVO : value2) {
                if (!dependentEmptySet.contains(hisEDEntityRelVO.getRightEntityNum()) || value2.size() != 1) continue;
                Map<String, Set<String>> conditionMap = HisEDTaskService.buildConditionMap(hisEDEntityRelVO);
                HisEntitySyncStatusValidateResultBo validateResultBo = HisEDTaskService.validate(hisEDEntityRelVO.getLeftEntityNum(), hisEDEntityRelVO.getRightEntityNum(), conditionMap);
                if (validateResultBo.getHisEntityValidateErrorMsgBoList().isEmpty()) continue;
                validateResultBoMap.put(next.getKey(), validateResultBo);
            }
            value2.removeIf(v -> dependentEmptySet.contains(v.getRightEntityNum()));
            if (!value2.isEmpty()) continue;
            next.setValue(null);
        }
        HisEDTaskService.process(dependentMap, validateResultBoMap);
    }

    private static Map<String, Set<String>> buildConditionMap(HisEDEntityRelVO hisEDEntityRelVO) {
        List conditionList = hisEDEntityRelVO.getConditionList();
        HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty((Collection)conditionList)) {
            HashSet rightProp = Sets.newHashSet((Object[])new String[]{"id"});
            conditionMap.put("id", rightProp);
        } else {
            for (HisEDEntityConditionVO hisEDEntityConditionVO : conditionList) {
                String leftProp = hisEDEntityConditionVO.getLeftProp();
                Set rightPropSet = conditionMap.getOrDefault(leftProp, Sets.newHashSetWithExpectedSize((int)conditionList.size()));
                rightPropSet.add(hisEDEntityConditionVO.getRightProp());
                conditionMap.put(leftProp, rightPropSet);
            }
        }
        return conditionMap;
    }

    private static HisEntitySyncStatusValidateResultBo validate(String leftEntityNum, String rightEntityNum, Map<String, Set<String>> conditionMap) {
        LOGGER.info("HisEDTask_validate,leftEntityNum:{},rightEntityNum:{},conditionMap:{}", new Object[]{leftEntityNum, rightEntityNum, conditionMap});
        return HisEDTaskService.validateStatus(leftEntityNum, rightEntityNum, conditionMap);
    }

    private static HisEntitySyncStatusValidateResultBo validateStatus(String entityId, String joinEntityId, Map<String, Set<String>> originConditionMap) {
        HisEntitySyncStatusValidateResultBo bo = HisEDTaskService.buildHisEntitySyncStatusValidateResultBo(entityId);
        String[] data = HisEDTaskService.hasHis(entityId, joinEntityId);
        if (HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)data[0])) {
            boolean isVersion = Boolean.parseBoolean(data[1]);
            String[] split = data[2].split("#");
            ArrayList conditionList = Lists.newArrayListWithExpectedSize((int)split.length);
            if (originConditionMap.containsKey("id")) {
                Set<String> idSet = originConditionMap.remove("id");
                for (String key2 : split) {
                    Map<String, Set<String>> destMap = HisEDTaskService.deepCopy(originConditionMap);
                    destMap.put(key2, idSet);
                    conditionList.add(destMap);
                }
            }
            HashMap errMsgMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map conditionMap : conditionList) {
                Map statusMap;
                HRBaseServiceHelper joinServiceHelper = new HRBaseServiceHelper(joinEntityId);
                HisSyncDataStatusRepository repository = HisSyncDataStatusRepository.getInstance();
                try {
                    DataSet joinDataSet = repository.getJoinDataSet(joinServiceHelper, HisEDTaskService.getJoinSelectFields(isVersion, conditionMap));
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
                    DataSet dataSet = repository.getDataSet(serviceHelper, null, HisEDTaskService.getSelectFields(conditionMap));
                    statusMap = repository.getJoinEntityStatus(dataSet, joinDataSet, conditionMap, isVersion);
                    LOGGER.info("HisEDTask_validateStatus,statusMap:{}", (Object)statusMap);
                }
                catch (Exception e) {
                    LOGGER.error("HisEDTask_validateStatus_error:{}", (Object)e.getMessage());
                    return bo;
                }
                for (Map.Entry entry : statusMap.entrySet()) {
                    List value2 = (List)entry.getValue();
                    for (Map map : value2) {
                        String bdStatus = (String)map.get("datastatus");
                        String bdVersionNum = (String)map.get("hisversion");
                        Long id = (Long)map.get("id");
                        boolean isFail = false;
                        String errMsg = null;
                        if (!HRStringUtils.equals((String)bdStatus, (String)EnumHisDataVersionStatus.EFFECTING.getStatus())) {
                            errMsg = !HRStringUtils.isEmpty((String)bdVersionNum) ? String.format(ResManager.loadKDString((String)"\u6240\u5173\u8054%1$s\u7684%2$s\u7248\u672c\u672a\u751f\u6548\u3002", (String)"HisEDTaskService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), id, bdVersionNum) : ResManager.loadKDString((String)"\u6240\u5173\u8054%s\u672a\u751f\u6548\u3002", (String)"HisEDTaskService_0", (String)"hrmp-hrcs-business", (Object[])new Object[]{id});
                            isFail = true;
                        }
                        if (!isFail) continue;
                        StringBuilder stringBuilder = errMsgMap.getOrDefault(entry.getKey(), new StringBuilder());
                        if (stringBuilder.indexOf(errMsg) == -1) {
                            stringBuilder.append(errMsg);
                        }
                        errMsgMap.put(entry.getKey(), stringBuilder);
                    }
                }
            }
            errMsgMap.forEach((key, value) -> bo.getHisEntityValidateErrorMsgBoList().add(HisEDTaskService.buildHisEntityValidateErrorMsgBo(key, null, value.toString())));
        }
        return bo;
    }

    private static String[] hasHis(String entityNum, String joinEntityNum) {
        String[] data = new String[3];
        String type = HisCommonService.getInstance().entityInhRelation(joinEntityNum);
        if (!EnumEntityTpl.COMMON_TPL.getNumber().equals(type)) {
            String entityId = MetadataDao.getIdByNumber((String)entityNum, (MetaCategory)MetaCategory.Entity);
            String joinEntityId = MetadataDao.getIdByNumber((String)joinEntityNum, (MetaCategory)MetaCategory.Entity);
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            List entityItems = metadata.getItems();
            HashMap entryMap = Maps.newHashMapWithExpectedSize((int)entityItems.size());
            for (EntityItem entityItem : entityItems) {
                if (!(entityItem instanceof EntryEntity)) continue;
                entryMap.put(entityItem.getId(), entityItem.getKey());
            }
            for (EntityItem entityItem : entityItems) {
                String entryKey;
                String key;
                String baseEntityId;
                String selData;
                HisModelBasedataField field;
                if (!(entityItem instanceof HisModelBasedataField) && !(entityItem instanceof MulHisModelBasedataField)) continue;
                if (entityItem instanceof HisModelBasedataField) {
                    field = (HisModelBasedataField)entityItem;
                    selData = field.getSelData();
                    baseEntityId = field.getBaseEntityId();
                    key = field.getKey() + '.' + "id";
                } else {
                    field = (MulHisModelBasedataField)entityItem;
                    selData = field.getSelData();
                    baseEntityId = field.getBaseEntityId();
                    key = field.getKey() + '.' + "fbasedataid.id";
                }
                if (!HRStringUtils.equals((String)joinEntityId, (String)baseEntityId)) continue;
                data[0] = Boolean.TRUE.toString();
                if (!Boolean.TRUE.toString().equals(data[1])) {
                    data[1] = Boolean.toString("bdversion".equals(selData));
                }
                if (!HRStringUtils.isEmpty((String)(entryKey = (String)entryMap.get(entityItem.getParentId())))) {
                    key = entryKey + '.' + key;
                }
                if (!HRStringUtils.isEmpty((String)data[2])) {
                    data[2] = data[2] + "#" + key;
                    continue;
                }
                data[2] = key;
            }
        }
        return data;
    }

    private static HisEntitySyncStatusValidateResultBo buildHisEntitySyncStatusValidateResultBo(String entityNum) {
        HisEntitySyncStatusValidateResultBo hisEntitySyncStatusValidateResultBo = new HisEntitySyncStatusValidateResultBo();
        hisEntitySyncStatusValidateResultBo.setEntityNumber(entityNum);
        ArrayList hisEntityValidateErrorMsgBoList = Lists.newArrayListWithExpectedSize((int)128);
        hisEntitySyncStatusValidateResultBo.setHisEntityValidateErrorMsgBoList((List)hisEntityValidateErrorMsgBoList);
        return hisEntitySyncStatusValidateResultBo;
    }

    private static HisEntityValidateErrorMsgBo buildHisEntityValidateErrorMsgBo(Long boId, String errorNumber, String errorMsg) {
        HisEntityValidateErrorMsgBo hisEntityValidateErrorMsgBo = new HisEntityValidateErrorMsgBo();
        hisEntityValidateErrorMsgBo.setBoId(boId);
        hisEntityValidateErrorMsgBo.setErrorNumber(errorNumber);
        hisEntityValidateErrorMsgBo.setErrorMsg(errorMsg);
        return hisEntityValidateErrorMsgBo;
    }

    private static String getJoinSelectFields(boolean isVersion, Map<String, Set<String>> conditionMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id").append(',').append("datastatus");
        if (isVersion) {
            stringBuilder.append(',').append("hisversion");
        }
        conditionMap.forEach((key, value) -> {
            for (String rightProp : value) {
                if ("id".equals(rightProp)) continue;
                stringBuilder.append(',').append(rightProp);
            }
        });
        return stringBuilder.toString();
    }

    private static String getSelectFields(Map<String, Set<String>> conditionMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("boid");
        conditionMap.forEach((key, value) -> stringBuilder.append(',').append((String)key));
        return stringBuilder.toString();
    }

    private static Map<String, Set<String>> deepCopy(Map<String, Set<String>> originMap) {
        HashMap destMap = Maps.newHashMapWithExpectedSize((int)originMap.size());
        for (Map.Entry<String, Set<String>> entry : originMap.entrySet()) {
            destMap.put(entry.getKey(), entry.getValue());
        }
        return destMap;
    }
}

