/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.label.BaseLabelResult;
import kd.hr.hbp.common.model.label.LabelResultEntry;
import kd.hr.hbp.common.model.label.LabelResultInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelSceneServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelTaskStorageService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class APILabelServiceHelper {
    private static final Log logger = LogFactory.getLog(APILabelServiceHelper.class);
    private static final int QUERY_PAGE_SIZE = 1000;
    private static String[] BATCH_GET_LABEL_SELECT_FIELDS = new String[]{"labelObjectId", "policyId", "createTime", "creatorId", "id", "labels.labelValueId", "labels.labelValueName", "labels.createTime", "labels.labelId", "labels.from", "labels.labelBizValue"};
    private static String[] GET_LABEL_SELECT_FIELDS = new String[]{"labelObjectId", "policyId", "taskNumber", "labels.labelId", "createTime", "lastUpdateTime", "isDeleted", "id", "topBizId", "labels.labelValueId", "labels.labelValueName", "labels.labelBizValue", "labels.from", "labels.creatorId", "labels.createTime"};

    public static Map<String, Object> batchSaveLabels(String sceneNumber, Long creator, List<BaseLabelResult> labelResultList, boolean isReplace) {
        List preLabels;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Date curDate = new Date();
        DynamicObject labelScene = LabelSceneServiceHelper.getLabelSceneDyn(sceneNumber);
        if (labelScene == null) {
            result.put("success", Boolean.FALSE);
            result.put("msg", "sceneNumber is null.");
            return result;
        }
        DynamicObjectCollection dynLabelObjs = labelScene.getDynamicObjectCollection("lblobjectids");
        if (dynLabelObjs == null || dynLabelObjs.size() <= 0) {
            result.put("success", Boolean.FALSE);
            result.put("msg", "label object id is null.");
            return result;
        }
        Long labelObjectId = ((DynamicObject)dynLabelObjs.get(0)).getDynamicObject("fbasedataid").getLong("id");
        HashMap labels = new HashMap(16);
        for (BaseLabelResult baseLabelResult : labelResultList) {
            for (LabelResultEntry labelResultEntry : baseLabelResult.getLabelResult()) {
                Long labelId = labelResultEntry.getLabelId();
                if (!labels.containsKey(labelId)) {
                    HashMap resultMap = new HashMap(16);
                    labels.put(labelId, resultMap);
                }
                if (!((Map)labels.get(labelId)).containsKey(baseLabelResult.getId())) {
                    LabelResultInfo labelResultInfo = new LabelResultInfo();
                    labelResultInfo.setId(baseLabelResult.getId());
                    labelResultInfo.setCreatorId(creator);
                    labelResultInfo.setCreateTime(curDate);
                    labelResultInfo.setLabelObjectId(labelObjectId);
                    ((Map)labels.get(labelId)).put(baseLabelResult.getId(), labelResultInfo);
                }
                ((LabelResultInfo)((Map)labels.get(labelId)).get(baseLabelResult.getId())).addModelLabel(labelResultEntry.getLabelId(), labelResultEntry.getLabelValueId(), labelResultEntry.getLabelValueName(), curDate, creator);
            }
        }
        for (Map.Entry entry : labels.entrySet()) {
            DynamicObject[] labelPolicyArray = LabelPolicyServiceHelper.getPolicyDyns(labelObjectId, (Long)entry.getKey());
            if (labelPolicyArray == null || labelPolicyArray.length == 0) {
                result.put("success", Boolean.FALSE);
                result.put("msg", "label policy not found.");
                return result;
            }
            if ("0".equals(labelPolicyArray[0].getString("enable"))) {
                result.put("success", Boolean.FALSE);
                result.put("msg", "label policy is not enable.");
                return result;
            }
            LabelTaskStorageService labelTaskStorageService = new LabelTaskStorageService(labelPolicyArray[0].getLong("id"), labelPolicyArray[0].getString("lasttasknumber"));
            ArrayList<LabelResultInfo> newLabelResultList = new ArrayList<LabelResultInfo>(16);
            ArrayList idList = new ArrayList(10);
            ((Map)entry.getValue()).forEach((itemKey, itemValue) -> {
                idList.add(String.valueOf(itemValue.getId()));
                itemValue.setPolicyId(Long.valueOf(labelPolicyArray[0].getLong("id")));
                newLabelResultList.add((LabelResultInfo)itemValue);
            });
            if (!isReplace) {
                if (!result.containsKey("labels")) {
                    ArrayList preLabels2 = new ArrayList(10);
                    result.put("labels", preLabels2);
                }
                List preLabels2 = (List)result.get("labels");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("id", "in", idList));
                List<Map<String, Object>> list = labelTaskStorageService.getResultList(GET_LABEL_SELECT_FIELDS, qFilters, 0, 1000);
                ArrayList<String> hasLabelIdList = new ArrayList<String>(10);
                for (Map<String, Object> stringObjectMap : list) {
                    BaseLabelResult labelResult = new BaseLabelResult();
                    hasLabelIdList.add(String.valueOf(stringObjectMap.get("id")));
                    labelResult.setId(stringObjectMap.get("id"));
                    labelResult.setSceneNumber(sceneNumber);
                    if (stringObjectMap.get("createTime") != null && !"".equals(stringObjectMap.get("createTime"))) {
                        try {
                            labelResult.setCreateTime(HRDateTimeUtils.parseDate((String)String.valueOf(stringObjectMap.get("createTime"))));
                        }
                        catch (ParseException e) {
                            logger.error("date formate error {}", stringObjectMap.get("createTime"));
                            logger.error((Throwable)e);
                        }
                    }
                    if (stringObjectMap.get("creatorId") != null && !"".equals(stringObjectMap.get("creatorId"))) {
                        labelResult.setCreatorId(Long.valueOf(Long.parseLong(String.valueOf(stringObjectMap.get("creatorId")))));
                    }
                    if (stringObjectMap.get("labels") != null && stringObjectMap.get("labels") instanceof List) {
                        List curValues = (List)stringObjectMap.get("labels");
                        for (Map curValue : curValues) {
                            LabelResultEntry lrEntry = new LabelResultEntry(Long.valueOf(Long.parseLong(String.valueOf(curValue.get("labelId")))), Long.valueOf(Long.parseLong(String.valueOf(curValue.get("labelValueId")))), String.valueOf(curValue.get("labelValueName")), null);
                            lrEntry.setFrom(String.valueOf(curValue.get("from")));
                            if (curValue.get("createTime") != null && !"".equals(curValue.get("createTime"))) {
                                try {
                                    lrEntry.setCreateTime(HRDateTimeUtils.parseDate((String)String.valueOf(curValue.get("createTime"))));
                                }
                                catch (ParseException e) {
                                    logger.error("date formate error {}", curValue.get("createTime"));
                                    logger.error((Throwable)e);
                                }
                            }
                            labelResult.getLabelResult().add(lrEntry);
                        }
                    }
                    preLabels2.add(labelResult);
                }
                if (hasLabelIdList.size() > 0) {
                    List<LabelResultInfo> needSaveLabelResultList = newLabelResultList.stream().filter(lblResultInfo -> hasLabelIdList.contains(String.valueOf(lblResultInfo.getId()))).collect(Collectors.toList());
                    APILabelServiceHelper.setDisplayFieldS(labelObjectId, needSaveLabelResultList);
                    labelTaskStorageService.batchSaveLabelResult(needSaveLabelResultList, "API");
                    continue;
                }
                APILabelServiceHelper.setDisplayFieldS(labelObjectId, newLabelResultList);
                labelTaskStorageService.batchSaveLabelResult(newLabelResultList, "API");
                continue;
            }
            APILabelServiceHelper.setDisplayFieldS(labelObjectId, newLabelResultList);
            labelTaskStorageService.batchSaveLabelResult(newLabelResultList, "API");
        }
        if (result.containsKey("labels") && (preLabels = (List)result.get("labels")).size() > 0) {
            result.put("msg", "can not replace some labels");
        }
        result.put("success", Boolean.TRUE);
        return result;
    }

    public static Map<String, Object> queryResults(Map<String, Object> paramMap) {
        HRBaseServiceHelper policyServiceHelper;
        DynamicObject[] policyList;
        Object sceneId = paramMap.get("sceneId");
        Object id = paramMap.get("id");
        Object ids = paramMap.get("ids");
        Object labelObjectId = paramMap.get("labelObjectId");
        Object labelId = paramMap.get("labelId");
        Object labelValueId = paramMap.get("labelValueId");
        Object labelType = paramMap.get("labelType");
        Object from = paramMap.get("from");
        Object groupId = paramMap.get("groupId");
        Object creatorId = paramMap.get("creatorId");
        Object lblPolicyId = paramMap.get("policyId");
        HashMap<Long, Long> labelSortNos = new HashMap<Long, Long>(16);
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        ArrayList resultList = new ArrayList();
        result.put("responseCode", "200");
        result.put("responseDesc", "success");
        ArrayList policyQFilterList = Lists.newArrayListWithExpectedSize((int)8);
        if (lblPolicyId != null) {
            policyQFilterList.add(new QFilter("id", "=", lblPolicyId));
        }
        if (sceneId != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelscene");
            DynamicObject scene = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", sceneId)});
            if (scene == null) {
                result.put("resultList", resultList);
                return result;
            }
            DynamicObjectCollection col = scene.getDynamicObjectCollection("lblobjectids");
            long lblObjId = ((DynamicObject)col.get(0)).getLong("fbasedataid.id");
            policyQFilterList.add(new QFilter("labelobject", "=", (Object)lblObjId));
            DynamicObjectCollection entry = scene.getDynamicObjectCollection("entryentity");
            ArrayList labelIdList = Lists.newArrayListWithExpectedSize((int)entry.size());
            for (DynamicObject dynamicObject : entry) {
                labelIdList.add(dynamicObject.getLong("label.id"));
                labelSortNos.put(dynamicObject.getLong("label.id"), dynamicObject.getLong("bizindex"));
            }
            policyQFilterList.add(new QFilter("label", "in", (Object)labelIdList));
        }
        if (labelObjectId != null) {
            policyQFilterList.add(new QFilter("labelobject", "=", labelObjectId));
        }
        HRBaseServiceHelper labelServiceHelper = new HRBaseServiceHelper("hrcs_label");
        if (labelType != null || groupId != null) {
            DynamicObject[] labels;
            ArrayList labelQFilterList = Lists.newArrayListWithExpectedSize((int)8);
            if (labelType != null) {
                labelQFilterList.add(new QFilter("type", "=", labelType));
            }
            if (groupId != null) {
                labelQFilterList.add(new QFilter("group", "=", groupId));
            }
            if ((labels = labelServiceHelper.queryOriginalArray("id", labelQFilterList.toArray(new QFilter[0]))).length == 0) {
                result.put("resultList", resultList);
                return result;
            }
            ArrayList labelIdList = Lists.newArrayListWithExpectedSize((int)labels.length);
            for (DynamicObject label : labels) {
                labelIdList.add(label.getLong("id"));
            }
            policyQFilterList.add(new QFilter("label", "in", (Object)labelIdList));
        }
        if (labelId != null) {
            policyQFilterList.add(new QFilter("label", "=", labelId));
        }
        if ((policyList = (policyServiceHelper = new HRBaseServiceHelper("hrcs_lblstrategy")).loadDynamicObjectArray(policyQFilterList.toArray(new QFilter[0]))) == null || policyList.length == 0) {
            result.put("resultList", resultList);
            return result;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (ids != null) {
            if (((List)ids).size() > 500) {
                result.put("responseCode", "400");
                result.put("responseDesc", "fail");
                result.put("responseMsg", "ids size exceeds 500");
                return result;
            }
            List newIdList = ((List)ids).stream().map(Object::toString).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", newIdList));
        } else if (id != null) {
            qFilters.add(new QFilter("id", "=", (Object)id.toString()));
        }
        if (labelValueId != null) {
            qFilters.add(new QFilter("labels.labelValueId", "=", labelValueId));
        }
        if (from != null) {
            qFilters.add(new QFilter("labels.from", "=", (Object)((String)from).toLowerCase(Locale.ROOT)));
        }
        if (creatorId != null) {
            qFilters.add(new QFilter("labels.creatorId", "=", (Object)creatorId.toString()));
        }
        LabelTaskStorageService taskStorageService = new LabelTaskStorageService(policyList[0].getLong("id"), "hand");
        Arrays.stream(policyList).forEach(policy -> {
            long policyId = policy.getLong("id");
            String taskNumber = policy.getString("lasttasknumber");
            if (StringUtils.isNotEmpty((String)taskNumber)) {
                List<Map<String, Object>> list = taskStorageService.getMultiResultList(policyId, taskNumber, GET_LABEL_SELECT_FIELDS, qFilters, 0, 1000);
                resultList.addAll(list);
            }
        });
        ArrayList labelIdList = Lists.newArrayListWithExpectedSize((int)resultList.size());
        for (Map data : resultList) {
            List labelList = (List)data.get("labels");
            for (Map labelData : labelList) {
                labelIdList.add((Long)labelData.get("labelId"));
            }
        }
        DynamicObject[] labels = labelServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)labelIdList)});
        Map<Long, DynamicObject> labelMap = Arrays.stream(labels).collect(Collectors.toMap(lb -> lb.getLong("id"), lb -> lb));
        for (Map data : resultList) {
            List labelList = (List)data.get("labels");
            for (Map labelData : labelList) {
                DynamicObject label = labelMap.get(labelData.get("labelId"));
                labelData.put("labelNumber", label.getString("number"));
                labelData.put("labelName", label.getString("name"));
                labelData.put("groupName", label.getString("group.name"));
                labelData.put("type", label.getString("type"));
                if (labelSortNos.containsKey(labelData.get("labelId"))) {
                    labelData.put("bizIndex", labelSortNos.get(labelData.get("labelId")));
                }
                labelData.put("description", label.getString("description"));
                DynamicObjectCollection entry = label.getDynamicObjectCollection("entryentitylabelvalue");
                for (DynamicObject lblVal : entry) {
                    if (!Objects.equals(labelData.get("labelValueId"), lblVal.get("id"))) continue;
                    labelData.put("labelValueDesc", lblVal.getString("labelvaluedesc"));
                }
            }
        }
        result.put("resultList", resultList);
        return result;
    }

    public static Map<String, Object> deleteResults(Map<String, Object> paramMap) {
        Map deleteData = (Map)paramMap.get("deleteData");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelscene");
        Set sceneIdSet = deleteData.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        DynamicObject[] scenes = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", sceneIdSet)});
        HashMap deleteMap = Maps.newHashMapWithExpectedSize((int)deleteData.size());
        HashSet lblValueIdSet = Sets.newHashSetWithExpectedSize((int)deleteMap.size());
        for (DynamicObject dynamicObject : scenes) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            Map lblValueMap = (Map)deleteData.get(dynamicObject.getString("id"));
            for (DynamicObject labelEntry : dynamicObjectCollection) {
                DynamicObjectCollection lblValueCol = labelEntry.getDynamicObjectCollection("label.entryentitylabelvalue");
                boolean bizLabel = labelEntry.getBoolean("bizlabel");
                if (!bizLabel) continue;
                for (DynamicObject lblVal : lblValueCol) {
                    Long labelValueId = lblVal.getLong("id");
                    List bizIdSet = (List)lblValueMap.get(labelValueId.toString());
                    if (CollectionUtils.isEmpty((Collection)bizIdSet)) continue;
                    DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection("lblobjectids");
                    long id = ((DynamicObject)col.get(0)).getLong("fbasedataid.id");
                    Map sonMap = deleteMap.getOrDefault(id, Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size()));
                    sonMap.put(labelValueId.toString(), bizIdSet);
                    deleteMap.put(id, sonMap);
                    lblValueIdSet.add(labelValueId);
                }
            }
        }
        HRBaseServiceHelper serviceHelper1 = new HRBaseServiceHelper("hrcs_lblstrategy");
        DynamicObject[] lblStrategy = serviceHelper1.loadDynamicObjectArray(new QFilter[]{new QFilter("labelobject", "in", deleteMap.keySet()), new QFilter("label.entryentitylabelvalue.id", "in", (Object)lblValueIdSet)});
        HashMap successDeleteData = Maps.newHashMapWithExpectedSize((int)deleteData.size());
        for (DynamicObject dynamicObject : lblStrategy) {
            long labelObjectId = dynamicObject.getLong("labelobject.id");
            Map lblValueMap = (Map)deleteMap.get(labelObjectId);
            long id = dynamicObject.getLong("id");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("label.entryentitylabelvalue");
            HashMap bizIdMap = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
            for (DynamicObject lblValue : dynamicObjectCollection) {
                Long lblValueId = lblValue.getLong("id");
                List bizIdSet = (List)lblValueMap.get(lblValueId.toString());
                if (CollectionUtils.isEmpty((Collection)bizIdSet)) continue;
                for (String bizId : bizIdSet) {
                    Set lblValueSet = bizIdMap.getOrDefault(bizId, Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size()));
                    lblValueSet.add(lblValueId);
                    bizIdMap.put(bizId, lblValueSet);
                }
            }
            LabelTaskStorageService service = new LabelTaskStorageService(id, dynamicObject.getString("lasttasknumber"));
            ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)1);
            ArrayList idQFilterList = Lists.newArrayList(bizIdMap.keySet());
            qFilterList.add(new QFilter("id", "in", (Object)idQFilterList));
            List<Map<String, Object>> resultList = service.getResultList(GET_LABEL_SELECT_FIELDS, qFilterList, 0, 1000);
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)resultList.size());
            for (Map<String, Object> data2 : resultList) {
                String bizId = (String)data2.get("id");
                Set lblValueSet = (Set)bizIdMap.get(bizId);
                List labelList = (List)data2.get("labels");
                labelList.removeIf(lbl -> {
                    Long labelValueId = (Long)lbl.get("labelValueId");
                    if (lblValueSet.contains(labelValueId)) {
                        Set bizIdSet = successDeleteData.getOrDefault(labelValueId.toString(), Sets.newHashSetWithExpectedSize((int)8));
                        bizIdSet.add(bizId);
                        successDeleteData.put(labelValueId.toString(), bizIdSet);
                        return true;
                    }
                    return false;
                });
                if (!labelList.isEmpty()) continue;
                idList.add(data2.get("id"));
            }
            service.deleteByIds(idList);
            resultList.removeIf(data -> idList.contains(data.get("id")));
            service.batchSaveLabelResultByLabel(resultList);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        hashMap.put("successData", successDeleteData);
        return hashMap;
    }

    private static void setDisplayFieldS(Long labelObjectId, List<LabelResultInfo> labelResultList) {
        List idList;
        QFilter qFilter;
        if (labelResultList == null || labelResultList.size() == 0) {
            return;
        }
        LabelDataService labelDataService = new LabelDataService(labelObjectId, true);
        List<Map<String, Object>> entryDataList = labelDataService.getEntryDataList(qFilter = new QFilter("id", "in", idList = labelResultList.stream().map(labelResultInfo -> labelResultInfo.getId()).collect(Collectors.toList())));
        if (entryDataList == null || entryDataList.size() == 0) {
            return;
        }
        Map<String, Map> entryDataGroup = entryDataList.stream().collect(Collectors.toMap(ed -> String.valueOf(ed.get("id")), ed -> ed));
        for (LabelResultInfo labelResultInfo2 : labelResultList) {
            if (!entryDataGroup.containsKey(String.valueOf(labelResultInfo2.getId()))) continue;
            Map item = entryDataGroup.get(String.valueOf(labelResultInfo2.getId()));
            item.entrySet().forEach(entry -> labelResultInfo2.putDisplayField((String)entry.getKey(), entry.getValue()));
        }
    }

    public static Map<String, Object> queryLabelObjectsByEntityNumber(String mainEntityNumber) {
        DynamicObject[] mainEntities = LabelObjectServiceHelper.getMainEntities(mainEntityNumber);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ArrayList resultList = new ArrayList(10);
        result.put("success", Boolean.TRUE);
        result.put("resultList", resultList);
        result.put("msg", "");
        if (mainEntities == null || mainEntities.length == 0) {
            return result;
        }
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        ArrayList<Long> labelObjectIds = new ArrayList<Long>(10);
        HashMap labelObjectRelations = new HashMap(16);
        for (DynamicObject joinEntity : mainEntities) {
            if (joinEntity.getDynamicObject("labelobject") == null) continue;
            labelObjectIds.add(joinEntity.getDynamicObject("labelobject").getLong("id"));
            ArrayList labelIds = new ArrayList(10);
            labelObjectRelations.put(joinEntity.getDynamicObject("labelobject").getLong("id"), labelIds);
        }
        DynamicObject[] labelDyns = labelServiceHelper.getLabelsByLabelObjects(labelObjectIds);
        HashMap labelsMap = new HashMap(16);
        for (DynamicObject labelDyn : labelDyns) {
            HashMap<String, Object> labelInfo = new HashMap<String, Object>(16);
            labelsMap.put(labelDyn.getLong("id"), labelInfo);
            labelInfo.put("labelId", labelDyn.getLong("id"));
            labelInfo.put("labelNumber", labelDyn.getString("number"));
            labelInfo.put("labelName", labelDyn.getLocaleString("name"));
            if (labelDyn.getDynamicObject("group") != null) {
                labelInfo.put("labelGroupId", labelDyn.getDynamicObject("group").getLong("id"));
                labelInfo.put("labelGroupName", labelDyn.getDynamicObject("group").getLocaleString("name"));
                labelInfo.put("labelGroupNumber", labelDyn.getDynamicObject("group").getString("number"));
            }
            labelInfo.put("labelType", labelDyn.getString("type"));
            labelInfo.put("labelDesc", labelDyn.getLocaleString("description"));
            labelInfo.put("status", labelDyn.getString("status"));
            labelInfo.put("enable", labelDyn.getString("enable"));
            ArrayList labelValueList = new ArrayList(10);
            labelInfo.put("labelValues", labelValueList);
            for (DynamicObject labelValueDyn : labelDyn.getDynamicObjectCollection("entryentitylabelvalue")) {
                HashMap<String, ILocaleString> labelValueInfo = new HashMap<String, ILocaleString>(16);
                labelValueInfo.put("labelValueName", labelValueDyn.getLocaleString("labelvalue"));
                labelValueInfo.put("labelValueDesc", labelValueDyn.getLocaleString("labelvaluedesc"));
                labelValueList.add(labelValueInfo);
            }
            for (DynamicObject labelObjDyn : labelDyn.getDynamicObjectCollection("entryentityrange")) {
                if (labelObjDyn.getDynamicObject("labelobject") == null || !labelObjectRelations.containsKey(labelObjDyn.getDynamicObject("labelobject").getLong("id"))) continue;
                ((List)labelObjectRelations.get(labelObjDyn.getDynamicObject("labelobject").getLong("id"))).add(labelDyn.getLong("id"));
            }
        }
        for (DynamicObject joinEntity : mainEntities) {
            if (joinEntity.getDynamicObject("labelobject") == null) continue;
            HashMap<String, Object> labelObjectMap = new HashMap<String, Object>(16);
            labelObjectMap.put("labelObjectId", joinEntity.getDynamicObject("labelobject").get("id"));
            labelObjectMap.put("labelObjectNumber", joinEntity.getDynamicObject("labelobject").get("number"));
            labelObjectMap.put("labelObjectName", joinEntity.getDynamicObject("labelobject").getLocaleString("name"));
            ArrayList labelList = new ArrayList(10);
            labelObjectMap.put("labels", labelList);
            for (Long labelId : (List)labelObjectRelations.get(joinEntity.getDynamicObject("labelobject").get("id"))) {
                labelList.add(labelsMap.get(labelId));
            }
            resultList.add(labelObjectMap);
        }
        return result;
    }

    public static Map<String, Object> getLabels(String enable, String status, Map<String, Object> filters, int start, int pageSize) {
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        DynamicObject[] labelDyns = labelServiceHelper.getLabels(enable, status, filters, start, pageSize);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ArrayList resultList = new ArrayList(10);
        result.put("success", Boolean.TRUE);
        result.put("resultList", resultList);
        result.put("msg", "");
        if (labelDyns == null || labelDyns.length == 0) {
            return result;
        }
        for (DynamicObject labelDyn : labelDyns) {
            HashMap<String, Object> labelInfo = new HashMap<String, Object>(16);
            labelInfo.put("labelId", labelDyn.getLong("id"));
            labelInfo.put("labelNumber", labelDyn.getString("number"));
            labelInfo.put("labelName", labelDyn.getLocaleString("name"));
            if (labelDyn.getDynamicObject("group") != null) {
                labelInfo.put("labelGroupId", labelDyn.getDynamicObject("group").getLong("id"));
                labelInfo.put("labelGroupName", labelDyn.getDynamicObject("group").getLocaleString("name"));
                labelInfo.put("labelGroupNumber", labelDyn.getDynamicObject("group").getString("number"));
            }
            labelInfo.put("labelType", labelDyn.getString("type"));
            labelInfo.put("labelDesc", labelDyn.getLocaleString("description"));
            labelInfo.put("status", labelDyn.getString("status"));
            labelInfo.put("enable", labelDyn.getString("enable"));
            ArrayList labelValueList = new ArrayList(10);
            labelInfo.put("labelValues", labelValueList);
            for (DynamicObject labelValueDyn : labelDyn.getDynamicObjectCollection("entryentitylabelvalue")) {
                HashMap<String, Long> labelValueInfo = new HashMap<String, Long>(16);
                labelValueInfo.put("labelValueId", labelValueDyn.getLong("id"));
                labelValueInfo.put("labelValueName", (Long)labelValueDyn.getLocaleString("labelvalue"));
                labelValueInfo.put("labelValueDesc", (Long)labelValueDyn.getLocaleString("labelvaluedesc"));
                labelValueList.add(labelValueInfo);
            }
            ArrayList labelObjectList = new ArrayList(10);
            labelInfo.put("labelObjects", labelObjectList);
            for (DynamicObject labelObjectDyn : labelDyn.getDynamicObjectCollection("entryentityrange")) {
                if (labelObjectDyn.getDynamicObject("labelobject") == null) continue;
                HashMap<String, Object> labelObjectMap = new HashMap<String, Object>(16);
                labelObjectMap.put("labelObjectId", labelObjectDyn.getDynamicObject("labelobject").get("id"));
                labelObjectMap.put("labelObjectNumber", labelObjectDyn.getDynamicObject("labelobject").get("number"));
                labelObjectMap.put("labelObjectName", labelObjectDyn.getDynamicObject("labelobject").getLocaleString("name"));
                labelObjectList.add(labelObjectMap);
            }
            resultList.add(labelInfo);
        }
        return result;
    }

    public static int getLabelResultCount(Long labelObjectId, Long labelId, Map<String, Object> filters) {
        DynamicObject[] labelPolicyArray = LabelPolicyServiceHelper.getPolicyDyns(labelObjectId, labelId);
        if (labelPolicyArray == null || labelPolicyArray.length == 0) {
            return 0;
        }
        if ("0".equals(labelPolicyArray[0].getString("enable"))) {
            return 0;
        }
        LabelTaskStorageService labelTaskStorageService = new LabelTaskStorageService(labelPolicyArray[0].getLong("id"), labelPolicyArray[0].getString("lasttasknumber"));
        return labelTaskStorageService.getAllCount(APILabelServiceHelper.getLabelResultQFilterList(filters));
    }

    public static Map<String, Object> getLabelResult(Long labelObjectId, Long labelId, Map<String, Object> filters, int start, int pageSize, Object[] objSortValues) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        ArrayList resultList = new ArrayList(10);
        result.put("success", Boolean.TRUE);
        result.put("resultList", resultList);
        result.put("objSortValues", null);
        result.put("msg", "");
        DynamicObject[] labelPolicyArray = LabelPolicyServiceHelper.getPolicyDyns(labelObjectId, labelId);
        if (labelPolicyArray == null || labelPolicyArray.length == 0) {
            result.put("msg", "label policy not exists.");
            return result;
        }
        if ("0".equals(labelPolicyArray[0].getString("enable"))) {
            result.put("msg", "label policy is not enable.");
            return result;
        }
        LabelTaskStorageService labelTaskStorageService = new LabelTaskStorageService(labelPolicyArray[0].getLong("id"), labelPolicyArray[0].getString("lasttasknumber"));
        EsResultVo labelResultVo = labelTaskStorageService.getAllResultList(GET_LABEL_SELECT_FIELDS, APILabelServiceHelper.getLabelResultQFilterList(filters), "lastUpdateTime ASC", start, pageSize, objSortValues);
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        DynamicObject label = labelServiceHelper.getLabel(labelId);
        if (label == null) {
            result.put("msg", "labelId is not exists.");
            return result;
        }
        if (labelResultVo.getResultData() != null) {
            for (Map data : labelResultVo.getResultData()) {
                List labelList = (List)data.get("labels");
                for (Map labelData : labelList) {
                    labelData.put("labelNumber", label.getString("number"));
                    labelData.put("labelName", label.getLocaleString("name"));
                    labelData.put("groupName", label.getLocaleString("group.name"));
                    labelData.put("type", label.getString("type"));
                    labelData.put("description", label.getLocaleString("description"));
                    DynamicObjectCollection entry = label.getDynamicObjectCollection("entryentitylabelvalue");
                    for (DynamicObject lblVal : entry) {
                        if (!Objects.equals(labelData.get("labelValueId"), lblVal.get("id"))) continue;
                        labelData.put("labelValueDesc", lblVal.getLocaleString("labelvaluedesc"));
                    }
                }
            }
            resultList.addAll(labelResultVo.getResultData());
            result.put("objSortValues", labelResultVo.getObjSortValues());
        }
        return result;
    }

    public static Map<String, Object> getLabelResult(Long labelObjectId, Long labelId, Map<String, Object> filters, int start, int pageSize) {
        return APILabelServiceHelper.getLabelResult(labelObjectId, labelId, filters, start, pageSize, null);
    }

    private static List<QFilter> getLabelResultQFilterList(Map<String, Object> filters) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (filters != null && filters.size() > 0) {
            if (filters.containsKey("isDeleted")) {
                if (!"2".equals(String.valueOf(filters.get("isDeleted")))) {
                    qFilters.add(new QFilter("isDeleted", "=", filters.get("isDeleted")));
                }
            } else {
                qFilters.add(new QFilter("isDeleted", "=", (Object)0));
            }
            if (filters.containsKey("lastUpdateTime")) {
                qFilters.add(new QFilter("lastUpdateTime", ">=", filters.get("lastUpdateTime")));
            }
            if (filters.containsKey("pkIds")) {
                qFilters.add(new QFilter("id", "in", filters.get("pkIds")));
            }
        }
        return qFilters;
    }
}

