/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;

@ExcludeFromJacocoGeneratedReport
public class ConvertFieldService {
    private static final Map<String, String> typeMap = Maps.newHashMapWithExpectedSize((int)16);

    public static void convertToBO(List<QueryFieldCommonBo> queryFieldCommonBoList, List<FieldTreeNode> fieldTreeNodeList) {
        for (FieldTreeNode fieldTreeNode : fieldTreeNodeList) {
            if (fieldTreeNode.getField().booleanValue()) {
                QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
                queryFieldCommonBo.setFieldAlias(fieldTreeNode.getFieldAlias());
                queryFieldCommonBo.setComplexType(fieldTreeNode.getComplexType());
                queryFieldCommonBo.setEntityNumber(fieldTreeNode.getEntityNumber());
                queryFieldCommonBo.setFieldPath(fieldTreeNode.getFieldPath());
                queryFieldCommonBo.setFieldName(fieldTreeNode.getName());
                queryFieldCommonBo.setValueType(fieldTreeNode.getValueType());
                queryFieldCommonBo.setControlType(fieldTreeNode.getControlType());
                queryFieldCommonBo.setEntityName(fieldTreeNode.getEntityName());
                queryFieldCommonBoList.add(queryFieldCommonBo);
            }
            if (CollectionUtils.isEmpty((Collection)fieldTreeNode.getChildren())) continue;
            ConvertFieldService.convertToBO(queryFieldCommonBoList, fieldTreeNode.getChildren());
        }
    }

    public static List<QueryFieldCommonBo> convertToBO(List<FieldTreeNode> fieldTreeNodeList) {
        ArrayList queryFieldCommonBoList = Lists.newArrayListWithCapacity((int)fieldTreeNodeList.size());
        for (FieldTreeNode fieldTreeNode : fieldTreeNodeList) {
            if (!fieldTreeNode.getField().booleanValue()) continue;
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            queryFieldCommonBo.setFieldAlias(fieldTreeNode.getFieldAlias());
            queryFieldCommonBo.setComplexType(fieldTreeNode.getComplexType());
            queryFieldCommonBo.setEntityNumber(fieldTreeNode.getEntityNumber());
            queryFieldCommonBo.setFieldPath(fieldTreeNode.getFieldPath());
            queryFieldCommonBo.setFieldName(fieldTreeNode.getName());
            queryFieldCommonBo.setValueType(fieldTreeNode.getValueType());
            queryFieldCommonBo.setControlType(fieldTreeNode.getControlType());
            queryFieldCommonBo.setEntityName(fieldTreeNode.getEntityName());
            queryFieldCommonBoList.add(queryFieldCommonBo);
        }
        return queryFieldCommonBoList;
    }

    public static String convertType(DynamicObject field, boolean isLabel) {
        String controlType = field.getString("controltype");
        String fieldPath = field.getString("fieldpath");
        String complexType = field.getString("complextype");
        if (AnalyseObjectUtil.isBaseDataType((String)complexType) && (isLabel ? fieldPath.endsWith(".id") : fieldPath.endsWith(".id") || fieldPath.endsWith(".number") || fieldPath.endsWith(".name"))) {
            return ParamTypeEnum.BASEDATA.getValue();
        }
        return typeMap.get(controlType) == null ? ParamTypeEnum.OTHER.getValue() : typeMap.get(controlType);
    }

    static {
        typeMap.put(FieldControlType.TEXT.getValue(), ParamTypeEnum.STRING.getValue());
        typeMap.put(FieldControlType.MUL_LANG_TEXT.getValue(), ParamTypeEnum.STRING.getValue());
        typeMap.put(FieldControlType.LARGE_TEXT.getValue(), ParamTypeEnum.STRING.getValue());
        typeMap.put(FieldControlType.INTEGER.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.BIGINT.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.DECIMAL.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.STEPPER.getValue(), ParamTypeEnum.NUMBER.getValue());
        typeMap.put(FieldControlType.DATE.getValue(), ParamTypeEnum.DATE.getValue());
        typeMap.put(FieldControlType.DATE_TIME.getValue(), ParamTypeEnum.DATE.getValue());
        typeMap.put(FieldControlType.COMBO.getValue(), ParamTypeEnum.ENUM.getValue());
        typeMap.put(FieldControlType.MUL_COMBO.getValue(), ParamTypeEnum.ENUM.getValue());
        typeMap.put(FieldControlType.BASE_DATA.getValue(), ParamTypeEnum.BASEDATA.getValue());
        typeMap.put(FieldControlType.USER.getValue(), ParamTypeEnum.BASEDATA.getValue());
        typeMap.put(FieldControlType.ORG.getValue(), ParamTypeEnum.BASEDATA.getValue());
        typeMap.put(FieldControlType.CHECKBOX.getValue(), ParamTypeEnum.BOOLEAN.getValue());
        typeMap.put(FieldControlType.HIS_BASE_DATA.getValue(), ParamTypeEnum.BASEDATA.getValue());
        typeMap.put(FieldControlType.HR_USER.getValue(), ParamTypeEnum.BASEDATA.getValue());
    }
}

