/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.label.LabelInfo;
import kd.hr.hbp.common.model.label.LabelSceneInfo;
import kd.hr.hbp.common.model.label.LabelValueInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class LabelSceneServiceHelper {
    public static DynamicObject getLabelSceneDyn(String sceneNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelscene");
        return serviceHelper.queryOne("id,number,name,lblobjectids.id,lblobjectids.number,lblobjectids.name,entryentity,entryentity.label,entryentity.label.id,entryentity.bizlabel", new QFilter[]{new QFilter("number", "=", (Object)sceneNumber), new QFilter("enable", "=", (Object)"1")});
    }

    public static LabelSceneInfo getLabelSceneInfo(String sceneNumber) {
        DynamicObject labelScene;
        LabelSceneInfo labelSceneInfo = null;
        if (HRStringUtils.isNotEmpty((String)sceneNumber) && (labelScene = LabelSceneServiceHelper.getLabelSceneDyn(sceneNumber)) != null) {
            labelSceneInfo = new LabelSceneInfo();
            DynamicObjectCollection dynLabelObjs = labelScene.getDynamicObjectCollection("lblobjectids");
            if (dynLabelObjs != null && dynLabelObjs.size() > 0) {
                labelSceneInfo.setLabelObjId(((DynamicObject)dynLabelObjs.get(0)).getDynamicObject("fbasedataid").getLong("id"));
                labelSceneInfo.setLabelObjNumber(((DynamicObject)dynLabelObjs.get(0)).getDynamicObject("fbasedataid").getString("number"));
                labelSceneInfo.setLabelObjName(((DynamicObject)dynLabelObjs.get(0)).getDynamicObject("fbasedataid").getLocaleString("name"));
            }
            labelSceneInfo.setSceneName(labelScene.getLocaleString("name"));
            labelSceneInfo.setSceneNumber(labelScene.getString("number"));
            ArrayList<LabelInfo> lableList = new ArrayList<LabelInfo>(10);
            if (labelScene.getDynamicObjectCollection("entryentity") != null && labelScene.getDynamicObjectCollection("entryentity").size() > 0) {
                DynamicObject[] labels;
                LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
                List<Long> idList = labelScene.getDynamicObjectCollection("entryentity").stream().filter(item -> item.getBoolean("bizlabel")).map(refLabel -> refLabel.getDynamicObject("label").getLong("id")).collect(Collectors.toList());
                for (DynamicObject labelObject : labels = labelServiceHelper.getLabels(idList)) {
                    LabelInfo labelInfo = new LabelInfo();
                    labelInfo.setLabelId(labelObject.getLong("id"));
                    labelInfo.setLabelName(labelObject.getLocaleString("name"));
                    labelInfo.setLabelNumber(labelObject.getString("number"));
                    ArrayList labelValueInfoList = new ArrayList(10);
                    labelObject.getDynamicObjectCollection("entryentitylabelvalue").forEach(labelValue -> {
                        LabelValueInfo labelValueInfo = new LabelValueInfo();
                        labelValueInfo.setLabelValueId(labelValue.getLong("id"));
                        labelValueInfo.setLabelValueName(labelValue.getLocaleString("labelvalue"));
                        labelValueInfoList.add(labelValueInfo);
                    });
                    labelInfo.setLabelValueInfoList(labelValueInfoList);
                    lableList.add(labelInfo);
                }
            }
            labelSceneInfo.setLabelList(lableList);
        }
        return labelSceneInfo;
    }
}

