/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.label.LabelResultInfo;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskProcessService;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.service.label.LabelObjectServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.HRLabelObjectConfigServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class LabelTaskProcessService
implements ILabelTaskProcessService {
    private static final Log logger = LogFactory.getLog(LabelTaskProcessService.class);
    private final Long policyId;
    private static final String LABELOBJECT_TYPE_MAIN = "0";
    private static final String LABELOBJECT_TYPE_SUB = "1";
    private final String taskNumber;
    private DynamicObject labelPolicy;
    private DynamicObject brmRuleScene;
    private final Map<String, DynamicObject> paramsMap = new LinkedHashMap<String, DynamicObject>(16);
    private final Map<String, String> baseDataEntityMap = new LinkedHashMap<String, String>(16);
    private final Map<String, List<ValueMapItem>> comboMap = new LinkedHashMap<String, List<ValueMapItem>>(16);
    private final Map<Long, String> labelValueMap = new LinkedHashMap<Long, String>(16);
    private final Map<Long, String> inputNumberMapping = new LinkedHashMap<Long, String>(16);
    private final Map<Long, String> lableInputNumberMapping = new LinkedHashMap<Long, String>(16);
    private final List<DynamicObject> displayFields = new ArrayList<DynamicObject>(16);
    private LabelDataService labelDataService;
    private DynamicObject labelObject;
    private HRComplexObjContext context;
    private String subIdKey;
    private String rootOrgNumber;

    public LabelTaskProcessService(Long policyId, String taskNumber) {
        this.policyId = policyId;
        this.taskNumber = taskNumber;
        this.init();
        if (this.labelObject != null) {
            this.labelDataService = new LabelDataService(this.labelObject.getLong("id"), true);
        }
    }

    private void initParentIdQuery() {
        DynamicObject parentMainEntity = LabelPolicyServiceHelper.getParentByObjectId(this.labelObject.getLong("id"));
        DynamicObject mainEntity = LabelPolicyServiceHelper.getEntryByObjectId(this.labelObject.getLong("id"));
        if (parentMainEntity != null) {
            DynamicObject[] entityRelations;
            this.subIdKey = mainEntity.getString("entityalias") + "." + "id";
            String mainEntityNumber = parentMainEntity.getString("entitynumber");
            String mainEntityAlias = parentMainEntity.getString("entityalias");
            this.context = new HRComplexObjContext();
            this.context.setEntityNumber(mainEntityNumber);
            this.context.setEntityTable(HREntityHelper.getTableName((String)mainEntityNumber));
            ArrayList queryFieldsInfoList = Lists.newArrayListWithExpectedSize((int)10);
            HRComplexObjFieldInfo parentFieldInfo = new HRComplexObjFieldInfo("id", LABELOBJECT_TYPE_SUB, "id");
            parentFieldInfo.setDataType(DataTypeEnum.LONG);
            queryFieldsInfoList.add(parentFieldInfo);
            HRComplexObjFieldInfo fieldInfo = new HRComplexObjFieldInfo(this.subIdKey, LABELOBJECT_TYPE_SUB, this.subIdKey);
            fieldInfo.setDataType(DataTypeEnum.LONG);
            queryFieldsInfoList.add(fieldInfo);
            this.context.setComplexObjFieldInfoList((List)queryFieldsInfoList);
            ArrayList joinRelationList = Lists.newArrayListWithExpectedSize((int)10);
            for (DynamicObject entityRelation : entityRelations = LabelPolicyServiceHelper.getMainEntityRelation(this.labelObject.getLong("id"), mainEntityNumber)) {
                HRComplexObjJoinRelation relationInfo = new HRComplexObjJoinRelation(mainEntityNumber, mainEntityAlias, entityRelation.getString("joinentityid.entitynumber"), entityRelation.getString("joinentityid.entityalias"), entityRelation.getString("jointype"));
                DynamicObjectCollection joinConditions = entityRelation.getDynamicObjectCollection("joinconditions");
                ArrayList joinConditionBoList = Lists.newArrayListWithExpectedSize((int)joinConditions.size());
                for (DynamicObject joinCondition : joinConditions) {
                    HRComplexObjConditionRow condition = new HRComplexObjConditionRow(joinCondition.getString("leftprop"), joinCondition.getString("rightprop"));
                    condition.setCompareOp(joinCondition.getString("comparetype"));
                    condition.setLogicOp(joinCondition.getString("logictype"));
                    condition.setRightFieldItem("field".equals(joinCondition.getString("rightproptype")));
                    joinConditionBoList.add(condition);
                }
                relationInfo.setCondition((List)joinConditionBoList);
                joinRelationList.add(relationInfo);
            }
            this.context.setJoinRelationList((List)joinRelationList);
        }
    }

    private void init() {
        this.labelPolicy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        if (this.labelPolicy != null) {
            this.brmRuleScene = LblStrategyServiceHelper.getRuleScene(this.labelPolicy.getLong("label.id"), this.labelPolicy.getLong("labelobject.id"));
            DynamicObject[] labelObjects = LabelObjectServiceHelper.getLabelObjectsByFilter(new QFilter("id", "=", (Object)this.labelPolicy.getLong("labelobject.id")));
            if (labelObjects != null && labelObjects.length > 0) {
                this.labelObject = labelObjects[0];
            }
        }
        if (this.labelPolicy != null && this.brmRuleScene != null) {
            DynamicObjectCollection displayFieldCol;
            DynamicObject[] labelValues;
            DynamicObjectCollection paramDynCol = this.brmRuleScene.getDynamicObjectCollection("brmscene.sceneinputparams");
            if (paramDynCol != null && paramDynCol.size() > 0) {
                DynamicObject[] dynFields;
                Object tempInputNumber;
                for (DynamicObject dynamicObject : paramDynCol) {
                    if (dynamicObject.getString("inputnumber").startsWith("pl")) {
                        tempInputNumber = Long.valueOf(Long.parseLong(dynamicObject.getString("inputnumber").replace("pl", "")));
                        this.lableInputNumberMapping.put((Long)tempInputNumber, dynamicObject.getString("inputnumber"));
                        continue;
                    }
                    if (!dynamicObject.getString("inputnumber").startsWith("p")) continue;
                    tempInputNumber = Long.parseLong(dynamicObject.getString("inputnumber").replace("p", ""));
                    this.inputNumberMapping.put((Long)tempInputNumber, dynamicObject.getString("inputnumber"));
                }
                HashSet<Long> tempSet = new HashSet<Long>(16);
                tempSet.addAll(this.inputNumberMapping.keySet());
                tempSet.addAll(this.lableInputNumberMapping.keySet());
                tempInputNumber = dynFields = this.getFields(tempSet);
                int n = ((DynamicObject[])tempInputNumber).length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject field = tempInputNumber[i];
                    if (this.inputNumberMapping.containsKey(field.getLong("id"))) {
                        this.paramsMap.put(this.inputNumberMapping.get(field.getLong("id")), field);
                    }
                    if (!this.lableInputNumberMapping.containsKey(field.getLong("id"))) continue;
                    this.paramsMap.put(this.lableInputNumberMapping.get(field.getLong("id")), field);
                }
            }
            for (DynamicObject dynamicObject : labelValues = LblStrategyServiceHelper.getLabelValues(this.labelPolicy.getLong("label.id"))) {
                this.labelValueMap.put(dynamicObject.getLong("id"), dynamicObject.getString("value"));
            }
            DynamicObject labelObjectConfig = HRLabelObjectConfigServiceHelper.getDisplayFields(this.brmRuleScene.getLong("labelobject.id"));
            if (labelObjectConfig != null && (displayFieldCol = labelObjectConfig.getDynamicObjectCollection("displayentryentity")) != null && displayFieldCol.size() > 0) {
                for (DynamicObject dynamicObject : displayFieldCol) {
                    if (dynamicObject.getInt("isdefault") == 1) continue;
                    this.displayFields.add(dynamicObject);
                }
            }
        }
        this.rootOrgNumber = HRLabelObjectConfigServiceHelper.getOrgNumber(OrgServiceUtil.getHRRootOrgId());
    }

    @Override
    public LabelResultInfo getRuleResult(List<Map<String, Object>> paramsList, Map<String, Object> cacheMap) {
        if (this.brmRuleScene != null && this.labelPolicy != null && paramsList != null && paramsList.size() > 0) {
            List sceneResultList;
            LabelResultInfo resultInfo = new LabelResultInfo();
            resultInfo.setCreateTime(new Date());
            resultInfo.setLabelObjectId(Long.valueOf(this.brmRuleScene.getLong("labelobject.id")));
            resultInfo.setPolicyId(this.policyId);
            ArrayList reqParamsList = new ArrayList(8);
            StringBuilder cacheKey = new StringBuilder();
            for (Map<String, Object> row : paramsList) {
                HashMap<String, Object> reqParamMap = new HashMap<String, Object>(8);
                Object pkid = row.get("id");
                if (pkid != null) {
                    resultInfo.setId(pkid);
                    reqParamMap.put("serialNumber", String.valueOf(pkid));
                }
                reqParamMap.put("bizApp", this.brmRuleScene.getString("brmscene.bizappid.number"));
                reqParamMap.put("sceneNumber", this.brmRuleScene.getString("brmscene.number"));
                reqParamMap.put("buNumber", this.rootOrgNumber);
                if (this.paramsMap.size() > 0) {
                    HashMap inputParams = new HashMap(this.paramsMap.size());
                    for (Map.Entry entry : this.paramsMap.entrySet()) {
                        DynamicObject dynField = (DynamicObject)entry.getValue();
                        if (paramsList.size() == 1) {
                            cacheKey.append(row.get(dynField.getString("fieldalias"))).append(';');
                        }
                        if (AnalyseObjectUtil.isBaseDataType((String)dynField.getString("complextype")) && dynField.getString("fieldalias").endsWith(".id")) {
                            DynamicObject baseDataDyn = this.getBaseDataDyn(dynField.getString("entitynumber"), dynField.getString("fieldpath"), dynField.getString("fieldalias"), row.get(dynField.getString("fieldalias")));
                            inputParams.put(entry.getKey(), baseDataDyn);
                            continue;
                        }
                        if (FieldControlType.CHECKBOX.getValue().equals(dynField.getString("controltype"))) {
                            if (LABELOBJECT_TYPE_SUB.equals(row.get(dynField.getString("fieldalias"))) || LABELOBJECT_TYPE_MAIN.equals(row.get(dynField.getString("fieldalias"))) || "true".equals(row.get(dynField.getString("fieldalias"))) || "false".equals(row.get(dynField.getString("fieldalias")))) {
                                inputParams.put(entry.getKey(), LABELOBJECT_TYPE_SUB.equals(row.get(dynField.getString("fieldalias"))) || "true".equals(row.get(dynField.getString("fieldalias"))));
                                continue;
                            }
                            inputParams.put(entry.getKey(), row.get(dynField.getString("fieldalias")));
                            continue;
                        }
                        inputParams.put(entry.getKey(), row.get(dynField.getString("fieldalias")));
                    }
                    reqParamMap.put("inputParams", inputParams);
                }
                reqParamsList.add(reqParamMap);
            }
            this.setTopBizId(resultInfo);
            Object cacheObject = cacheMap.get(cacheKey.toString());
            if (paramsList.size() == 1 && cacheObject != null) {
                sceneResultList = (List)cacheObject;
            } else {
                sceneResultList = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngine", (Object[])new Object[]{reqParamsList});
                cacheMap.put(cacheKey.toString(), sceneResultList);
            }
            if (sceneResultList != null) {
                for (Map resultMap : sceneResultList) {
                    SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)resultMap);
                    if ("200".equals(sceneResult.getResponseCode())) {
                        for (PolicyResult policyResult : sceneResult.getPolicyResults()) {
                            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                                Map matchResults = ruleResult.getMatchResults();
                                DynamicObject labelValue = (DynamicObject)matchResults.get("labelValue");
                                String bizLabelValue = null;
                                Object lvalue = matchResults.get("bizLabelValue");
                                if (lvalue != null) {
                                    bizLabelValue = (String)lvalue;
                                }
                                resultInfo.addLabelResult(Long.valueOf(this.labelPolicy.getLong("label.id")), Long.valueOf(labelValue.getLong("id")), this.labelValueMap.get(labelValue.getLong("id")), bizLabelValue);
                            }
                        }
                        continue;
                    }
                    throw new KDBizException(sceneResult.getErrorMsg());
                }
                this.setDisplayField(resultInfo, paramsList);
                return resultInfo;
            }
        }
        return null;
    }

    private void setDisplayFields(List<LabelResultInfo> resultList) {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        List idList = resultList.stream().map(labelResultInfo -> labelResultInfo.getId()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", idList);
        List<Map<String, Object>> entryDataList = this.labelDataService.getEntryDataList(qFilter);
        if (entryDataList == null || entryDataList.size() == 0) {
            return;
        }
        Map<String, Map> entryDataGroup = entryDataList.stream().collect(Collectors.toMap(ed -> String.valueOf(ed.get("id")), ed -> ed));
        for (LabelResultInfo labelResultInfo2 : resultList) {
            if (!entryDataGroup.containsKey(String.valueOf(labelResultInfo2.getId()))) continue;
            Map item = entryDataGroup.get(String.valueOf(labelResultInfo2.getId()));
            item.entrySet().forEach(entry -> labelResultInfo2.putDisplayField(((String)entry.getKey()).replaceAll("_dm6h7z_", "@"), entry.getValue()));
        }
    }

    private void setDisplayField(LabelResultInfo resultInfo, List<Map<String, Object>> paramsList) {
        if (this.displayFields != null && this.displayFields.size() > 0 && paramsList != null && paramsList.size() > 0) {
            Map<String, Object> params = paramsList.get(0);
            for (DynamicObject field : this.displayFields) {
                String fieldKey = null;
                fieldKey = HRStringUtils.isEmpty((String)field.getString("displayentitynumberalias")) ? field.getString("displayfieldnumber") : field.getString("displayentitynumberalias") + "." + field.getString("displayfieldnumber");
                resultInfo.putDisplayField(fieldKey, params.get(fieldKey));
            }
        }
    }

    private void setTopBizId(LabelResultInfo resultInfo) {
        if (this.labelObject != null) {
            if (LABELOBJECT_TYPE_MAIN.equals(this.labelObject.getString("type"))) {
                resultInfo.setTopBizId(resultInfo.getId());
            } else if (this.context != null && LABELOBJECT_TYPE_SUB.equals(this.labelObject.getString("type"))) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter(this.subIdKey, "=", resultInfo.getId()));
                this.context.setQfilterList(qFilters);
                ReportQueryService reportQueryService = new ReportQueryService(this.context);
                List dataList = reportQueryService.queryMap();
                if (dataList != null && dataList.size() > 0) {
                    resultInfo.setTopBizId(((Map)dataList.get(0)).get("id"));
                }
            }
        }
    }

    @Override
    public void finish() {
        Date nowDate = new Date();
        LabelPolicyServiceHelper.updatePolicyTask(this.policyId, this.taskNumber, "2", null);
        HRBaseServiceHelper labelPolicyHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
        DynamicObject tempLabelPolicy = LabelPolicyServiceHelper.getPolicyDy(this.policyId);
        tempLabelPolicy.set("lasttasknumber", (Object)this.taskNumber);
        tempLabelPolicy.set("lasttasktime", (Object)nowDate);
        tempLabelPolicy.set("modifytime", (Object)nowDate);
        labelPolicyHelper.updateOne(tempLabelPolicy);
    }

    private DynamicObject[] getFields(Set<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        return serviceHelper.query("id,fieldname,entitynumber,valuetype,labelobjectid,fieldalias,fieldpath,complextype,controltype", new QFilter[]{new QFilter("id", "in", ids)});
    }

    private DynamicObject getBaseDataDyn(String entityNumber, String fieldPath, String fieldAlias, Object pkid) {
        if (!this.baseDataEntityMap.containsKey(fieldAlias)) {
            DynamicProperty dynamicProperty = LabelService.getFieldDynamicProperty(entityNumber, fieldPath);
            if (dynamicProperty instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)dynamicProperty;
                this.baseDataEntityMap.put(fieldAlias, basedataProp.getBaseEntityId());
                return this.getDynamicObject(this.baseDataEntityMap.get(fieldAlias), pkid);
            }
            return this.getDynamicObject(entityNumber, pkid);
        }
        return this.getDynamicObject(this.baseDataEntityMap.get(fieldAlias), pkid);
    }

    private String getComboName(String entityNumber, String fieldPath, String fieldAlias, Object key) {
        if (key == null) {
            return null;
        }
        if (!this.comboMap.containsKey(fieldAlias)) {
            DynamicProperty dynamicProperty = LabelService.getFieldDynamicProperty(entityNumber, fieldPath);
            if (dynamicProperty instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)dynamicProperty;
                List itemList = comboProp.getComboItems();
                this.comboMap.put(fieldAlias, itemList);
                return this.getComboName(key, this.comboMap.get(fieldAlias));
            }
            return key == null ? null : String.valueOf(key);
        }
        return this.getComboName(key, this.comboMap.get(fieldAlias));
    }

    private String getComboName(Object key, List<ValueMapItem> itemList) {
        for (ValueMapItem item : itemList) {
            if (!key.equals(item.getValue())) continue;
            return item.getName().getLocaleValue();
        }
        return key == null ? null : String.valueOf(key);
    }

    private DynamicObject getDynamicObject(String entityName, Object pkid) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, pkid);
        dynamicObject.set("id", pkid);
        return dynamicObject;
    }

    private List<LabelResultInfo> getRuleResultListFromBrm(Map<Long, List<Map<String, Object>>> paramMap, Map<String, List<PolicyResult>> lruCacheMap) {
        ArrayList<LabelResultInfo> resultList = new ArrayList<LabelResultInfo>(10);
        HashMap<Long, LabelResultInfo> resultInfoMap = new HashMap<Long, LabelResultInfo>(16);
        if (this.brmRuleScene != null && this.labelPolicy != null && paramMap != null && paramMap.size() > 0) {
            List<Map<String, Object>> reqParamsList = this.getBrmReqParamsList(paramMap);
            logger.info("executeLabelPolicyTask getRuleResultListFromBrm size:{}", (Object)reqParamsList.size());
            List sceneResultList = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngine", (Object[])new Object[]{reqParamsList});
            if (sceneResultList != null) {
                for (Map resultMap : sceneResultList) {
                    SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)resultMap);
                    if ("200".equals(sceneResult.getResponseCode())) {
                        LabelResultInfo resultInfo;
                        if (resultInfoMap.containsKey(Long.valueOf(sceneResult.getSerialNumber()))) {
                            resultInfo = (LabelResultInfo)resultInfoMap.get(Long.valueOf(sceneResult.getSerialNumber()));
                        } else {
                            resultInfo = this.createLabelResultInfo(Long.valueOf(sceneResult.getSerialNumber()), paramMap.get(Long.valueOf(sceneResult.getSerialNumber())));
                            resultInfoMap.put(Long.valueOf(sceneResult.getSerialNumber()), resultInfo);
                        }
                        this.setResultCache(sceneResult, paramMap, lruCacheMap);
                        this.setLabelResultValues(resultInfo, sceneResult.getPolicyResults());
                        continue;
                    }
                    logger.error("executeLabelPolicyTask getRuleResultListFromBrm error:{}", (Object)sceneResult);
                    throw new KDBizException(sceneResult.getErrorMsg());
                }
            }
        }
        HashMap<Long, Long> parentIdMap = new HashMap<Long, Long>(16);
        for (Map.Entry entry : resultInfoMap.entrySet()) {
            parentIdMap.put((Long)((LabelResultInfo)entry.getValue()).getId(), null);
            this.addResult2List((LabelResultInfo)entry.getValue(), resultList);
        }
        this.setTopBizId(parentIdMap, resultList);
        return resultList;
    }

    private void setTopBizId(Map<Long, Long> parentIdMap, List<LabelResultInfo> resultList) {
        if (this.labelObject != null && this.context != null && LABELOBJECT_TYPE_SUB.equals(this.labelObject.getString("type")) && parentIdMap.size() > 0) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(this.subIdKey, "in", Arrays.asList(parentIdMap.keySet().toArray(new Long[0]))));
            this.context.setQfilterList(qFilters);
            ReportQueryService reportQueryService = new ReportQueryService(this.context);
            List dataList = reportQueryService.queryMap();
            if (dataList != null && dataList.size() > 0) {
                for (Map row : dataList) {
                    parentIdMap.put((Long)row.get(this.subIdKey), (Long)row.get("id"));
                }
            }
            for (LabelResultInfo labelResultInfo : resultList) {
                labelResultInfo.setTopBizId((Object)parentIdMap.get(labelResultInfo.getId()));
            }
        }
    }

    private void addResult2List(LabelResultInfo resultInfo, List<LabelResultInfo> resultList) {
        if (resultInfo != null && resultInfo.getLabelResult() != null && resultInfo.getLabelResult().size() > 0) {
            resultList.add(resultInfo);
        }
    }

    private void setLabelResultValues(LabelResultInfo resultInfo, List<PolicyResult> policyResultList) {
        for (PolicyResult policyResult : policyResultList) {
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                Map matchResults = ruleResult.getMatchResults();
                DynamicObject labelValue = (DynamicObject)matchResults.get("labelValue");
                String bizLabelValue = null;
                Object lvalue = matchResults.get("bizLabelValue");
                if (lvalue != null) {
                    bizLabelValue = (String)lvalue;
                }
                resultInfo.addLabelResult(Long.valueOf(this.labelPolicy.getLong("label.id")), Long.valueOf(labelValue.getLong("id")), this.labelValueMap.get(labelValue.getLong("id")), bizLabelValue);
            }
        }
    }

    private void setResultCache(SceneResult sceneResult, Map<Long, List<Map<String, Object>>> paramMap, Map<String, List<PolicyResult>> lruCacheMap) {
        Long pkId = Long.valueOf(sceneResult.getSerialNumber());
        if (paramMap.containsKey(pkId) && paramMap.get(pkId).size() == 1) {
            String cacheKey = this.getCacheKey(paramMap.get(pkId).get(0));
            lruCacheMap.put(cacheKey, sceneResult.getPolicyResults());
        }
    }

    private LabelResultInfo createLabelResultInfo(Long id, List<Map<String, Object>> paramsList) {
        LabelResultInfo resultInfo = new LabelResultInfo();
        resultInfo.setId((Object)id);
        resultInfo.setCreateTime(new Date());
        resultInfo.setLabelObjectId(Long.valueOf(this.brmRuleScene.getLong("labelobject.id")));
        resultInfo.setPolicyId(this.policyId);
        return resultInfo;
    }

    private List<Map<String, Object>> getBrmReqParamsList(Map<Long, List<Map<String, Object>>> paramMap) {
        ArrayList<Map<String, Object>> reqParamsList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<Long, List<Map<String, Object>>> entry : paramMap.entrySet()) {
            for (Map<String, Object> row : entry.getValue()) {
                HashMap<String, Object> reqParamMap = new HashMap<String, Object>(16);
                reqParamMap.put("serialNumber", String.valueOf(row.get("id")));
                reqParamMap.put("bizApp", this.brmRuleScene.getString("brmscene.bizappid.number"));
                reqParamMap.put("sceneNumber", this.brmRuleScene.getString("brmscene.number"));
                reqParamMap.put("buNumber", this.rootOrgNumber);
                if (this.paramsMap.size() > 0) {
                    HashMap<String, Object> inputParams = new HashMap<String, Object>(this.paramsMap.size());
                    for (Map.Entry<String, DynamicObject> param : this.paramsMap.entrySet()) {
                        DynamicObject dynField = param.getValue();
                        if (AnalyseObjectUtil.isBaseDataType((String)dynField.getString("complextype")) && (dynField.getString("fieldalias").endsWith(".id") || dynField.getString("fieldalias").endsWith(".name") || dynField.getString("fieldalias").endsWith(".number"))) {
                            if (param.getKey().startsWith("pl") && !dynField.getString("fieldalias").endsWith(".id")) {
                                inputParams.put(param.getKey(), row.get(dynField.getString("fieldalias")));
                                continue;
                            }
                            Object tempPKid = null;
                            if (dynField.getString("fieldalias").endsWith(".id")) {
                                tempPKid = row.get(dynField.getString("fieldalias"));
                            } else if (dynField.getString("fieldalias").endsWith(".name")) {
                                tempPKid = row.get(dynField.getString("fieldalias").substring(0, dynField.getString("fieldalias").length() - 4) + "id");
                            } else if (dynField.getString("fieldalias").endsWith(".number")) {
                                tempPKid = row.get(dynField.getString("fieldalias").substring(0, dynField.getString("fieldalias").length() - 6) + "id");
                            }
                            DynamicObject baseDataDyn = this.getBaseDataDyn(dynField.getString("entitynumber"), dynField.getString("fieldpath"), dynField.getString("fieldalias"), tempPKid);
                            inputParams.put(param.getKey(), baseDataDyn);
                            continue;
                        }
                        if (FieldControlType.COMBO.getValue().equals(dynField.getString("controltype"))) {
                            if (param.getKey().startsWith("pl")) {
                                inputParams.put(param.getKey(), this.getComboName(dynField.getString("entitynumber"), dynField.getString("fieldpath"), dynField.getString("fieldalias"), row.get(dynField.getString("fieldalias"))));
                                continue;
                            }
                            inputParams.put(param.getKey(), row.get(dynField.getString("fieldalias")));
                            continue;
                        }
                        if (FieldControlType.CHECKBOX.getValue().equals(dynField.getString("controltype"))) {
                            if (LABELOBJECT_TYPE_SUB.equals(row.get(dynField.getString("fieldalias"))) || LABELOBJECT_TYPE_MAIN.equals(row.get(dynField.getString("fieldalias"))) || "true".equals(row.get(dynField.getString("fieldalias"))) || "false".equals(row.get(dynField.getString("fieldalias")))) {
                                inputParams.put(param.getKey(), LABELOBJECT_TYPE_SUB.equals(row.get(dynField.getString("fieldalias"))) || "true".equals(row.get(dynField.getString("fieldalias"))));
                                continue;
                            }
                            inputParams.put(param.getKey(), row.get(dynField.getString("fieldalias")));
                            continue;
                        }
                        if (FieldControlType.MUL_COMBO.getValue().equals(dynField.getString("controltype"))) {
                            if (!"string".equals(dynField.getString("valuetype")) && row.get(dynField.getString("fieldalias")) instanceof String && ("".equals(row.get(dynField.getString("fieldalias"))) || "null".equalsIgnoreCase((String)row.get(dynField.getString("fieldalias"))))) {
                                inputParams.put(param.getKey(), null);
                                continue;
                            }
                            String tempValue = String.valueOf(row.get(dynField.getString("fieldalias")));
                            if (tempValue.startsWith(",")) {
                                tempValue = tempValue.substring(1, tempValue.length());
                            }
                            if (tempValue.endsWith(",")) {
                                tempValue = tempValue.substring(0, tempValue.length() - 1);
                            }
                            inputParams.put(param.getKey(), tempValue);
                            continue;
                        }
                        if (!"string".equals(dynField.getString("valuetype")) && row.get(dynField.getString("fieldalias")) instanceof String && ("".equals(row.get(dynField.getString("fieldalias"))) || "null".equalsIgnoreCase((String)row.get(dynField.getString("fieldalias"))))) {
                            inputParams.put(param.getKey(), null);
                            continue;
                        }
                        inputParams.put(param.getKey(), row.get(dynField.getString("fieldalias")));
                    }
                    reqParamMap.put("inputParams", inputParams);
                }
                reqParamsList.add(reqParamMap);
            }
        }
        return reqParamsList;
    }

    private String getCacheKey(Map<String, Object> row) {
        StringBuilder cacheKey = new StringBuilder();
        for (Map.Entry<String, DynamicObject> param : this.paramsMap.entrySet()) {
            DynamicObject dynField = param.getValue();
            cacheKey.append(row.get(dynField.getString("fieldalias"))).append(';');
        }
        return cacheKey.toString();
    }

    private LabelResultInfo getLabelResultInfo(Long pkId, List<Map<String, Object>> paramList, List<PolicyResult> policyResultList) {
        LabelResultInfo labelResultInfo = this.createLabelResultInfo(pkId, paramList);
        this.setLabelResultValues(labelResultInfo, policyResultList);
        return labelResultInfo;
    }

    @Override
    public List<LabelResultInfo> getRuleResultList(Map<Long, List<Map<String, Object>>> paramMap, Map<String, List<PolicyResult>> lruCacheMap) {
        int totalIdCount = paramMap.size();
        int rowCount = 0;
        int idx = 0;
        int brmMaxRowCount = 500;
        HashMap<Long, List<Map<String, Object>>> tempParamMap = new HashMap<Long, List<Map<String, Object>>>(16);
        ArrayList<LabelResultInfo> resultList = new ArrayList<LabelResultInfo>(10);
        for (Map.Entry<Long, List<Map<String, Object>>> entry : paramMap.entrySet()) {
            String cacheKey;
            ++idx;
            boolean needQueryFromBrm = true;
            if (entry.getValue() != null && entry.getValue().size() == 1 && lruCacheMap.containsKey(cacheKey = this.getCacheKey(entry.getValue().get(0)))) {
                this.addResult2List(this.getLabelResultInfo(entry.getKey(), entry.getValue(), lruCacheMap.get(cacheKey)), resultList);
                needQueryFromBrm = false;
            }
            if (needQueryFromBrm) {
                if (rowCount + entry.getValue().size() > brmMaxRowCount) {
                    resultList.addAll(this.getRuleResultListFromBrm(tempParamMap, lruCacheMap));
                    tempParamMap.clear();
                    rowCount = 0;
                }
                tempParamMap.put(entry.getKey(), entry.getValue());
                rowCount += entry.getValue().size();
            }
            if (idx != totalIdCount || tempParamMap.size() <= 0) continue;
            resultList.addAll(this.getRuleResultListFromBrm(tempParamMap, lruCacheMap));
        }
        this.setDisplayFields(resultList);
        return resultList;
    }
}

