/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.common.model.label.LabelResultEntry;
import kd.hr.hbp.common.model.label.LabelResultInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.ILabelTaskStorageService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;

public class LabelTaskStorageService
implements ILabelTaskStorageService {
    private static final Log LOGGER = LogFactory.getLog(LabelTaskStorageService.class);
    private final Long policyId;
    private final String taskNumber;
    private final EsStorage esStorage;
    private final String preTaskNumber;
    private final String[] selectFields = new String[]{"labelObjectId", "policyId", "taskNumber", "labels.labelId", "createTime", "lastUpdateTime", "isDeleted", "id", "topBizId", "labels.labelValueId", "labels.labelValueName", "labels.labelBizValue", "labels.from", "labels.creatorId", "labels.createTime"};

    public LabelTaskStorageService(Long policyId, String taskNumber) {
        this.policyId = policyId;
        this.taskNumber = HRStringUtils.isEmpty((String)taskNumber) ? "hand" : taskNumber;
        this.esStorage = EsStorageFactory.getStorage((String)"hr");
        DynamicObject labelPolicy = LabelPolicyServiceHelper.getPolicyDy(policyId);
        this.preTaskNumber = labelPolicy != null ? labelPolicy.getString("lasttasknumber") : null;
    }

    @Override
    public String getLabelIndexName() {
        return "hrcs_label_" + this.policyId + "_" + this.taskNumber;
    }

    @Override
    public boolean saveIdList(List<Map<String, Object>> idList, String isProcess) {
        return this.saveIdList(idList, isProcess, 3);
    }

    @Override
    public boolean saveIdList(List<Map<String, Object>> idList, String isProcess, int taskSplitCount) {
        List<EsBatchValue> batchValue = LabelTaskStorageService.buildBatchIdValue(idList, isProcess, taskSplitCount);
        this.esStorage.batchSave(this.getLabelIdIndexName(), "t_data", batchValue.toArray(new EsBatchValue[batchValue.size()]));
        return true;
    }

    private static List<EsBatchValue> buildBatchIdValue(List<Map<String, Object>> idList, String isProcess, int splitCount) {
        ArrayList<EsBatchValue> batchValues = new ArrayList<EsBatchValue>(idList.size());
        for (Map<String, Object> row : idList) {
            ArrayList<EsPropertyValue> propertyValues = new ArrayList<EsPropertyValue>(2);
            propertyValues.add(new EsPropertyValue("id", row.get("id")));
            propertyValues.add(new EsPropertyValue("isprocess", (Object)isProcess));
            propertyValues.add(new EsPropertyValue("splitno", (Object)LabelTaskStorageService.getSplitNumber(row.get("id"), splitCount)));
            EsBatchValue esValue = new EsBatchValue(row.get("id"), propertyValues.toArray(new EsPropertyValue[0]));
            batchValues.add(esValue);
        }
        return batchValues;
    }

    private static int getSplitNumber(Object pkid, int splitCount) {
        if (pkid != null) {
            if (pkid instanceof Integer) {
                return Math.abs((Integer)pkid % splitCount);
            }
            if (pkid instanceof Long) {
                return Math.abs(Integer.parseInt(String.valueOf((Long)pkid % (long)splitCount)));
            }
            return Math.abs(pkid.hashCode() % splitCount);
        }
        return 0;
    }

    @Override
    public List<Map<String, Object>> getProcessDataList(Integer splitNo, int pageSize) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("splitno", "=", (Object)splitNo));
        qFilters.add(new QFilter("isprocess", "=", (Object)"0"));
        String indexName = this.getLabelIdIndexName();
        ArrayList<EsFilterField> filters = null;
        filters = new ArrayList<EsFilterField>(qFilters.size());
        for (QFilter qFilter : qFilters) {
            filters.add(new EsFilterField("", qFilter.getProperty(), "=", new Object[]{qFilter.getValue()}));
        }
        EsResultVo result = this.esStorage.query(indexName, "t_data", new String[]{"id", "splitno"}, filters, null, true, 0, pageSize);
        return result.getResultData();
    }

    @Override
    public boolean batchSaveLabelResult(List<LabelResultInfo> labelResultList, String from) {
        List<EsBatchValue> batchValue = LabelTaskStorageService.buildBatchResultValue(labelResultList, from);
        if (batchValue.size() > 0) {
            String indexName = this.getLabelIdIndexName();
            if (!this.esStorage.isIndexExist(indexName).booleanValue()) {
                this.esStorage.createIndex("hr", indexName, null);
                this.addMappingIndex(indexName);
            }
            this.esStorage.batchSave(this.getLabelIndexName(), "t_data", batchValue.toArray(new EsBatchValue[batchValue.size()]));
        }
        return true;
    }

    @Override
    public boolean batchSaveLabelResult(List<LabelResultInfo> labelResultList) {
        return this.batchSaveLabelResult(labelResultList, "PAGE");
    }

    private static List<EsBatchValue> buildBatchResultValue(List<LabelResultInfo> labelResultList, String from) {
        ArrayList<EsBatchValue> batchValues = new ArrayList<EsBatchValue>(labelResultList.size());
        for (LabelResultInfo labelResultInfo : labelResultList) {
            Object key2;
            ArrayList<EsPropertyValue> propertyValues = new ArrayList<EsPropertyValue>(10);
            propertyValues.add(new EsPropertyValue("id", (Object)String.valueOf(labelResultInfo.getId())));
            propertyValues.add(new EsPropertyValue("labelObjectId", (Object)String.valueOf(labelResultInfo.getLabelObjectId())));
            propertyValues.add(new EsPropertyValue("policyId", (Object)String.valueOf(labelResultInfo.getPolicyId())));
            propertyValues.add(new EsPropertyValue("creatorId", (Object)(labelResultInfo.getCreatorId() == null ? "" : String.valueOf(labelResultInfo.getCreatorId()))));
            propertyValues.add(new EsPropertyValue("createTime", (Object)HRDateTimeUtils.format((Date)labelResultInfo.getCreateTime())));
            propertyValues.add(new EsPropertyValue("lastUpdateTime", (Object)(labelResultInfo.getLastUpdateTime() == null ? new Date() : labelResultInfo.getLastUpdateTime())));
            propertyValues.add(new EsPropertyValue("isDeleted", (Object)labelResultInfo.getIsDeleted()));
            EsPropertyValue fields = new EsPropertyValue("fields", EsDataType.NESTED, null);
            ArrayList<EsPropertyValue> fieldValues = new ArrayList<EsPropertyValue>(10);
            if (labelResultInfo.getLabelResult() != null && labelResultInfo.getLabelResult().size() > 0) {
                if (labelResultInfo.getDisplayFields() == null || labelResultInfo.getDisplayFields().size() == 0) {
                    fieldValues.add(new EsPropertyValue("id", (Object)String.valueOf(labelResultInfo.getId())));
                } else {
                    for (Object key2 : labelResultInfo.getDisplayFields().keySet()) {
                        Object value = labelResultInfo.getDisplayFields().get(key2);
                        if (value instanceof Long || value instanceof Integer) {
                            value = String.valueOf(value);
                        }
                        fieldValues.add(new EsPropertyValue((String)key2, value));
                    }
                }
            }
            fields.nests.add(fieldValues);
            propertyValues.add(fields);
            EsPropertyValue labels = new EsPropertyValue("labels", EsDataType.NESTED, null);
            key2 = labelResultInfo.getLabelResult().iterator();
            while (key2.hasNext()) {
                LabelResultEntry label = (LabelResultEntry)key2.next();
                ArrayList<EsPropertyValue> labelValues = new ArrayList<EsPropertyValue>(10);
                labelValues.add(new EsPropertyValue("labelId", (Object)label.getLabelId()));
                labelValues.add(new EsPropertyValue("labelValueId", (Object)label.getLabelValueId()));
                labelValues.add(new EsPropertyValue("labelValueName", (Object)label.getLabelValueName()));
                labelValues.add(new EsPropertyValue("labelBizValue", (Object)label.getLabelBizValue()));
                labelValues.add(new EsPropertyValue("from", (Object)from));
                labelValues.add(new EsPropertyValue("creatorId", (Object)(label.getCreatorId() == null ? "" : String.valueOf(label.getCreatorId()))));
                labelValues.add(new EsPropertyValue("createTime", (Object)(label.getCreateTime() == null ? HRDateTimeUtils.format((Date)new Date()) : HRDateTimeUtils.format((Date)label.getCreateTime()))));
                labels.nests.add(labelValues);
            }
            propertyValues.add(labels);
            EsBatchValue esValue = new EsBatchValue(labelResultInfo.getId(), propertyValues.toArray(new EsPropertyValue[0]));
            batchValues.add(esValue);
        }
        return batchValues;
    }

    @Override
    public boolean batchSaveLabelResultByLabel(List<Map<String, Object>> dataList) {
        return this.batchSaveLabelResultByLabel(this.getLabelIndexName(), dataList);
    }

    private boolean batchSaveLabelResultByLabel(String indexName, List<Map<String, Object>> dataList) {
        List<EsBatchValue> batchValue = LabelTaskStorageService.buildBatchValueByDelete(dataList);
        if (batchValue.size() > 0) {
            String idIndexName = this.getLabelIdIndexName();
            if (!this.esStorage.isIndexExist(idIndexName).booleanValue()) {
                this.esStorage.createIndex("hr", idIndexName, null);
                this.addMappingIndex(indexName);
            }
            this.esStorage.batchSave(indexName, "t_data", batchValue.toArray(new EsBatchValue[0]));
        }
        return true;
    }

    private static List<EsBatchValue> buildBatchValueByDelete(List<Map<String, Object>> dataList) {
        ArrayList batchValues = Lists.newArrayListWithExpectedSize((int)dataList.size());
        for (Map<String, Object> data : dataList) {
            ArrayList propertyValues = Lists.newArrayListWithExpectedSize((int)10);
            propertyValues.add(new EsPropertyValue("id", data.get("id")));
            EsPropertyValue labels = new EsPropertyValue("labels", EsDataType.NESTED, null);
            List labelList = (List)data.get("labels");
            for (Map label : labelList) {
                ArrayList labelValues = Lists.newArrayListWithExpectedSize((int)10);
                labelValues.add(new EsPropertyValue("labelId", label.get("labelId")));
                labelValues.add(new EsPropertyValue("labelValueId", label.get("labelValueId")));
                labelValues.add(new EsPropertyValue("labelValueName", label.get("labelValueName")));
                labelValues.add(new EsPropertyValue("labelBizValue", label.get("labelBizValue")));
                labelValues.add(new EsPropertyValue("from", label.get("from")));
                labelValues.add(new EsPropertyValue("creatorId", label.get("creatorId")));
                labelValues.add(new EsPropertyValue("createTime", label.get("createTime")));
                labels.nests.add(labelValues);
            }
            propertyValues.add(labels);
            EsBatchValue esValue = new EsBatchValue(data.get("id"), propertyValues.toArray(new EsPropertyValue[0]));
            batchValues.add(esValue);
        }
        return batchValues;
    }

    @Override
    public void createLabelIndex(boolean isForceRebuild) {
        String indexName = this.getLabelIndexName();
        String indexIdName = this.getLabelIdIndexName();
        if (this.esStorage.isIndexExist(indexName).booleanValue()) {
            this.esStorage.deleteIndex(indexName);
        }
        this.esStorage.createIndex("hr", indexName, null);
        this.addMappingIndex(indexName);
        if (this.esStorage.isIndexExist(indexIdName).booleanValue()) {
            this.esStorage.deleteIndex(indexIdName);
        }
        this.esStorage.createIndex("hr", indexIdName, null);
        this.savePreLabelResult();
    }

    private void addMappingIndex(String indexName) {
        ArrayList<EsMappingProperty> propertys = new ArrayList<EsMappingProperty>(16);
        propertys.add(new EsMappingProperty("lastUpdateTime", EsDataType.DATE));
        this.esStorage.addMappingIndex(indexName, "t_data", propertys.toArray(new EsMappingProperty[0]));
    }

    private void savePreLabelResult() {
        if (this.preTaskNumber == null || this.preTaskNumber.equals(this.taskNumber)) {
            return;
        }
        String preIndexName = "hrcs_label_" + this.policyId + "_" + this.preTaskNumber;
        if (!this.esStorage.isIndexExist(preIndexName).booleanValue()) {
            return;
        }
        int total = this.getCount(preIndexName, null, true);
        int pageSize = 5000;
        try {
            Object[] objSortValues = null;
            for (int idx = 0; idx < total; idx += pageSize) {
                EsResultVo pageResult = this.getResultList(preIndexName, this.selectFields, null, null, 0, pageSize, true, objSortValues);
                this.batchSavePreResult(pageResult.getResultData());
                objSortValues = pageResult.getObjSortValues();
            }
        }
        catch (Exception exp) {
            LOGGER.error("labeltaskstorage save pre index info error.");
            LOGGER.error((Throwable)exp);
        }
    }

    private void batchSavePreResult(List<Map<String, Object>> pageResultList) {
        if (pageResultList == null || pageResultList.size() == 0) {
            return;
        }
        ArrayList batchValues = Lists.newArrayListWithExpectedSize((int)pageResultList.size());
        for (Map<String, Object> data : pageResultList) {
            ArrayList propertyValues = Lists.newArrayListWithExpectedSize((int)10);
            propertyValues.add(new EsPropertyValue("id", data.get("id")));
            propertyValues.add(new EsPropertyValue("labelObjectId", data.get("labelObjectId")));
            propertyValues.add(new EsPropertyValue("policyId", data.get("policyId")));
            propertyValues.add(new EsPropertyValue("createTime", data.get("createTime")));
            propertyValues.add(new EsPropertyValue("isDeleted", (Object)1));
            if ("1".equals(String.valueOf(data.get("isDeleted")))) {
                propertyValues.add(new EsPropertyValue("lastUpdateTime", data.get("lastUpdateTime")));
            } else {
                propertyValues.add(new EsPropertyValue("lastUpdateTime", (Object)new Date()));
            }
            EsPropertyValue labels = new EsPropertyValue("labels", EsDataType.NESTED, null);
            List labelList = (List)data.get("labels");
            for (Map label : labelList) {
                ArrayList labelValues = Lists.newArrayListWithExpectedSize((int)10);
                labelValues.add(new EsPropertyValue("labelId", label.get("labelId")));
                labelValues.add(new EsPropertyValue("labelValueId", label.get("labelValueId")));
                labelValues.add(new EsPropertyValue("labelValueName", label.get("labelValueName")));
                labelValues.add(new EsPropertyValue("labelBizValue", label.get("labelBizValue")));
                labelValues.add(new EsPropertyValue("from", label.get("from")));
                labelValues.add(new EsPropertyValue("creatorId", label.get("creatorId")));
                labelValues.add(new EsPropertyValue("createTime", label.get("createTime")));
                labels.nests.add(labelValues);
            }
            propertyValues.add(labels);
            EsBatchValue esValue = new EsBatchValue(data.get("id"), propertyValues.toArray(new EsPropertyValue[0]));
            batchValues.add(esValue);
        }
        if (batchValues.size() > 0) {
            this.esStorage.batchSave(this.getLabelIndexName(), "t_data", batchValues.toArray(new EsBatchValue[0]));
        }
    }

    @Override
    public List<Map<String, Object>> getResultList(String[] selectFields, List<QFilter> qFilters, int start, int pageSize) {
        return this.getResultList(selectFields, qFilters, null, start, pageSize);
    }

    @Override
    public String getLabelIdIndexName() {
        return "hrcs_label_id_" + this.policyId + "_" + this.taskNumber;
    }

    @Override
    public int getAllCount(List<QFilter> qFilters) {
        return this.getCount(qFilters, true);
    }

    @Override
    public int getCount(List<QFilter> qFilters) {
        return this.getCount(qFilters, false);
    }

    public int getCount(List<QFilter> qFilters, boolean containDeleted) {
        return this.getCount(this.getLabelIndexName(), qFilters, containDeleted);
    }

    public int getCount(String indexName, List<QFilter> qFilters, boolean containDeleted) {
        if (!this.esStorage.isIndexExist(indexName).booleanValue()) {
            return 0;
        }
        ArrayList<EsFilterField> filters = new ArrayList<EsFilterField>(10);
        if (!containDeleted) {
            filters.add(new EsFilterField("", "isDeleted", "!=", new Object[]{1}));
        }
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if ("in".equals(qFilter.getCP()) && qFilter.getValue() instanceof List) {
                    filters.add(new EsFilterField("", qFilter.getProperty(), qFilter.getCP(), ((List)qFilter.getValue()).toArray()));
                    continue;
                }
                filters.add(new EsFilterField("", qFilter.getProperty(), qFilter.getCP(), new Object[]{qFilter.getValue()}));
            }
        }
        return this.esStorage.getCount(indexName, "t_data", filters);
    }

    @Override
    public void deleteIndex(String indexName) {
        if (this.esStorage.isIndexExist(indexName).booleanValue()) {
            this.esStorage.deleteIndex(indexName);
        }
    }

    @Override
    public void deleteByIds(List<Object> ids) {
        String indexName = this.getLabelIndexName();
        if (this.esStorage.isIndexExist(indexName).booleanValue()) {
            ArrayList<EsFilterField> filters = new ArrayList<EsFilterField>();
            if (ids != null) {
                EsFilterField esFilter = new EsFilterField("", "id", "in", ids.toArray());
                filters.add(esFilter);
            }
            EsPropertyValue[] upFields = new EsPropertyValue[]{new EsPropertyValue("isDeleted", (Object)1), new EsPropertyValue("lastUpdateTime", (Object)new Date())};
            this.esStorage.updateByQuery(indexName, "t_data", filters, upFields);
        }
    }

    @Override
    public List<Map<String, Object>> getAllResultList(String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize) {
        return this.getResultList(selectFields, qFilters, orderBy, start, pageSize, true);
    }

    @Override
    public List<Map<String, Object>> getResultList(String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize) {
        return this.getResultList(selectFields, qFilters, orderBy, start, pageSize, false);
    }

    private List<Map<String, Object>> getResultList(String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize, boolean containDeleted) {
        return this.getResultList(this.getLabelIndexName(), selectFields, qFilters, orderBy, start, pageSize, containDeleted);
    }

    private List<Map<String, Object>> getResultList(String indexName, String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize, boolean containDeleted) {
        if (!this.esStorage.isIndexExist(indexName).booleanValue()) {
            return new ArrayList<Map<String, Object>>(10);
        }
        ArrayList<EsFilterField> filters = new ArrayList<EsFilterField>(10);
        if (!containDeleted) {
            filters.add(new EsFilterField("", "isDeleted", "!=", new Object[]{1}));
        }
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if ("in".equals(qFilter.getCP()) && qFilter.getValue() instanceof List) {
                    filters.add(new EsFilterField("", qFilter.getProperty(), qFilter.getCP(), ((List)qFilter.getValue()).toArray()));
                    continue;
                }
                filters.add(new EsFilterField("", qFilter.getProperty(), qFilter.getCP(), new Object[]{qFilter.getValue()}));
            }
        }
        SortField sortField = null;
        if (!HRStringUtils.isEmpty((String)orderBy)) {
            String[] orderByArrSub = orderBy.split(" ");
            String fieldName = orderByArrSub[0];
            sortField = new SortField(fieldName);
            if (orderByArrSub.length == 2) {
                if ("ASC".equalsIgnoreCase(orderByArrSub[1])) {
                    sortField.setAsc(true);
                } else {
                    sortField.setAsc(false);
                }
            } else if (orderByArrSub.length == 1) {
                sortField.setAsc(true);
            }
        }
        EsResultVo result = this.esStorage.query(indexName, "t_data", selectFields, filters, new SortField[]{sortField}, true, start, pageSize);
        return result.getResultData();
    }

    @Override
    public List<Map<String, Object>> getMultiResultList(Long policyId, String taskNumber, String[] selectFields, List<QFilter> qFilters, int start, int pageSize) {
        return this.getResultList("hrcs_label_" + policyId + "_" + taskNumber, selectFields, qFilters, null, start, pageSize, false);
    }

    @Override
    public List<Map<String, Object>> getMultiResultList(Long policyId, String taskNumber, String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize) {
        return this.getResultList("hrcs_label_" + policyId + "_" + taskNumber, selectFields, qFilters, orderBy, start, pageSize, false);
    }

    @Override
    public int getMultiCount(Long policyId, String taskNumber, List<QFilter> qFilters) {
        return this.getCount("hrcs_label_" + policyId + "_" + taskNumber, qFilters, false);
    }

    @Override
    public EsResultVo getResultList(String[] selectFields, List<QFilter> qFilters, int start, int pageSize, Object[] objSortValues) {
        return this.getResultList(selectFields, qFilters, null, start, pageSize, objSortValues);
    }

    @Override
    public EsResultVo getResultList(String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize, Object[] objSortValues) {
        return null;
    }

    @Override
    public EsResultVo getMultiResultList(Long policyId, String taskNumber, String[] selectFields, List<QFilter> qFilters, int start, int pageSize, Object[] objSortValues) {
        return this.getMultiResultList(policyId, taskNumber, selectFields, qFilters, null, start, pageSize, objSortValues);
    }

    @Override
    public EsResultVo getMultiResultList(Long policyId, String taskNumber, String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize, Object[] objSortValues) {
        return this.getResultList("hrcs_label_" + policyId + "_" + taskNumber, selectFields, qFilters, orderBy, start, pageSize, false, objSortValues);
    }

    @Override
    public EsResultVo getAllResultList(String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize, Object[] objSortValues) {
        return this.getResultList("hrcs_label_" + this.policyId + "_" + this.taskNumber, selectFields, qFilters, orderBy, start, pageSize, true, objSortValues);
    }

    private EsResultVo getResultList(String indexName, String[] selectFields, List<QFilter> qFilters, String orderBy, int start, int pageSize, boolean containDeleted, Object[] objSortValues) {
        if (!this.esStorage.isIndexExist(indexName).booleanValue()) {
            return new EsResultVo();
        }
        ArrayList<EsFilterField> filters = new ArrayList<EsFilterField>(10);
        if (!containDeleted) {
            filters.add(new EsFilterField("", "isDeleted", "!=", new Object[]{1}));
        }
        if (qFilters != null) {
            for (QFilter qFilter : qFilters) {
                if ("in".equals(qFilter.getCP()) && qFilter.getValue() instanceof List) {
                    filters.add(new EsFilterField("", qFilter.getProperty(), qFilter.getCP(), ((List)qFilter.getValue()).toArray()));
                    continue;
                }
                filters.add(new EsFilterField("", qFilter.getProperty(), qFilter.getCP(), new Object[]{qFilter.getValue()}));
            }
        }
        SortField sortField = null;
        if (!HRStringUtils.isEmpty((String)orderBy)) {
            String[] orderByArrSub = orderBy.split(" ");
            String fieldName = orderByArrSub[0];
            sortField = new SortField(fieldName);
            if (orderByArrSub.length == 2) {
                if ("ASC".equalsIgnoreCase(orderByArrSub[1])) {
                    sortField.setAsc(true);
                } else {
                    sortField.setAsc(false);
                }
            } else if (orderByArrSub.length == 1) {
                sortField.setAsc(true);
            }
        }
        return this.esStorage.searchAfter(indexName, "t_data", selectFields, filters, new SortField[]{sortField}, true, start, pageSize, objSortValues);
    }
}

