/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.label;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.common.constants.label.LabelConstants;

@ExcludeFromJacocoGeneratedReport
public class ObjectFieldServiceHelper {
    private static final Log logger = LogFactory.getLog(ObjectFieldServiceHelper.class);

    public static boolean saveBatchFields(List<DynamicObject> objs) {
        Map<Long, DynamicObject> updateObjectMap;
        QFilter qFilter;
        if (CollectionUtils.isEmpty(objs)) {
            return false;
        }
        List<DynamicObject> newObjects = objs.stream().filter(obj -> obj.getLong("id") == 0L).collect(Collectors.toList());
        List<DynamicObject> updateObjects = objs;
        updateObjects.removeAll(newObjects);
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject obj2 : newObjects) {
            obj2.set("creator", (Object)userId);
            obj2.set("fieldtypeid", (Object)LabelConstants.VAL_DEFAULT_NODE_ID);
        }
        HRBaseServiceHelper fieldServiceHelper = new HRBaseServiceHelper("hrcs_lblobjectfield");
        DynamicObject[] updateFields = null;
        if (CollectionUtils.isNotEmpty(updateObjects) && (updateFields = fieldServiceHelper.query("id,fieldname,modifier,modifytime,selectedfield", new QFilter[]{qFilter = new QFilter("id", "in", (updateObjectMap = updateObjects.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy))).keySet())})) != null && updateFields.length > 0) {
            for (DynamicObject obj3 : updateFields) {
                DynamicObject oldDy = updateObjectMap.get(obj3.getLong("id"));
                obj3.set("fieldname", (Object)oldDy.getString("fieldname"));
                obj3.set("selectedfield", (Object)oldDy.getBoolean("selectedfield"));
                obj3.set("modifier", (Object)userId);
                obj3.set("modifytime", (Object)new Date());
            }
        }
        try (TXHandle txHandle = TX.required();){
            try {
                if (CollectionUtils.isNotEmpty(newObjects)) {
                    int newSize = newObjects.size();
                    DynamicObject[] newObjectArray = new DynamicObject[newSize];
                    newObjects.toArray(newObjectArray);
                    fieldServiceHelper.save(newObjectArray);
                }
                if (updateFields != null && updateFields.length > 0) {
                    fieldServiceHelper.updateDatas(updateFields);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                if (logger.isErrorEnabled()) {
                    logger.error("save or update label object fields  failed :", (Throwable)e);
                }
                int n = 0;
                if (txHandle != null) {
                    if (var7_7 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return n != 0;
            }
        }
        return true;
    }
}

