/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class EntityReleaseInfoService {
    private static String releaseInfoEntityName = "hrcs_entityreleaseinfo";
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(releaseInfoEntityName);

    public static DynamicObject getEntityReleaseInfoByName(String queryEntityName) {
        Map<String, String> srcAndExtNumMap = EntityReleaseInfoService.querySrcAndExtNum(queryEntityName);
        QFilter filterQueryEntityName = new QFilter("queryentityname", "in", srcAndExtNumMap.values());
        DynamicObject[] dyReleaseInfoList = serviceHelper.query("queryentityname,modifytime,datasourcetype,ksqlquerytype,ksqluseunion,bizapplytype", new QFilter[]{filterQueryEntityName});
        if (dyReleaseInfoList == null || dyReleaseInfoList.length == 0) {
            return null;
        }
        if (dyReleaseInfoList.length > 1) {
            DynamicObject dynamicObject = Arrays.stream(dyReleaseInfoList).filter(dyo -> dyo.get("queryentityname").equals(srcAndExtNumMap.get("extnum"))).findFirst().orElse(null);
            if (dynamicObject == null) {
                throw new KDException(BosEsErrorCode.esException, new Object[]{"Query entity name: (" + queryEntityName + "),release infomation data has more than 1 row!"});
            }
            return dynamicObject;
        }
        return dyReleaseInfoList[0];
    }

    private static Map<String, String> querySrcAndExtNum(String queryEntityNumber) {
        String entityMetaQuerySql = "select source.fnumber srcnum, ext.fnumber extnum\nfrom t_meta_entitydesign source\n         left join t_meta_entitydesign ext on source.fid = ext.fparentid\nwhere source.fmodeltype = 'QueryListModel'\n  and source.fnumber = ? ";
        HashMap<String, String> rstMap = new HashMap<String, String>(2);
        rstMap.put("srcnum", queryEntityNumber);
        HRDBUtil.query((DBRoute)DBRoute.meta, (String)entityMetaQuerySql, (Object[])new Object[]{queryEntityNumber}, resultSet -> {
            String extnum;
            if (resultSet.next() && HRStringUtils.isNotEmpty((String)(extnum = resultSet.getString("extnum")))) {
                rstMap.put("extnum", extnum);
            }
            return null;
        });
        return rstMap;
    }

    public static DynamicObject[] getEntityReleaseInfoListByName(List<String> listQueryEntityName) {
        QFilter filterQueryEntityName = new QFilter("queryentityname", "in", listQueryEntityName);
        DynamicObject[] dyReleaseInfoList = serviceHelper.query("queryentityname,modifytime,datasourcetype,ksqlquerytype,ksqluseunion,bizapplytype", new QFilter[]{filterQueryEntityName});
        return dyReleaseInfoList;
    }

    public static Object saveOne(DynamicObject dobj) {
        return serviceHelper.saveOne(dobj);
    }

    public static void deleteByEntityNumber(String number) {
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("queryentityname", "=", (Object)number)});
    }

    public static DynamicObject generateEmptyDynamicObject() {
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("ksqlquerytype", (Object)"SQLQUERY");
        dynamicObject.set("ksqluseunion", (Object)Boolean.TRUE);
        return dynamicObject;
    }

    public static List<String> findQueryentitynameByBizapplytype(String bizapplytype) {
        DynamicObjectCollection objects = serviceHelper.queryOriginalCollection("queryentityname", new QFilter[]{new QFilter("bizapplytype", "=", (Object)bizapplytype)});
        return objects.stream().map(de -> de.getString("queryentityname")).collect(Collectors.toList());
    }

    public static List<String> findQueryentityIdByNumber(List<String> numbers) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("cts_querydynsourcelist");
        DynamicObjectCollection collection = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("number", "in", numbers)});
        return collection.stream().map(de -> de.getString("id")).collect(Collectors.toList());
    }

    public static List<String> findExtentQueryentityId() {
        QFilter[] qFilters = new QFilter[]{new QFilter("modeltype", "=", (Object)"QueryListModel"), new QFilter("inheritpath", "!=", (Object)" ")};
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id", (QFilter[])qFilters);
        return Arrays.asList(collection).stream().map(de -> de.getString("id")).collect(Collectors.toList());
    }

    public static boolean isExtentQueryentity(String id) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,inheritpath", (QFilter[])qFilters);
        return StringUtils.isNotEmpty((String)collection[0].getString("inheritpath"));
    }
}

