/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDBUtil;

public class EntitySyncConfigService {
    private static final String prefix = "hrentitytransmapping#parm=";

    public static DynamicObjectCollection getEntitySyncConfig(int start, int limit, QueryBuilder queryBuilder, DynamicObjectType dt) {
        StringBuilder sql = new StringBuilder("SELECT top ");
        sql.append(limit).append(',').append(start).append(' ');
        sql.append(" fid,fentitynumber,fmappingrule ");
        sql.append(EntitySyncConfigService.getFromAndWhereSql(queryBuilder));
        sql.append(" ORDER BY fentitynumber");
        List<Map<String, String>> list = EntitySyncConfigService.queryMetaEntityDesign(sql);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dt, null);
        for (Map<String, String> map : list) {
            DynamicObject dyn = new DynamicObject(dt);
            dyn.set("id", (Object)map.get("FID"));
            String entityNumber = map.get("fentitynumber");
            dyn.set("number", (Object)entityNumber);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            LocaleString localeString = mainEntityType.getDisplayName();
            String displayName = (String)localeString.getDefaultItem();
            dyn.set("entityname", (Object)displayName);
            String mappingrule = map.get("fmappingrule");
            mappingrule = mappingrule.replaceFirst(prefix, "");
            dyn.set("name", (Object)mappingrule);
            String[] rpcParmArray = mappingrule.split("\\$");
            if (rpcParmArray == null || rpcParmArray.length != 4) continue;
            dyn.set("cloudid", (Object)rpcParmArray[0]);
            dyn.set("appid", (Object)rpcParmArray[1]);
            dyn.set("servicename", (Object)rpcParmArray[2]);
            dyn.set("methodname", (Object)rpcParmArray[3]);
            dynamicObjectCollection.add((Object)dyn);
        }
        return dynamicObjectCollection;
    }

    private static String getFromAndWhereSql(QueryBuilder queryBuilder) {
        StringBuilder sql = new StringBuilder();
        sql.append(" FROM t_dts_datasyncconfig WHERE fenable='1' and fregion = 'hr' and fmappingrule like 'hrentitytransmapping#parm=%' ");
        QFilter[] qFilters = queryBuilder.getFilters();
        if (qFilters != null && qFilters.length > 0) {
            String valuePrefix = "number#";
            for (QFilter qFilter : qFilters) {
                String cp = qFilter.getCP();
                Object objValue = qFilter.getValue();
                String value = (String)objValue;
                if (!StringUtils.isNotEmpty((CharSequence)value) || !StringUtils.isNotEmpty((CharSequence)cp) || !cp.equals("ftlike") || !value.startsWith(valuePrefix)) continue;
                String realValue = value.substring(valuePrefix.length());
                sql.append("and fentitynumber like '%");
                sql.append(realValue);
                sql.append("%' ");
            }
        }
        return sql.toString();
    }

    private static List<Map<String, String>> queryMetaEntityDesign(StringBuilder sql) {
        final ArrayList<Map<String, String>> listDB = new ArrayList<Map<String, String>>();
        HRDBUtil.query((DBRoute)DBRoute.base, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put("FID", rs.getString("FID"));
                    tempMap.put("fentitynumber", rs.getString("fentitynumber"));
                    tempMap.put("fmappingrule", rs.getString("fmappingrule"));
                    listDB.add(tempMap);
                }
                return null;
            }
        });
        return listDB;
    }

    public static int getDataCount(QueryBuilder queryBuilder) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(1) as dataCount ");
        sql.append(EntitySyncConfigService.getFromAndWhereSql(queryBuilder));
        return EntitySyncConfigService.getEntitySyncConfigCount(sql);
    }

    private static int getEntitySyncConfigCount(StringBuffer sql) {
        final int[] dataCount = new int[1];
        HRDBUtil.query((DBRoute)DBRoute.base, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                rs.next();
                dataCount[0] = rs.getInt("dataCount");
                return null;
            }
        });
        return dataCount[0];
    }
}

