/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.QueryEntity;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hrcs.bussiness.service.aisearch.EsSyncSchemeConfigService;
import kd.hr.hrcs.bussiness.service.multientity.EsStrageBaseHelper;
import kd.hr.hrcs.bussiness.service.multientity.IEsQueryEntityReleaseService;
import kd.hr.hrcs.bussiness.service.multientity.impl.AIQEsDtsBusinessType;
import kd.hr.hrcs.bussiness.service.multientity.impl.AiSearchEsCreateMapping;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class AISearchEsQueryEntityReleaseService
implements IEsQueryEntityReleaseService {
    private static final Log logger = LogFactory.getLog(AISearchEsQueryEntityReleaseService.class);
    private static volatile AISearchEsQueryEntityReleaseService esQueryEntityReleaseService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AISearchEsQueryEntityReleaseService getInstance() {
        if (esQueryEntityReleaseService != null) return esQueryEntityReleaseService;
        Class<AISearchEsQueryEntityReleaseService> clazz = AISearchEsQueryEntityReleaseService.class;
        synchronized (AISearchEsQueryEntityReleaseService.class) {
            if (esQueryEntityReleaseService != null) return esQueryEntityReleaseService;
            esQueryEntityReleaseService = new AISearchEsQueryEntityReleaseService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return esQueryEntityReleaseService;
        }
    }

    @Override
    public int batchImportData(Long esschemeId, Long syncRecordId) throws KDBizException {
        DynamicObject esscheme = EsSyncSchemeConfigService.load(esschemeId);
        String queryEntityName = esscheme.getString("queryentity.number");
        long startTime = System.currentTimeMillis();
        logger.info("HRSmartSearch batch import data queryEntityName:{},startTime:{}", (Object)queryEntityName, (Object)startTime);
        String mappingRule = "hraiqmultmapping#multientityname=" + queryEntityName;
        String businessType = AIQEsDtsBusinessType.class.getName();
        QueryEntity queryEntity = EsStrageBaseHelper.getQueryEntity(queryEntityName);
        if (queryEntity == null) {
            return 0;
        }
        if (this.isFullSync(queryEntityName, queryEntity.getEntityName())) {
            return 1;
        }
        String lockKey = EsCommonUtils.getLockPath((String)"hr", (String)queryEntityName) + "_lock";
        DLock lock = DLock.create((String)lockKey);
        try {
            boolean locked = lock.tryLock();
            if (!locked) {
                int n = 1;
                return n;
            }
            int version = 1;
            version = (Integer)esscheme.get("version") + 1;
            AiSearchEsCreateMapping esCreateMapping = new AiSearchEsCreateMapping();
            String indexName = EsCommonUtils.getAISearchIndexName((String)"hr", (String)queryEntityName, (int)version);
            EsStorage storage = EsStrageBaseHelper.init();
            esCreateMapping.createMapping(storage, queryEntity, indexName);
            this.saveDtsConfig(mappingRule, businessType, queryEntity);
            esscheme.set("version", (Object)version);
            esscheme.set("modifytime", (Object)new Date());
            EsSyncSchemeConfigService.saveOne(esscheme);
        }
        catch (KDBizException e) {
            logger.error("import_es_data_occur_exception: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("HRSmartSearch_import_es_data_occur_exception:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65ES\u6570\u636e\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AISearchEsQueryEntityReleaseService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        finally {
            try {
                lock.unlock();
            }
            catch (Exception ignore) {
                logger.error("lock.unlock()_occur_exception: {}", (Object)CommonUtil.getStackTrace((Exception)ignore));
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("HRSmartSearch batch import data queryEntityName:{}, total time:{}ms", (Object)queryEntityName, (Object)(endTime - startTime));
        return 0;
    }

    private void saveDtsConfig(String mappingRule, String businessType, QueryEntity queryEntity) {
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        dtsConfigOperator.deleteDtsConfig(queryEntity.getEntityName(), businessType, "hr", mappingRule);
        List joinEntities = queryEntity.getJoinEntitys();
        for (JoinEntity joinEntity : joinEntities) {
            String joinEntityName = joinEntity.getEntityName();
            dtsConfigOperator.deleteDtsConfig(joinEntityName, businessType, "hr", mappingRule);
        }
        Map<String, List<String>> mapEntityAndFileds = this.getQueryEntitySelectFileds(queryEntity);
        for (JoinEntity joinEntity : joinEntities) {
            String joinEntityName = joinEntity.getEntityName();
            this.saveDtsConfigOperatorInfo(joinEntityName, mappingRule, businessType, mapEntityAndFileds, dtsConfigOperator);
        }
        this.saveDtsConfigOperatorInfo(queryEntity.getEntityName(), mappingRule, businessType, mapEntityAndFileds, dtsConfigOperator);
    }

    private Map<String, List<String>> getQueryEntitySelectFileds(QueryEntity queryEntity) {
        HashMap mapEntityAndFileds = Maps.newHashMapWithExpectedSize((int)queryEntity.getJoinEntitys().size());
        List listJoinEntityName = queryEntity.getJoinEntitys().stream().map(JoinEntity::getEntityName).collect(Collectors.toList());
        HashSet setSelectFileld = Sets.newHashSetWithExpectedSize((int)queryEntity.getSelectFields().size());
        for (QuerySelectField selectField : queryEntity.getSelectFields()) {
            String fieldName = selectField.getAlias();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            for (String joinEntityName : listJoinEntityName) {
                String[] nameKeys = fieldName.split("\\.");
                if (nameKeys.length <= 2 || !fieldName.startsWith(joinEntityName + ".")) continue;
                fieldName = (String)nameKeys[0] + "." + (String)nameKeys[1];
            }
            setSelectFileld.add(fieldName);
        }
        for (String joinEntityName : listJoinEntityName) {
            mapEntityAndFileds.put(joinEntityName, null);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
            DataEntityPropertyCollection dataEntityPropertyCollection = entityType.getProperties();
            ArrayList<String> entityFieldList = new ArrayList<String>();
            entityFieldList.add(entityType.getPrimaryKey().getName());
            for (IDataEntityProperty dataEntityProperty : dataEntityPropertyCollection) {
                boolean isDbIgnore = dataEntityProperty.isDbIgnore();
                if (isDbIgnore) continue;
                String name = dataEntityProperty.getName();
                String entityProperty = joinEntityName + "." + name;
                if (!setSelectFileld.contains(entityProperty)) continue;
                entityFieldList.add(name);
            }
            mapEntityAndFileds.put(joinEntityName, entityFieldList);
        }
        String mainEntityName = queryEntity.getEntityName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityName);
        DataEntityPropertyCollection mainDataEntityPropertyCollection = mainEntityType.getProperties();
        ArrayList<String> entityFieldList = new ArrayList<String>();
        for (IDataEntityProperty dataEntityProperty : mainDataEntityPropertyCollection) {
            String name;
            boolean isDbIgnore = dataEntityProperty.isDbIgnore();
            if (isDbIgnore && !(dataEntityProperty instanceof BasedataProp) || !setSelectFileld.contains(name = dataEntityProperty.getName())) continue;
            entityFieldList.add(name);
        }
        mapEntityAndFileds.put(mainEntityName, entityFieldList);
        return mapEntityAndFileds;
    }

    private void saveDtsConfigOperatorInfo(String entityName, String mappingRule, String businessType, Map<String, List<String>> mapEntityAndFileds, DtsConfigOperator dtsConfigOperator) {
        List<String> entityFieldList = mapEntityAndFileds.get(entityName);
        if (entityFieldList == null) {
            return;
        }
        DtsConfigOperatorInfo dtsConfigOperatorInfo = new DtsConfigOperatorInfo();
        dtsConfigOperatorInfo.setEntityNumber(entityName);
        dtsConfigOperatorInfo.setDtsDestType(DtsDestTypeEnum.FULLTEXT);
        dtsConfigOperatorInfo.setRegion("hr");
        dtsConfigOperatorInfo.setMappingRule(mappingRule);
        dtsConfigOperatorInfo.setBusinessType(businessType);
        dtsConfigOperatorInfo.setEnable("1");
        dtsConfigOperatorInfo.setEntityFields(entityFieldList.toArray(new String[0]));
        dtsConfigOperator.saveDtsConfig(dtsConfigOperatorInfo);
    }

    @Override
    public boolean isFullSync(String queryEntityName, String mainEntityName) {
        String mappingRule = "hraiqmultmapping#multientityname=" + queryEntityName;
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        boolean isFullSync = dtsConfigOperator.isFullSync(mainEntityName, "hr", DtsDestTypeEnum.FULLTEXT.getCode(), mappingRule);
        return isFullSync;
    }

    @Override
    public void stopIncrement(Long recordid, String queryEntityName) {
    }
}

