/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.QueryEntity;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.EsTokenizerType;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hrcs.bussiness.service.aisearch.AISearchEsConfigService;
import kd.hr.hrcs.bussiness.service.multientity.EsStrageBaseHelper;
import kd.hr.hrcs.bussiness.service.multientity.IEsCreateMapping;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.ElasticsearchStatusException;

public class AiSearchEsCreateMapping
implements IEsCreateMapping {
    private static final Log logger = LogFactory.getLog(AiSearchEsCreateMapping.class);
    private InteServiceImpl inteService = new InteServiceImpl();
    private Set<String> enableLangNums;

    public Set<String> getEnableLangNums() {
        if (this.enableLangNums != null && this.enableLangNums.size() > 0) {
            return this.enableLangNums;
        }
        List enabledLang = this.inteService.getEnabledLang();
        this.enableLangNums = enabledLang.stream().map(EnabledLang::getNumber).collect(Collectors.toSet());
        return this.enableLangNums;
    }

    @Override
    public void createMapping(EsStorage storage, QueryEntity queryEntity, String indexName) throws KDBizException {
        if (storage.isIndexExist(indexName).booleanValue()) {
            storage.deleteIndex(indexName);
        }
        try {
            storage.createIndex("hr", indexName, null);
        }
        catch (ElasticsearchStatusException e) {
            logger.error("AIQ create es mapping exception: {}", (Object)CommonUtil.getStackTrace((Exception)((Object)e)));
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efaES\u7d22\u5f15\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AiSearchEsCreateMapping_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        List<EsMappingProperty> propertys = this.buildMappingPropertys(queryEntity);
        storage.addMappingIndex(indexName, "t_data", propertys.toArray(new EsMappingProperty[0]));
    }

    private void parseSelectField(QueryEntity queryEntity, Set<String> mainPropertys, Set<String> nestPropertys) {
        for (QuerySelectField selectField : queryEntity.getSelectFields()) {
            MainEntityType relationEntityType;
            String fieldName = selectField.getAlias();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            boolean mainFlags = false;
            String entityName = QFilterUtilHR.getSubEntityName((String)fieldName, (QueryEntity)queryEntity);
            if (entityName == null) {
                entityName = queryEntity.getEntityName();
                mainFlags = true;
            }
            try {
                relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            }
            catch (Exception ex) {
                throw new KDBizException("Read entity meta data from cache error! entity name: " + entityName);
            }
            IDataEntityProperty joinProperty = this.transBaseDataToId(relationEntityType, fieldName);
            if (joinProperty instanceof BasedataProp) {
                fieldName = fieldName + ".id";
            }
            if (mainFlags) {
                mainPropertys.add(fieldName);
                continue;
            }
            if (!fieldName.contains(entityName)) {
                fieldName = entityName + "." + fieldName;
            }
            nestPropertys.add(fieldName);
        }
        mainPropertys.remove(null);
        nestPropertys.remove(null);
        mainPropertys.add("id");
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            nestPropertys.add(joinEntity.getEntityName() + ".id");
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            String fieldName = AiSearchEsCreateMapping.transferBaseData(mainEntityType, joinEntity.getFKProperty(), true);
            mainPropertys.add(fieldName);
            nestPropertys.add(joinEntity.getEntityName() + ".id");
        }
    }

    public static String transferBaseData(MainEntityType entityType, String property, boolean isMapping) {
        IDataEntityProperty joinProperty = QueryEntityUtil.findProperty((MainEntityType)entityType, (String)property);
        if (joinProperty instanceof IComplexProperty) {
            property = joinProperty.getName() + (isMapping ? ".id" : "_id");
        }
        return property;
    }

    private IDataEntityProperty transBaseDataToId(MainEntityType entityType, String property) {
        String[] split;
        String propertyStrCopy = property;
        String entityTypeName = entityType.getName();
        if (propertyStrCopy.startsWith(entityTypeName + ".")) {
            propertyStrCopy = propertyStrCopy.replace(entityTypeName + ".", "");
        }
        if (1 > (split = propertyStrCopy.split("\\.")).length || split.length > 4) {
            return null;
        }
        if (split.length == 1) {
            return entityType.getProperty(split[0]);
        }
        DynamicProperty bdProp = entityType.getProperty(split[0]);
        if (bdProp instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)bdProp;
            String newProp = propertyStrCopy.replace(split[0] + ".", "");
            return this.transBaseDataToId(EntityMetadataCache.getDataEntityType((String)basedataProp.getBaseEntityId()), newProp);
        }
        return bdProp;
    }

    private List<EsMappingProperty> buildMappingPropertys(QueryEntity queryEntity) throws KDBizException {
        HashSet<String> mainPropertys = new HashSet<String>();
        HashSet<String> nestPropertySet = new HashSet<String>();
        this.parseSelectField(queryEntity, mainPropertys, nestPropertySet);
        ArrayList<EsMappingProperty> esMappingPropertyList = new ArrayList<EsMappingProperty>();
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            MainEntityType relationEntityType;
            EsMappingProperty nestPropertys;
            String joinEntityName = joinEntity.getEntityName();
            List<String> joinSelectListNew = EsStrageBaseHelper.filterPropertys(nestPropertySet, joinEntityName);
            if (joinSelectListNew.size() <= 0) continue;
            DynamicObject aiSearchEsConfig = AISearchEsConfigService.queryAISearchEsConfig(queryEntity.getKey());
            String arrayDisPlayProp = AISearchEsConfigService.getArrayDisPlayProp(aiSearchEsConfig, joinEntityName);
            if (StringUtils.isNotEmpty((CharSequence)arrayDisPlayProp)) {
                nestPropertys = new EsMappingProperty(joinEntityName, EsDataType.OBJECT);
                relationEntityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
                this.buildProperty(relationEntityType, "id", nestPropertys.nests);
                String[] split = arrayDisPlayProp.split("\\.");
                if (split.length == 1) {
                    this.buildProperty(relationEntityType, arrayDisPlayProp, nestPropertys.nests);
                } else {
                    IDataEntityProperty simpleProperty = QueryEntityUtil.getSimpleProperty((DynamicObjectType)relationEntityType, (String)arrayDisPlayProp);
                    if (simpleProperty != null) {
                        ISimpleProperty primaryKey = simpleProperty.getParent().getPrimaryKey();
                        StringBuilder primaryKeyStr = new StringBuilder();
                        for (int i = 0; i < split.length - 1; ++i) {
                            primaryKeyStr.append(split[i]);
                            primaryKeyStr.append(".");
                        }
                        primaryKeyStr.append(primaryKey.getName());
                        this.buildProperty(relationEntityType, primaryKeyStr.toString(), nestPropertys.nests);
                    }
                    this.buildProperty(relationEntityType, arrayDisPlayProp, nestPropertys.nests);
                }
                if (nestPropertys.nests.size() <= 0) continue;
                esMappingPropertyList.add(nestPropertys);
                continue;
            }
            if (AISearchEsConfigService.isObject(aiSearchEsConfig, joinEntityName)) {
                nestPropertys = new EsMappingProperty(joinEntityName, EsDataType.OBJECT);
                relationEntityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
                for (String select : joinSelectListNew) {
                    this.buildProperty(relationEntityType, select, nestPropertys.nests);
                }
                if (nestPropertys.nests.size() <= 0) continue;
                esMappingPropertyList.add(nestPropertys);
                continue;
            }
            nestPropertys = new EsMappingProperty(joinEntityName, EsDataType.NESTED);
            relationEntityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
            for (String select : joinSelectListNew) {
                this.buildProperty(relationEntityType, select, nestPropertys.nests);
            }
            if (nestPropertys.nests.size() <= 0) continue;
            esMappingPropertyList.add(nestPropertys);
        }
        mainPropertys.removeAll(nestPropertySet);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        for (String property : mainPropertys) {
            this.buildProperty(mainEntityType, property, esMappingPropertyList);
        }
        return esMappingPropertyList;
    }

    private void buildProperty(MainEntityType mainEntityType, String property, List<EsMappingProperty> esMappingPropertyList) throws KDBizException {
        IDataEntityProperty dataEntityProperty = QueryEntityUtil.getFieldProperty((MainEntityType)mainEntityType, (String)property);
        if (dataEntityProperty instanceof EntryProp) {
            String entityName = mainEntityType.getExtendName();
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%s\u201d\u5305\u542b\u5206\u5f55\u6570\u636e\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u5b9e\u4f53\u540c\u6b65ES\u6570\u636e\u3002", (String)"AiSearchEsCreateMapping_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), entityName));
        }
        if (null == dataEntityProperty) {
            return;
        }
        if (dataEntityProperty instanceof DynamicSimpleProperty) {
            DynamicSimpleProperty dynamicSimpleProperty = (DynamicSimpleProperty)dataEntityProperty;
            boolean isEncrypt = dynamicSimpleProperty.isEncrypt();
            if (isEncrypt) {
                EsMappingProperty enpEsMappingProperty = this.genEsMapping(property + "_enp", EsDataType.KEYWORD);
                esMappingPropertyList.add(enpEsMappingProperty);
            }
            if (dynamicSimpleProperty instanceof MuliLangTextProp) {
                Set<String> enableLangNums = this.getEnableLangNums();
                for (String langNum : enableLangNums) {
                    boolean resetAnalyzer = false;
                    if (langNum.equals(Lang.zh_CN.name()) || langNum.equals(Lang.zh_TW.name())) {
                        resetAnalyzer = true;
                    }
                    EsMappingProperty langMappingProperty = this.genEsMapping(property + "_l." + langNum, EsDataType.TEXT, resetAnalyzer);
                    esMappingPropertyList.add(langMappingProperty);
                }
                EsMappingProperty langMappingProperty = this.genEsMapping(property + "_l.GLang", EsDataType.TEXT);
                esMappingPropertyList.add(langMappingProperty);
            }
        }
        EsMappingProperty esMappingProperty = this.genEsMapping(property, EsStrageBaseHelper.convertPropertyType(dataEntityProperty, property));
        esMappingPropertyList.add(esMappingProperty);
    }

    private EsMappingProperty genEsMapping(String property, EsDataType esDataType) {
        return this.genEsMapping(property, esDataType, true);
    }

    private EsMappingProperty genEsMapping(String property, EsDataType esDataType, boolean resetAnalyzer) {
        EsMappingProperty esMappingProperty = new EsMappingProperty(property, esDataType);
        if (resetAnalyzer) {
            this.fitAnalyzer(esMappingProperty);
        }
        return esMappingProperty;
    }

    private void fitAnalyzer(EsMappingProperty esMappingProperty) {
        if (EsDataType.TEXT == esMappingProperty.getDataType()) {
            esMappingProperty.setTokenizerType(EsTokenizerType.IKMAXWORD);
            esMappingProperty.setSearchTokenizerType(EsTokenizerType.IKSMART);
        }
    }
}

