/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.QueryEntity;
import kd.hr.hbp.common.enums.query.EnumQueryEntityReleaseStatus;
import kd.hr.hrcs.bussiness.service.multientity.EsStrageBaseHelper;
import kd.hr.hrcs.bussiness.service.multientity.IEntitySyncConfigReleaseService;
import kd.hr.hrcs.bussiness.service.multientity.impl.EntitySyncConfigDataService;
import kd.hr.hrcs.bussiness.service.multientity.impl.HrEntitySyncConfigBusinessType;
import kd.hr.hrcs.bussiness.service.multientity.impl.HrMuiltiEntityBusinessType;

public class EntitySyncConfigReleaseService
implements IEntitySyncConfigReleaseService {
    private static volatile EntitySyncConfigReleaseService entitySyncConfigReleaseService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EntitySyncConfigReleaseService getInstance() {
        if (entitySyncConfigReleaseService != null) return entitySyncConfigReleaseService;
        Class<EntitySyncConfigReleaseService> clazz = EntitySyncConfigReleaseService.class;
        synchronized (EntitySyncConfigReleaseService.class) {
            if (entitySyncConfigReleaseService != null) return entitySyncConfigReleaseService;
            entitySyncConfigReleaseService = new EntitySyncConfigReleaseService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return entitySyncConfigReleaseService;
        }
    }

    @Override
    public void batchImportData(String entityNumber, String mappingRule) throws KDBizException {
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        String businessType = HrEntitySyncConfigBusinessType.class.getName();
        dtsConfigOperator.deleteDtsConfig(entityNumber, businessType, "hr", mappingRule);
        ArrayList<String> entityFieldList = new ArrayList<String>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        entityFieldList.add(entityType.getPrimaryKey().getName());
        this.saveDtsConfigOperatorInfo(entityNumber, mappingRule, businessType, entityFieldList, dtsConfigOperator);
    }

    @Override
    public boolean isFullSync(String entityNumber, String mappingRule) {
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        boolean isFullSync = dtsConfigOperator.isFullSync(entityNumber, "hr", DtsDestTypeEnum.FULLTEXT.getCode(), mappingRule);
        return isFullSync;
    }

    @Override
    public void stopIncrement(String entityNumber, String mappingRuleParm) {
        EntitySyncConfigDataService.updateEsReleaseStatus(mappingRuleParm, EnumQueryEntityReleaseStatus.NONE.getStatus());
        String businessType = HrEntitySyncConfigBusinessType.class.getName();
        String realMappingRule = "hrentitysyncmapping#parm=" + mappingRuleParm;
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        dtsConfigOperator.deleteDtsConfig(entityNumber, businessType, "hr", realMappingRule);
    }

    @Override
    public void deleteEsDtsConfig(List<String> listQueryEntityName) {
        String businessType = HrMuiltiEntityBusinessType.class.getName();
        for (String queryEntityName : listQueryEntityName) {
            QueryEntity queryEntity = EsStrageBaseHelper.getQueryEntity(queryEntityName);
            String mappingRule = "hrmultmapping#multientityname=" + queryEntityName;
            DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
            dtsConfigOperator.deleteDtsConfig(queryEntity.getEntityName(), businessType, "hr", mappingRule);
            List joinEntities = queryEntity.getJoinEntitys();
            for (JoinEntity joinEntity : joinEntities) {
                String joinEntityName = joinEntity.getEntityName();
                dtsConfigOperator.deleteDtsConfig(joinEntityName, businessType, "hr", mappingRule);
            }
        }
    }

    private void saveDtsConfigOperatorInfo(String entityNumber, String mappingRule, String businessType, List<String> entityFieldList, DtsConfigOperator dtsConfigOperator) {
        if (entityFieldList == null) {
            return;
        }
        DtsConfigOperatorInfo dtsConfigOperatorInfo = new DtsConfigOperatorInfo();
        dtsConfigOperatorInfo.setEntityNumber(entityNumber);
        dtsConfigOperatorInfo.setDtsDestType(DtsDestTypeEnum.FULLTEXT);
        dtsConfigOperatorInfo.setRegion("hr");
        dtsConfigOperatorInfo.setMappingRule(mappingRule);
        dtsConfigOperatorInfo.setBusinessType(businessType);
        dtsConfigOperatorInfo.setEnable("1");
        dtsConfigOperatorInfo.setEntityFields(entityFieldList.toArray(new String[entityFieldList.size()]));
        dtsConfigOperator.saveDtsConfig(dtsConfigOperatorInfo);
    }
}

