/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hrcs.bussiness.service.multientity.impl.AbstractJobAndPlanService;
import kd.hr.hrcs.bussiness.service.multientity.impl.EsReleaseTask;

public class EsBatchImportDataJobAndPlanService
extends AbstractJobAndPlanService {
    private static final String jobNumberPrifix = "hrcs_es_";
    private static final String planNumberPrifix = "hrcs_es_";

    @Override
    protected String getTaskClassName() {
        return EsReleaseTask.class.getName();
    }

    @Override
    protected String getNamePreFix() {
        return ResManager.loadKDString((String)"ES\u65b9\u6848", (String)"EsBatchImportDataJobAndPlanService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    @Override
    public void fixedTimeRelease(Map<String, Object> jobParam, Date fixedTime) {
        String name = (String)jobParam.get("name");
        String jobNumber = "hrcs_es_" + name.concat("_").concat(String.valueOf(jobParam.get("recordId")));
        String planNumber = "hrcs_es_" + name.concat("_").concat(String.valueOf(jobParam.get("recordId")));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        String jobId = UUID.randomUUID().toString();
        jobInfo.setAppId("hrcs");
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(this.getTaskClassName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(this.getNamePreFix() + "job_" + name);
        jobInfo.setId(jobId);
        jobInfo.setNumber(jobNumber);
        jobInfo.setEnable(true);
        jobInfo.setParams(jobParam);
        ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(planNumber);
        planInfo.setName(this.getNamePreFix() + "plan_" + name);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(fixedTime);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(fixedTime);
        endTime.add(5, 1);
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        ScheduleServiceHelper.createPlan((PlanInfo)planInfo);
    }

    public void deleteJobAndPlanByQueryEntityName(String queryNumber, String recordId) {
        String planNumber = "hrcs_es_" + queryNumber.concat("_").concat(recordId);
        this.deleteJobAndPlan(planNumber);
    }
}

