/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.multientity.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.QueryEntity;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hrcs.bussiness.service.multientity.EsStrageBaseHelper;
import kd.hr.hrcs.bussiness.service.multientity.IEsCreateMapping;
import org.elasticsearch.ElasticsearchStatusException;

public class EsCreateMapping
implements IEsCreateMapping {
    private static final Log logger = LogFactory.getLog(EsCreateMapping.class);

    @Override
    public void createMapping(EsStorage storage, QueryEntity queryEntity, String indexName) throws KDBizException {
        if (storage.isIndexExist(indexName).booleanValue()) {
            storage.deleteIndex(indexName);
        }
        try {
            storage.createIndex("hr", indexName, null);
        }
        catch (ElasticsearchStatusException e) {
            logger.error("create es index occur exception: " + CommonUtil.getStackTrace((Exception)((Object)e)));
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efaES\u7d22\u5f15\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EsImportDataValidator_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        List<EsMappingProperty> propertys = this.buildMappingPropertys(queryEntity);
        EsMappingProperty[] propertyArr = propertys.toArray(new EsMappingProperty[propertys.size()]);
        storage.addMappingIndex(indexName, "t_data", propertyArr);
    }

    private List<EsMappingProperty> buildMappingPropertys(QueryEntity queryEntity) throws KDBizException {
        HashSet<String> mainPropertys = new HashSet<String>();
        HashSet<String> nestPropertySet = new HashSet<String>();
        EsStrageBaseHelper.parseSelectField(queryEntity, mainPropertys, nestPropertySet, Boolean.TRUE);
        ArrayList<EsMappingProperty> esMappingPropertyList = new ArrayList<EsMappingProperty>();
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            List<String> joinSelectListNew = EsStrageBaseHelper.filterPropertys(nestPropertySet, joinEntity.getEntityName());
            if (null == joinSelectListNew || joinSelectListNew.size() <= 0) continue;
            EsMappingProperty nestPropertys = new EsMappingProperty(joinEntity.getEntityName(), EsDataType.NESTED);
            MainEntityType relationEntityType = EntityMetadataCache.getDataEntityType((String)joinEntity.getEntityName());
            for (String select : joinSelectListNew) {
                this.buildProperty(relationEntityType, select, nestPropertys.nests);
            }
            if (nestPropertys.nests.size() <= 0) continue;
            esMappingPropertyList.add(nestPropertys);
        }
        mainPropertys.removeAll(nestPropertySet);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        for (String property : mainPropertys) {
            this.buildProperty(mainEntityType, property, esMappingPropertyList);
        }
        return esMappingPropertyList;
    }

    private void buildProperty(MainEntityType mainEntityType, String property, List<EsMappingProperty> esMappingPropertyList) throws KDBizException {
        DynamicSimpleProperty dynamicSimpleProperty;
        boolean isEncrypt;
        IDataEntityProperty dataEntityProperty = EsStrageBaseHelper.findProperty(mainEntityType, property);
        if (dataEntityProperty instanceof EntryProp) {
            String entityName = mainEntityType.getExtendName();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c%s\u201d\u5305\u542b\u5206\u5f55\u6570\u636e\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u5b9e\u4f53\u540c\u6b65ES\u6570\u636e\u3002", (String)"EsImportDataValidator_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), entityName));
        }
        if (null == dataEntityProperty) {
            return;
        }
        if (dataEntityProperty instanceof DynamicSimpleProperty && (isEncrypt = (dynamicSimpleProperty = (DynamicSimpleProperty)dataEntityProperty).isEncrypt())) {
            esMappingPropertyList.add(new EsMappingProperty(property, EsStrageBaseHelper.convertPropertyType(dataEntityProperty)));
            esMappingPropertyList.add(new EsMappingProperty(property + "_enp", EsDataType.TEXT));
            return;
        }
        esMappingPropertyList.add(new EsMappingProperty(property, EsStrageBaseHelper.convertPropertyType(dataEntityProperty)));
    }
}

