/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class ChoiceFieldPageCustomQueryService {
    protected final BlockingDeque<IDataEntityProperty> propertyStack = new LinkedBlockingDeque<IDataEntityProperty>();
    public static final String KEY_ID = "field_id";
    public static final String KEY_NAME = "field_name";
    public static final String KEY_ENTITYNUM = "field_entityNum";
    public static final String KEY_DAYATYPE = "field_dataType";
    public static final String KEY_ISQUERYENTITYTYPE = "isQueryEntityType";
    public static final String SPLIT_FIELD = "||";

    public List<Map<String, String>> parseProperty(IDataEntityType entityType, List<String> selectedFields) {
        return this.parseProperty(entityType, selectedFields, Maps.newHashMap());
    }

    public List<Map<String, String>> parseProperty(IDataEntityType entityType) {
        return this.parseProperty(entityType, null);
    }

    public List<Map<String, String>> parseProperty(IDataEntityType entityType, List<String> selectedFields, Map<String, Object> formViewCustomParam) {
        if (entityType == null) {
            return Collections.emptyList();
        }
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        if (propertyCollection != null && !propertyCollection.isEmpty()) {
            List<Map<String, String>> resultList = this.listResult(entityType, selectedFields, formViewCustomParam, propertyCollection);
            if (entityType instanceof QueryEntityType) {
                this.handleQueryEntityType((QueryEntityType)entityType, formViewCustomParam, selectedFields, resultList);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    public List<Map<String, String>> parsePropertySub(IDataEntityType entityType, List<String> selectedFields, Map<String, Object> formViewCustomParam, String filter, List<String> noDBProps) {
        if (entityType == null) {
            return Collections.emptyList();
        }
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        if (propertyCollection != null && !propertyCollection.isEmpty()) {
            List<Map<String, String>> resultList = this.listResultSub(entityType, selectedFields, formViewCustomParam, propertyCollection, noDBProps);
            if (entityType instanceof QueryEntityType) {
                this.handleQueryEntityTypeSub((QueryEntityType)entityType, formViewCustomParam, selectedFields, resultList, noDBProps);
            }
            resultList = resultList.stream().filter(it -> HRStringUtils.isNotEmpty((String)((String)it.get(KEY_ID))) && !((String)it.get(KEY_ID)).equals("multilanguagetext")).collect(Collectors.toList());
            if (HRStringUtils.isEmpty((String)((String)formViewCustomParam.get("addId"))) && !"true".equals(formViewCustomParam.get("param_ifShowBaseDataProp"))) {
                HashMap idMap = Maps.newHashMapWithExpectedSize((int)1);
                idMap.put(KEY_ID, "ID");
                idMap.put(KEY_NAME, "ID");
                resultList.add(0, idMap);
                formViewCustomParam.put("addId", "true");
            }
            if (null != filter && !"1=1".equals(filter)) {
                this.filterProp(resultList, filter);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    private void filterProp(List<Map<String, String>> result, String filter) {
        Algo algo = Algo.create((String)"ChoiceFieldPageCustomQuery");
        ArrayList<Field> permFields = new ArrayList<Field>(2);
        permFields.add(new Field("fieldid", (DataType)DataType.StringType));
        permFields.add(new Field("fieldnumber", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Map<String, String> map : result) {
            builder.append(new Object[]{map.get(KEY_ID), map.get(KEY_NAME)});
        }
        DataSet dataset = builder.build();
        filter = filter.replace("ftlike", "like");
        dataset = dataset.filter(filter);
        result.clear();
        for (Row row : dataset) {
            String fieldId = row.getString("fieldid");
            String fieldNum = row.getString("fieldnumber");
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(KEY_ID, fieldId);
            map.put(KEY_NAME, fieldNum);
            result.add(map);
        }
    }

    private String getIdByNumber(String number) {
        MetadataReader reader = new MetadataReader();
        return reader.loadIdByNumber(number, MetaCategory.Form);
    }

    protected List<Map<String, String>> listResult(IDataEntityType entityType, List<String> selectedFields, Map<String, Object> formViewCustomParam, DataEntityPropertyCollection propertyCollection) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)propertyCollection.size());
        for (IDataEntityProperty property : propertyCollection) {
            this.propertyStack.offerLast(property);
            if (!this.shouldSkip(property, formViewCustomParam)) {
                if (property instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)property;
                    EntryType entryType = (EntryType)entryProp.getItemType();
                    formViewCustomParam.put("isEntry", "true");
                    formViewCustomParam.put("mainEntity", entryType.getName());
                    List<Map<String, String>> subResult = this.parseProperty((IDataEntityType)entryType, selectedFields, formViewCustomParam);
                    formViewCustomParam.remove("mainEntity");
                    formViewCustomParam.remove("isEntry");
                    resultList.addAll(subResult);
                } else {
                    HashMap propertieMap = Maps.newHashMapWithExpectedSize((int)2);
                    String name = this.getPropertyName(false, true);
                    String displayName = this.getPropertyName(true, true);
                    if (!StringUtils.isEmpty((String)displayName) && (selectedFields == null || selectedFields.isEmpty() || selectedFields.contains(name + SPLIT_FIELD + displayName))) {
                        if (formViewCustomParam != null && formViewCustomParam.get(KEY_ISQUERYENTITYTYPE) != null) {
                            String entNum = entityType.getName();
                            if (formViewCustomParam.get("isEntry") != null) {
                                entNum = (String)formViewCustomParam.get("mainEntity");
                            }
                            name = entNum + "." + name;
                        }
                        propertieMap.put(KEY_ID, name);
                        propertieMap.put(KEY_NAME, displayName);
                        if (this.ifShowBaseDataProp(formViewCustomParam)) {
                            propertieMap.put(KEY_ENTITYNUM, ((BasedataProp)property).getBaseEntityId());
                        }
                        resultList.add(propertieMap);
                    }
                }
            }
            this.propertyStack.pollLast();
        }
        return resultList;
    }

    protected List<Map<String, String>> listResultSub(IDataEntityType entityType, List<String> selectedFields, Map<String, Object> formViewCustomParam, DataEntityPropertyCollection propertyCollection, List<String> noDBProps) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)propertyCollection.size());
        for (IDataEntityProperty property : propertyCollection) {
            if (HRStringUtils.isEmpty((String)property.getAlias())) {
                noDBProps.add(property.getName());
            }
            this.propertyStack.offerLast(property);
            if (!this.shouldSkip(property, formViewCustomParam)) {
                HashMap propertieMap;
                if (property instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)property;
                    EntryType entryType = (EntryType)entryProp.getItemType();
                    List<Map<String, String>> subResult = this.parsePropertySub((IDataEntityType)entryType, selectedFields, formViewCustomParam, null, noDBProps);
                    resultList.addAll(subResult);
                } else if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
                    String propName;
                    String propNumber;
                    DataEntityPropertyCollection props;
                    String baseEntityId;
                    BasedataProp basedataProp;
                    Object isJoinEntity;
                    Object object = isJoinEntity = Objects.isNull(formViewCustomParam) ? null : formViewCustomParam.get("isJoinEntity");
                    if (property instanceof BasedataProp) {
                        basedataProp = (BasedataProp)property;
                        baseEntityId = basedataProp.getBaseEntityId();
                        props = basedataProp.getDynamicComplexPropertyType().getProperties();
                    } else {
                        basedataProp = (MulBasedataProp)property;
                        baseEntityId = basedataProp.getBaseEntityId();
                        props = basedataProp.getComplexType().getProperties();
                    }
                    if (isJoinEntity != null) {
                        propNumber = entityType.getName() + "." + property.getName();
                        propName = property.getDisplayName() != null && HRStringUtils.isNotEmpty((String)property.getDisplayName().getLocaleValue()) ? entityType.getDisplayName().getLocaleValue() + "." + property.getDisplayName().getLocaleValue() : propNumber;
                    } else {
                        propNumber = property.getName();
                        propName = property instanceof JoinProperty ? ((JoinProperty)property).getDynamicComplexPropertyType().getDisplayName().getLocaleValue() : (property.getDisplayName() != null && HRStringUtils.isNotEmpty((String)property.getDisplayName().getLocaleValue()) ? property.getDisplayName().getLocaleValue() : propNumber);
                    }
                    propertieMap = Maps.newHashMapWithExpectedSize((int)2);
                    propertieMap.put(KEY_ID, propNumber);
                    propertieMap.put(KEY_NAME, propName);
                    propertieMap.put(KEY_ENTITYNUM, baseEntityId);
                    resultList.add(propertieMap);
                    if (!this.ifShowBaseDataProp(formViewCustomParam) || this.ifShowAllBaseDataProp(formViewCustomParam)) {
                        ArrayList properties = Lists.newArrayListWithExpectedSize((int)10);
                        List entryProperties = props.stream().filter(it -> it instanceof EntryProp).collect(Collectors.toList());
                        for (IDataEntityProperty entryProperty : entryProperties) {
                            EntryProp entryProp = (EntryProp)entryProperty;
                            EntryType entryType = (EntryType)entryProp.getItemType();
                            List entrySubProperties = entryType.getProperties().stream().filter(it -> it instanceof BasedataProp).collect(Collectors.toList());
                            properties.addAll(entrySubProperties);
                        }
                        List bdProperties = props.stream().filter(it -> it instanceof BasedataProp).collect(Collectors.toList());
                        List mulBdProperties = props.stream().filter(it -> it instanceof MulBasedataProp).collect(Collectors.toList());
                        properties.addAll(bdProperties);
                        properties.addAll(mulBdProperties);
                        if (!CollectionUtils.isEmpty((Collection)properties)) {
                            ArrayList<HashMap> subResult = new ArrayList<HashMap>(properties.size());
                            for (IDataEntityProperty iDataEntityProperty : properties) {
                                String subProp = iDataEntityProperty.getName();
                                String subPropName = iDataEntityProperty.getDisplayName().getLocaleValue();
                                propertieMap = Maps.newHashMapWithExpectedSize((int)2);
                                String keyId = propNumber + "." + subProp;
                                propertieMap.put(KEY_ID, keyId);
                                propertieMap.put(KEY_NAME, propName + "." + subPropName);
                                if (mulBdProperties.contains(iDataEntityProperty)) {
                                    propertieMap.put(KEY_ENTITYNUM, ((MulBasedataProp)iDataEntityProperty).getBaseEntityId());
                                } else {
                                    propertieMap.put(KEY_ENTITYNUM, ((BasedataProp)iDataEntityProperty).getBaseEntityId());
                                }
                                subResult.add(propertieMap);
                            }
                            resultList.addAll(subResult);
                        }
                    }
                } else {
                    propertieMap = Maps.newHashMapWithExpectedSize((int)2);
                    String name = this.getPropertyName(false, true);
                    String displayName = this.getPropertyName(true, true);
                    if (!StringUtils.isEmpty((String)displayName) && (selectedFields == null || selectedFields.isEmpty() || selectedFields.contains(name + SPLIT_FIELD + displayName))) {
                        if (formViewCustomParam != null && formViewCustomParam.get(KEY_ISQUERYENTITYTYPE) != null) {
                            String localeValue = entityType.getDisplayName().getLocaleValue();
                            displayName = localeValue + "." + displayName;
                            String entNum = entityType.getName();
                            name = entNum + "." + name;
                        }
                        propertieMap.put(KEY_ID, name);
                        propertieMap.put(KEY_NAME, displayName);
                        resultList.add(propertieMap);
                    }
                }
            }
            this.propertyStack.pollLast();
        }
        return resultList;
    }

    private void handleQueryEntityType(QueryEntityType entityType, Map<String, Object> formViewCustomParam, List<String> selectedFields, List<Map<String, String>> resultList) {
        List subEntityTypeList = entityType.getAllJoinEntityType();
        formViewCustomParam.put(KEY_ISQUERYENTITYTYPE, "true");
        for (MainEntityType met : subEntityTypeList) {
            List<Map<String, String>> itemList = this.parseProperty((IDataEntityType)met, selectedFields, formViewCustomParam);
            resultList.addAll(itemList);
        }
    }

    private void handleQueryEntityTypeSub(QueryEntityType entityType, Map<String, Object> formViewCustomParam, List<String> selectedFields, List<Map<String, String>> resultList, List<String> noDBProps) {
        List subEntityTypeList = entityType.getAllJoinEntityType();
        formViewCustomParam.put(KEY_ISQUERYENTITYTYPE, "true");
        formViewCustomParam.put("isJoinEntity", "true");
        if (!this.ifShowBaseDataProp(formViewCustomParam)) {
            for (MainEntityType mainEntityType : subEntityTypeList) {
                HashMap temp = Maps.newHashMapWithExpectedSize((int)3);
                temp.put(KEY_ID, mainEntityType.getName() + ".id");
                temp.put(KEY_NAME, mainEntityType.getDisplayName().getLocaleValue() + ".id");
                resultList.add(temp);
            }
        }
        for (MainEntityType met : subEntityTypeList) {
            List<Map<String, String>> itemList = this.parsePropertySub((IDataEntityType)met, selectedFields, formViewCustomParam, null, noDBProps);
            resultList.addAll(itemList);
        }
        formViewCustomParam.remove("isJoinEntity");
        formViewCustomParam.remove(KEY_ISQUERYENTITYTYPE);
    }

    private void filterPropByStdBlackList(String entityNum, List<Map<String, String>> fieldInfoList) {
        List fieldKeysFromStdBlackList = PermFormCommonUtil.getFieldKeysFromStdBlackList((String)entityNum);
        Iterator<Map<String, String>> iter = fieldInfoList.iterator();
        while (iter.hasNext()) {
            Map<String, String> fieldInfo = iter.next();
            String fieldKey = fieldInfo.get(KEY_ID);
            if (!fieldKeysFromStdBlackList.contains(fieldKey)) continue;
            iter.remove();
        }
    }

    protected boolean ifShowBaseDataProp(Map<String, Object> formViewCustomParam) {
        return formViewCustomParam != null && "true".equals(formViewCustomParam.get("param_ifShowBaseDataProp"));
    }

    protected boolean ifShowAllBaseDataProp(Map<String, Object> formViewCustomParam) {
        return formViewCustomParam != null && "true".equals(formViewCustomParam.get("param_ifShowAllBaseDataProp"));
    }

    protected boolean ifShowForDynaRule(Map<String, Object> formViewCustomParam) {
        return formViewCustomParam != null && "true".equals(formViewCustomParam.get("param_ifShowForDynaRule"));
    }

    protected boolean shouldSkip(IDataEntityProperty property, Map<String, Object> formViewCustomParam) {
        boolean result;
        boolean bl = result = !(property instanceof DynamicProperty) || property instanceof PKFieldProp || "seq".equals(property.getName()) || "treeentryentity".equals(property.getName());
        if (result) {
            return true;
        }
        boolean isBdProp = property instanceof BasedataProp || property instanceof MulBasedataProp || property instanceof EntryProp;
        return this.ifShowBaseDataProp(formViewCustomParam) && !isBdProp || this.ifShowForDynaRule(formViewCustomParam) && (!(property instanceof ComboProp) || property instanceof MulComboProp) && !(property instanceof BooleanProp) && !isBdProp;
    }

    protected String getPropertyName(boolean displayName, boolean getSimpleId) {
        int lastIndex;
        Iterator<IDataEntityProperty> propertyIterator = this.propertyStack.iterator();
        StringBuilder propertyNameBuffer = new StringBuilder();
        while (propertyIterator.hasNext()) {
            LocaleString propertyLocaleDisplayName;
            DynamicProperty property = (DynamicProperty)propertyIterator.next();
            String propertyName = displayName ? ((propertyLocaleDisplayName = property.getDisplayName()) == null ? "" : propertyLocaleDisplayName.toString()) : property.getName();
            propertyNameBuffer.append(propertyName);
            if (!propertyIterator.hasNext()) continue;
            propertyNameBuffer.append('.');
        }
        String strPropertyName = propertyNameBuffer.toString();
        if (!displayName && getSimpleId && (lastIndex = strPropertyName.lastIndexOf(46)) != -1) {
            strPropertyName = strPropertyName.substring(lastIndex + 1, strPropertyName.length());
        }
        return strPropertyName;
    }

    public List<Map<String, String>> parsePropertyFormula(IDataEntityType entityType, List<String> selectedFields, Map<String, Object> formViewCustomParam) {
        if (entityType == null) {
            return Collections.emptyList();
        }
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        if (propertyCollection != null && !propertyCollection.isEmpty()) {
            List<Map<String, String>> resultList = this.listResultFormula(entityType, selectedFields, formViewCustomParam, propertyCollection);
            if (entityType instanceof QueryEntityType) {
                this.handleQueryEntityTypeSub((QueryEntityType)entityType, formViewCustomParam, selectedFields, resultList, new ArrayList<String>(0));
            }
            resultList = resultList.stream().filter(it -> HRStringUtils.isNotEmpty((String)((String)it.get(KEY_ID))) && !((String)it.get(KEY_ID)).equals("multilanguagetext")).collect(Collectors.toList());
            return resultList;
        }
        return Collections.emptyList();
    }

    protected List<Map<String, String>> listResultFormula(IDataEntityType entityType, List<String> selectedFields, Map<String, Object> formViewCustomParam, DataEntityPropertyCollection propertyCollection) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)propertyCollection.size());
        for (IDataEntityProperty property : propertyCollection) {
            String dataType = this.getDataType(property);
            this.propertyStack.offerLast(property);
            if (HRStringUtils.isNotEmpty((String)dataType) && !HRStringUtils.equals((String)"id", (String)property.getName())) {
                HashMap propertieMap;
                if (property instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)property;
                    EntryType entryType = (EntryType)entryProp.getItemType();
                    List<Map<String, String>> subResult = this.parsePropertyFormula((IDataEntityType)entryType, selectedFields, formViewCustomParam);
                    resultList.addAll(subResult);
                } else if (property instanceof BasedataProp) {
                    String propName;
                    String propNumber;
                    Object isJoinEntity = Objects.isNull(formViewCustomParam) ? null : formViewCustomParam.get("isJoinEntity");
                    BasedataProp basedataProp = (BasedataProp)property;
                    DataEntityPropertyCollection props = basedataProp.getDynamicComplexPropertyType().getProperties();
                    if (isJoinEntity != null) {
                        propNumber = entityType.getName() + "." + property.getName();
                        propName = property.getDisplayName() != null && HRStringUtils.isNotEmpty((String)property.getDisplayName().getLocaleValue()) ? entityType.getDisplayName().getLocaleValue() + "." + property.getDisplayName().getLocaleValue() : propNumber;
                    } else {
                        propNumber = property.getName();
                        propName = property instanceof JoinProperty ? ((JoinProperty)property).getDynamicComplexPropertyType().getDisplayName().getLocaleValue() : (property.getDisplayName() != null && HRStringUtils.isNotEmpty((String)property.getDisplayName().getLocaleValue()) ? property.getDisplayName().getLocaleValue() : propNumber);
                    }
                    propertieMap = Maps.newHashMapWithExpectedSize((int)3);
                    propertieMap.put(KEY_ID, propNumber);
                    propertieMap.put(KEY_NAME, propName);
                    propertieMap.put(KEY_DAYATYPE, dataType);
                    resultList.add(propertieMap);
                    if (!this.ifShowBaseDataProp(formViewCustomParam) || this.ifShowAllBaseDataProp(formViewCustomParam)) {
                        ArrayList properties = Lists.newArrayListWithExpectedSize((int)10);
                        List entryProperties = props.stream().filter(it -> it instanceof EntryProp).collect(Collectors.toList());
                        for (IDataEntityProperty entryProperty : entryProperties) {
                            EntryProp entryProp = (EntryProp)entryProperty;
                            EntryType entryType = (EntryType)entryProp.getItemType();
                            List entrySubProperties = entryType.getProperties().stream().filter(it -> it instanceof BasedataProp).collect(Collectors.toList());
                            properties.addAll(entrySubProperties);
                        }
                        List bdProperties = props.stream().filter(it -> it instanceof BasedataProp).collect(Collectors.toList());
                        properties.addAll(bdProperties);
                        if (!CollectionUtils.isEmpty((Collection)properties)) {
                            ArrayList<HashMap> subResult = new ArrayList<HashMap>(properties.size());
                            for (IDataEntityProperty iDataEntityProperty : properties) {
                                String curDataType = this.getDataType(iDataEntityProperty);
                                if (HRStringUtils.isEmpty((String)curDataType)) continue;
                                String subProp = iDataEntityProperty.getName();
                                String subPropName = iDataEntityProperty.getDisplayName().getLocaleValue();
                                propertieMap = Maps.newHashMapWithExpectedSize((int)2);
                                String keyId = propNumber + "." + subProp;
                                propertieMap.put(KEY_ID, keyId);
                                propertieMap.put(KEY_NAME, propName + "." + subPropName);
                                propertieMap.put(KEY_DAYATYPE, curDataType);
                                subResult.add(propertieMap);
                            }
                            resultList.addAll(subResult);
                        }
                    }
                } else {
                    propertieMap = Maps.newHashMapWithExpectedSize((int)3);
                    String name = this.getPropertyName(false, true);
                    String displayName = this.getPropertyName(true, true);
                    if (!StringUtils.isEmpty((String)displayName) && (selectedFields == null || selectedFields.isEmpty() || selectedFields.contains(name + SPLIT_FIELD + displayName))) {
                        if (formViewCustomParam != null && formViewCustomParam.get(KEY_ISQUERYENTITYTYPE) != null) {
                            String localeValue = entityType.getDisplayName().getLocaleValue();
                            displayName = localeValue + "." + displayName;
                            String entNum = entityType.getName();
                            name = entNum + "." + name;
                        }
                        propertieMap.put(KEY_ID, name);
                        propertieMap.put(KEY_NAME, displayName);
                        propertieMap.put(KEY_DAYATYPE, dataType);
                        resultList.add(propertieMap);
                    }
                }
            }
            this.propertyStack.pollLast();
        }
        return resultList;
    }

    private String getDataType(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return DataTypeEnum.BASE.getCode();
        }
        if (property instanceof LongProp || property instanceof BigIntProp || property instanceof DecimalProp) {
            return DataTypeEnum.NUM.getCode();
        }
        if (property instanceof TextProp || property instanceof TextAreaProp || property instanceof MuliLangTextProp) {
            return DataTypeEnum.TEXT.getCode();
        }
        if (property instanceof ComboProp) {
            return "enum";
        }
        if (property instanceof BooleanProp) {
            return DataTypeEnum.BOOLEAN.getCode();
        }
        if (property instanceof IntegerProp) {
            return DataTypeEnum.INT.getCode();
        }
        if (property instanceof DateProp) {
            return DataTypeEnum.DATE.getCode();
        }
        if (property instanceof DateTimeProp) {
            return DataTypeEnum.DATETIME.getCode();
        }
        if (property instanceof EntryProp) {
            return "entry";
        }
        return "";
    }
}

