/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.perm.DimensionBean;
import kd.hr.hbp.common.model.perm.UserRoleRelateBean;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.common.model.DimValue;
import org.apache.commons.collections.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class DataPermissionService {
    private static final Log LOGGER = LogFactory.getLog(DataPermissionService.class);

    public boolean hasDataPermByPropValues(long userId, String appId, String entityNumber, String permItemId, Map<String, Object> fieldValueMap) {
        DynamicObjectCollection userRoleRelateColl;
        boolean hasFuncPerm = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityNumber, (String)permItemId);
        if (!hasFuncPerm) {
            return false;
        }
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject entityCtrl = entityCtrlHelper.queryOne("entryentity.propkey,entryentity.dimension", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNumber)});
        DynamicObjectCollection collection = entityCtrl.getDynamicObjectCollection("entryentity");
        HashMap<Long, Object> dimValueMap = new HashMap<Long, Object>(fieldValueMap.size());
        for (DynamicObject row : collection) {
            String propKey = row.getString("propkey");
            if (!fieldValueMap.containsKey(propKey)) continue;
            dimValueMap.put(row.getLong("dimension.id"), fieldValueMap.get(propKey));
        }
        if (MapUtils.isEmpty(dimValueMap)) {
            return true;
        }
        Long buId = Long.valueOf(HRBuCaServiceHelper.getBuCaFuncFromSpec(entityNumber, appId));
        HRBaseServiceHelper dimensionHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dimensions = dimensionHelper.query("id,datasource,entitytype,showtype,hrbu", new QFilter[]{new QFilter("id", "in", dimValueMap.keySet())});
        HashMap dimInfo = Maps.newHashMapWithExpectedSize((int)dimensions.length);
        for (DynamicObject dimension : dimensions) {
            long dimId = dimension.getLong("id");
            String dataSource = dimension.getString("datasource");
            String entity = dimension.getString("entitytype.id");
            String showType = dimension.getString("showtype");
            boolean isLongPrimaryKey = true;
            boolean canContainSub = false;
            if (HRStringUtils.equals((String)dataSource, (String)"orgteam")) {
                canContainSub = true;
            } else if (HRStringUtils.equals((String)dataSource, (String)"hrbu")) {
                if (HRStringUtils.equals((String)showType, (String)"tree")) {
                    canContainSub = true;
                }
            } else if (HRStringUtils.equals((String)dataSource, (String)"basedata")) {
                MainEntityType dataEntityType;
                ISimpleProperty primaryKey;
                if (HRStringUtils.equals((String)showType, (String)"tree")) {
                    canContainSub = true;
                }
                if (!((primaryKey = (dataEntityType = EntityMetadataCache.getDataEntityType((String)entity)).getPrimaryKey()) instanceof LongProp)) {
                    isLongPrimaryKey = false;
                }
            }
            dimInfo.put(dimId, new DimensionBean(dimId, dimValueMap.get(dimId), dataSource, entity, showType, canContainSub, isLongPrimaryKey, buId.longValue(), dimension.getLong("hrbu.id")));
        }
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        QFilter filter = new QFilter("user", "=", (Object)userId).and("permfile.permfileenable", "!=", (Object)"0");
        if (enableValidateTime) {
            Date now = new Date();
            filter.and("validstart", "<=", (Object)now).and("validend", ">=", (Object)now);
        }
        if ((userRoleRelateColl = userRoleRelateHelper.queryOriginalCollection("id,role.id,customenable", new QFilter[]{filter})).size() <= 0) {
            return true;
        }
        HashMap userRoleMap = Maps.newHashMapWithExpectedSize((int)userRoleRelateColl.size());
        for (DynamicObject row : userRoleRelateColl) {
            String roleId = row.getString("role.id");
            long userRoleRelateId = row.getLong("id");
            boolean customEnable = row.getBoolean("customenable");
            UserRoleRelateBean userRoleRelate = userRoleMap.computeIfAbsent(roleId, key -> new UserRoleRelateBean(roleId));
            Map userRoleCustomInfo = userRoleRelate.getUserRoleCustomInfo();
            userRoleCustomInfo.put(userRoleRelateId, customEnable);
        }
        HashSet allUserRoleIds = Sets.newHashSet(userRoleMap.keySet());
        Set<String> hasPermRoles = this.hasPermRoles(allUserRoleIds, new String[]{appId, entityNumber, permItemId});
        allUserRoleIds.removeAll(hasPermRoles);
        allUserRoleIds.forEach(userRoleMap::remove);
        if (userRoleMap.size() <= 0) {
            return true;
        }
        HashSet hasPermRoleIds = Sets.newHashSet(userRoleMap.keySet());
        Set<String> roleIds = this.hasAllDimRoles(dimInfo.keySet(), hasPermRoleIds, buId);
        hasPermRoleIds.removeAll(roleIds);
        hasPermRoleIds.forEach(userRoleMap::remove);
        List<Long> userRoleRelateIds = userRoleRelateColl.stream().filter(it -> roleIds.contains(it.getString("role.id"))).map(it -> it.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper hrcsRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection roleColl = hrcsRoleHelper.queryOriginalCollection("id,property,isintersection", new QFilter[]{new QFilter("id", "in", roleIds)});
        for (DynamicObject role : roleColl) {
            String roleId = role.getString("id");
            UserRoleRelateBean userRoleRelateBean = (UserRoleRelateBean)userRoleMap.get(roleId);
            userRoleRelateBean.setProperty(role.getString("property"));
            userRoleRelateBean.setIsIntersection(role.getString("isintersection"));
        }
        Map<String, List<Map<Long, List<DimValue>>>> roleDimValueInfo = this.assembleRoleDimGrpInfo(roleIds, buId, dimValueMap);
        Map<Long, List<Map<Long, List<DimValue>>>> userRoleDimValueInfo = this.assembleUrDimGrpInfo(userRoleRelateIds, buId, dimValueMap);
        Map<Long, String> dimPropType = DimServiceWithCache.calCheckPropTypeWithCache(dimInfo.keySet());
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        roleDimValueInfo = this.dynaCondConvert(userId, roleDimValueInfo, dimPropType, dynaCondMap);
        userRoleDimValueInfo = this.dynaCondConvert(userId, userRoleDimValueInfo, dimPropType, dynaCondMap);
        return this.checkUserPerm(roleDimValueInfo, userRoleDimValueInfo, dimInfo, userRoleMap);
    }

    private Map<?, List<Map<Long, List<DimValue>>>> dynaCondConvert(Long userId, Map<?, List<Map<Long, List<DimValue>>>> dimValueInfo, Map<Long, String> dimPropType, Map<Long, DynamicObject> dynaCondMap) {
        if (kd.bos.orm.util.CollectionUtils.isEmpty(dimValueInfo)) {
            return dimValueInfo;
        }
        for (Map.Entry<?, List<Map<Long, List<DimValue>>>> entry : dimValueInfo.entrySet()) {
            List<Map<Long, List<DimValue>>> groupList = entry.getValue();
            for (Map<Long, List<DimValue>> dimValuesMap : groupList) {
                for (Map.Entry<Long, List<DimValue>> dimValuesEntry : dimValuesMap.entrySet()) {
                    Long dimId = dimValuesEntry.getKey();
                    String propType = dimPropType.get(dimId);
                    List<DimValue> dimValues = dimValuesEntry.getValue();
                    List<DimValue> fixedDimValuesResult = DynaCondConverter.dimValues2Fixeds(userId, dimValues, propType, dynaCondMap);
                    dimValuesEntry.setValue(fixedDimValuesResult);
                }
            }
        }
        return dimValueInfo;
    }

    private boolean checkUserPerm(Map<String, List<Map<Long, List<DimValue>>>> roleDimValueInfo, Map<Long, List<Map<Long, List<DimValue>>>> userRoleDimValueInfo, Map<Long, DimensionBean> dimInfo, Map<String, UserRoleRelateBean> userRoleMap) {
        for (Map.Entry<String, UserRoleRelateBean> userRoleRelateEntry : userRoleMap.entrySet()) {
            String roleId = userRoleRelateEntry.getKey();
            UserRoleRelateBean userRoleRelateBean = userRoleRelateEntry.getValue();
            String property = userRoleRelateBean.getProperty();
            String isIntersection = userRoleRelateBean.getIsIntersection();
            Map userRoleCustomInfo = userRoleRelateBean.getUserRoleCustomInfo();
            boolean isMatch = false;
            List<Map<Long, List<DimValue>>> roleDimValueMap = roleDimValueInfo.get(roleId);
            boolean roleNoDimValue = CollectionUtils.isEmpty(roleDimValueMap);
            if (HRStringUtils.equals((String)property, (String)"0")) {
                if (roleNoDimValue || this.checkPerm(dimInfo, roleDimValueMap)) {
                    return true;
                }
            } else {
                boolean roleDimEqual = roleNoDimValue || this.checkPerm(dimInfo, roleDimValueMap);
                boolean roleRef = HRStringUtils.equals((String)isIntersection, (String)"1") || HRStringUtils.equals((String)isIntersection, (String)"2");
                for (Map.Entry userRoleCustomEntry : userRoleCustomInfo.entrySet()) {
                    Long userRoleRelateId = (Long)userRoleCustomEntry.getKey();
                    Boolean userCustom = (Boolean)userRoleCustomEntry.getValue();
                    if (!userCustom.booleanValue()) {
                        if (roleDimEqual) {
                            return true;
                        }
                    } else {
                        List<Map<Long, List<DimValue>>> userRoleDimValue = userRoleDimValueInfo.get(userRoleRelateId);
                        boolean userDimEqual = CollectionUtils.isEmpty(userRoleDimValue) ? true : this.checkPerm(dimInfo, userRoleDimValue);
                        isMatch = roleRef ? roleDimEqual && userDimEqual : userDimEqual;
                    }
                    if (!isMatch) continue;
                    break;
                }
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private boolean checkPerm(Map<Long, DimensionBean> dimInfo, List<Map<Long, List<DimValue>>> dimValList) {
        for (Map<Long, List<DimValue>> dimValueBeanMap : dimValList) {
            boolean isMatch = true;
            for (Map.Entry<Long, List<DimValue>> dimValueEntry : dimValueBeanMap.entrySet()) {
                Long dimId = dimValueEntry.getKey();
                List<DimValue> dimValueBeans = dimValueEntry.getValue();
                boolean isGroupMatch = true;
                for (DimValue dimValueBean : dimValueBeans) {
                    if (!dimValueBean.isAll()) {
                        isGroupMatch = this.checkDimValue(dimValueBean, dimInfo.get(dimId));
                    }
                    if (!isGroupMatch) continue;
                    break;
                }
                if (isGroupMatch) continue;
                isMatch = false;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private boolean checkDimValue(DimValue dimValueBean, DimensionBean dimension) {
        String dataSource = dimension.getDatasource();
        Object dimValueParam = dimension.getDimValue();
        String dimVal = dimValueBean.getDimVal();
        boolean adminContainsSub = dimValueBean.isAdminContainsSub();
        boolean containsSub = dimValueBean.isContainsSub();
        boolean longPrimaryKey = dimension.isLongPrimaryKey();
        if (dimension.isCanContainSub()) {
            if (HRStringUtils.equals((String)dataSource, (String)"orgteam")) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
                QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)true);
                DynamicObject otDyParam = serviceHelper.queryOriginalOne("structlongnumber", new QFilter("orgteam", "=", dimValueParam).and(isCurrentVersionFilter));
                DynamicObject otDy = serviceHelper.queryOriginalOne("structlongnumber", new QFilter("orgteam", "=", (Object)Long.valueOf(dimVal)).and(isCurrentVersionFilter));
                if (null == otDyParam || null == otDy) {
                    return false;
                }
                String otDyParamLongNumber = otDyParam.getString("structlongnumber");
                String otDyLongNumber = otDy.getString("structlongnumber");
                if (containsSub) {
                    return otDyParamLongNumber.startsWith(otDyLongNumber);
                }
                return HRStringUtils.equals((String)otDyParamLongNumber, (String)otDyLongNumber);
            }
            if (HRStringUtils.equals((String)dataSource, (String)"basedata")) {
                String entityType = dimension.getEntityType();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityType);
                DynamicObject dyParam = serviceHelper.queryOriginalOne("longnumber", new QFilter("id", "=", dimValueParam));
                DynamicObject dy = serviceHelper.queryOriginalOne("longnumber", new QFilter("id", "=", longPrimaryKey ? Long.valueOf(dimVal) : dimVal));
                if (null == dyParam || null == dy) {
                    return false;
                }
                String dyParamLongNumber = dyParam.getString("longnumber");
                String dyLongNumber = dy.getString("longnumber");
                if (containsSub) {
                    return dyParamLongNumber.startsWith(dyLongNumber);
                }
                return HRStringUtils.equals((String)dyParamLongNumber, (String)dyLongNumber);
            }
            if (HRStringUtils.equals((String)dataSource, (String)"hrbu")) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
                QFilter viewFilter = new QFilter("view", "=", (Object)dimension.getBuId());
                DynamicObject orgDyParam = serviceHelper.queryOriginalOne("longnumber", new QFilter("org", "=", dimValueParam).and(viewFilter));
                DynamicObject orgDy = serviceHelper.queryOriginalOne("longnumber", new QFilter("org", "=", longPrimaryKey ? Long.valueOf(dimVal) : dimVal).and(viewFilter));
                if (null == orgDyParam || null == orgDy) {
                    return false;
                }
                String orgDyParamLongNumber = orgDyParam.getString("longnumber");
                String orgDyLongNumber = orgDy.getString("longnumber");
                if (containsSub) {
                    return orgDyParamLongNumber.startsWith(orgDyLongNumber);
                }
                return HRStringUtils.equals((String)orgDyParamLongNumber, (String)orgDyLongNumber);
            }
            return false;
        }
        return HRStringUtils.equals((String)dimValueBean.getDimVal(), (String)String.valueOf(dimValueParam));
    }

    private Map<Long, List<Map<Long, List<DimValue>>>> assembleUrDimGrpInfo(List<Long> userRoleRelateIds, long buId, Map<Long, Object> dimValueMap) {
        HRBaseServiceHelper userRoleDimGrpHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        DynamicObject[] userDimGrps = userRoleDimGrpHelper.query("userrolerelat,entry.dimension,entry.isall,entry.otclassify,entry.admincontainssub,entry.containssub,entry.dimval,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("userrolerelat", "in", userRoleRelateIds).and("bucafunc", "=", (Object)buId)});
        HashMap userRoleDimValueInfo = Maps.newHashMapWithExpectedSize((int)userDimGrps.length);
        for (DynamicObject dimGrp : userDimGrps) {
            Long useRoleRelateId = dimGrp.getLong("userrolerelat.id");
            List dimValList = userRoleDimValueInfo.computeIfAbsent(useRoleRelateId, key -> Lists.newArrayListWithExpectedSize((int)10));
            HashMap dimValueBeanMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObjectCollection dimValColl = dimGrp.getDynamicObjectCollection("entry");
            for (DynamicObject dimVal : dimValColl) {
                long dimId = dimVal.getLong("dimension.id");
                if (!dimValueMap.containsKey(dimId)) continue;
                DimValue dimValueBean = new DimValue(dimVal.getBoolean("isall"), dimVal.getString("dimval"), dimVal.getBoolean("containssub"), dimVal.getBoolean("admincontainssub"), Long.valueOf(dimVal.getLong("otclassify.id")), false);
                dimValueBean.setValType(dimVal.getString("valtype"));
                dimValueBean.setDynaCondId(Long.valueOf(dimVal.getLong("dynacond.id")));
                dimValueBeanMap.computeIfAbsent(dimId, key -> Lists.newArrayListWithExpectedSize((int)10)).add(dimValueBean);
            }
            if (!MapUtils.isNotEmpty((Map)dimValueBeanMap)) continue;
            dimValList.add(dimValueBeanMap);
        }
        return userRoleDimValueInfo;
    }

    private Map<String, List<Map<Long, List<DimValue>>>> assembleRoleDimGrpInfo(Set<String> roleIds, long buId, Map<Long, Object> dimValueMap) {
        HRBaseServiceHelper roleDimGrpHelper = new HRBaseServiceHelper("hrcs_roledimgrp");
        DynamicObject[] dimGrps = roleDimGrpHelper.query("role,entry.dimension,entry.isall,entry.otclassify,entry.admincontainssub,entry.containssub,entry.dimval,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("role", "in", roleIds).and("bucafunc", "=", (Object)buId)});
        HashMap roleDimValueInfo = Maps.newHashMapWithExpectedSize((int)dimGrps.length);
        for (DynamicObject dimGrp : dimGrps) {
            String roleId = dimGrp.getString("role.id");
            List dimValList = roleDimValueInfo.computeIfAbsent(roleId, key -> Lists.newArrayListWithExpectedSize((int)10));
            HashMap dimValueBeanMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObjectCollection dimValColl = dimGrp.getDynamicObjectCollection("entry");
            for (DynamicObject dimVal : dimValColl) {
                long dimId = dimVal.getLong("dimension.id");
                if (!dimValueMap.containsKey(dimId)) continue;
                DimValue dimValueBean = new DimValue(dimVal.getBoolean("isall"), dimVal.getString("dimval"), dimVal.getBoolean("containssub"), dimVal.getBoolean("admincontainssub"), Long.valueOf(dimVal.getLong("otclassify.id")), false);
                dimValueBean.setValType(dimVal.getString("valtype"));
                dimValueBean.setDynaCondId(Long.valueOf(dimVal.getLong("dynacond.id")));
                dimValueBeanMap.computeIfAbsent(dimId, key -> Lists.newArrayListWithExpectedSize((int)10)).add(dimValueBean);
            }
            if (!MapUtils.isNotEmpty((Map)dimValueBeanMap)) continue;
            dimValList.add(dimValueBeanMap);
        }
        return roleDimValueInfo;
    }

    private Set<String> hasAllDimRoles(Set<Long> dimIds, Set<String> hasPermRoles, long buId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("role.id,dimension.id", new QFilter[]{new QFilter("role", "in", hasPermRoles).and("bucafunc", "=", (Object)buId)});
        HashMap roleDimMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : collection) {
            String roleId = dy.getString("role.id");
            long dimId = dy.getLong("dimension.id");
            roleDimMap.computeIfAbsent(roleId, key -> Sets.newHashSetWithExpectedSize((int)16)).add(dimId);
        }
        Set<String> roleIds = roleDimMap.keySet();
        roleIds.removeIf(it -> !((Set)roleDimMap.get(it)).containsAll(dimIds));
        return roleIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> hasPermRoles(Set<String> userRoleIds, String[] filterArgs) {
        HashSet roleIds = Sets.newHashSetWithExpectedSize((int)userRoleIds.size());
        try (DataSet rs = null;){
            String roleIdStr = userRoleIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
            String sql = "select froleid from t_perm_rolepermdetial where froleid in(" + roleIdStr + ")and fbizappid=? and fentitytypeid=? and fpermitemid=?";
            rs = DB.queryDataSet((String)(this.getClass() + ".hasPermRoles"), (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])filterArgs);
            while (rs.hasNext()) {
                Row next = rs.next();
                roleIds.add(next.getString("froleid"));
            }
        }
        return roleIds;
    }
}

