/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleMainModel;

@ExcludeFromJacocoGeneratedReport
public class DimChangeCheckService {
    private static final Log LOG = LogFactory.getLog(DimChangeCheckService.class);
    public static final int SAME = 0;
    public static final int HRBU = 1;
    public static final int ORG = 2;
    public static final int DIM_GROUP = 3;
    public static final int DIM_VALUE = 4;
    public static final int DATA_RULE = 5;

    public static int checkDimDiff(IFormView formView) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView, false);
        Map<String, RoleDataPermModel> originalPermDataMap = permPageCacheUtil.getOriginalDataPermMap();
        Map<String, RoleDataPermModel> permDataMap = permPageCacheUtil.getDataPermMap();
        if (!Sets.symmetricDifference(originalPermDataMap.keySet(), permDataMap.keySet()).isEmpty()) {
            LOG.info("Hrbu is different.");
            return 1;
        }
        for (Map.Entry<String, RoleDataPermModel> entry : originalPermDataMap.entrySet()) {
            String dataRuleStr;
            String dimStr;
            String buKey = entry.getKey();
            RoleDataPermModel originalRoleDataPermModel = entry.getValue();
            RoleDataPermModel roleDataPermModel = permDataMap.get(buKey);
            if (!Sets.symmetricDifference(originalRoleDataPermModel.getOrgMap().keySet(), roleDataPermModel.getOrgMap().keySet()).isEmpty()) {
                LOG.info("Org is different.");
                return 2;
            }
            Map originalDimGrpModelMap = originalRoleDataPermModel.getDimGroupMap();
            Map dimGrpModelMap = roleDataPermModel.getDimGroupMap();
            if (originalDimGrpModelMap.size() != dimGrpModelMap.size()) {
                LOG.info("Dim group size is different.");
                return 3;
            }
            String originalDimStr = DimChangeCheckService.stringifyDim(originalDimGrpModelMap.values());
            if (!HRStringUtils.equals((String)originalDimStr, (String)(dimStr = DimChangeCheckService.stringifyDim(dimGrpModelMap.values())))) {
                LOG.info("Dim value is different.");
                return 4;
            }
            String originalDataRuleStr = DimChangeCheckService.stringifyDataRule(originalRoleDataPermModel.getAppEntity2DataRules().values());
            if (HRStringUtils.equals((String)originalDataRuleStr, (String)(dataRuleStr = DimChangeCheckService.stringifyDataRule(roleDataPermModel.getAppEntity2DataRules().values())))) continue;
            LOG.info("Data rule is different.");
            return 5;
        }
        LOG.info("Dim is same.");
        return 0;
    }

    private static String stringifyDim(Collection<DimGrpModel> dimGrpModels) {
        if (null == dimGrpModels || dimGrpModels.isEmpty()) {
            return "";
        }
        return dimGrpModels.stream().map(dimGrpModel -> dimGrpModel.getDimMap().values().stream().map(dimModel -> {
            String dimNumber = dimModel.getDimNumber();
            String limit = dimModel.getLimit();
            String values = dimModel.getDimValues().values().stream().map(dimValue -> dimValue.getOrDefault("id", "") + dimValue.get("includeSub").toString()).collect(Collectors.joining());
            return dimNumber + limit + values;
        }).collect(Collectors.joining())).collect(Collectors.joining("#"));
    }

    private static String stringifyDataRule(Collection<RoleDataRuleMainModel> roleDataRuleMainModels) {
        if (null == roleDataRuleMainModels || roleDataRuleMainModels.isEmpty()) {
            return "";
        }
        return roleDataRuleMainModels.stream().map(roleDataRuleMainModel -> roleDataRuleMainModel.getDataRuleMap().values().stream().filter(Objects::nonNull).filter(roleDataRuleEntryModel -> Optional.ofNullable(roleDataRuleEntryModel.getPermItem()).orElseGet(() -> Collections.emptyList()).contains("47150e89000000ac")).map(roleDataRuleEntryModel -> roleDataRuleEntryModel.getDataRuleId()).collect(Collectors.joining())).collect(Collectors.joining("#"));
    }
}

