/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class HRPermTreeService {
    private static final Log LOGGER = LogFactory.getLog(HRPermTreeService.class);
    private static final String BIZ_UNIT_REL_FORM_DS = "bizUnitRelFormDS";
    private static final String BIZ_OBJ_APP_DS = "bizObjAppDS";
    private static final String ENTITY_DESIGN_DS = "entityDesignDS";
    private static final String ENTAPP_ENTNUM = "entapp_entnum";
    private static final String ENT_NUM = "ent_num";
    private static final String ENTAPP_APPID = "entapp_appid";
    private static final String ENT_ID = "ent_id";
    private static final String FUNC_PERM_DS = "funcPermDS";
    private static final String FUNCPERM_ENTID = "funcperm_entid";
    private static final String BURF_FORMID = "burf_formid";
    private static final String BURF_APPID = "burf_appid";
    private static final String ENT_DS = "entDS";
    private static final String ENTD_ID = "entd_id";
    private static final String ENTD_NUM = "entd_num";

    public DataSet getAllFuncPermTree() {
        String algoKeyPrefix = this.getClass().getName() + ".searchAllFuncPermTreeByText.";
        DataSet bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
        DataSet bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
        DataSet entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
        DataSet bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
        HashSet forBidEntitySet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet forBidAppSet = Sets.newHashSetWithExpectedSize((int)16);
        EntityCtrlServiceHelper.queryEntityForBidInfo(forBidEntitySet, forBidAppSet, null);
        String whereCondition = HRPermTreeService.getHRCondition(forBidAppSet);
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
            whereCondition = whereCondition + " and burf_appid not in (" + appBlacklist + ")";
        }
        LOGGER.info("Got HRCondition: {}.", (Object)whereCondition);
        DataSet appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).where(whereCondition);
        DataSet funcPermDS = this.queryFuncPermDS(algoKeyPrefix);
        DataSet appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
        DataSet entDS = this.queryEntDS("", RequestContext.get().getLang().name(), algoKeyPrefix);
        if (forBidEntitySet.size() > 0) {
            HashMap<String, HashSet> filterMap = new HashMap<String, HashSet>(1);
            filterMap.put("valids", forBidEntitySet);
            entDS = entDS.filter("entd_num not in valids", filterMap);
        }
        return appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM, ENTD_ID}).finish();
    }

    private DataSet getBizUniRelFormDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid,  fformid burf_formid FROM t_meta_bizunitrelform");
    }

    private DataSet getBizObjAppDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid  entapp_entnum FROM t_perm_bizobjapp");
    }

    private DataSet getEntityDesignDs(String algoKeyPrefix) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entitymeta");
        return helper.queryDataSet(algoKeyPrefix + ENTITY_DESIGN_DS, "id ent_id, number ent_num, name");
    }

    private static String getHRCondition(Set<String> forBidApps) {
        List<Object> appIds;
        List forbidExtApps = PermFormCommonUtil.getAllExtAppId((List)Lists.newArrayList(forBidApps));
        HRBaseServiceHelper userAdminGroupServiceHelper = new HRBaseServiceHelper("perm_useradmingroup");
        HRBaseServiceHelper adminGroupServiceHelper = new HRBaseServiceHelper("perm_admingroupapp");
        DynamicObject[] userGroupItems = userAdminGroupServiceHelper.queryOriginalArray("usergroup.id,usergroup.level", new QFilter[]{new QFilter("user.id", "=", (Object)RequestContext.get().getCurrUserId()).and("usergroup.isdomain", "=", (Object)"1").and("usergroup.domain.number", "=", (Object)"hr")});
        Set topAdminGroupIds = Arrays.stream(userGroupItems).filter(it -> it.getInt("usergroup.level") == 2).map(it -> it.getLong("usergroup.id")).collect(Collectors.toSet());
        DynamicObject[] topAGRange = adminGroupServiceHelper.queryOriginalArray("app,usergroup.id", new QFilter[]{new QFilter("usergroup.id", "in", topAdminGroupIds).and("app", "not in", (Object)forbidExtApps)});
        int count = (int)Arrays.stream(topAGRange).map(it -> it.getLong("usergroup.id")).distinct().count();
        if (count < topAdminGroupIds.size()) {
            appIds = Lists.newArrayList(EntityCtrlServiceHelper.getHRApps(true));
        } else {
            List userGroupIds = Arrays.stream(userGroupItems).map(it -> it.getLong("usergroup.id")).collect(Collectors.toList());
            DynamicObject[] apps = adminGroupServiceHelper.queryOriginalArray("app", new QFilter[]{new QFilter("usergroup.id", "in", userGroupIds).and("app", "not in", (Object)forbidExtApps)});
            appIds = Arrays.stream(apps).map(it -> it.getString("app")).collect(Collectors.toList());
        }
        appIds.removeAll(forbidExtApps);
        List finalFilterAppIds = PermFormCommonUtil.getAllExtAppId((List)appIds);
        String appIdStr = finalFilterAppIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
        if (HRStringUtils.isEmpty((String)appIdStr)) {
            return "1=2";
        }
        return " burf_appid in ( " + appIdStr + " )";
    }

    private DataSet queryFuncPermDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)" select distinct funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm  INNER  JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID ");
    }

    private DataSet queryEntDS(String searchText, String langStr, String algoKeyPrefix) {
        searchText = '%' + searchText + '%';
        return DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"select entd.FID entd_id, entd.fnumber entd_num from t_meta_entitydesign entd  INNER JOIN t_meta_mainentityinfo_l entdl  ON (entdl.FID = entd.fnumber AND entdl.FLOCALEID = ?  and entdl.fname like ?)   where entd.FISTEMPLATE = '0'  and fmodeltype <> 'ReportQueryListModel' ", (Object[])new Object[]{langStr, searchText});
    }
}

