/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;

public class PermNotifyService {
    private static final Log LOGGER = LogFactory.getLog(PermNotifyService.class);

    public static void notifyAll(String roleId) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.PermNotifyService.notifyAll", () -> {
            List userIds = PermissionServiceHelper.getUsersByRoleID((String)roleId);
            PermNotifyService.notifyUsers(userIds);
        });
    }

    public static void notifyByDataProperty(String roleId, String dataProperty) {
        LOGGER.info("Notify user by data property with role-id:[{}] and data-property:[{}].", (Object)roleId, (Object)dataProperty);
        if ("0".equals(dataProperty) || "1".equals(dataProperty)) {
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.PermNotifyService.notifyByDataProperty", () -> {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
                DynamicObject[] items = serviceHelper.query("user.id", new QFilter[]{new QFilter("role.id", "=", (Object)roleId), new QFilter("customenable", "=", (Object)dataProperty)});
                List<Long> userIds = Arrays.stream(items).map(it -> it.getLong("user.id")).collect(Collectors.toList());
                PermNotifyService.notifyUsers(userIds);
            });
        } else {
            LOGGER.error("Illegal data property: [{}].", (Object)dataProperty);
        }
    }

    public static void notifyUsers(List<Long> userIds) {
        if (null == userIds || userIds.isEmpty()) {
            LOGGER.info("Terminate notification because of empty user id.");
            return;
        }
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.PermNotifyService.notifyUsers", () -> {
            LOGGER.info("Cancel show form data rights. User ids:{}.", (Object)userIds);
            boolean notify = PermCheckUtil.getSysParamAuthorityChangeNotice();
            if (notify) {
                FormConfigFactory.cancelShowFormDataRights((List)userIds);
            } else {
                LOGGER.info("The authority change notice switch has been disabled.");
            }
        });
    }

    public static void notifyUser(Long userId) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.PermNotifyService.notifyUser", () -> PermNotifyService.notifyUsers(Collections.singletonList(userId)));
    }

    public static void notifyByDataRule(Long dataRuleId) {
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.perm.PermNotifyService.notifyByDataRule", () -> {
            QFilter[] qFilters = new QFilter[]{new QFilter("permitem.number", "=", (Object)"QXX0001"), new QFilter("datarule.id", "=", (Object)dataRuleId)};
            HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
            DynamicObject[] users = userDataRuleHelper.query("userrolerelate.user.id", qFilters);
            Set userIds = Arrays.stream(users).map(it -> it.getLong("userrolerelate.user.id")).collect(Collectors.toSet());
            HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_roledatarule");
            DynamicObject[] roles = roleDataRuleHelper.query("role.id,role.property,role.isintersection", qFilters);
            HashSet allRoleIds = new HashSet();
            HashSet roleIds = new HashSet();
            Arrays.stream(roles).forEach(role -> {
                String roleId = role.getString("role.id");
                if (HRStringUtils.equals((String)"1", (String)role.getString("role.property")) && HRStringUtils.equals((String)"0", (String)role.getString("role.isintersection"))) {
                    roleIds.add(roleId);
                } else {
                    allRoleIds.add(roleId);
                }
            });
            userIds.addAll(Arrays.stream(BusinessDataServiceHelper.load((String)"perm_userrole", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("role.id", "in", allRoleIds)})).map(it -> it.getLong("user.id")).collect(Collectors.toSet()));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
            DynamicObject[] items = serviceHelper.query("user.id", new QFilter[]{new QFilter("role.id", "in", roleIds), new QFilter("customenable", "=", (Object)"0")});
            userIds.addAll(Arrays.stream(items).map(it -> it.getLong("user.id")).collect(Collectors.toSet()));
            PermNotifyService.notifyUsers(new ArrayList<Long>(userIds));
        });
    }
}

