/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class RoleService {
    private static final Log LOGGER = LogFactory.getLog(RoleService.class);
    private static final String KEY_HRBUCA = "hrbuca";
    private static final String KEY_CONTAINS_SUB = "containssub";

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, List<Map<String, Object>>> queryUserHrBu(Object userRoleRelateId) {
        HashMap userBuMap = Maps.newHashMapWithExpectedSize((int)16);
        StringBuilder sql = new StringBuilder();
        sql.append("select a.forgid org ,a.fisincludesuborg containssub, a.fbucafuncid bucafunc ").append(" from T_HBSS_USERROLE a ").append(" where a.fuserrolerealtid = ? ");
        try (DataSet userBuDataSet = HRDBUtil.queryDataSet((String)"RoleService.queryUserHrBu", (DBRoute)new DBRoute("hmp"), (String)sql.toString(), (Object[])new Object[]{userRoleRelateId});){
            while (userBuDataSet.hasNext()) {
                Row row = userBuDataSet.next();
                String buKey = row.getString("bucafunc") + "@" + row.getString("bucafunc");
                HashMap<String, Object> buMap = new HashMap<String, Object>(3);
                buMap.put("org", row.get("org"));
                buMap.put(KEY_CONTAINS_SUB, row.get(KEY_CONTAINS_SUB));
                buMap.put(KEY_HRBUCA, buKey);
                userBuMap.computeIfAbsent(buKey, key -> new ArrayList(16)).add(buMap);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return userBuMap;
    }

    public static Map<String, String> queryHrBuca() {
        HashMap hrBucaMap = Maps.newHashMapWithExpectedSize((int)16);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.fid hrbucaid,a.fparentid parentid,b.fid hrbucafuncid ").append(" from t_hbss_hrbuca a ").append(" inner join t_hbss_hrbucafunc b on a.fhrbucafuncid = b.fid ").append(" where a.fstatus = 'C' and a.fenable = '1' ");
        try (DataSet userBuDataSet = HRDBUtil.queryDataSet((String)"RoleService.queryHrBuca", (DBRoute)new DBRoute("hmp"), (String)sql.toString(), (Object[])new Object[0]);){
            while (userBuDataSet.hasNext()) {
                Row row = userBuDataSet.next();
                String parentid = row.getString("parentid");
                StringBuilder key = new StringBuilder();
                key.append(row.getString("hrbucafuncid")).append('@').append(row.getString("hrbucaid"));
                if (HRStringUtils.equals((String)parentid, (String)"0")) {
                    hrBucaMap.put(key.toString(), row.getString("hrbucaid"));
                    continue;
                }
                hrBucaMap.put(key.toString(), row.getString("parentid"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return hrBucaMap;
    }

    public static void removeHRBUCace(String currentKey, IPageCache iPageCache) {
        String hrEqualBuId = iPageCache.get("hrequalsebuid");
        if (HRStringUtils.isEmpty((String)hrEqualBuId)) {
            return;
        }
        Set bucafuncIdSet = (Set)SerializationUtils.fromJsonString((String)hrEqualBuId, Set.class);
        bucafuncIdSet.remove(currentKey);
        iPageCache.put("hrequalsebuid", SerializationUtils.toJsonString((Object)bucafuncIdSet));
        if (bucafuncIdSet.size() == 0) {
            iPageCache.remove("hr.businessType");
            iPageCache.remove("hrequalsebuid");
        }
    }

    public static void addHRBUCace(String currentKey, IPageCache iPageCache) {
        if (HRStringUtils.isNotEmpty((String)currentKey)) {
            HashSet bucafuncIdSet = Sets.newHashSet();
            bucafuncIdSet.add(currentKey);
            iPageCache.put("hrequalsebuid", SerializationUtils.toJsonString((Object)bucafuncIdSet));
            iPageCache.put("hr.businessType", currentKey);
        }
    }

    public static Set<String> getSelectBuFunc(IPageCache iPageCache) {
        String hrEqualBuId = iPageCache.get("hrequalsebuid");
        Set bucafuncIdSet = Sets.newHashSet();
        if (!HRStringUtils.isEmpty((String)hrEqualBuId)) {
            bucafuncIdSet = (Set)SerializationUtils.fromJsonString((String)hrEqualBuId, Set.class);
        }
        return bucafuncIdSet;
    }

    public static void commonWriteLogBeforeDoOp(BeforeDoOperationEventArgs args) {
        Object operationObj = args.getSource();
        String operationKey = "";
        String operationName = "";
        String entityNum = "";
        String appNum = "";
        if (operationObj instanceof FormOperate) {
            FormOperate formOperate = (FormOperate)operationObj;
            entityNum = formOperate.getEntityId();
            appNum = formOperate.getView().getFormShowParameter().getAppId();
            operationKey = formOperate.getOperateKey();
            operationName = formOperate.getOperateName().getLocaleValue_zh_CN();
        }
        RoleService.commonWriteLogWithOpKey(operationKey, operationName, true, entityNum, PermCommonUtil.getAppIdFromSuspectedAppNum((String)appNum));
    }

    public static void getOrgDimension(IFormView view) {
        Map<String, Long> dimMap = RoleService.getOrgDimension();
        if (CollectionUtils.isEmpty(dimMap)) {
            return;
        }
        for (Map.Entry<String, Long> dimension : dimMap.entrySet()) {
            view.getPageCache().put(dimension.getKey(), dimension.getValue().toString());
        }
    }

    public static Map<String, Long> getOrgDimension() {
        HRBaseServiceHelper dimensionHelper = new HRBaseServiceHelper("hrcs_dimension");
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", (Object)new String[]{"adminorg", "orgteam"})};
        DynamicObjectCollection dimColl = dimensionHelper.queryOriginalCollection("id,number", filters);
        Map<String, Long> resultMap = dimColl.stream().collect(Collectors.toMap(dimension -> dimension.getString("number"), dimension -> dimension.getLong("id")));
        return resultMap;
    }

    public static void showOrgteamF7Form(IFormView view, IFormPlugin plugin) {
        if (HRStringUtils.isEmpty((String)view.getPageCache().get("orgteam"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9879\u76ee\u56e2\u961f\u7ef4\u5ea6", (String)"RoleService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection orgColl = view.getModel().getEntryEntity("orgteamentryentity");
        ArrayList teamFilter = Lists.newArrayListWithExpectedSize((int)orgColl.size());
        orgColl.forEach(row -> teamFilter.add(row.getLong("orgteam.id")));
        QFilter filter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        if (teamFilter.size() > 0) {
            QFilter idFilter = new QFilter("id", "not in", (Object)teamFilter);
            filter.and(idFilter);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("show orgteamF7Form,entityNumber={}", (Object)"haos_adminorghr");
        }
        RoleService.showF7Form(filter, "haos_adminorgteam", true, "orgteam", "bos_listf7", view, plugin);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void showF7Form(QFilter qFilter, String entityName, boolean isMultiSelect, IFormView view, IFormPlugin plugin) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("qFilter", qFilter);
        params.put("entityName", entityName);
        params.put("isMultiSelect", isMultiSelect);
        RoleService.showF7Form(params, view, plugin);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void showF7Form(QFilter qFilter, String entityName, boolean isMultiSelect, String actionId, String formId, IFormView view, IFormPlugin plugin) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("qFilter", qFilter);
        params.put("entityName", entityName);
        params.put("isMultiSelect", isMultiSelect);
        params.put("formId", formId);
        params.put("actionId", actionId);
        RoleService.showF7Form(params, view, plugin);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void showF7Form(Map<String, Object> params, IFormView view, IFormPlugin plugin) {
        Object isMultiSelect;
        Object actionParam;
        String formId;
        String entityName = params.get("entityName").toString();
        if (HRStringUtils.isEmpty((String)entityName)) {
            view.showMessage(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0\u672a\u5b9a\u4e49\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RoleService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)entityName, (boolean)true, (int)0, (boolean)true);
        showListForm.setCloseCallBack(new CloseCallBack(plugin, entityName));
        showListForm.getOpenStyle().setShowType(ShowType.Modal);
        Object formIdParam = params.get("formId");
        String string = formId = Objects.nonNull(formIdParam) ? formIdParam.toString() : "";
        if (HRStringUtils.isNotEmpty((String)formId)) {
            showListForm.setFormId(formId);
        }
        String actionId = Objects.nonNull(actionParam = params.get("actionId")) && HRStringUtils.isNotEmpty((String)actionParam.toString()) ? actionParam.toString() : entityName;
        Object qFilter = params.get("qFilter");
        if (Objects.nonNull(qFilter)) {
            showListForm.getListFilterParameter().setFilter((QFilter)qFilter);
        }
        if (Objects.nonNull(isMultiSelect = params.get("isMultiSelect"))) {
            showListForm.setMultiSelect(((Boolean)isMultiSelect).booleanValue());
        }
        showListForm.setShowTitle(false);
        showListForm.setHasRight(true);
        Object caption = params.get("caption");
        if (Objects.nonNull(caption)) {
            showListForm.setCaption(caption.toString());
        }
        if (Objects.nonNull(caption)) {
            showListForm.setCaption(caption.toString());
        }
        showListForm.setCloseCallBack(new CloseCallBack(plugin, actionId));
        view.showForm((FormShowParameter)showListForm);
    }

    public static boolean isAdmin() {
        boolean isCosmic;
        boolean isHrAdmin = true;
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
        if (!isAdmin & !(isCosmic = PermCommonUtil.isCosmicUser((Long)userId))) {
            isHrAdmin = false;
        }
        if (!RoleService.isHrAdmin()) {
            isHrAdmin = false;
        }
        return isHrAdmin;
    }

    public static boolean isHrAdmin() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection adminSchemes = QueryServiceHelper.query((String)"perm_adminscheme", (String)"id", (QFilter[])filters);
        Long adminScheme = (Long)((DynamicObject)adminSchemes.get(0)).get("id");
        filters = new QFilter[]{new QFilter("user.id", "=", (Object)userId).and("usergroup.adminscheme.id", "=", (Object)adminScheme).and("usergroup.isdomain", "=", (Object)"1").and("usergroup.domain", "=", (Object)1386267129346523136L).or("usergroup.id", "=", (Object)1393280986623636480L).and("user.id", "=", (Object)userId)};
        DynamicObject[] userAdminGroup = BusinessDataServiceHelper.load((String)"hrcs_useradmingroup", (String)"user,usergroup", (QFilter[])filters);
        return userAdminGroup != null && userAdminGroup.length != 0;
    }

    public static void commonWriteLogWithOpKey(String opKey, String opName, boolean isOpSuc, String entityNum, String appid) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo opLogAppInfo = RoleService.buildLogWithOpKey(opKey, opName, isOpSuc, entityNum, appid);
        service.addLog((AppLogInfo)opLogAppInfo);
    }

    public static void commonWriteLogNoOpKey(String englishKey, MultiLangEnumBridge langEnumBridge, boolean isOpSuc, String entityNum, String appid) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo opLogAppInfo = RoleService.buildLogNoOpKey(englishKey, langEnumBridge, isOpSuc, entityNum, appid);
        service.addLog((AppLogInfo)opLogAppInfo);
    }

    public static void addLogWithOpKey(String opKey, String opName, boolean isOpSuc, String entityNum, String appid, List<OpLogAppInfo> appLogInfoList, String description) {
        OpLogAppInfo opLogAppInfo = RoleService.buildLogWithOpKey(opKey, opName, isOpSuc, entityNum, appid);
        opLogAppInfo.setOpDescription(description);
        appLogInfoList.add(opLogAppInfo);
    }

    public static void addLogNoOpKey(String englishKey, MultiLangEnumBridge langEnumBridge, boolean isOpSuc, String entityNum, String appid, List<OpLogAppInfo> appLogInfoList, String description) {
        OpLogAppInfo opLogAppInfo = RoleService.buildLogNoOpKey(englishKey, langEnumBridge, isOpSuc, entityNum, appid);
        opLogAppInfo.setOpDescription(description);
        appLogInfoList.add(opLogAppInfo);
    }

    private static OpLogAppInfo buildLogWithOpKey(String opKey, String opName, boolean isOpSuc, String entityNum, String appid) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        opLogAppInfo.setOpName(opKey, opName);
        opLogAppInfo.setBizObjID(entityNum);
        opLogAppInfo.setBizAppID(appid);
        opLogAppInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        if (isOpSuc) {
            opLogAppInfo.setStatus("1");
        } else {
            opLogAppInfo.setStatus("0");
        }
        return opLogAppInfo;
    }

    private static OpLogAppInfo buildLogNoOpKey(String englishKey, MultiLangEnumBridge langEnumBridge, boolean isOpSuc, String entityNum, String appid) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        opLogAppInfo.setOpName(englishKey, langEnumBridge);
        opLogAppInfo.setBizObjID(entityNum);
        opLogAppInfo.setBizAppID(appid);
        opLogAppInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        if (isOpSuc) {
            opLogAppInfo.setStatus("1");
        } else {
            opLogAppInfo.setStatus("0");
        }
        return opLogAppInfo;
    }
}

