/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.model.perm.AssignSource;
import kd.hr.hbp.common.model.perm.PermDataRangeParam;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.model.perm.UserRoleBatchAssignBean;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.check.UserAdminOrgService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRPermDimServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignParamBuilder;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignService;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermFileSyncServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignSaveService;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogBussinessHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogServiceHelper;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.DimValueGroup;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@ExcludeFromJacocoGeneratedReport
public class UserRoleService {
    private static final Log LOGGER = LogFactory.getLog(UserRoleService.class);
    private static final String DIM_TYPE_HRUB = "hrbu";
    private static final String DIM_TYPE_ORG_TEAM = "orgteam";

    public HrApiResponse batchUserAssignRole(List<UserRoleBatchAssignBean> permList) {
        LOGGER.info("kd.hr.hrcs.bussiness.service.perm.UserRoleService.batchUserAssignRole permList = {}", (Object)JSONArray.toJSONString(permList));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(permList)) {
            HrApiResponse apiResult = new HrApiResponse();
            apiResult.setSuccess(true);
            apiResult.setErrorMessage("permList is empty");
            apiResult.setCode(EnumResponseCode.SUCCESS.getCode());
            return apiResult;
        }
        ArrayList<Long> userList = new ArrayList<Long>(permList.size());
        ArrayList<String> roleNumberList = new ArrayList<String>(permList.size());
        QFilter permFileFilter = null;
        for (UserRoleBatchAssignBean detail : permList) {
            Long userId = detail.getUserId();
            String roleNumber = detail.getRoleNumber();
            Long orgId = detail.getOrgId();
            userList.add(userId);
            roleNumberList.add(roleNumber);
            QFilter curPermFileFilter = new QFilter("user", "=", (Object)userId).and("permfileenable", "=", (Object)"1");
            if (null != orgId) {
                curPermFileFilter = curPermFileFilter.and(new QFilter("org", "=", (Object)orgId));
            }
            if (null == permFileFilter) {
                permFileFilter = curPermFileFilter;
                continue;
            }
            permFileFilter = permFileFilter.or(curPermFileFilter);
        }
        Map<Long, Boolean> userMap = this.queryUserMap(userList);
        ArrayList roleIdList = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, Pair<String, Boolean>> permRoleMap = this.queryPermRoleMap(roleNumberList, roleIdList);
        Map<String, Boolean> hrcsRoleMap = this.queryHrcsRoleMap(roleIdList);
        List<String> existDataRangeRoleIds = RoleMemberAssignServiceHelper.existDataRangeRoles(roleIdList);
        Map<Long, Long> existPfUserList = this.queryUserPermFileMap(permFileFilter);
        Map<String, Map<Long, List<Long>>> allRoleBuCaDimMap = this.queryAllRoleBuCaDimMap(roleIdList);
        Map<String, List<Long>> roleBuMap = this.queryRoleBuMap(roleIdList);
        StringBuilder message = new StringBuilder();
        this.validateData(permList, message, userMap, permRoleMap, hrcsRoleMap, existDataRangeRoleIds, existPfUserList.keySet(), allRoleBuCaDimMap, roleBuMap);
        HrApiResponse apiResult = new HrApiResponse();
        if (message.length() > 0) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
            return apiResult;
        }
        ArrayList userRoleAssignParamList = Lists.newArrayListWithExpectedSize((int)permList.size());
        for (UserRoleBatchAssignBean detail : permList) {
            Long userId = detail.getUserId();
            String roleNumber = detail.getRoleNumber();
            Date validStart = detail.getValidStart();
            Date validEnd = detail.getValidEnd();
            boolean isCustomData = detail.isCustomData();
            Map bucaPermData = detail.getBucaPermData();
            Long creatorId = detail.getCreatorId();
            String roleId = (String)permRoleMap.get(roleNumber).getLeft();
            Long permFileId = existPfUserList.get(userId);
            UserRoleAssignParam param = new UserRoleAssignParam(permFileId, roleId, validStart, validEnd, creatorId);
            param.setCustomData(isCustomData);
            AssignSource assignSource = param.getAssignSource();
            assignSource.setObType("userRoleAdd");
            assignSource.setPageSource("mservice");
            assignSource.setOtherInfo("batchUserAssignRole");
            assignSource.setSourceType("1");
            if (isCustomData) {
                PermDataRangeParam dataRangeParam = new PermDataRangeParam();
                dataRangeParam.setBucaPermData(bucaPermData);
                param.setDataRangeParam(dataRangeParam);
            }
            userRoleAssignParamList.add(param);
        }
        LOGGER.info("kd.hr.hrcs.bussiness.service.perm.UserRoleService.batchUserAssignRole userRoleAssignParamList = {}", (Object)JSONArray.toJSONString((Object)userRoleAssignParamList));
        Map<String, Object> assignResult = RoleAssignService.roleAssignUserBatch(userRoleAssignParamList);
        if (!HRStringUtils.equals((String)((String)assignResult.get("success")), (String)"true")) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage((String)assignResult.get("message"));
            apiResult.setCode((String)assignResult.get("code"));
            return apiResult;
        }
        apiResult.setCode(EnumResponseCode.SUCCESS.getCode());
        apiResult.setSuccess(true);
        apiResult.setErrorMessage("user assign role success");
        HRPermCacheMgr.clearAllCache();
        return apiResult;
    }

    private Map<String, List<Long>> queryRoleBuMap(List<String> roleIdList) {
        HRBaseServiceHelper roleBuFuncHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        DynamicObjectCollection roleBuColl = roleBuFuncHelper.queryOriginalCollection("role,hrbucafunc", new QFilter[]{new QFilter("role", "in", roleIdList)});
        HashMap roleBuMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : roleBuColl) {
            String roleId = dy.getString("role");
            long hrbucafunc = dy.getLong("hrbucafunc");
            List roleBuIds = roleBuMap.computeIfAbsent(roleId, key -> Lists.newArrayListWithExpectedSize((int)10));
            roleBuIds.add(hrbucafunc);
        }
        return roleBuMap;
    }

    private Map<String, Map<Long, List<Long>>> queryAllRoleBuCaDimMap(List<String> roleIdList) {
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObjectCollection roleDimColl = roleDimHelper.queryOriginalCollection("role,dimension.id,bucafunc.id", new QFilter[]{new QFilter("role", "in", roleIdList)});
        HashMap allRoleBuCaDimMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject roleDim : roleDimColl) {
            String roleId = roleDim.getString("role");
            long bucaId = roleDim.getLong("bucafunc.id");
            long dimId = roleDim.getLong("dimension.id");
            Map roleBuCaDimMap = allRoleBuCaDimMap.computeIfAbsent(roleId, it -> Maps.newHashMapWithExpectedSize((int)16));
            List dimList = roleBuCaDimMap.computeIfAbsent(bucaId, key -> Lists.newArrayListWithExpectedSize((int)10));
            dimList.add(dimId);
        }
        return allRoleBuCaDimMap;
    }

    private Map<Long, Long> queryUserPermFileMap(QFilter permFileFilter) {
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObjectCollection permFileColl = permFileHelper.queryOriginalCollection("id,user.id,permfileenable", new QFilter[]{permFileFilter}, "createtime asc");
        HashMap userPermFileMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject permFile : permFileColl) {
            long userId = permFile.getLong("user.id");
            long permFileId = permFile.getLong("id");
            if (userPermFileMap.containsKey(userId)) continue;
            userPermFileMap.put(userId, permFileId);
        }
        return userPermFileMap;
    }

    private Map<String, Boolean> queryHrcsRoleMap(List<String> roleIdList) {
        HRBaseServiceHelper hrcsRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection hrcsRoleColl = hrcsRoleHelper.queryOriginalCollection("id,property", new QFilter[]{new QFilter("id", "in", roleIdList)});
        Map<String, Boolean> hrcsRoleMap = hrcsRoleColl.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> HRStringUtils.equals((String)it.getString("property"), (String)"1")));
        return hrcsRoleMap;
    }

    private Map<String, Pair<String, Boolean>> queryPermRoleMap(List<String> roleNumberList, List<String> roleIdList) {
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_role");
        DynamicObjectCollection permRoleDyColl = roleHelper.queryOriginalCollection("id,number,enable", new QFilter[]{new QFilter("number", "in", roleNumberList)});
        HashMap permRoleMap = Maps.newHashMapWithExpectedSize((int)permRoleDyColl.size());
        ArrayList roleIdListTmp = Lists.newArrayListWithExpectedSize((int)permRoleDyColl.size());
        for (DynamicObject permRole : permRoleDyColl) {
            String roleId = permRole.getString("id");
            roleIdList.add(roleId);
            permRoleMap.put(permRole.getString("number"), Pair.of((Object)roleId, (Object)HRStringUtils.equals((String)permRole.getString("enable"), (String)"1")));
        }
        roleIdList.addAll(roleIdListTmp);
        return permRoleMap;
    }

    private Map<Long, Boolean> queryUserMap(List<Long> userList) {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObjectCollection userDyColl = userHelper.queryOriginalCollection("id,isforbidden", new QFilter[]{new QFilter("id", "in", userList)});
        Map<Long, Boolean> userMap = userDyColl.stream().collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getBoolean("isforbidden"), (newVal, oldVal) -> newVal));
        return userMap;
    }

    private void validateData(List<UserRoleBatchAssignBean> permList, StringBuilder message, Map<Long, Boolean> userMap, Map<String, Pair<String, Boolean>> permRoleMap, Map<String, Boolean> hrcsRoleMap, List<String> existDataRangeRoleIds, Set<Long> existPfUserList, Map<String, Map<Long, List<Long>>> allRoleBuCaDimMap, Map<String, List<Long>> roleBuMap) {
        for (UserRoleBatchAssignBean detail : permList) {
            String dimIdStr;
            Long buId;
            Long userId = detail.getUserId();
            String roleNumber = detail.getRoleNumber();
            Date validStart = detail.getValidStart();
            Date validEnd = detail.getValidEnd();
            boolean isCustomData = detail.isCustomData();
            Map bucaPermData = detail.getBucaPermData();
            StringBuilder curMessage = new StringBuilder();
            if (!userMap.containsKey(userId)) {
                curMessage.append(ResManager.loadKDString((String)"\u7528\u6237%s\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_23", (String)"hrmp-hrcs-business", (Object[])new Object[]{userId}));
            } else {
                boolean isForbidden = userMap.get(userId);
                if (isForbidden) {
                    curMessage.append(ResManager.loadKDString((String)"\u7528\u6237%s\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u5206\u914d\u89d2\u8272\u3002", (String)"UserRoleService_24", (String)"hrmp-hrcs-business", (Object[])new Object[]{userId}));
                }
            }
            if (!existPfUserList.contains(userId)) {
                message.append(ResManager.loadKDString((String)"\u7528\u6237%s\u65e0\u53ef\u7528\u7684\u6743\u9650\u6863\u6848\u3002", (String)"UserRoleService_25", (String)"hrmp-hrcs-business", (Object[])new Object[]{userId}));
            }
            String permRoleId = null;
            if (!permRoleMap.containsKey(roleNumber)) {
                curMessage.append(ResManager.loadKDString((String)"\u89d2\u8272\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_26", (String)"hrmp-hrcs-business", (Object[])new Object[]{roleNumber}));
            } else {
                Pair<String, Boolean> permRoleInfo = permRoleMap.get(roleNumber);
                if (!((Boolean)permRoleInfo.getRight()).booleanValue()) {
                    message.append(ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u7528\u6237\u3002", (String)"UserRoleService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                }
                if (!hrcsRoleMap.containsKey(permRoleId = (String)permRoleInfo.getLeft())) {
                    message.append(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728\uff1b", (String)"UserRoleService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                } else {
                    boolean enableCustom = hrcsRoleMap.get(permRoleId);
                    if (!enableCustom && isCustomData) {
                        message.append(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u3002", (String)"UserRoleService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    }
                    if (isCustomData && MapUtils.isEmpty((Map)bucaPermData)) {
                        curMessage.append(ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5b9a\u4e49\u5fc5\u987b\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\uff1b", (String)"UserRoleService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    }
                    boolean existRange = existDataRangeRoleIds.contains(permRoleId);
                    if (enableCustom && !existRange && !isCustomData) {
                        curMessage.append(ResManager.loadKDString((String)"\u89d2\u8272\u6570\u636e\u8303\u56f4\u7a7a\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"UserRoleService_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                    }
                }
            }
            this.validateTime(validStart, validEnd, curMessage);
            if (curMessage.length() > 0) {
                message.append((CharSequence)curMessage);
                continue;
            }
            if (!isCustomData) continue;
            HashSet<Long> roleNoBuCaIds = new HashSet<Long>(bucaPermData.size());
            HashMap roleNoDimIds = new HashMap(bucaPermData.size());
            HashMap<Long, Set<Long>> roleNoOrgIds = new HashMap<Long, Set<Long>>(bucaPermData.size());
            HashMap<Long, List<Long>> urLackDim = new HashMap<Long, List<Long>>(bucaPermData.size());
            Map<Long, List<Long>> roleBuCaDimMap = allRoleBuCaDimMap.getOrDefault(permRoleId, Maps.newLinkedHashMapWithExpectedSize((int)0));
            List<Long> roleBuIds = roleBuMap.getOrDefault(permRoleId, Lists.newArrayListWithExpectedSize((int)0));
            for (Map.Entry entry : bucaPermData.entrySet()) {
                Long buCaId = (Long)entry.getKey();
                List<Long> dimIds = roleBuCaDimMap.getOrDefault(buCaId, Lists.newArrayListWithExpectedSize((int)0));
                if (!roleBuIds.contains(buCaId)) {
                    roleNoBuCaIds.add(buCaId);
                    continue;
                }
                HashSet filledDimIds = new HashSet(16);
                UserBucaPermDataParam userBucaPermDataParam = (UserBucaPermDataParam)entry.getValue();
                this.queryNotExistOrg(userBucaPermDataParam, roleNoOrgIds);
                List userDimGroupData = userBucaPermDataParam.getUserDimGroupData();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)userDimGroupData)) {
                    userDimGroupData.forEach(it -> filledDimIds.addAll(it.getDimValuesMap().keySet()));
                    ArrayList roleBuDimCopy = Lists.newArrayList(dimIds);
                    roleBuDimCopy.removeAll(filledDimIds);
                    filledDimIds.removeAll(dimIds);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(filledDimIds)) {
                        roleNoDimIds.put(buCaId, filledDimIds);
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)roleBuDimCopy)) continue;
                    urLackDim.put(buCaId, roleBuDimCopy);
                    continue;
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(dimIds)) continue;
                urLackDim.put(buCaId, dimIds);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(roleNoBuCaIds)) {
                String noBuStr = roleNoBuCaIds.stream().map(Object::toString).collect(Collectors.joining(","));
                message.append(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4ee5\u4e0b\u804c\u80fd\uff1a%s\u3002", (String)"UserRoleService_7", (String)"hrmp-hrcs-business", (Object[])new Object[]{noBuStr}));
            }
            Set filledRoleBus = bucaPermData.keySet();
            HashSet roleBuIdCopy = Sets.newHashSet(roleBuIds);
            roleBuIdCopy.removeAll(filledRoleBus);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)roleBuIdCopy)) {
                String roleBuIdCopyStr = roleBuIdCopy.stream().map(Object::toString).collect(Collectors.joining(","));
                message.append(ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272\u7f3a\u5c11\u4ee5\u4e0b\u804c\u80fd\uff1a%s\u3002", (String)"UserRoleService_14", (String)"hrmp-hrcs-business", (Object[])new Object[]{roleBuIdCopyStr}));
            }
            if (MapUtils.isNotEmpty(roleNoDimIds)) {
                for (Map.Entry entry : roleNoDimIds.entrySet()) {
                    buId = (Long)entry.getKey();
                    dimIdStr = ((Set)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","));
                    message.append(String.format(ResManager.loadKDString((String)"\u804c\u80fd%1$s\u4e0b\u65e0\u4ee5\u4e0b\u7ef4\u5ea6\uff1a%2$s\u3002", (String)"UserRoleService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buId, dimIdStr));
                }
            }
            if (MapUtils.isNotEmpty(urLackDim)) {
                for (Map.Entry entry : urLackDim.entrySet()) {
                    buId = (Long)entry.getKey();
                    dimIdStr = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","));
                    message.append(String.format(ResManager.loadKDString((String)"\u804c\u80fd%1$s\u4e0b\u7f3a\u5c11\u4ee5\u4e0b\u7ef4\u5ea6\uff1a%2$s\u3002", (String)"UserRoleService_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buId, dimIdStr));
                }
            }
            if (!MapUtils.isNotEmpty(roleNoOrgIds)) continue;
            for (Map.Entry entry : roleNoOrgIds.entrySet()) {
                buId = (Long)entry.getKey();
                String orgIdStr = ((Set)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","));
                message.append(String.format(ResManager.loadKDString((String)"\u804c\u80fd%1$s\u7684\u7ec4\u7ec7\uff1a%2$s\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buId, orgIdStr));
            }
        }
    }

    private void validateTime(Date validStart, Date validEnd, StringBuilder message) {
        boolean startNotNull = null != validStart;
        boolean endNotNull = null != validEnd;
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            if (!startNotNull) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!endNotNull) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        if (startNotNull && endNotNull && HRDateTimeUtils.dayBefore((Date)validEnd, (Date)validStart)) {
            message.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6709\u6548\u5f00\u59cb\u65e5\u671f\uff1b", (String)"UserRoleService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    public HrApiResponse userAssignRole(Long userId, String roleNumber, Date validStart, Date validEnd, boolean isCustomData, Map<Long, UserBucaPermDataParam> bucaPermData, Long creatorId) {
        Map<String, Object> assignResult;
        HrApiResponse apiResult = new HrApiResponse();
        StringBuilder message = new StringBuilder();
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject userDy = userHelper.queryOriginalOne("isforbidden", (Object)userId);
        if (null == userDy) {
            message.append(ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff1b", (String)"UserRoleService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        } else {
            boolean isForbidden = userDy.getBoolean("isforbidden");
            if (isForbidden) {
                message.append(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u89d2\u8272\u3002", (String)"UserRoleService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObject permFile = permFileHelper.queryOriginalOne("id,permfileenable", new QFilter[]{new QFilter("user", "=", (Object)userId).and("permfileenable", "=", (Object)"1")}, "createtime asc");
        if (null == permFile) {
            message.append(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6743\u9650\u6863\u6848\u4e0d\u53ef\u7528\u3002", (String)"UserRoleService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String permRoleId = null;
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_role");
        DynamicObject permRoleDy = roleHelper.queryOriginalOne("id,enable", new QFilter("number", "=", (Object)roleNumber));
        if (null == permRoleDy) {
            message.append(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728\uff1b", (String)"UserRoleService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        } else {
            HRBaseServiceHelper hrcsRoleHelper;
            DynamicObject hrcsRoleDy;
            boolean enable = permRoleDy.getString("enable").equals("1");
            if (!enable) {
                message.append(ResManager.loadKDString((String)"\u5f53\u524d\u89d2\u8272\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5206\u914d\u7528\u6237\u3002", (String)"UserRoleService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (null == (hrcsRoleDy = (hrcsRoleHelper = new HRBaseServiceHelper("hrcs_role")).queryOriginalOne("property", new QFilter("id", "=", (Object)(permRoleId = permRoleDy.getString("id")))))) {
                message.append(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728\uff1b", (String)"UserRoleService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            } else {
                boolean enableCustom = HRStringUtils.equals((String)hrcsRoleDy.getString("property"), (String)"1");
                if (!enableCustom && isCustomData) {
                    message.append(ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u3002", (String)"UserRoleService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                }
                if (isCustomData && MapUtils.isEmpty(bucaPermData)) {
                    message.append(ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5b9a\u4e49\u5fc5\u987b\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\uff1b", (String)"UserRoleService_22", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                }
                boolean existRange = RoleMemberAssignServiceHelper.roleExistDataRange(permRoleDy.getString("id"));
                if (enableCustom && !existRange && !isCustomData) {
                    message.append(ResManager.loadKDString((String)"\u89d2\u8272\u6570\u636e\u8303\u56f4\u7a7a\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"UserRoleService_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                }
            }
        }
        boolean startNotNull = null != validStart;
        boolean endNotNull = null != validEnd;
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            if (!startNotNull) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (!endNotNull) {
                message.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
        }
        if (startNotNull && endNotNull && HRDateTimeUtils.dayBefore((Date)validEnd, (Date)validStart)) {
            message.append(ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6709\u6548\u5f00\u59cb\u65e5\u671f\uff1b", (String)"UserRoleService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (message.length() > 0) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
            return apiResult;
        }
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObjectCollection roleDimColl = roleDimHelper.queryOriginalCollection("dimension.id,bucafunc.id", new QFilter[]{new QFilter("role", "=", (Object)permRoleId)});
        HashMap<Long, List> roleBuCaDimMap = new HashMap<Long, List>(16);
        for (DynamicObject roleDim : roleDimColl) {
            long bucaId = roleDim.getLong("bucafunc.id");
            long dimId = roleDim.getLong("dimension.id");
            roleBuCaDimMap.computeIfAbsent(bucaId, key -> Lists.newArrayListWithExpectedSize((int)10)).add(dimId);
        }
        HRBaseServiceHelper roleBuFuncHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        List roleBuIds = roleBuFuncHelper.queryOriginalCollection("hrbucafunc", new QFilter[]{new QFilter("role", "=", (Object)permRoleId)}).stream().map(it -> it.getLong("hrbucafunc")).collect(Collectors.toList());
        int orgCount = 0;
        if (isCustomData) {
            String dimIdStr;
            Long buId;
            HashSet<Long> roleNoBuCaIds = new HashSet<Long>(bucaPermData.size());
            HashMap roleNoDimIds = new HashMap(bucaPermData.size());
            HashMap<Long, Set<Long>> roleNoOrgIds = new HashMap<Long, Set<Long>>(bucaPermData.size());
            HashMap<Long, List> urLackDim = new HashMap<Long, List>(bucaPermData.size());
            for (Map.Entry<Long, UserBucaPermDataParam> entry : bucaPermData.entrySet()) {
                orgCount += entry.getValue().getOrgInfos().size();
                Long buCaId = entry.getKey();
                List dimIds = roleBuCaDimMap.getOrDefault(buCaId, Lists.newArrayListWithExpectedSize((int)0));
                if (!roleBuIds.contains(buCaId)) {
                    roleNoBuCaIds.add(buCaId);
                    continue;
                }
                HashSet filledDimIds = new HashSet(16);
                UserBucaPermDataParam userBucaPermDataParam = entry.getValue();
                this.queryNotExistOrg(userBucaPermDataParam, roleNoOrgIds);
                List userDimGroupData = userBucaPermDataParam.getUserDimGroupData();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)userDimGroupData)) {
                    userDimGroupData.forEach(it -> filledDimIds.addAll(it.getDimValuesMap().keySet()));
                    ArrayList roleBuDimCopy = Lists.newArrayList((Iterable)dimIds);
                    roleBuDimCopy.removeAll(filledDimIds);
                    filledDimIds.removeAll(dimIds);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(filledDimIds)) {
                        roleNoDimIds.put(buCaId, filledDimIds);
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)roleBuDimCopy)) continue;
                    urLackDim.put(buCaId, roleBuDimCopy);
                    continue;
                }
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dimIds)) continue;
                urLackDim.put(buCaId, dimIds);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(roleNoBuCaIds)) {
                String noBuStr = roleNoBuCaIds.stream().map(Object::toString).collect(Collectors.joining(","));
                message.append(ResManager.loadKDString((String)"\u89d2\u8272\u65e0\u4ee5\u4e0b\u804c\u80fd\uff1a%s\u3002", (String)"UserRoleService_7", (String)"hrmp-hrcs-business", (Object[])new Object[]{noBuStr}));
            }
            Set<Long> filledRoleBus = bucaPermData.keySet();
            HashSet roleBuIdCopy = Sets.newHashSet(roleBuIds);
            roleBuIdCopy.removeAll(filledRoleBus);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)roleBuIdCopy)) {
                String roleBuIdCopyStr = roleBuIdCopy.stream().map(Object::toString).collect(Collectors.joining(","));
                message.append(ResManager.loadKDString((String)"\u7528\u6237\u89d2\u8272\u7f3a\u5c11\u4ee5\u4e0b\u804c\u80fd\uff1a%s\u3002", (String)"UserRoleService_14", (String)"hrmp-hrcs-business", (Object[])new Object[]{roleBuIdCopyStr}));
            }
            if (message.length() > 0) {
                apiResult.setSuccess(true);
                apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                return apiResult;
            }
            if (MapUtils.isNotEmpty(roleNoDimIds)) {
                for (Map.Entry entry : roleNoDimIds.entrySet()) {
                    buId = (Long)entry.getKey();
                    dimIdStr = ((Set)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","));
                    message.append(String.format(ResManager.loadKDString((String)"\u804c\u80fd%1$s\u4e0b\u65e0\u4ee5\u4e0b\u7ef4\u5ea6\uff1a%2$s\u3002", (String)"UserRoleService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buId, dimIdStr));
                }
            }
            if (MapUtils.isNotEmpty(urLackDim)) {
                for (Map.Entry entry : urLackDim.entrySet()) {
                    buId = (Long)entry.getKey();
                    dimIdStr = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","));
                    message.append(String.format(ResManager.loadKDString((String)"\u804c\u80fd%1$s\u4e0b\u7f3a\u5c11\u4ee5\u4e0b\u7ef4\u5ea6\uff1a%2$s\u3002", (String)"UserRoleService_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buId, dimIdStr));
                }
            }
            if (message.length() > 0) {
                apiResult.setSuccess(true);
                apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                return apiResult;
            }
            if (MapUtils.isNotEmpty(roleNoOrgIds)) {
                for (Map.Entry entry : roleNoOrgIds.entrySet()) {
                    buId = (Long)entry.getKey();
                    String orgIdStr = ((Set)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","));
                    message.append(String.format(ResManager.loadKDString((String)"\u804c\u80fd%1$s\u7684\u7ec4\u7ec7\uff1a%2$s\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]), buId, orgIdStr));
                }
            }
            if (message.length() > 0) {
                apiResult.setSuccess(true);
                apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                return apiResult;
            }
        }
        if (null == permRoleDy) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage("role not exist");
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
            return apiResult;
        }
        UserRoleAssignParam param = new UserRoleAssignParam(Long.valueOf(permFile.getLong("id")), permRoleDy.getString("id"), validStart, validEnd, creatorId);
        param.setCustomData(isCustomData);
        AssignSource assignSource = param.getAssignSource();
        assignSource.setObType("userRoleAdd");
        assignSource.setPageSource("mservice");
        assignSource.setOtherInfo("userAssignRole");
        assignSource.setSourceType("1");
        if (isCustomData) {
            PermDataRangeParam dataRangeParam = new PermDataRangeParam();
            dataRangeParam.setBucaPermData(bucaPermData);
            param.setDataRangeParam(dataRangeParam);
        }
        if (!HRStringUtils.equals((String)((String)(assignResult = RoleAssignService.roleAssignUserBatch(Lists.newArrayList((Object[])new UserRoleAssignParam[]{param}))).get("success")), (String)"true")) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage((String)assignResult.get("message"));
            apiResult.setCode((String)assignResult.get("code"));
            return apiResult;
        }
        apiResult.setCode(EnumResponseCode.SUCCESS.getCode());
        apiResult.setSuccess(true);
        apiResult.setErrorMessage("user assign role success");
        HRPermCacheMgr.clearAllCache();
        return apiResult;
    }

    private void queryNotExistOrg(UserBucaPermDataParam userBucaPermDataParam, Map<Long, Set<Long>> roleNoOrgIds) {
        Long buCaId = userBucaPermDataParam.getBucaId();
        Set longs = userBucaPermDataParam.getOrgInfos().keySet();
        HashSet orgIds = Sets.newHashSet(longs);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org");
        Set existIds = serviceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", (Object)orgIds)}).stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
        orgIds.removeAll(existIds);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgIds)) {
            roleNoOrgIds.put(buCaId, orgIds);
        }
    }

    public HrApiResponse batchDeleteUserRole(List<Triple<Long, String, Long>> userRoleList) {
        HrApiResponse hrApiResponse;
        List<String> list;
        LOGGER.info("kd.hr.hrcs.bussiness.service.perm.UserRoleService.batchDeleteUserRole userRoleList = {}", (Object)JSONArray.toJSONString(userRoleList));
        HashSet userIds = Sets.newHashSetWithExpectedSize((int)userRoleList.size());
        HashSet roleNumbers = Sets.newHashSetWithExpectedSize((int)userRoleList.size());
        for (Triple<Long, String, Long> info : userRoleList) {
            userIds.add(info.getLeft());
            roleNumbers.add(info.getMiddle());
        }
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObjectCollection userDyColl = userHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", (Object)userIds)});
        List existUserIds = userDyColl.stream().map(it -> it.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_role");
        Map<String, String> existRoleMap = roleHelper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", (Object)roleNumbers)}).stream().collect(Collectors.toMap(it -> it.getString("number"), it -> it.getString("id"), (newVal, oldVal) -> newVal));
        HrApiResponse apiResult = new HrApiResponse();
        StringBuilder message = new StringBuilder();
        for (Triple<Long, String, Long> triple : userRoleList) {
            Long l = (Long)triple.getLeft();
            String roleNumber = (String)triple.getMiddle();
            if (!existUserIds.contains(l)) {
                message.append(ResManager.loadKDString((String)"\u7528\u6237%s\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_23", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            if (existRoleMap.containsKey(roleNumber)) continue;
            message.append(ResManager.loadKDString((String)"\u89d2\u8272\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"UserRoleService_26", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (message.length() > 0) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
            return apiResult;
        }
        QFilter deleteFilter = null;
        for (Triple<Long, String, Long> triple : userRoleList) {
            Long userId = (Long)triple.getLeft();
            String roleNumber = (String)triple.getMiddle();
            Long buId = (Long)triple.getRight();
            QFilter curFilter = new QFilter("user", "=", (Object)userId).and("role", "=", (Object)existRoleMap.get(roleNumber));
            if (null != buId) {
                curFilter = curFilter.and(new QFilter("permfile.org", "=", (Object)buId));
            }
            if (null == deleteFilter) {
                deleteFilter = curFilter;
                continue;
            }
            deleteFilter = deleteFilter.or(curFilter);
        }
        try (TXHandle tXHandle = TX.requiresNew();){
            try {
                HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
                DynamicObject[] userRoleRelates = userRoleRelateHelper.loadDynamicObjectArray(new QFilter[]{deleteFilter});
                List<Long> userRoleRelateIds = Arrays.stream(userRoleRelates).map(it -> it.getLong("id")).collect(Collectors.toList());
                ArrayList deletePermLogpParams = Lists.newArrayListWithCapacity((int)16);
                try {
                    for (DynamicObject userRoleRelate : userRoleRelates) {
                        String customenable = userRoleRelate.getString("customenable");
                        String roleId = userRoleRelate.getString("role.id");
                        if (HRStringUtils.equals((String)"1", (String)customenable)) {
                            UserRoleAssignParam userRoleAssignParam = RoleAssignParamBuilder.buildBeforeUserRoleAssignParams(roleId, userRoleRelate.getLong("id"));
                            deletePermLogpParams.add(userRoleAssignParam);
                            continue;
                        }
                        long permFileId = userRoleRelate.getLong("permfile.id");
                        Date validStart = userRoleRelate.getDate("validstart");
                        Date validEnd = userRoleRelate.getDate("validend");
                        UserRoleAssignParam beforeParam = new UserRoleAssignParam(Long.valueOf(permFileId), roleId, validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
                        AssignSource assignSource = beforeParam.getAssignSource();
                        assignSource.setRelateId(Long.valueOf(userRoleRelate.getLong("id")));
                        deletePermLogpParams.add(beforeParam);
                        RoleAssignLogBussinessHelper.setSourceTypeAndSchemeName(beforeParam.getAssignSource(), userRoleRelate.getLong("id"));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("RoleMemberAssignNewPlugin generate UserRoleAssignParam error", (Throwable)exception);
                }
                userRoleRelateHelper.delete((Object[])userRoleRelateIds.toArray(new Long[0]));
                HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
                QFilter[] qFilters = new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIds)};
                list = userRoleHelper.queryOriginalCollection("userrolepf", qFilters).stream().map(it -> it.getString("userrolepf")).collect(Collectors.toList());
                userRoleHelper.deleteByFilter(qFilters);
                HRBaseServiceHelper userRoleDimGrpHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
                QFilter[] grpFilters = new QFilter[]{new QFilter("userrolerelat", "in", userRoleRelateIds)};
                userRoleDimGrpHelper.deleteByFilter(grpFilters);
                HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
                QFilter[] drFilters = new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelateIds)};
                userDataRuleHelper.deleteByFilter(drFilters);
                HRBaseServiceHelper userFieldHelper = new HRBaseServiceHelper("hrcs_userfield");
                userFieldHelper.deleteByFilter(qFilters);
                try {
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    for (int i = 0; i < deletePermLogpParams.size(); ++i) {
                        UserRoleAssignParam deletePermLogpParam = (UserRoleAssignParam)deletePermLogpParams.get(i);
                        AssignSource assignSource = deletePermLogpParam.getAssignSource();
                        assignSource.setObType("userRoleDelete");
                        assignSource.setPageSource("mservice");
                        assignSource.setOtherInfo("batchDeleteUserRole");
                        RoleAssignLogServiceHelper.roleAssignPermLog("userRoleDelete", deletePermLogpParam, null, i, dynamicObjectCollection);
                    }
                    PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
                }
                catch (Exception exception) {
                    LOGGER.error("webservice batchDeleteUserRole error", (Throwable)exception);
                }
            }
            catch (Exception ex) {
                tXHandle.markRollback();
                apiResult.setSuccess(true);
                apiResult.setErrorMessage("delete hrcs_userole failed");
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                LOGGER.info("UserRoleService batchDeleteUserRole erorr: {}", (Object)ex);
                hrApiResponse = apiResult;
                if (tXHandle != null) {
                    if (var14_20 != null) {
                        try {
                            tXHandle.close();
                        }
                        catch (Throwable throwable) {
                            var14_20.addSuppressed(throwable);
                        }
                    } else {
                        tXHandle.close();
                    }
                }
                return hrApiResponse;
            }
        }
        var14_20 = null;
        try (TXHandle tXHandle = TX.requiresNew();){
            try {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                    HRBaseServiceHelper permUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
                    permUserRoleHelper.delete((Object[])list.toArray(new String[0]));
                }
            }
            catch (Exception ex) {
                tXHandle.markRollback();
                apiResult.setSuccess(true);
                apiResult.setErrorMessage("batchDeleteUserRole perm_userole failed");
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                LOGGER.info("UserRoleService batchDeleteUserRole erorr: {}", (Object)ex.getMessage());
                hrApiResponse = apiResult;
                if (tXHandle != null) {
                    if (var14_20 != null) {
                        try {
                            tXHandle.close();
                        }
                        catch (Throwable throwable) {
                            var14_20.addSuppressed(throwable);
                        }
                    } else {
                        tXHandle.close();
                    }
                }
                return hrApiResponse;
            }
        }
        catch (Throwable throwable) {
            var14_20 = throwable;
            throw throwable;
        }
        apiResult.setSuccess(true);
        apiResult.setErrorMessage("delete user role success");
        HRPermCacheMgr.clearAllCache();
        return apiResult;
    }

    public HrApiResponse deleteUserRole(long userId, String roleNumber) {
        HRBaseServiceHelper roleHelper;
        DynamicObject permRoleDy;
        HrApiResponse apiResult = new HrApiResponse();
        StringBuilder message = new StringBuilder();
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject userDy = userHelper.queryOriginalOne("id", (Object)userId);
        if (null == userDy) {
            message.append(ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff1b", (String)"UserRoleService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (null == (permRoleDy = (roleHelper = new HRBaseServiceHelper("perm_role")).queryOriginalOne("id", new QFilter("number", "=", (Object)roleNumber)))) {
            message.append(ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5b58\u5728\uff1b", (String)"UserRoleService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (message.length() > 0) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage(message.deleteCharAt(message.length() - 1).toString());
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
            return apiResult;
        }
        if (null == permRoleDy) {
            apiResult.setSuccess(true);
            apiResult.setErrorMessage("role not exist");
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
            return apiResult;
        }
        String roleId = permRoleDy.getString("id");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                HRBaseServiceHelper permUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
                permUserRoleHelper.deleteByFilter(new QFilter[]{new QFilter("user", "=", (Object)userId).and("role", "=", (Object)roleId)});
            }
            catch (Exception ex) {
                txHandle.markRollback();
                apiResult.setSuccess(true);
                apiResult.setErrorMessage("delete perm_userole failed");
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                LOGGER.info("UserRoleService deleteUserRole erorr: {}", (Object)ex.getMessage());
                HrApiResponse hrApiResponse = apiResult;
                if (txHandle != null) {
                    if (var12_11 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var12_11.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return hrApiResponse;
            }
        }
        txHandle = TX.requiresNew();
        var12_11 = null;
        try {
            try {
                HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
                DynamicObject[] userRoleRelates = userRoleRelateHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("user", "=", (Object)userId).and("role", "=", (Object)roleId)});
                List<Long> userRoleRelateIds = Arrays.stream(userRoleRelates).map(it -> it.getLong("id")).collect(Collectors.toList());
                ArrayList deletePermLogpParams = Lists.newArrayListWithCapacity((int)16);
                try {
                    for (DynamicObject userRoleRelate : userRoleRelates) {
                        String customenable = userRoleRelate.getString("customenable");
                        if (HRStringUtils.equals((String)"1", (String)customenable)) {
                            UserRoleAssignParam userRoleAssignParam = RoleAssignParamBuilder.buildBeforeUserRoleAssignParams(roleId, userRoleRelate.getLong("id"));
                            deletePermLogpParams.add(userRoleAssignParam);
                            continue;
                        }
                        long permFileId = userRoleRelate.getLong("permfile.id");
                        Date validStart = userRoleRelate.getDate("validstart");
                        Date validEnd = userRoleRelate.getDate("validend");
                        UserRoleAssignParam beforeParam = new UserRoleAssignParam(Long.valueOf(permFileId), roleId, validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
                        AssignSource assignSource = beforeParam.getAssignSource();
                        assignSource.setRelateId(Long.valueOf(userRoleRelate.getLong("id")));
                        deletePermLogpParams.add(beforeParam);
                        RoleAssignLogBussinessHelper.setSourceTypeAndSchemeName(beforeParam.getAssignSource(), userRoleRelate.getLong("id"));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("RoleMemberAssignNewPlugin generate UserRoleAssignParam error", (Throwable)exception);
                }
                userRoleRelateHelper.delete((Object[])userRoleRelateIds.toArray(new Long[0]));
                HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
                userRoleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIds)});
                HRBaseServiceHelper userRoleDimGrpHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
                userRoleDimGrpHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelat", "in", userRoleRelateIds)});
                HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
                userDataRuleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelateIds)});
                HRBaseServiceHelper userFieldHelper = new HRBaseServiceHelper("hrcs_userfield");
                userFieldHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIds)});
                try {
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    for (int i = 0; i < deletePermLogpParams.size(); ++i) {
                        UserRoleAssignParam deletePermLogpParam = (UserRoleAssignParam)deletePermLogpParams.get(i);
                        AssignSource assignSource = deletePermLogpParam.getAssignSource();
                        assignSource.setObType("userRoleDelete");
                        assignSource.setPageSource("mservice");
                        assignSource.setOtherInfo("deleteUserRole");
                        RoleAssignLogServiceHelper.roleAssignPermLog("userRoleDelete", deletePermLogpParam, null, i, dynamicObjectCollection);
                    }
                    PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
                }
                catch (Exception exception) {
                    LOGGER.error("webservice deleteUserRole error", (Throwable)exception);
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
                apiResult.setSuccess(true);
                apiResult.setErrorMessage("delete hrcs_userole failed");
                apiResult.setCode(EnumResponseCode.FAIL.getCode());
                LOGGER.info("UserRoleService deleteUserRole erorr: {}", (Object)ex.getMessage());
                HrApiResponse hrApiResponse = apiResult;
                if (txHandle != null) {
                    if (var12_11 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var12_11.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return hrApiResponse;
            }
        }
        catch (Throwable throwable) {
            var12_11 = throwable;
            throw throwable;
        }
        finally {
            if (txHandle != null) {
                if (var12_11 != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable) {
                        var12_11.addSuppressed(throwable);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        apiResult.setSuccess(true);
        apiResult.setErrorMessage("delete user role success");
        HRPermCacheMgr.clearAllCache();
        return apiResult;
    }

    public static Map<String, String> getEntityProps(String entityNumber) {
        Map<String, String> propMap;
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject entityType = entityHelper.queryOriginalOne("modeltype", new QFilter("id", "=", (Object)entityNumber));
        if (entityType == null) {
            LOGGER.info("UserRoleService.getEntityProps : entity '{}' not exists", (Object)entityNumber);
            return new HashMap<String, String>(0);
        }
        boolean isDynamicFormType = EntityCtrlServiceHelper.checkModelType(entityType);
        if (isDynamicFormType) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
            DynamicObject entity = serviceHelper.queryOne("entryentity.propkey,entryentity.propname", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNumber)});
            DynamicObjectCollection collection = entity.getDynamicObjectCollection("entryentity");
            propMap = collection.stream().collect(Collectors.toMap(it -> it.getString("propkey"), it -> it.getString("propname"), (newVal, oldVal) -> newVal));
        } else {
            ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ArrayList<String> noDBProps = new ArrayList<String>(10);
            List<Map<String, String>> propertyMapInEntity = customQuery.parsePropertySub((IDataEntityType)mainEntityType, null, new HashMap<String, Object>(1), "1=1", noDBProps);
            propMap = propertyMapInEntity.stream().collect(Collectors.toMap(it -> (String)it.get("field_id"), it -> (String)it.get("field_name"), (newVal, oldVal) -> oldVal));
        }
        return propMap;
    }

    public static List<Long> getRoleDim(Long funcId, String roleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject[] roles = serviceHelper.queryOriginalArray("dimension.id", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter("bucafunc.id", "=", (Object)funcId)});
        if (Objects.isNull(roles)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(roles).map(it -> it.getLong("dimension.id")).collect(Collectors.toList());
    }

    public static List<String> getPermConfigFields(String entityNum) {
        ArrayList propNumList = Lists.newArrayListWithCapacity((int)10);
        HRBaseServiceHelper permConfigHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject permDy = permConfigHelper.queryOne("entitytype, entryentity, entryentity.propkey", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNum)});
        if (permDy == null) {
            return propNumList;
        }
        DynamicObjectCollection fieldEntry = permDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldDy : fieldEntry) {
            String propNum = fieldDy.getString("propkey");
            propNumList.add(propNum);
        }
        return propNumList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrApiResponse syncPermFiles(List<Long> laborrelStatusIds) {
        HrApiResponse apiResult = new HrApiResponse();
        int updTotalCount = 0;
        int newTotalCount = 0;
        int chkIsNotPassTotalCount = 0;
        int chkUserIdTotalCount = 0;
        int chkEnableTotalCount = 0;
        int chkRelSysUserTotalCount = 0;
        boolean isSuccess = true;
        String errorInfo = "";
        try {
            ArrayList labrelStatusclsList = Lists.newArrayListWithCapacity((int)16);
            ArrayList labreltypeclsList = Lists.newArrayListWithCapacity((int)16);
            HRBaseServiceHelper laborrelStatusHelper = new HRBaseServiceHelper("hbss_laborrelstatus");
            QFilter[] idsFilters = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(laborrelStatusIds)) {
                idsFilters = new QFilter[]{new QFilter("id", "in", laborrelStatusIds)};
            }
            DynamicObject[] laborrelStatuss = laborrelStatusHelper.query("labrelstatuscls,laborreltypecls", idsFilters);
            for (int i = 0; i < laborrelStatuss.length; ++i) {
                List laborreltypeclsId = ((MulBasedataDynamicObjectCollection)laborrelStatuss[i].get("laborreltypecls")).stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
                labreltypeclsList.addAll(laborreltypeclsId);
                labrelStatusclsList.add(laborrelStatuss[i].getLong("labrelstatuscls.id"));
            }
            LOGGER.info("syncPermFiles-laborrelStatusIds:{},labrelStatusclsList:{},labrelTypeclsList:{}", new Object[]{laborrelStatusIds, labrelStatusclsList, labreltypeclsList});
            int totalCount = PermFileSyncServiceHelper.getErmanFilesCount(labreltypeclsList, labrelStatusclsList);
            LOGGER.info("syncPermFiles-totalCount:{}", (Object)totalCount);
            long id = 0L;
            int top = 5000;
            int microReqCount = totalCount / top;
            if (totalCount % top > 0) {
                ++microReqCount;
            }
            int resedueCount = totalCount;
            long startTime = System.currentTimeMillis();
            for (int reqSeq = 1; reqSeq <= microReqCount; ++reqSeq) {
                long reqStartTime = System.currentTimeMillis();
                DynamicObject[] ermanFiles = PermFileSyncServiceHelper.getErmanFiles(labreltypeclsList, labrelStatusclsList, id, top);
                if (null == ermanFiles) break;
                if (ermanFiles.length == 0) {
                    break;
                }
                long reqEndTime = System.currentTimeMillis();
                LOGGER.info("syncPermFiles-req-api:reqSeq={},reqTime(ms)={}", (Object)reqSeq, (Object)(reqEndTime - reqStartTime));
                long handleStartTime = System.currentTimeMillis();
                Map<String, Object> rspMap = PermFileSyncServiceHelper.genPermFiles(ermanFiles);
                long handleEndTime = System.currentTimeMillis();
                LOGGER.info("syncPermFiles-handle-api:reqSeq={},handleTime(ms)={}", (Object)reqSeq, (Object)(handleEndTime - handleStartTime));
                UserRoleService.recordHandleCountLog(reqSeq, rspMap);
                updTotalCount += ((Integer)rspMap.get("updCount")).intValue();
                newTotalCount += ((Integer)rspMap.get("newCount")).intValue();
                chkIsNotPassTotalCount += ((Integer)rspMap.get("chkIsNotPassCount")).intValue();
                chkUserIdTotalCount += ((Integer)rspMap.get("chkUserIdCount")).intValue();
                chkEnableTotalCount += ((Integer)rspMap.get("chkEnableCount")).intValue();
                chkRelSysUserTotalCount += ((Integer)rspMap.get("chkRelSysUserCount")).intValue();
                resedueCount = reqSeq == microReqCount ? 0 : (resedueCount -= top);
                if (ermanFiles.length < top) {
                    break;
                }
                id = ermanFiles[ermanFiles.length - 1].getLong("id");
                LOGGER.info("syncPermFiles-genPermFiles-TotalCount(microReqCount={}):totalCount={},updTotalCount={},newTotalCount={},chkIsNotPassTotalCount={},chkUserIdTotalCount={},chkEnableTotalCount={},chkRelSysUserTotalCount={}", new Object[]{microReqCount, totalCount, updTotalCount, newTotalCount, chkIsNotPassTotalCount, chkUserIdTotalCount, chkEnableTotalCount, chkRelSysUserTotalCount});
                long endTime = System.currentTimeMillis();
                LOGGER.info("SyncPermFilesTask-execute-totalTime(ms):{}", (Object)(endTime - startTime));
            }
        }
        catch (Exception e) {
            isSuccess = false;
            errorInfo = UserRoleService.getStackTrace(e);
            LOGGER.error("syncPermFiles-execute-fail-errorInfo\uff1a", (Throwable)e);
        }
        finally {
            UserRoleService.buildRspResult(apiResult, isSuccess, newTotalCount, updTotalCount, errorInfo);
        }
        return apiResult;
    }

    private static void recordHandleCountLog(int reqSeq, Map<String, Object> rspMap) {
        int updCount = (Integer)rspMap.get("updCount");
        int newCount = (Integer)rspMap.get("newCount");
        int chkIsNotPassCount = (Integer)rspMap.get("chkIsNotPassCount");
        int chkUserIdCount = (Integer)rspMap.get("chkUserIdCount");
        int chkEnableCount = (Integer)rspMap.get("chkEnableCount");
        int chkRelSysUserCount = (Integer)rspMap.get("chkRelSysUserCount");
        LOGGER.info("SyncPermFilesTask-genPermFiles-Count(reqSeq={}):updCount={},newCount={},chkIsNotPassCount={},chkUserIdCount={},chkEnableCount={},chkRelSysUserCount={}", new Object[]{reqSeq, updCount, newCount, chkIsNotPassCount, chkUserIdCount, chkEnableCount, chkRelSysUserCount});
    }

    private static HrApiResponse buildRspResult(HrApiResponse apiResult, boolean isSuccess, int newCount, int updCount, String errorInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        apiResult.setSuccess(true);
        if (isSuccess) {
            apiResult.setErrorMessage("save hrcs_userrole success");
        } else {
            apiResult.setErrorMessage("save hrcs_userrole failed");
            apiResult.setCode(EnumResponseCode.FAIL.getCode());
        }
        result.put("newCount", newCount);
        result.put("updCount", updCount);
        result.put("errorInfo", errorInfo);
        apiResult.setData(result);
        return apiResult;
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static Map<String, Object> copyUserRole(long fromUserId, long fromOrgId, long toUserId, long toOrgId, Date startDate, Date endDate) {
        List<Object> relatIds = Lists.newArrayListWithExpectedSize((int)16);
        boolean isSuccess = true;
        String errorInfo = "";
        try {
            if (Objects.isNull(startDate)) {
                errorInfo = ResManager.loadKDString((String)"\u6709\u6548\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
            }
            if (Objects.isNull(endDate)) {
                errorInfo = ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserRoleService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
            }
            if (Objects.nonNull(startDate) && Objects.nonNull(endDate) && HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                errorInfo = ResManager.loadKDString((String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6709\u6548\u5f00\u59cb\u65e5\u671f", (String)"UserRoleService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
            }
            HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userpermfile");
            DynamicObject fromPermFile = permFileHelper.queryOne("id,permfileenable,user", new QFilter[]{new QFilter("user", "=", (Object)fromUserId).and("permfileenable", "=", (Object)"1").and("org", "=", (Object)fromOrgId)}, "createtime asc");
            if (null == fromPermFile || fromPermFile.getBoolean("user.isforbidden")) {
                errorInfo = ResManager.loadKDString((String)"\u539f\u7528\u6237\u65e0\u53ef\u7528\u7684\u6743\u9650\u6863\u6848", (String)"UserRoleService_16", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
            }
            DynamicObject toPermFile = permFileHelper.queryOne("id,permfileenable,user", new QFilter[]{new QFilter("user", "=", (Object)toUserId).and("permfileenable", "=", (Object)"1").and("org", "=", (Object)toOrgId)}, "createtime asc");
            if (null == toPermFile || toPermFile.getBoolean("user.isforbidden")) {
                errorInfo = ResManager.loadKDString((String)"\u76ee\u6807\u7528\u6237\u65e0\u53ef\u7528\u7684\u6743\u9650\u6863\u6848\u3002", (String)"UserRoleService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
            }
            Long permFileId = fromPermFile.getLong("id");
            Pair<List<String>, List<Pair<String, Long>>> pairUserRoleIdSet = UserRoleService.getSourceUserRoleIdSet(permFileId);
            List sourceUserRoleId = (List)pairUserRoleIdSet.getLeft();
            List customSourceUserRoleId = (List)pairUserRoleIdSet.getRight();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)sourceUserRoleId) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customSourceUserRoleId)) {
                errorInfo = ResManager.loadKDString((String)"\u539f\u7528\u6237\u6ca1\u6709\u53ef\u590d\u5236\u7684\u89d2\u8272", (String)"UserRoleService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
            }
            Long toPermFileId = toPermFile.getLong("id");
            DynamicObject[] oldRelations = UserRoleService.getUserRelatesByPermFields(new Object[]{toPermFileId});
            List oldRelatIds = Arrays.stream(oldRelations).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            RoleMemberAssignSaveService.saveUserPermRole(sourceUserRoleId, Lists.newArrayList((Object[])new Long[]{toPermFileId}), startDate, endDate, "userRoleAdd", "web");
            RoleMemberAssignSaveService.saveUserPermRoleCustom(customSourceUserRoleId, Lists.newArrayList((Object[])new Long[]{toPermFileId}), startDate, endDate, "userRoleAdd", "web");
            DynamicObject[] newRelations = UserRoleService.getUserRelatesByPermFields(new Object[]{toPermFileId});
            relatIds = Arrays.stream(newRelations).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            relatIds.removeAll(oldRelatIds);
        }
        catch (Exception ex) {
            LOGGER.error("copyUserRole error", (Throwable)ex);
            errorInfo = "system error";
            return UserRoleService.buildCopyPermResult(false, errorInfo, (List<Long>)relatIds);
        }
        return UserRoleService.buildCopyPermResult(true, errorInfo, relatIds);
    }

    private static Pair<List<String>, List<Pair<String, Long>>> getSourceUserRoleIdSet(Long permFileId) {
        DynamicObject[] relations = UserRoleService.getUserRelatesByPermFields(new Object[]{permFileId});
        ArrayList sourceUserRoleIdSet = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList customSourceUserRoleIdSet = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject viewRelation : relations) {
            String roleId = viewRelation.getString("role.id");
            Long relationId = (Long)viewRelation.getPkValue();
            String customenable = viewRelation.getString("customenable");
            if ("1".equals(customenable)) {
                customSourceUserRoleIdSet.add(Pair.of((Object)roleId, (Object)relationId));
                continue;
            }
            sourceUserRoleIdSet.add(roleId);
        }
        return Pair.of((Object)sourceUserRoleIdSet, (Object)customSourceUserRoleIdSet);
    }

    private static DynamicObject[] getUserRelatesByPermFields(Object[] permFileIds) {
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        return permFileHelper.query("id,user.id,user.name,user.number,permfile.org.id,permfile.org.name,permfile.org.number,role.id,role.number,role.name,role.enable,customenable,validstart,validend,creator", new QFilter[]{new QFilter("permfile.id", "in", (Object)permFileIds), new QFilter("role.enable", "=", (Object)"1")}, "role.number,user.name");
    }

    private static Map<String, Object> buildCopyPermResult(boolean isSuccess, String errorInfo, List<Long> relatIds) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (isSuccess) {
            result.put("code", "200");
            result.put("data", relatIds);
        } else {
            result.put("msg", errorInfo);
            result.put("data", relatIds);
            result.put("code", EnumResponseCode.FAIL.getCode());
        }
        return result;
    }

    public static Map<String, Object> getUserListByDims(String appId, String entityNumber, String roleNumber, Map<String, List<Object>> dimValList) {
        DynamicObject sysRoleDyn = UserAdminOrgService.getSysRoleDyna(roleNumber);
        HashMap resultData = Maps.newHashMapWithExpectedSize((int)2);
        if (sysRoleDyn == null) {
            String msg = String.format("role number:%s not exist in bos or disabled.", roleNumber);
            resultData.put("code", EnumResponseCode.FAIL.getCode());
            resultData.put("msg", msg);
            return resultData;
        }
        String roleId = sysRoleDyn.getString("id");
        DynamicObject hmpRoleDyn = UserAdminOrgService.getHmpRoleDyna(roleId);
        if (hmpRoleDyn == null) {
            String msg = String.format("role number:%s not exist in hmp.", roleNumber);
            resultData.put("code", EnumResponseCode.FAIL.getCode());
            resultData.put("msg", msg);
            return resultData;
        }
        List<Object> hasPermUserIdList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection relatDynaColl = UserAdminOrgService.getUserRoleRelatDynaColl(roleId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)relatDynaColl)) {
            LOGGER.info("getUserListByAdminOrg userRoleRelat is null. return null list.");
            resultData.put("userIds", hasPermUserIdList);
            resultData.put("code", EnumResponseCode.SUCCESS.getCode());
            return resultData;
        }
        if (dimValList == null || dimValList.size() == 0) {
            hasPermUserIdList = relatDynaColl.stream().map(it -> it.getLong("user.id")).collect(Collectors.toList());
            resultData.put("userIds", hasPermUserIdList);
            resultData.put("code", EnumResponseCode.SUCCESS.getCode());
            return resultData;
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber);
        HashSet roleIds = Sets.newHashSet((Object[])new String[]{roleId});
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, entityNumber, funcId, null);
        List<RoleRuleInfo> roleRuleInfos = roleDimPropRelat.get(roleId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(roleRuleInfos)) {
            LOGGER.info("getUserListByDims role has no dims, return null list.");
            resultData.put("msg", "role has no dim, please config");
            resultData.put("code", EnumResponseCode.FAIL.getCode());
            return resultData;
        }
        Set<Long> dimIds = HRPermDimServiceHelper.collectEntityDimIds(roleDimPropRelat);
        Map<String, List<DimValueGroup>> roleDimGroupMap = DataRangeServiceHelperWithCache.getRoleDimValGroupWithCache(roleIds, funcId, dimIds);
        Set<Long> relationIds = relatDynaColl.stream().map(dyna -> dyna.getLong("id")).collect(Collectors.toSet());
        Map<Long, List<DimValueGroup>> userRoleDimGroupMap = DataRangeServiceHelperWithCache.getUserRoleDimValGroupWithCache(relationIds, funcId, dimIds);
        LinkedHashSet hasPermUserIdSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        List<RoleRuleInfo> otDim = UserRoleService.getOTDim(roleRuleInfos);
        List<Long> allAdminOrgLst = UserRoleService.getOrgIdList(otDim, roleDimGroupMap.get(roleId), userRoleDimGroupMap);
        UserRoleService.collectParamOrgDim(allAdminOrgLst, dimValList);
        Map<Long, String> adminOrgLongNumberMap = UserAdminOrgService.getAdminOrgStructLongNumber(allAdminOrgLst);
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        boolean isRoleContainDynaCond = DynaCondConverter.hasDynaCondInGroup(roleDimGroupMap);
        boolean isContainRole = false;
        if (!isRoleContainDynaCond) {
            isContainRole = UserRoleService.isContainRoleDimVal(dimValList, roleRuleInfos, roleDimGroupMap, adminOrgLongNumberMap, roleId);
        }
        Map<Long, String> dimPropType = DimServiceWithCache.calCheckPropTypeWithCache(dimIds);
        String isIntersectionStr = hmpRoleDyn.getString("isintersection");
        boolean isIntersection = HRStringUtils.equals((String)isIntersectionStr, (String)"1") || HRStringUtils.equals((String)isIntersectionStr, (String)"2");
        for (DynamicObject relatDyna : relatDynaColl) {
            List<DimValueGroup> singleRelatDimGroup;
            Map<Object, Object> singleRelatDimGroupMap;
            Map<String, List<DimValueGroup>> roleDimGroupMapUser;
            boolean isCustom = relatDyna.getBoolean("customenable");
            Long relatId = relatDyna.getLong("id");
            Long userId = relatDyna.getLong("user.id");
            if (isCustom && isIntersection) {
                if (isRoleContainDynaCond) {
                    roleDimGroupMapUser = DynaCondConverter.groupDynaCondConvertClone(userId, roleDimGroupMap, dimPropType, dynaCondMap);
                    UserAdminOrgService.reAddLongNumber(adminOrgLongNumberMap, UserRoleService.getOrgIdList(otDim, roleDimGroupMap.get(roleId), null));
                    isContainRole = UserRoleService.isContainRoleDimVal(dimValList, roleRuleInfos, roleDimGroupMapUser, adminOrgLongNumberMap, roleId);
                }
                singleRelatDimGroupMap = Maps.newHashMapWithExpectedSize((int)1);
                singleRelatDimGroup = userRoleDimGroupMap.get(relatId);
                if (!Objects.isNull(singleRelatDimGroup)) {
                    singleRelatDimGroupMap.put(relatId, userRoleDimGroupMap.get(relatId));
                    singleRelatDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, singleRelatDimGroupMap, dimPropType, dynaCondMap);
                }
                UserAdminOrgService.reAddLongNumber(adminOrgLongNumberMap, UserRoleService.getOrgIdList(otDim, null, singleRelatDimGroupMap));
                if (!UserRoleService.isContainUserDimVal(dimValList, roleRuleInfos, singleRelatDimGroupMap, adminOrgLongNumberMap, relatId) || !isContainRole) continue;
                hasPermUserIdSet.add(userId);
                continue;
            }
            if (isCustom && !isIntersection) {
                singleRelatDimGroupMap = Maps.newHashMapWithExpectedSize((int)1);
                singleRelatDimGroup = userRoleDimGroupMap.get(relatId);
                if (!Objects.isNull(singleRelatDimGroup)) {
                    singleRelatDimGroupMap.put(relatId, userRoleDimGroupMap.get(relatId));
                    singleRelatDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, singleRelatDimGroupMap, dimPropType, dynaCondMap);
                }
                UserAdminOrgService.reAddLongNumber(adminOrgLongNumberMap, UserRoleService.getOrgIdList(otDim, null, singleRelatDimGroupMap));
                if (!UserRoleService.isContainUserDimVal(dimValList, roleRuleInfos, singleRelatDimGroupMap, adminOrgLongNumberMap, relatId)) continue;
                hasPermUserIdSet.add(relatDyna.getLong("user.id"));
                continue;
            }
            if (isRoleContainDynaCond) {
                roleDimGroupMapUser = DynaCondConverter.groupDynaCondConvertClone(userId, roleDimGroupMap, dimPropType, dynaCondMap);
                UserAdminOrgService.reAddLongNumber(adminOrgLongNumberMap, UserRoleService.getOrgIdList(otDim, roleDimGroupMap.get(roleId), null));
                isContainRole = UserRoleService.isContainRoleDimVal(dimValList, roleRuleInfos, roleDimGroupMapUser, adminOrgLongNumberMap, roleId);
            }
            if (!isContainRole) continue;
            hasPermUserIdSet.add(relatDyna.getLong("user.id"));
        }
        hasPermUserIdList.addAll(hasPermUserIdSet);
        resultData.put("userIds", hasPermUserIdList);
        resultData.put("code", EnumResponseCode.SUCCESS.getCode());
        return resultData;
    }

    private static void collectParamOrgDim(List<Long> allAdminOrgLst, Map<String, List<Object>> dimValMap) {
        HRBaseServiceHelper dimensionHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dimensions = dimensionHelper.query("id,number,datasource,showtype", new QFilter[]{new QFilter("number", "in", dimValMap.keySet()), new QFilter("datasource", "=", (Object)DIM_TYPE_ORG_TEAM)});
        if (dimensions != null && dimensions.length > 0) {
            Arrays.stream(dimensions).forEach(it -> {
                List orgIdLst = (List)dimValMap.get(it.getString("number"));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgIdLst)) {
                    allAdminOrgLst.addAll(orgIdLst.stream().map(itOrg -> Long.parseLong(String.valueOf(itOrg))).collect(Collectors.toList()));
                }
            });
        }
    }

    private static List<Long> getOrgIdList(List<RoleRuleInfo> otDim, List<DimValueGroup> roleDimValueGroups, Map<Long, List<DimValueGroup>> userRoleDimGroupMap) {
        ArrayList allAdminOrgLst = Lists.newArrayListWithExpectedSize((int)16);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(roleDimValueGroups)) {
            for (DimValueGroup dimValueGroup : roleDimValueGroups) {
                UserRoleService.initDimValueGroup(otDim, dimValueGroup, allAdminOrgLst);
            }
        }
        if (userRoleDimGroupMap != null) {
            for (Map.Entry entry : userRoleDimGroupMap.entrySet()) {
                for (DimValueGroup dimValueGroup : (List)entry.getValue()) {
                    UserRoleService.initDimValueGroup(otDim, dimValueGroup, allAdminOrgLst);
                }
            }
        }
        return allAdminOrgLst;
    }

    private static void initDimValueGroup(List<RoleRuleInfo> otDim, DimValueGroup dimValueGroup, List<Long> allAdminOrgLst) {
        for (Map.Entry entryDim : dimValueGroup.getDimValuesMap().entrySet()) {
            if (!otDim.stream().anyMatch(it -> it.getDimensionId().compareTo((Long)entryDim.getKey()) == 0)) continue;
            allAdminOrgLst.addAll(((List)entryDim.getValue()).stream().filter(el -> HRStringUtils.isNotEmpty((String)el.getDimVal()) && el.getStructProjectId() != null && el.getStructProjectId().equals(1010L)).map(ite -> Long.parseLong(ite.getDimVal())).collect(Collectors.toList()));
        }
    }

    private static boolean isContainRoleDimVal(Map<String, List<Object>> dimValListMap, List<RoleRuleInfo> roleRuleInfos, Map<String, List<DimValueGroup>> roleDimGroupMap, Map<Long, String> adminOrgLongNumberMap, String roleId) {
        List<DimValueGroup> dimValueGroups = roleDimGroupMap.get(roleId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dimValueGroups)) {
            return true;
        }
        return UserRoleService.checkDimVal(dimValListMap, roleRuleInfos, dimValueGroups, adminOrgLongNumberMap);
    }

    private static boolean isContainUserDimVal(Map<String, List<Object>> dimValListMap, List<RoleRuleInfo> roleRuleInfos, Map<Long, List<DimValueGroup>> userRoleDimGroupMap, Map<Long, String> adminOrgLongNumberMap, Long relatId) {
        List<DimValueGroup> dimValueGroups = userRoleDimGroupMap.get(relatId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dimValueGroups)) {
            return false;
        }
        return UserRoleService.checkDimVal(dimValListMap, roleRuleInfos, dimValueGroups, adminOrgLongNumberMap);
    }

    private static List<RoleRuleInfo> getOTDim(List<RoleRuleInfo> roleRuleInfos) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (RoleRuleInfo roleRuleInfo : roleRuleInfos) {
            String dimensionType = roleRuleInfo.getDimensionType();
            if (!HRStringUtils.equals((String)dimensionType, (String)DIM_TYPE_ORG_TEAM)) continue;
            result.add(roleRuleInfo);
        }
        return result;
    }

    private static boolean checkDimVal(Map<String, List<Object>> dimValListMap, List<RoleRuleInfo> roleRuleInfos, List<DimValueGroup> dimValueGroups, Map<Long, String> adminOrgLongNumberMap) {
        for (DimValueGroup dimValueGroup : dimValueGroups) {
            ArrayList dimLst = Lists.newArrayListWithExpectedSize((int)dimValueGroup.getDimValuesMap().size());
            ArrayList containResult = Lists.newArrayListWithExpectedSize((int)dimValueGroup.getDimValuesMap().size());
            for (Map.Entry entry : dimValueGroup.getDimValuesMap().entrySet()) {
                Optional<RoleRuleInfo> any = roleRuleInfos.stream().filter(it -> it.getDimensionId().equals(entry.getKey())).findAny();
                if (!any.isPresent() || !dimValListMap.containsKey(any.get().getDimensionNumber())) continue;
                RoleRuleInfo roleRuleInfo = any.get();
                dimLst.add(roleRuleInfo.getDimensionId());
                boolean isContain = UserRoleService.dealSingleDimVal(roleRuleInfo, dimValListMap.get(roleRuleInfo.getDimensionNumber()), (List)entry.getValue(), adminOrgLongNumberMap);
                containResult.add(isContain);
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dimLst) || !org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)containResult) || !containResult.stream().allMatch(it -> it)) continue;
            return true;
        }
        return false;
    }

    private static boolean dealSingleDimVal(RoleRuleInfo roleRuleInfo, List<Object> paramValList, List<DimValue> dbDimValue, Map<Long, String> adminOrgLongNumberMap) {
        if (HRStringUtils.equals((String)roleRuleInfo.getDimensionType(), (String)DIM_TYPE_ORG_TEAM)) {
            for (Object orgId : paramValList) {
                if (!UserAdminOrgService.isContainAdminOrg(adminOrgLongNumberMap, dbDimValue, Long.parseLong(String.valueOf(orgId)))) continue;
                return true;
            }
        } else if (HRStringUtils.equals((String)roleRuleInfo.getDimensionType(), (String)DIM_TYPE_HRUB)) {
            Set allocatedOrgIds = dbDimValue.stream().map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
            List containsSubIds = dbDimValue.stream().filter(DimValue::isContainsSub).map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(containsSubIds)) {
                String viewId = roleRuleInfo.getOrgFuncId().toString();
                List subList = OrgServiceHelper.getAllSubordinateOrgs((String)viewId, containsSubIds, (boolean)true);
                allocatedOrgIds.addAll(subList);
            }
            for (Object bu : paramValList) {
                if (!allocatedOrgIds.contains(Long.parseLong(String.valueOf(bu)))) continue;
                return true;
            }
        } else {
            for (Object target : paramValList) {
                if (!dbDimValue.stream().anyMatch(DimValue::isAll) && !dbDimValue.stream().anyMatch(it -> it.getDimVal().equals(String.valueOf(target)))) continue;
                return true;
            }
        }
        return false;
    }
}

