/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class DimService {
    public static Map<Long, String> calCheckPropType(Set<Long> dimIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dimDynoArr = helper.queryOriginalArray("id,datasource,entitytype", new QFilter[]{new QFilter("id", "in", dimIds)});
        HashMap propTypeMap = Maps.newHashMapWithExpectedSize((int)dimDynoArr.length);
        for (DynamicObject dimDyno : dimDynoArr) {
            Long dimId = dimDyno.getLong("id");
            String dataSource = dimDyno.getString("datasource");
            if (HRStringUtils.equalsIgnoreCase((String)"enum", (String)dataSource)) {
                propTypeMap.put(dimId, "string");
                continue;
            }
            if (HRStringUtils.equalsIgnoreCase((String)"hrbu", (String)dataSource)) {
                propTypeMap.put(dimId, "long");
                continue;
            }
            String entityNumber = dimDyno.getString("entitytype");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ISimpleProperty property = mainEntityType.getPrimaryKey();
            if (property instanceof LongProp || property instanceof IntegerProp) {
                propTypeMap.put(dimId, "long");
                continue;
            }
            propTypeMap.put(dimId, "string");
        }
        return propTypeMap;
    }

    public static Long getDimIdByNumber(String dimNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject dimDyno = helper.queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)dimNumber)});
        if (dimDyno != null) {
            return dimDyno.getLong("id");
        }
        return 0L;
    }

    public static String getDimEntityTypeById(Long dimId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject dimDyno = helper.queryOne("entitytype.number", new QFilter[]{new QFilter("id", "=", (Object)dimId)});
        if (dimDyno != null) {
            return dimDyno.getString("entitytype.number");
        }
        return null;
    }
}

