/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import java.util.List;
import java.util.Map;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.cache.HREntityIgnorePermServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DataRuleScriptServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DynamicFormHelper;
import kd.hr.hrcs.common.model.UserRoleInfo;
import kd.hr.hrcs.common.utils.DataRuleScriptUtil;

public class MatchDataRuleByScriptService {
    private static final Log LOGGER = LogFactory.getLog(MatchDataRuleByScriptService.class);

    public static String getDataRuleScript(Long userId, String appId, String entityNumber, String permItemId, Map<String, Object> customParam) {
        String tableNameInDB = EntityMetadataCache.getDataEntityType((String)entityNumber).getAlias();
        if (HRStringUtils.isEmpty((String)tableNameInDB)) {
            LOGGER.info("HRDataPermService getDataRuleScript tableNameInDB is null,return null. entity={},appId={}", (Object)entityNumber, (Object)appId);
            return null;
        }
        if (DynamicFormHelper.isDynamicFormOrReport(entityNumber)) {
            LOGGER.info("HRDataPermService getDataRuleScript isDynamicFormOrReport return null. entity={},appId={}", (Object)entityNumber, (Object)appId);
            return null;
        }
        if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityDataRuleWithCache(entityNumber)) {
            LOGGER.info("HRDataPermService getDataRuleScript ignore entity={},appId={}", (Object)entityNumber, (Object)appId);
            return null;
        }
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNumber, permItemId);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService getDataRuleScript roleList is empty,return all.");
            return null;
        }
        Map<Long, String> ruleScriptMap = DataRuleScriptServiceHelper.assembleUserEntryDataRuleScript(appId, entityNumber, permItemId, userRoleInfoList);
        Map<Long, String> dimScriptMap = DataRuleScriptServiceHelper.assembleUserDimValueScript(userId, appId, entityNumber, userRoleInfoList, customParam);
        String resultScript = null;
        for (UserRoleInfo roleInfo : userRoleInfoList) {
            String dimScript;
            Long relatId = roleInfo.getRelatId();
            String ruleScript = CollectionUtils.isEmpty(ruleScriptMap) ? null : ruleScriptMap.get(relatId);
            String singleRelatScript = DataRuleScriptUtil.scriptAnd((String)ruleScript, (String)(dimScript = CollectionUtils.isEmpty(dimScriptMap) ? null : dimScriptMap.get(relatId)));
            if (singleRelatScript == null) {
                LOGGER.info("HRDataPermService getDataRuleScript singleRelatScript is empty,roleId:{},return all.", (Object)roleInfo.getRoleId());
                return null;
            }
            if (HRStringUtils.isEmpty(resultScript)) {
                resultScript = singleRelatScript;
                continue;
            }
            resultScript = DataRuleScriptUtil.scriptOr((String)resultScript, (String)singleRelatScript);
        }
        return resultScript;
    }
}

