/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.service.perm.check.handler.DimQFilterHandlerFactory;
import kd.hr.hrcs.bussiness.service.perm.check.handler.IDimQFilterHandler;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DynamicFormHelper;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRPermDimServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.OrgTeamStructProjectServiceHelper;
import kd.hr.hrcs.common.constants.DimRange;
import kd.hr.hrcs.common.constants.MethodSource;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.DimValueGroup;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;
import kd.hr.hrcs.common.util.LoggerStrUtil;

public class PermDimDataCheckService {
    private static final Log LOG = LogFactory.getLog(PermDimDataCheckService.class);

    public static Map<Long, QFilter> assembleUserDimValueQFilter(Long userId, String appId, String entityNum, List<UserRoleInfo> userRoleInfoList, Map<String, Object> customParam) {
        List needCheckDimIds;
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, entityNum, funcId, null);
        if (CollectionUtils.isEmpty(roleDimPropRelat)) {
            LOG.info("HRDataPermService assembleUserDimValueQFilter roleDimPropRelat is empty,return empty Map.");
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, MethodSource.METHOD_LIST.getCode());
        List needDimCheckProps = (List)customParam.get("hr_dataperm_needDimCheckProps");
        if (needDimCheckProps != null) {
            PermDimDataCheckService.filterNeedDimCheckProps(roleDimPropRelat, needDimCheckProps);
        }
        if ((needCheckDimIds = (List)customParam.get("hr_dataperm_needCheckDims")) != null) {
            PermDimDataCheckService.filterNeedCheckDims(roleDimPropRelat, needCheckDimIds);
        }
        OrgTeamStructProjectServiceHelper.setStructProjectConfig(entityNum, roleDimPropRelat, customParam);
        return PermDimDataCheckService.assembleUserDimValueQFilter(userId, appId, entityNum, userRoleInfoList, roleDimPropRelat, customParam);
    }

    private static void filterNeedDimCheckProps(Map<String, List<RoleRuleInfo>> roleDimPropRelat, List<String> needDimCheckProps) {
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            entry.getValue().removeIf(ruleInfo -> !PermDimDataCheckService.isNeedDimProp(ruleInfo, needDimCheckProps));
        }
    }

    private static void filterNeedCheckDims(Map<String, List<RoleRuleInfo>> roleDimPropRelat, List<Long> needCheckDimIds) {
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            entry.getValue().removeIf(ruleInfo -> !PermDimDataCheckService.isNeedCheckDim(ruleInfo, needCheckDimIds));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean isNeedDimProp(RoleRuleInfo ruleInfo, List<String> needDimCheckProps) {
        String permPropKey = ruleInfo.getPropkey();
        for (String needProp : needDimCheckProps) {
            String[] permPropKeyArr;
            if (HRStringUtils.equals((String)needProp, (String)permPropKey)) {
                return true;
            }
            if (!permPropKey.contains(".") || !HRStringUtils.equals((String)needProp, (String)(permPropKeyArr = permPropKey.split("\\."))[0])) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean isNeedCheckDim(RoleRuleInfo ruleInfo, List<Long> needCheckDimIds) {
        Long dimensionId = ruleInfo.getDimensionId();
        for (Long needDimId : needCheckDimIds) {
            if (!Objects.equals(dimensionId, needDimId)) continue;
            return true;
        }
        return false;
    }

    public static void filterDimAuthRange(Map<String, List<RoleRuleInfo>> roleDimPropRelat, String methodSource) {
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            PermDimDataCheckService.initPropFullKey(entry.getValue());
            entry.getValue().removeIf(next -> !PermDimDataCheckService.hasAuthRang(next, methodSource));
        }
    }

    private static void initPropFullKey(List<RoleRuleInfo> userRoleInfoList) {
        for (RoleRuleInfo roleRuleInfo : userRoleInfoList) {
            roleRuleInfo.setPropFullKey(roleRuleInfo.getPropkey());
        }
    }

    private static boolean hasAuthRang(RoleRuleInfo ruleInfo, String methodSource) {
        return DimRange.RANGE_ALL.getCode().equals(ruleInfo.getAuthRange()) || methodSource.equals(ruleInfo.getAuthRange());
    }

    public static Map<Long, QFilter> assembleUserDimValueQFilter(Long userId, String appId, String entityNum, List<UserRoleInfo> userRoleInfoList, Map<String, List<RoleRuleInfo>> roleDimPropRelat, Map<String, Object> customParam) {
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Set<Long> relationIds = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Set<Long> dimIds = HRPermDimServiceHelper.collectEntityDimIds(roleDimPropRelat);
        Map<Long, String> dimPropType = DimServiceWithCache.calCheckPropTypeWithCache(dimIds);
        Map<String, List<DimValueGroup>> roleDimGroupMap = DataRangeServiceHelperWithCache.getRoleDimValGroupWithCache(roleIds, funcId, dimIds);
        Map<Long, List<DimValueGroup>> userRoleDimGroupMap = DataRangeServiceHelperWithCache.getUserRoleDimValGroupWithCache(relationIds, funcId, dimIds);
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        roleDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, roleDimGroupMap, dimPropType, dynaCondMap);
        userRoleDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, userRoleDimGroupMap, dimPropType, dynaCondMap);
        HashMap ruleQfilterMap = Maps.newHashMapWithExpectedSize((int)userRoleInfoList.size());
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            Long relatId = userRoleInfo.getRelatId();
            String roleId = userRoleInfo.getRoleId();
            QFilter singleRelateFilter = PermDimDataCheckService.assembleSingleRelatDimValueQFilter(userRoleInfo, roleDimPropRelat.get(roleId), roleDimGroupMap.get(roleId), userRoleDimGroupMap.get(relatId), dimPropType, customParam);
            ruleQfilterMap.put(userRoleInfo.getRelatId(), singleRelateFilter);
        }
        LOG.info("HRDataPermService assembleUserDimValueQFilter resultQFilterMap:{}", (Object)LoggerStrUtil.mapToString((Map)ruleQfilterMap));
        return ruleQfilterMap;
    }

    public static Map<Long, QFilter> assembleUserF7DimValueQFilter(Long userId, String appId, String parentEntityNumber, String propKey, String propFullKey, List<UserRoleInfo> userRoleInfoList, String permItemId, Map<String, Object> customParam) {
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            return null;
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, parentEntityNumber);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, parentEntityNumber, funcId, propKey);
        PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, MethodSource.METHOD_F7.getCode());
        OrgTeamStructProjectServiceHelper.setStructProjectConfig(parentEntityNumber, roleDimPropRelat, customParam);
        PermDimDataCheckService.initDimProp4F7(roleDimPropRelat, propFullKey, permItemId);
        return PermDimDataCheckService.assembleUserDimValueQFilter(userId, appId, parentEntityNumber, userRoleInfoList, roleDimPropRelat, customParam);
    }

    private static void initDimProp4F7(Map<String, List<RoleRuleInfo>> roleDimPropRelat, String fullPropKey, String permItemId) {
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            for (RoleRuleInfo roleRuleInfo : entry.getValue()) {
                PermDimDataCheckService.setPropRuleKey(roleRuleInfo, fullPropKey, permItemId);
            }
        }
    }

    private static void setPropRuleKey(RoleRuleInfo roleRuleInfo, String fullPropKey, String permItemId) {
        String dimPropKey = roleRuleInfo.getPropkey();
        String[] split = dimPropKey.split(fullPropKey);
        if (HRStringUtils.equals((String)dimPropKey, (String)fullPropKey)) {
            roleRuleInfo.setPropkey("id");
            return;
        }
        if (split.length == 0) {
            roleRuleInfo.setPropkey("id");
        } else if (split.length == 2) {
            String oneKey = split[1];
            if (!oneKey.contains(".")) {
                roleRuleInfo.setPropkey("id");
            } else {
                String[] suffix = oneKey.split("\\.");
                roleRuleInfo.setPropkey(suffix[1]);
            }
        }
    }

    private static QFilter assembleSingleRelatDimValueQFilter(UserRoleInfo userRoleInfo, List<RoleRuleInfo> propRelatInfoList, List<DimValueGroup> roleDimGroupList, List<DimValueGroup> userRoleDimGroupList, Map<Long, String> dimPropType, Map<String, Object> customParam) {
        if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
            QFilter roleQFilter = PermDimDataCheckService.assembleSingleRelatRoleQFilter(propRelatInfoList, roleDimGroupList, dimPropType, customParam);
            QFilter userQFilter = PermDimDataCheckService.assembleSingleRelatRoleQFilter(propRelatInfoList, userRoleDimGroupList, dimPropType, customParam);
            return HRPermCommonUtil.qFilterAnd((QFilter)roleQFilter, (QFilter)userQFilter);
        }
        if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
            return PermDimDataCheckService.assembleSingleRelatRoleQFilter(propRelatInfoList, userRoleDimGroupList, dimPropType, customParam);
        }
        return PermDimDataCheckService.assembleSingleRelatRoleQFilter(propRelatInfoList, roleDimGroupList, dimPropType, customParam);
    }

    private static QFilter assembleSingleRelatRoleQFilter(List<RoleRuleInfo> propRelatInfoList, List<DimValueGroup> roleDimGroupList, Map<Long, String> dimPropType, Map<String, Object> customParam) {
        QFilter resultQFilter = null;
        if (CollectionUtils.isEmpty(roleDimGroupList)) {
            LOG.info("HRDataPermService assembleSingleRelatRoleQFilter() roleDimGroupList is empty.");
            return null;
        }
        if (CollectionUtils.isEmpty(propRelatInfoList)) {
            LOG.info("HRDataPermService assembleSingleRelatRoleQFilter() propRelatInfoList is empty. return null");
            return null;
        }
        boolean isDynaForm = DynamicFormHelper.isDynamicFormOrReport(propRelatInfoList.get(0).getEntityNum());
        for (DimValueGroup dimValueGroup : roleDimGroupList) {
            QFilter groupFilter = null;
            for (RoleRuleInfo propRelatInfo : propRelatInfoList) {
                Long dimId = propRelatInfo.getDimensionId();
                List dimValues = (List)dimValueGroup.getDimValuesMap().get(dimId);
                String propType = dimPropType.get(dimId);
                IDimQFilterHandler dimQFilterHandler = DimQFilterHandlerFactory.getHandler(propRelatInfo.getDimensionNumber(), propRelatInfo.getDimensionType(), propRelatInfo.getDimensionShowType());
                String filterProp = propRelatInfo.getPropkey();
                String targetEntityNumber = propRelatInfo.getEntityNum();
                String permMserviceSource = (String)customParam.get("permMserviceSourceKey");
                if (HRStringUtils.equals((String)permMserviceSource, (String)"f7")) {
                    targetEntityNumber = (String)customParam.get("propEntityNumberKey");
                }
                if (HRStringUtils.isEmpty((String)targetEntityNumber)) {
                    targetEntityNumber = propRelatInfo.getEntityNum();
                }
                LOG.info("HRDataPermService assembleSingleRelatRoleQFilter() isDynaForm:{},prop key convert from :{} to :{}", new Object[]{isDynaForm, propRelatInfo.getPropkey(), filterProp});
                QFilter qFilter = dimQFilterHandler.buildDimValueQFilter(propRelatInfo.getEntityNum(), filterProp, propType, dimValues, propRelatInfo, customParam);
                if (qFilter == null) continue;
                groupFilter = HRPermCommonUtil.qFilterAnd(groupFilter, (QFilter)qFilter);
            }
            if (groupFilter == null) {
                LOG.info("assembleSingleRelatRoleQFilter() groupFilter is null,return null.");
                return null;
            }
            resultQFilter = HRPermCommonUtil.qFilterOr(resultQFilter, groupFilter);
        }
        LOG.info("assembleSingleRelatRoleQFilter() resultQFilter:{}", (Object)LoggerStrUtil.qFilterToString(resultQFilter));
        return resultQFilter;
    }
}

