/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class HRPersonInfoService {
    private static final Log LOGGER = LogFactory.getLog(HRPersonInfoService.class);

    public static Long getPersonIdByUserId(Long userId) {
        long start = System.currentTimeMillis();
        Map userInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
        LOGGER.info("HRDataPermService HRPersonInfoService.getPersonIdByUserId result,cost_mills:{},param:userId={},return:{}", new Object[]{System.currentTimeMillis() - start, userId, userInfoMap});
        if (userInfoMap == null) {
            LOGGER.error("HRDataPermService HRPersonInfoService.getPersonIdByUserId return null.userId:{} ", (Object)userId);
            return null;
        }
        if (!Objects.equals(Boolean.TRUE, userInfoMap.getOrDefault("success", Boolean.FALSE))) {
            LOGGER.error("HRDataPermService HRPersonInfoService.getPersonIdByUserId return success is false.userId:{} ", (Object)userId);
            return null;
        }
        Map userInfoData = (Map)userInfoMap.get("data");
        return (Long)userInfoData.get("person");
    }

    public static List<Long> getMyDeptsByPersonId(Long personId) {
        if (personId == null || Objects.equals(personId, 0L)) {
            LOGGER.error("HRDataPermService HRPersonInfoService.getMyDeptsByPersonId personId is null or 0L");
            return null;
        }
        long start = System.currentTimeMillis();
        List depts = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonOrgIds", (Object[])new Object[]{personId});
        LOGGER.info("HRDataPermService HRPersonInfoService.getMyDeptsByPersonId result,cost_mills:{},param:personId={},return:{}", new Object[]{System.currentTimeMillis() - start, personId, depts});
        return depts;
    }

    public static List<Long> getMyCompanysByPersonId(Long personId) {
        if (personId == null || Objects.equals(personId, 0L)) {
            LOGGER.error("HRDataPermService HRPersonInfoService.getMyCompanysByPersonId personId is null or 0L");
            return null;
        }
        long start = System.currentTimeMillis();
        List posInfoList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{personId});
        LOGGER.info("HRDataPermService HRPersonInfoService.getMyCompanysByPersonId result,cost_mills:{},param:personId={},return:{}", new Object[]{System.currentTimeMillis() - start, personId, posInfoList});
        if (CollectionUtils.isEmpty((Collection)posInfoList)) {
            LOGGER.error("HRDataPermService HRPersonInfoService.getMyCompanysByPersonId invoke return null");
            return null;
        }
        HashSet companySet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map posInfoMap : posInfoList) {
            companySet.add((Long)posInfoMap.get("company_id"));
        }
        return Lists.newArrayList((Iterable)companySet);
    }
}

