/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.handler.IDimQFilterHandler;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DynamicFormHelper;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;

public abstract class AbstractDimQFilterHandler
implements IDimQFilterHandler {
    protected static final String NOT_SUPPORT_FILTER_PROPERTY = "dataPermTag_noSupportFilterProperty";
    private static final Log LOGGER = LogFactory.getLog(AbstractDimQFilterHandler.class);

    @Override
    public abstract QFilter buildDimValueQFilter(String var1, String var2, String var3, List<DimValue> var4, RoleRuleInfo var5, Map<String, Object> var6);

    protected boolean isContainAll(List<DimValue> dimValues) {
        if (CollectionUtils.isEmpty(dimValues)) {
            return true;
        }
        for (DimValue dimValue : dimValues) {
            if (!dimValue.isAll()) continue;
            return true;
        }
        return false;
    }

    protected Set<String> dimValueToStringList(List<DimValue> dimValues) {
        return dimValues.stream().filter(dimValue -> dimValue.isAll() || !HRStringUtils.isEmpty((String)dimValue.getDimVal())).map(DimValue::getDimVal).collect(Collectors.toSet());
    }

    @ExcludeFromJacocoGeneratedReport
    protected Set<Long> convertBoIdToFidsLong(String dimEntityNumber, Set<Long> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return boIds;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper(dimEntityNumber);
        QFilter[] hisQFilterArr = this.buildHisVersionQFilter(dimEntityNumber, boIds);
        DynamicObjectCollection idColl = adminOrgHelper.queryOriginalCollection("id", hisQFilterArr);
        return idColl.stream().map(dyno -> dyno.getLong("id")).collect(Collectors.toSet());
    }

    @ExcludeFromJacocoGeneratedReport
    protected Set<String> convertBoIdToFidsString(String dimEntityNumber, Set<String> boIds) {
        if (CollectionUtils.isEmpty(boIds)) {
            return boIds;
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper(dimEntityNumber);
        QFilter[] hisQFilterArr = this.buildHisVersionQFilter(dimEntityNumber, boIds);
        DynamicObjectCollection idColl = adminOrgHelper.queryOriginalCollection("id", hisQFilterArr);
        return idColl.stream().map(dyno -> dyno.getString("id")).collect(Collectors.toSet());
    }

    private QFilter[] buildHisVersionQFilter(String dimEntityNumber, Set boIds) {
        QFilter boIdQfilter = new QFilter("boid", "in", (Object)boIds);
        QFilter dataStatusQfilter = new QFilter("datastatus", "in", (Object)new String[]{"-2", "-1", "0", "1", "2"});
        if (this.isBindInitColumn(dimEntityNumber)) {
            QFilter initStatusQfilter = new QFilter("initstatus", "=", (Object)"2");
            return new QFilter[]{boIdQfilter, dataStatusQfilter, initStatusQfilter};
        }
        return new QFilter[]{boIdQfilter, dataStatusQfilter};
    }

    private boolean isBindInitColumn(String dimEntityNumber) {
        if (HRStringUtils.isEmpty((String)dimEntityNumber)) {
            return false;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dimEntityNumber);
        DynamicProperty initStatusProperty = entityType.getProperty("initstatus");
        if (initStatusProperty == null) {
            return false;
        }
        String tableColumn = initStatusProperty.getAlias();
        return HRStringUtils.isNotEmpty((String)tableColumn);
    }

    protected String buildQfilterPropKey(String entityNumber, String propKey, Map<String, Object> customParam) {
        try {
            LOGGER.info("HRDataPermService buildQfilterPropKey entry,entityNumber:{},propKey:{},customParam:{}", new Object[]{entityNumber, propKey, customParam});
            if (HRStringUtils.equals((String)propKey, (String)"id")) {
                return propKey;
            }
            String propEntityNumber = entityNumber;
            String permMserviceSource = (String)customParam.get("permMserviceSourceKey");
            if (HRStringUtils.equals((String)permMserviceSource, (String)"f7")) {
                propEntityNumber = (String)customParam.get("propEntityNumberKey");
            }
            if (DynamicFormHelper.isDynamicFormOrReport(propEntityNumber)) {
                LOGGER.info("HRDataPermService buildQfilterPropKey propEntityNumber:{} is isDynamicFormOrReport,return origin propkey", (Object)propEntityNumber);
                return propKey;
            }
            String permMserviceIsFromScript = (String)customParam.get("permMserviceIsFromScript");
            String[] propKeyArr = propKey.split("\\.");
            String qfilterProp = null;
            qfilterProp = propKeyArr.length == 1 ? this.convertSingleProp(propEntityNumber, propKey, permMserviceIsFromScript) : (propKeyArr.length == 2 ? this.convertMultiProp(propEntityNumber, propKey, permMserviceIsFromScript) : propKey);
            LOGGER.info("HRDataPermService buildQfilterPropKey result,qfilterProp:{}", (Object)qfilterProp);
            return qfilterProp;
        }
        catch (Exception ex) {
            LOGGER.error("HRDataPermService buildQfilterPropKey error.", (Throwable)ex);
            return propKey;
        }
    }

    private String convertMultiProp(String parentEntityNumber, String propKey, String permMserviceIsFromScript) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)parentEntityNumber);
        boolean isMultiEntity = mainType instanceof QueryEntityType;
        int dotPos = propKey.indexOf(46);
        String frontProp = propKey.substring(0, dotPos);
        String backProp = propKey.substring(dotPos + 1);
        if (isMultiEntity && this.isJoinEntity((QueryEntityType)mainType, frontProp)) {
            String subEntityNumber = frontProp;
            String queryProp = this.convertSingleProp(subEntityNumber, backProp, permMserviceIsFromScript);
            return subEntityNumber + "." + queryProp;
        }
        String frontQueryProp = this.convertSingleProp(parentEntityNumber, frontProp, permMserviceIsFromScript);
        String backQueryProp = backProp;
        String propEntityNumber = AbstractDimQFilterHandler.getPropEntityNumber(parentEntityNumber, frontProp);
        MainEntityType propEntityType = EntityMetadataCache.getDataEntityType((String)propEntityNumber);
        Map entityMap = propEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)entityMap.get(backProp);
        backQueryProp = AbstractDimQFilterHandler.calQueryProp(backQueryProp, property, permMserviceIsFromScript);
        return frontQueryProp + "." + backQueryProp;
    }

    private boolean isJoinEntity(QueryEntityType queryEntityType, String entityNumber) {
        List joinEntitys = queryEntityType.getJoinEntitys();
        return joinEntitys.stream().anyMatch(tmp -> entityNumber.equals(tmp.getEntityName()));
    }

    private String convertSingleProp(String parentEntityNumber, String propKey, String permMserviceIsFromScript) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)parentEntityNumber);
        Map entityMap = entityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)entityMap.get(propKey);
        return AbstractDimQFilterHandler.calQueryProp(propKey, property, permMserviceIsFromScript);
    }

    private static String calQueryProp(String propKey, IDataEntityProperty property, String permMserviceIsFromScript) {
        if (property == null) {
            return propKey;
        }
        boolean isFromScript = HRStringUtils.equals((String)permMserviceIsFromScript, (String)"true");
        boolean isEntry = property.getParent() instanceof EntryType;
        boolean isMultiBasedata = property instanceof MulBasedataProp;
        if (isFromScript) {
            if (isMultiBasedata) {
                return NOT_SUPPORT_FILTER_PROPERTY;
            }
            return propKey;
        }
        if (isEntry) {
            propKey = property.getParent().getName() + "." + propKey;
        }
        if (isMultiBasedata) {
            propKey = propKey + ".fbasedataid";
        }
        return propKey;
    }

    private static String getPropEntityNumber(String entityNumber, String propKey) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entityMap = entityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)entityMap.get(propKey);
        if (property instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)property;
            return bdProp.getBaseEntityId();
        }
        if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBdProp = (MulBasedataProp)property;
            return mulBdProp.getBaseEntityId();
        }
        return null;
    }

    protected static boolean isNotSupportFilterProperty(String property) {
        return HRStringUtils.isEmpty((String)property) || property.contains(NOT_SUPPORT_FILTER_PROPERTY);
    }

    protected static QFilter buildNotNullQfilter(String qfilterPropKey, String propType) {
        QFilter result = new QFilter(qfilterPropKey, "is not null", null);
        if (HRStringUtils.equals((String)propType, (String)"string")) {
            result.and(qfilterPropKey, "!=", (Object)"").and(qfilterPropKey, "!=", (Object)" ");
        } else {
            result.and(qfilterPropKey, "!=", (Object)0L);
        }
        return result;
    }
}

