/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.handler;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.handler.AbstractDimQFilterHandler;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;

@ExcludeFromJacocoGeneratedReport
public class BuDimHandler
extends AbstractDimQFilterHandler {
    private static final Log LOGGER = LogFactory.getLog(BuDimHandler.class);

    @Override
    public QFilter buildDimValueQFilter(String entityNum, String propKey, String propType, List<DimValue> dimValues, RoleRuleInfo roleRuleInfo, Map<String, Object> customParam) {
        if (this.isContainAll(dimValues)) {
            LOGGER.info("HRDataPermService isContainAll is true,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        String qfilterPropKey = this.buildQfilterPropKey(entityNum, propKey, customParam);
        if (BuDimHandler.isNotSupportFilterProperty(qfilterPropKey)) {
            LOGGER.info("HRDataPermService qfilterPropKey isNotSupportFilterProperty,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        if (PermCheckService.containDynaCondNotNull(dimValues)) {
            return BuDimHandler.buildNotNullQfilter(qfilterPropKey, propType);
        }
        Set allocatedOrgIds = dimValues.stream().map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
        List containsSubIds = dimValues.stream().filter(DimValue::isContainsSub).map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(containsSubIds)) {
            return new QFilter(qfilterPropKey, "in", allocatedOrgIds);
        }
        String viewId = roleRuleInfo.getOrgFuncId().toString();
        List subList = OrgServiceHelper.getAllSubordinateOrgs((String)viewId, containsSubIds, (boolean)true);
        allocatedOrgIds.addAll(subList);
        return new QFilter(qfilterPropKey, "in", allocatedOrgIds);
    }
}

