/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.handler;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.handler.AbstractDimQFilterHandler;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;

@ExcludeFromJacocoGeneratedReport
public class CommonTreeDimHandler
extends AbstractDimQFilterHandler {
    private String COMMON_LONG_NUMBER_FIELD = "longnumber";
    private static final Log LOGGER = LogFactory.getLog(CommonTreeDimHandler.class);

    @Override
    public QFilter buildDimValueQFilter(String entityNum, String propKey, String propType, List<DimValue> dimValues, RoleRuleInfo roleRuleInfo, Map<String, Object> customParam) {
        if (this.isContainAll(dimValues)) {
            LOGGER.info("HRDataPermService isContainAll is true,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        String qfilterPropKey = this.buildQfilterPropKey(entityNum, propKey, customParam);
        if (CommonTreeDimHandler.isNotSupportFilterProperty(qfilterPropKey)) {
            LOGGER.info("HRDataPermService qfilterPropKey isNotSupportFilterProperty,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        if (PermCheckService.containDynaCondNotNull(dimValues)) {
            return CommonTreeDimHandler.buildNotNullQfilter(qfilterPropKey, propType);
        }
        List<DimValue> noSubList = dimValues.stream().filter(val -> !val.isContainsSub()).collect(Collectors.toList());
        List<DimValue> withSubList = dimValues.stream().filter(val -> val.isContainsSub()).collect(Collectors.toList());
        String targetEntity = roleRuleInfo.getDimEntityNumber();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(targetEntity);
        Set<String> withSubStrValues = this.dimValueToStringList(withSubList);
        Set<String> noSubStrValues = this.dimValueToStringList(noSubList);
        if (HRStringUtils.equalsIgnoreCase((String)propType, (String)"string")) {
            DynamicObjectCollection longNumberColl = helper.queryOriginalCollection(this.COMMON_LONG_NUMBER_FIELD, new QFilter[]{new QFilter("id", "in", withSubStrValues)});
            Set<String> longNumbers = longNumberColl.stream().map(dyno -> dyno.getString(this.COMMON_LONG_NUMBER_FIELD)).collect(Collectors.toSet());
            QFilter longNumberQFilter = this.createLongNumberQFilter(longNumbers);
            DynamicObjectCollection subIdColl = helper.queryOriginalCollection("id", new QFilter[]{longNumberQFilter});
            Set subStrIds = subIdColl.stream().map(dyno -> dyno.getString("id")).collect(Collectors.toSet());
            HashSet allPermIds = Sets.newHashSetWithExpectedSize((int)16);
            allPermIds.addAll(subStrIds);
            allPermIds.addAll(withSubStrValues);
            allPermIds.addAll(noSubStrValues);
            return new QFilter(qfilterPropKey, "in", (Object)allPermIds);
        }
        Set<Long> noSubIds = PermRoleUtil.str2LongSet(noSubStrValues);
        Set<Long> withSubIds = PermRoleUtil.str2LongSet(withSubStrValues);
        DynamicObjectCollection longNumberColl = helper.queryOriginalCollection(this.COMMON_LONG_NUMBER_FIELD, new QFilter[]{new QFilter("id", "in", withSubIds)});
        Set<String> longNumbers = longNumberColl.stream().map(dyno -> dyno.getString(this.COMMON_LONG_NUMBER_FIELD)).collect(Collectors.toSet());
        QFilter longNumberQFilter = this.createLongNumberQFilter(longNumbers);
        DynamicObjectCollection subIdColl = helper.queryOriginalCollection("id", new QFilter[]{longNumberQFilter});
        Set subIds = subIdColl.stream().map(dyno -> dyno.getLong("id")).collect(Collectors.toSet());
        HashSet allPermIds = Sets.newHashSetWithExpectedSize((int)16);
        allPermIds.addAll(subIds);
        allPermIds.addAll(noSubIds);
        allPermIds.addAll(withSubIds);
        return new QFilter(qfilterPropKey, "in", (Object)allPermIds);
    }

    private QFilter createLongNumberQFilter(Set<String> longNumSet) {
        QFilter qFilter = QFilter.of((String)"1=2", (Object[])new Object[0]);
        if (longNumSet.size() > 0) {
            for (String longNum : longNumSet) {
                QFilter longNumberFilter = new QFilter(this.COMMON_LONG_NUMBER_FIELD, "like", (Object)(longNum + ".%"));
                qFilter.or(longNumberFilter);
            }
        }
        return qFilter;
    }
}

