/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.handler;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRMD5Util;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.handler.AbstractDimQFilterHandler;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBaseOrgStructureServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.check.helper.OrgOptimLongNumberHelper;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.util.LoggerStrUtil;

public class OrgTeamDimHandler
extends AbstractDimQFilterHandler {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamDimHandler.class);
    private static ThreadLocal<Map<String, Set<Long>>> resultOrgIdsLocal = new ThreadLocal();

    @Override
    public QFilter buildDimValueQFilter(String entityNum, String propKey, String propType, List<DimValue> dimValues, RoleRuleInfo roleRuleInfo, Map<String, Object> customParam) {
        String cacheKey;
        Set orgIdReulst;
        if (this.isContainAll(dimValues)) {
            LOGGER.info("HRDataPermService isContainAll is true,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        String qfilterPropKey = this.buildQfilterPropKey(entityNum, propKey, customParam);
        if (OrgTeamDimHandler.isNotSupportFilterProperty(qfilterPropKey)) {
            LOGGER.info("HRDataPermService qfilterPropKey isNotSupportFilterProperty,return null.entityNum={},propKey={}", (Object)entityNum, (Object)propKey);
            return null;
        }
        if (PermCheckService.containDynaCondNotNull(dimValues)) {
            return OrgTeamDimHandler.buildNotNullQfilter(qfilterPropKey, propType);
        }
        if (this.hasAllOrgPerm(roleRuleInfo.getStructProjectMap(), roleRuleInfo.getStructRootMap(), dimValues)) {
            LOGGER.info("HRDataPermService hasAllOrgPerm ,return null qfilter.entityNum={},propKey={},dimValues=()", new Object[]{entityNum, propKey, dimValues});
            return null;
        }
        QFilter longNumberQfilter = OrgOptimLongNumberHelper.optim2LongNumber(entityNum, propKey, (String)customParam.get("propEntityNumberKey"), (String)customParam.get("permMserviceCallerKey"), (String)customParam.get("permMserviceSourceKey"), roleRuleInfo.getStructProjectMap(), dimValues);
        if (longNumberQfilter != null) {
            LOGGER.info("HRDataPermService optim2LongNumber ,longNumberQfilter={}", (Object)LoggerStrUtil.qFilterToString((QFilter)longNumberQfilter));
            return longNumberQfilter;
        }
        HashMap orgIdReulstMap = resultOrgIdsLocal.get();
        if (orgIdReulstMap == null) {
            orgIdReulstMap = Maps.newHashMapWithExpectedSize((int)16);
            resultOrgIdsLocal.set(orgIdReulstMap);
        }
        if (!CollectionUtils.isEmpty((Collection)(orgIdReulst = (Set)orgIdReulstMap.get(cacheKey = RequestContext.get().getTraceId() + "_" + RequestContext.get().getCurrUserId() + "_" + roleRuleInfo.getDimensionId() + "_" + roleRuleInfo.getStructProjectMap() + this.getDimValueCacheKey(dimValues))))) {
            LOGGER.info("OrgTeamDimHandler getAuthorizedOrgTeams get from cache,result org sets size:{}", (Object)orgIdReulst.size());
            return new QFilter(qfilterPropKey, "in", (Object)orgIdReulst);
        }
        long start = System.currentTimeMillis();
        Set<Long> orgQFilterSet = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeams(roleRuleInfo.getStructProjectMap(), dimValues, null, null);
        LOGGER.info("OrgTeamDimHandler getAuthorizedOrgTeams result cost_mills:{},orgQFilterSet size:{} structProjectMap:{},dimValues:{},qfilterPropKey:{}", new Object[]{System.currentTimeMillis() - start, orgQFilterSet.size(), roleRuleInfo.getStructProjectMap(), dimValues, qfilterPropKey});
        orgIdReulstMap.put(cacheKey, orgQFilterSet);
        return new QFilter(qfilterPropKey, "in", orgQFilterSet);
    }

    private String getDimValueCacheKey(List<DimValue> dimValues) {
        StringBuilder sb = new StringBuilder();
        for (DimValue val : dimValues) {
            sb.append("DimValue{dimVal=").append(val.getDimVal()).append(",structProjectId=").append(val.getStructProjectId()).append(",containsSub=").append(val.isContainsSub()).append(",adminContainsSub=").append(val.isAdminContainsSub()).append("};");
        }
        String dimValueKey = sb.toString();
        if (HRStringUtils.isNotEmpty((String)dimValueKey) && dimValueKey.length() > 3000) {
            return HRMD5Util.getMD5String((String)dimValueKey);
        }
        return dimValueKey;
    }

    private boolean hasAllOrgPerm(Map<Long, Long> structProjectMap, Map<Long, Long> structRootMap, List<DimValue> dimValues) {
        if (CollectionUtils.isEmpty(structProjectMap)) {
            return false;
        }
        for (Map.Entry<Long, Long> entry : structProjectMap.entrySet()) {
            Long rootOrgId;
            Long dependId;
            Long structId = entry.getKey();
            if (this.isStructHasAll(structId, dependId = entry.getValue(), rootOrgId = structRootMap.get(structId), dimValues)) continue;
            return false;
        }
        return true;
    }

    private boolean isStructHasAll(Long structId, Long dependId, Long rootOrgId, List<DimValue> dimValues) {
        if (rootOrgId == null || Objects.equals(rootOrgId, 0L)) {
            return false;
        }
        for (DimValue dimValue : dimValues) {
            if (HRStringUtils.isEmpty((String)dimValue.getDimVal()) || !Objects.equals(structId, dimValue.getStructProjectId()) || !(dependId == null || Objects.equals(dependId, 0L) ? Objects.equals(Long.parseLong(dimValue.getDimVal()), rootOrgId) && dimValue.isContainsSub() : Objects.equals(Long.parseLong(dimValue.getDimVal()), rootOrgId) && dimValue.isContainsSub() && dimValue.isAdminContainsSub())) continue;
            return true;
        }
        return false;
    }
}

