/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.DimValueGroup;

public class DataRangeServiceHelper {
    private static final Log LOG = LogFactory.getLog(DataRangeServiceHelper.class);

    public static Map<String, List<String>> queryRoleDataRule(Set<String> roleIdSet, String appId, String entityId, String permItemId) {
        HashMap roleEntryDataRuleJsonMap = Maps.newHashMapWithExpectedSize((int)roleIdSet.size());
        if (roleIdSet.size() == 0) {
            return roleEntryDataRuleJsonMap;
        }
        StringBuilder roleEntryDataRule = new StringBuilder();
        roleEntryDataRule.append("SELECT a.FROLEID,c.FRULE from T_HRCS_ROLEDATARULE a INNER JOIN T_HRCS_ROLEDATARULEENTRY b").append(" on a.FID = b.FID INNER JOIN T_HRCS_DATARULE c on b.FDATARULEID = c.fid").append(" where a.froleid IN  ").append(PermCheckUtil.splitId(roleIdSet)).append(" and a.FAPPID = ? and a.FENTITYTYPEID = ? and b.FPERMITEMID = ? and c.FENTITYNUM = ?");
        DataSet roleEntryDataRuleDataSet = HRDBUtil.queryDataSet((String)"hrcs.queryRoleEntryDataRule", (DBRoute)new DBRoute("hmp"), (String)roleEntryDataRule.toString(), (Object[])PermCheckUtil.assembleParams(roleIdSet, appId, entityId, permItemId, entityId));
        while (roleEntryDataRuleDataSet.hasNext()) {
            Row row = roleEntryDataRuleDataSet.next();
            roleEntryDataRuleJsonMap.computeIfAbsent(row.getString("froleid"), key -> new ArrayList(16)).add(row.getString("frule"));
        }
        roleEntryDataRuleDataSet.close();
        return roleEntryDataRuleJsonMap;
    }

    public static Map<Long, List<String>> queryUserDataRule(Set<Long> userRoleRelIdSet, String appId, String entityId, String permItemId) {
        if (userRoleRelIdSet.size() == 0) {
            return Maps.newHashMap();
        }
        StringBuilder userEntryDataRule = new StringBuilder();
        userEntryDataRule.append("SELECT d.fid,d.froleid,c.frule from T_HRCS_USERROLERELAT d LEFT JOIN T_HRCS_USERDATARULE a on d.fid = a.fuserrolerealtid ").append(" INNER JOIN T_HRCS_USERDATARULEENTRY b  on a.FID = b.FID ").append(" INNER JOIN T_HRCS_DATARULE c on b.fdataruleid = c.fid").append(" where a.fuserrolerealtid IN  ").append(PermCheckUtil.splitId(userRoleRelIdSet)).append(" and a.fappid = ? and a.fentitytypeid = ? and b.fpermitemid = ? and c.fentitynum = ?");
        DataSet dataSet = HRDBUtil.queryDataSet((String)"hrcs.queryUserEntryDataRule", (DBRoute)new DBRoute("hmp"), (String)userEntryDataRule.toString(), (Object[])PermCheckUtil.assembleParams(userRoleRelIdSet, appId, entityId, permItemId, entityId));
        HashMap userEntryDataRuleJsonMap = Maps.newHashMapWithExpectedSize((int)16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            userEntryDataRuleJsonMap.computeIfAbsent(row.getLong("fid"), key -> new ArrayList(16)).add(row.getString("frule"));
        }
        dataSet.close();
        return userEntryDataRuleJsonMap;
    }

    public static Map<String, List<DimValueGroup>> getRoleDimValGroup(Set<String> roleIds, Long funcId, Set<Long> dimIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimgrp");
        DynamicObject[] dynoArr = helper.query("role,entry.dimension,entry.isall,entry.dimval,entry.containssub,entry.otclassify,entry.structproject,entry.admincontainssub,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("role", "in", roleIds), new QFilter("bucafunc", "=", (Object)funcId), new QFilter("entry.dimension", "in", dimIds)});
        HashMap roleDimValueGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dimGroupDyno : dynoArr) {
            String roleId = dimGroupDyno.getString("role.id");
            HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObjectCollection dimValueColl = dimGroupDyno.getDynamicObjectCollection("entry");
            for (DynamicObject dimValueDyno : dimValueColl) {
                Long dimId = dimValueDyno.getLong("dimension.id");
                if (!dimIds.contains(dimId)) continue;
                List dimValues = dimValuesMap.computeIfAbsent(dimId, key -> Lists.newArrayListWithExpectedSize((int)16));
                if (DataRangeServiceHelper.isDirtyDimVal(dimValueDyno)) continue;
                DimValue dimValue = new DimValue(dimValueDyno.getBoolean("isall"), dimValueDyno.getString("dimval"), dimValueDyno.getBoolean("containssub"), false);
                dimValue.setAdminContainsSub(dimValueDyno.getBoolean("admincontainssub"));
                dimValue.setOtClassify(Long.valueOf(dimValueDyno.getLong("otclassify.id")));
                dimValue.setStructProjectId(Long.valueOf(dimValueDyno.getLong("structproject.id")));
                dimValue.setValType(dimValueDyno.getString("valtype"));
                dimValue.setDynaCondId(Long.valueOf(dimValueDyno.getLong("dynacond.id")));
                dimValues.add(dimValue);
            }
            List roleDimGroupList = roleDimValueGroupMap.computeIfAbsent(roleId, key -> Lists.newArrayListWithExpectedSize((int)16));
            roleDimGroupList.add(new DimValueGroup((Map)dimValuesMap));
        }
        LOG.info("HRDataPermService getRoleDimValGroup() result:{}", (Object)roleDimValueGroupMap);
        return roleDimValueGroupMap;
    }

    public static Map<Long, List<DimValueGroup>> getUserRoleDimValGroup(Set<Long> relatIds, Long funcId, Set<Long> dimIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        DynamicObject[] dynoArr = helper.query("userrolerelat,entry.dimension,entry.isall,entry.dimval,entry.containssub,entry.otclassify,entry.structproject,entry.admincontainssub,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("userrolerelat", "in", relatIds), new QFilter("bucafunc", "=", (Object)funcId), new QFilter("entry.dimension", "in", dimIds)});
        HashMap roldDimValueGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dimGroupDyno : dynoArr) {
            Long relatId = dimGroupDyno.getLong("userrolerelat.id");
            HashMap dimValuesMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObjectCollection dimValueColl = dimGroupDyno.getDynamicObjectCollection("entry");
            for (DynamicObject dimValueDyno : dimValueColl) {
                Long dimId = dimValueDyno.getLong("dimension.id");
                if (!dimIds.contains(dimId)) continue;
                List dimValues = dimValuesMap.computeIfAbsent(dimId, key -> Lists.newArrayListWithExpectedSize((int)16));
                if (DataRangeServiceHelper.isDirtyDimVal(dimValueDyno)) continue;
                DimValue dimValue = new DimValue(dimValueDyno.getBoolean("isall"), dimValueDyno.getString("dimval"), dimValueDyno.getBoolean("containssub"), false);
                dimValue.setAdminContainsSub(dimValueDyno.getBoolean("admincontainssub"));
                dimValue.setOtClassify(Long.valueOf(dimValueDyno.getLong("otclassify.id")));
                dimValue.setStructProjectId(Long.valueOf(dimValueDyno.getLong("structproject.id")));
                dimValue.setValType(dimValueDyno.getString("valtype"));
                dimValue.setDynaCondId(Long.valueOf(dimValueDyno.getLong("dynacond.id")));
                dimValues.add(dimValue);
            }
            List roleDimGroupList = roldDimValueGroupMap.computeIfAbsent(relatId, key -> Lists.newArrayListWithExpectedSize((int)16));
            roleDimGroupList.add(new DimValueGroup((Map)dimValuesMap));
        }
        LOG.info("HRDataPermService getUserRoleDimValGroup() result:{}", (Object)roldDimValueGroupMap);
        return roldDimValueGroupMap;
    }

    private static boolean isDirtyDimVal(DynamicObject dimValueDyno) {
        return !dimValueDyno.getBoolean("isall") && HRStringUtils.isEmpty((String)dimValueDyno.getString("dimval")) && !HRStringUtils.equals((String)dimValueDyno.getString("valtype"), (String)"2");
    }

    public static Map<String, List<String>> getRoleBDDataRuleJson(Set<String> roleIdSet, String entityNum, String propKey, String appId) {
        if (roleIdSet.size() == 0) {
            return Maps.newHashMap();
        }
        Map<String, List<String>> roleBDDataRuleJsonMap = null;
        String roleBDDataRule = " SELECT rdr.froleid, dr.frule FROM T_HRCS_ROLEDATARULE rdr  INNER JOIN T_HRCS_ROLEBDRULEENTRY rde ON rdr.FID = rde.fid INNER JOIN T_HRCS_DATARULE dr ON rde.fdataruleid = dr.FID WHERE rdr.FROLEID in  " + PermCheckUtil.splitId(roleIdSet) + " and rdr.fentitytypeid = ? and rde.fpropkey = ?  and rdr.fappid = ? and dr.FENABLE = '1'";
        try (DataSet roleIdDataSet = HRDBUtil.queryDataSet((String)"hrcs.getRoleBDDataRuleJson", (DBRoute)new DBRoute("hmp"), (String)roleBDDataRule, (Object[])PermCheckUtil.assembleParams(roleIdSet, entityNum, propKey, appId));){
            roleBDDataRuleJsonMap = DataRangeServiceHelper.assembleDataRule(roleIdDataSet, roleIdSet);
        }
        return roleBDDataRuleJsonMap;
    }

    public static Map<Long, List<String>> getUserDBDataRuleJson(Set<Long> userRoleIdSet, String entityId, String propKey, String appId) {
        if (userRoleIdSet.size() == 0) {
            return Maps.newHashMap();
        }
        HashMap userRuleMap = Maps.newHashMapWithExpectedSize((int)16);
        String userBDDataRule = "SELECT udr.fuserrolerealtid, dr.frule from T_HRCS_USERDATARULE udr INNER JOIN T_HRCS_USERBDRULEENTRY ubd  on udr.FID = ubd.fid INNER JOIN T_HRCS_DATARULE dr on ubd.fdataruleid = dr.FID WHERE  udr.fuserrolerealtid in  " + PermCheckUtil.splitId(userRoleIdSet) + " and udr.fentitytypeid = ? and ubd.fpropkey = ? and udr.fappid = ? and dr.FENABLE = '1'";
        try (DataSet userDataSet = HRDBUtil.queryDataSet((String)"hrcs.getUserDataRule", (DBRoute)new DBRoute("hmp"), (String)userBDDataRule, (Object[])PermCheckUtil.assembleParams(userRoleIdSet, entityId, propKey, appId));){
            while (userDataSet.hasNext()) {
                Row row = userDataSet.next();
                userRuleMap.computeIfAbsent(row.getLong("fuserrolerealtid"), key -> new ArrayList(16)).add(row.getString("frule"));
            }
        }
        return userRuleMap;
    }

    private static Map<String, List<String>> assembleDataRule(DataSet dataSet, Set<String> roleIdSet) {
        HashMap dataRuleJsonMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String roleId : roleIdSet) {
            dataRuleJsonMap.put(roleId, Lists.newArrayList());
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            dataRuleJsonMap.computeIfAbsent(row.getString("froleid"), key -> new ArrayList(16)).add(row.getString("frule"));
        }
        return dataRuleJsonMap;
    }
}

