/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

public class DynamicFormHelper {
    private static final Log LOGGER = LogFactory.getLog(DynamicFormHelper.class);

    public static String getPropTypeFromDynamicForm(String entityNumber, String propKey) {
        if (!DynamicFormHelper.isDynamicFormOrReport(entityNumber)) {
            return null;
        }
        return DynamicFormHelper.getPropEntityNumber(entityNumber, propKey);
    }

    public static boolean isDynamicFormOrReport(String entityNumber) {
        HRBaseServiceHelper objectTypeHelper = new HRBaseServiceHelper("bos_objecttype");
        DynamicObject dynamicObject = objectTypeHelper.queryOriginalOne("modeltype", new QFilter("number", "=", (Object)entityNumber));
        if (dynamicObject == null) {
            return false;
        }
        String modelType = dynamicObject.getString("modeltype");
        return HRStringUtils.equals((String)"DynamicFormModel", (String)modelType) || HRStringUtils.equals((String)"ReportFormModel", (String)modelType);
    }

    @ExcludeFromJacocoGeneratedReport
    private static String getPropEntityNumber(String entityNumber, String propKey) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaformctrl");
        DynamicObject dynamicObject = helper.queryOne("entryentity.propkey,entryentity.bdtype", new QFilter("entitytype", "=", (Object)entityNumber));
        if (dynamicObject == null) {
            return null;
        }
        DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDyno : entryColl) {
            String relatPropKey = entryDyno.getString("propkey");
            if (!HRStringUtils.equals((String)relatPropKey, (String)propKey) && !relatPropKey.contains(propKey + ".")) continue;
            return entryDyno.getString("bdtype.id");
        }
        return null;
    }

    public static Map<String, String> getMultiPropEnityNumber(String entityNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dynaformctrl");
        DynamicObject[] dynamicObjectArr = helper.query("entitytype,entryentity.propkey,entryentity.bdtype", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNumber)}, null);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjectArr) {
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyno : entryColl) {
                result.put(entryDyno.getString("propkey"), entryDyno.getString("bdtype.id"));
            }
        }
        return result;
    }
}

