/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityPropParser {
    private static final Log LOGGER = LogFactory.getLog(EntityPropParser.class);

    public static String[] parseEntityPropFullKey(String parentEntityNumber, String propFullKey) {
        String[] result = new String[]{null, null};
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)parentEntityNumber);
        boolean isMultiEntity = mainType instanceof QueryEntityType;
        String propEntityNumber = null;
        String propKey = null;
        String[] propKeyArr = propFullKey.split("\\.");
        if (propKeyArr.length <= 2) {
            propEntityNumber = parentEntityNumber;
            propKey = propKeyArr[0];
        } else if (propKeyArr.length == 3) {
            if (isMultiEntity) {
                if (!EntityPropParser.isJoinEntity((QueryEntityType)mainType, propKeyArr[0])) {
                    propEntityNumber = ((QueryEntityType)mainType).getEntityName();
                    propKey = propKeyArr[0];
                } else {
                    propEntityNumber = propKeyArr[0];
                    propKey = propKeyArr[1];
                }
            } else {
                propEntityNumber = EntityPropParser.getBaseEntityId(parentEntityNumber, propKeyArr[0]);
                propKey = propKeyArr[1];
            }
        } else {
            return result;
        }
        result[0] = propEntityNumber;
        result[1] = propKey;
        return result;
    }

    private static boolean isJoinEntity(QueryEntityType queryEntityType, String entityNumber) {
        List joinEntitys = queryEntityType.getJoinEntitys();
        return joinEntitys.stream().anyMatch(tmp -> entityNumber.equals(tmp.getEntityName()));
    }

    public static String getPropTargetEntityNumber(String parentEntityNumber, String propFullKey) {
        String[] parseResult = EntityPropParser.parseEntityPropFullKey(parentEntityNumber, propFullKey);
        if (HRStringUtils.isEmpty((String)parseResult[0]) || HRStringUtils.isEmpty((String)parseResult[1])) {
            return null;
        }
        return EntityPropParser.getBaseEntityId(parseResult[0], parseResult[1]);
    }

    public static String getBaseEntityId(String entityNumber, String propKey) {
        if (HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)propKey)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entityMap = entityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)entityMap.get(propKey);
        if (property == null) {
            return null;
        }
        if (property instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)property;
            return bdProp.getBaseEntityId();
        }
        if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBdProp = (MulBasedataProp)property;
            return mulBdProp.getBaseEntityId();
        }
        return null;
    }

    public static String trimMultiBasedata(String propFullKey) {
        if (propFullKey.contains(".fbasedataid")) {
            propFullKey = propFullKey.replaceAll(".fbasedataid", "");
        }
        return propFullKey;
    }

    public static String trimLastNameAndNumberProperty(String propFullKey) {
        if (propFullKey.endsWith(".number")) {
            propFullKey = propFullKey.substring(0, propFullKey.length() - 7);
        } else if (propFullKey.endsWith(".name")) {
            propFullKey = propFullKey.substring(0, propFullKey.length() - 5);
        } else if (propFullKey.endsWith(".id")) {
            propFullKey = propFullKey.substring(0, propFullKey.length() - 3);
        }
        return propFullKey;
    }

    public static String getDataRuleFieldKey(String parentEntityNumber, String propFullKey) {
        return propFullKey;
    }

    private static boolean isSubEntityField(List<JoinEntity> entities, String entityNumber) {
        JoinEntity entity;
        Iterator<JoinEntity> iterator = entities.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!entityNumber.equals((entity = iterator.next()).getEntityName()) && !entityNumber.equals(entity.getAlias()));
        return true;
    }

    public static String getPropF7EntityNumber(String parentEntityNumber, String dataRuleKey) {
        try {
            String propEntity = null;
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)parentEntityNumber);
            boolean isMultiEntity = mainType instanceof QueryEntityType;
            if (!dataRuleKey.contains(".")) {
                return EntityPropParser.getBaseEntityId(parentEntityNumber, dataRuleKey);
            }
            String[] propKeyArr = dataRuleKey.split("\\.");
            int length = propKeyArr.length;
            if (!isMultiEntity) {
                if (length == 2) {
                    String entityNum = EntityPropParser.getBaseEntityId(parentEntityNumber, propKeyArr[0]);
                    propEntity = EntityPropParser.getBaseEntityId(entityNum, propKeyArr[1]);
                }
                return propEntity;
            }
            if (length == 2) {
                String entityNum = EntityPropParser.getBaseEntityId(parentEntityNumber, propKeyArr[0]);
                propEntity = EntityPropParser.getBaseEntityId(entityNum, propKeyArr[1]);
            } else if (length == 3) {
                String firstEntityNum = EntityPropParser.getBaseEntityId(parentEntityNumber, propKeyArr[0]);
                String secondEntityNum = EntityPropParser.getBaseEntityId(firstEntityNum, propKeyArr[1]);
                propEntity = EntityPropParser.getBaseEntityId(secondEntityNum, propKeyArr[2]);
            }
            return propEntity;
        }
        catch (Exception ex) {
            LOGGER.error(String.format("getPropF7EntityNumber error,parentEntityNumber=%s,dataRuleKey=%s", parentEntityNumber, dataRuleKey), (Throwable)ex);
            return null;
        }
    }
}

