/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimDataCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBaseOrgServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBaseOrgStructureServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.OrgTeamStructProjectServiceHelper;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;

@ExcludeFromJacocoGeneratedReport
public class HRAdminOrgServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRAdminOrgServiceHelper.class);

    public static AuthorizedOrgResult getAuthorizedAdminOrgs(Long userId, String appId, String entityNum, String permItemId, String propKey, String methodSource, Map<String, Object> customParam) {
        AuthorizedOrgResultWithSub resultWithSub = HRAdminOrgServiceHelper.getAuthorizedAdminOrgsWithSubInfoTrimRepeated(userId, appId, entityNum, permItemId, propKey, methodSource, customParam);
        if (resultWithSub.isHasAllOrgPerm()) {
            return AuthorizedOrgResult.allOrg();
        }
        Date bsedTime = (Date)customParam.get("hr_dataperm_bsedtime");
        Date bsledTime = (Date)customParam.get("hr_dataperm_bsledtime");
        List<Long> structFromParam = PermCheckService.getStructProjectIdsFromCustomParam(customParam, propKey);
        if (HRAdminOrgServiceHelper.isContainRootAndSub(structFromParam, resultWithSub.getHasPermOrgsWithSub())) {
            return AuthorizedOrgResult.allOrg();
        }
        Map<Long, Long> structDependMap = OrgTeamStructProjectServiceHelper.queryDependStructProject(structFromParam);
        Set<Long> hasPermOrgIds = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeams(structDependMap, HRAdminOrgServiceHelper.convertOrgToDimVal(resultWithSub.getHasPermOrgsWithSub()), bsedTime, bsledTime);
        if (hasPermOrgIds == null) {
            return new AuthorizedOrgResult(false, (List)Lists.newArrayListWithExpectedSize((int)0));
        }
        return new AuthorizedOrgResult(false, (List)Lists.newArrayList(hasPermOrgIds));
    }

    private static List<DimValue> convertOrgToDimVal(List<OrgSubInfo> orgInfos) {
        if (CollectionUtils.isEmpty(orgInfos)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList dimValues = Lists.newArrayListWithExpectedSize((int)orgInfos.size());
        for (OrgSubInfo orgSubInfo : orgInfos) {
            DimValue dimValue = new DimValue(false, orgSubInfo.getOrgId().toString(), orgSubInfo.isContainsSub(), false);
            dimValue.setStructProjectId(orgSubInfo.getStructProjectId());
            dimValues.add(dimValue);
        }
        return dimValues;
    }

    public static AuthorizedOrgResultWithSub getAuthorizedAdminOrgArraysWithSubInfo(Long userId, String appId, String entityNum, String permItemId, String propKey, String methodSource, Map<String, Object> customParam) {
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNum, permItemId);
        LOGGER.info("HRDataPermService getAuthorizedAdminOrgs userRoleInfoList:{}", userRoleInfoList);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService getAuthorizedAdminOrgs roleList is empty,return all.");
            return new AuthorizedOrgResultWithSub(true);
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        Set<String> roleIds = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roleIds, appId, entityNum, funcId, propKey);
        PermDimDataCheckService.filterDimAuthRange(roleDimPropRelat, methodSource);
        Map<String, RoleRuleInfo> roleDimIdRelat = HRBaseOrgServiceHelper.getRoleOrgTeamDim(roleDimPropRelat);
        if (CollectionUtils.isEmpty(roleDimIdRelat)) {
            LOGGER.info("HRDataPermService getAuthorizedAdminOrgs roldDimIdRelat is null,return all.");
            return AuthorizedOrgResultWithSub.allOrg();
        }
        Long targetDimId = null;
        for (String roleId : roleIds) {
            if (roleDimIdRelat.get(roleId) == null) {
                LOGGER.info("HRDataPermService getAuthorizedAdminOrgs roleId:{}  donot relate dimension,return all.", (Object)roleId);
                return AuthorizedOrgResultWithSub.allOrg();
            }
            targetDimId = roleDimIdRelat.get(roleId).getDimensionId();
        }
        List<Long> adminStructProjectIds = PermCheckService.getStructProjectIdsFromCustomParam(customParam, propKey);
        Map<String, List<DimValue>> roleDimValueMap = HRBaseOrgServiceHelper.getRoleDimValue(userRoleInfoList, appId, entityNum, targetDimId);
        Map<Long, List<DimValue>> userRoleDimValueMap = HRBaseOrgServiceHelper.getUserRoleDimValue(userRoleInfoList, appId, entityNum, targetDimId);
        HRAdminOrgServiceHelper.pickRoleAdminOrgData(roleDimValueMap, adminStructProjectIds);
        HRAdminOrgServiceHelper.pickUserAdminOrgData(userRoleDimValueMap, adminStructProjectIds);
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        roleDimValueMap = DynaCondConverter.dimDynaCondConvert(userId, roleDimValueMap, "long", dynaCondMap);
        userRoleDimValueMap = DynaCondConverter.dimDynaCondConvert(userId, userRoleDimValueMap, "long", dynaCondMap);
        Map<String, DynamicObject> structLongNumberMap = HRAdminOrgServiceHelper.queryStructLongNumberByStructAndIds(roleDimValueMap, userRoleDimValueMap);
        ArrayList resultWithSub = Lists.newArrayListWithExpectedSize((int)16);
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            boolean isRoleAll = false;
            if (CollectionUtils.isEmpty((Collection)roleDimValueMap.get(userRoleInfo.getRoleId()))) {
                isRoleAll = true;
            }
            for (Long structId : adminStructProjectIds) {
                if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
                    List<OrgSubInfo> roleOrgs = HRAdminOrgServiceHelper.dim2OrgSubInfos(roleDimValueMap.get(userRoleInfo.getRoleId()), structLongNumberMap, structId);
                    List<OrgSubInfo> userOrgs = HRAdminOrgServiceHelper.dim2OrgSubInfos(userRoleDimValueMap.get(userRoleInfo.getRelatId()), structLongNumberMap, structId);
                    if (isRoleAll) {
                        resultWithSub.addAll(userOrgs);
                        continue;
                    }
                    if (CollectionUtils.isEmpty(roleOrgs) || CollectionUtils.isEmpty(userOrgs)) continue;
                    resultWithSub.addAll(HRAdminOrgServiceHelper.adminOrgIntersect(roleOrgs, userOrgs));
                    continue;
                }
                if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
                    resultWithSub.addAll(HRAdminOrgServiceHelper.dim2OrgSubInfos(userRoleDimValueMap.get(userRoleInfo.getRelatId()), structLongNumberMap, structId));
                    continue;
                }
                resultWithSub.addAll(HRAdminOrgServiceHelper.dim2OrgSubInfos(roleDimValueMap.get(userRoleInfo.getRoleId()), structLongNumberMap, structId));
            }
        }
        return new AuthorizedOrgResultWithSub(false, (List)resultWithSub);
    }

    public static AuthorizedOrgResultWithSub getAuthorizedAdminOrgsWithSubInfoTrimRepeated(Long userId, String appId, String entityNum, String permItemId, String propKey, String methodSource, Map<String, Object> customParam) {
        AuthorizedOrgResultWithSub resultWithSub = HRAdminOrgServiceHelper.getAuthorizedAdminOrgArraysWithSubInfo(userId, appId, entityNum, permItemId, propKey, methodSource, customParam);
        if (resultWithSub.isHasAllOrgPerm()) {
            return resultWithSub;
        }
        List<OrgSubInfo> resultWithSubNoRepeated = HRAdminOrgServiceHelper.trimRepeatedSubOrg(resultWithSub.getHasPermOrgsWithSub());
        return new AuthorizedOrgResultWithSub(false, resultWithSubNoRepeated);
    }

    private static List<OrgSubInfo> adminOrgIntersect(List<OrgSubInfo> roleOrgs, List<OrgSubInfo> userOrgs) {
        if (CollectionUtils.isEmpty(roleOrgs) || CollectionUtils.isEmpty(userOrgs)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (OrgSubInfo roleInfo : roleOrgs) {
            if (!HRAdminOrgServiceHelper.isContainInList(roleInfo, userOrgs)) continue;
            result.add(roleInfo);
        }
        for (OrgSubInfo userInfo : userOrgs) {
            if (!HRAdminOrgServiceHelper.isContainInList(userInfo, roleOrgs)) continue;
            result.add(userInfo);
        }
        return result;
    }

    private static boolean isContainInList(OrgSubInfo targetRoleInfo, List<OrgSubInfo> orgInfos) {
        String longNumber = targetRoleInfo.getLongStructNumber();
        for (OrgSubInfo orgInfo : orgInfos) {
            if (!targetRoleInfo.isContainsSub() && HRStringUtils.equals((String)longNumber, (String)orgInfo.getLongStructNumber())) {
                return true;
            }
            if (targetRoleInfo.isContainsSub() && HRStringUtils.equals((String)longNumber, (String)orgInfo.getLongStructNumber()) && orgInfo.isContainsSub()) {
                return true;
            }
            if (!orgInfo.isContainsSub() || !longNumber.startsWith(orgInfo.getLongStructNumber())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, DynamicObject> queryStructLongNumberByStructAndIds(Map<String, List<DimValue>> roleDimValueMap, Map<Long, List<DimValue>> userRoleDimValueMap) {
        HashMap structOrgsMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList allDimValLists = Lists.newArrayListWithExpectedSize((int)16);
        allDimValLists.addAll(roleDimValueMap.values());
        allDimValLists.addAll(userRoleDimValueMap.values());
        for (Object dimValues : allDimValLists) {
            Iterator iterator = dimValues.iterator();
            while (iterator.hasNext()) {
                DimValue dimVal = (DimValue)iterator.next();
                List structOrgs = (List)structOrgsMap.get(dimVal.getStructProjectId());
                if (structOrgs == null) {
                    structOrgs = Lists.newArrayListWithExpectedSize((int)16);
                    structOrgsMap.put(dimVal.getStructProjectId(), structOrgs);
                }
                try {
                    structOrgs.add(Long.parseLong(dimVal.getDimVal()));
                }
                catch (Exception ex) {
                    LOGGER.info("HRDataPermService queryStructLongNumberByStructAndIds dimval cannnot convert to long.dimVal={}", (Object)dimVal);
                }
            }
        }
        QFilter resultQfilter = null;
        for (Map.Entry entry : structOrgsMap.entrySet()) {
            QFilter singleStructQFilter = new QFilter("structproject.id", "=", entry.getKey()).and("orgteam.id", "in", entry.getValue());
            if (resultQfilter == null) {
                resultQfilter = singleStructQFilter;
                continue;
            }
            resultQfilter.or(singleStructQFilter);
        }
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObjectCollection dynamicObjectCollection = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure").queryColl("structlongnumber,orgteam.structnumber structnumber,orgteam.id id,structproject.id structid", new QFilter[]{resultQfilter, currentFilter}, null);
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        for (DynamicObject dyno : dynamicObjectCollection) {
            result.put(dyno.getLong("structid") + "_" + dyno.getLong("id"), dyno);
        }
        return result;
    }

    private static List<OrgSubInfo> trimRepeatedSubOrg(List<OrgSubInfo> orgList) {
        if (CollectionUtils.isEmpty(orgList)) {
            return orgList;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (OrgSubInfo orgInfo : orgList) {
            List orgInfos = (List)map.get(orgInfo.getStructProjectId());
            if (orgInfos == null) {
                orgInfos = Lists.newArrayListWithExpectedSize((int)16);
                map.put(orgInfo.getStructProjectId(), orgInfos);
            }
            orgInfos.add(orgInfo);
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)orgList.size());
        for (Map.Entry entry : map.entrySet()) {
            result.addAll(HRAdminOrgServiceHelper.trimRepeatedSubOrgSingleStruct((List)entry.getValue()));
        }
        return result;
    }

    private static List<OrgSubInfo> trimRepeatedSubOrgSingleStruct(List<OrgSubInfo> orgList) {
        if (CollectionUtils.isEmpty(orgList)) {
            return orgList;
        }
        Collections.sort(orgList, (org1, org2) -> {
            int structNumberResult = org1.getLongStructNumber().compareTo(org2.getLongStructNumber());
            if (structNumberResult != 0) {
                return structNumberResult;
            }
            if (Objects.equals(org1.isContainsSub(), org2.isContainsSub())) {
                return 0;
            }
            return org1.isContainsSub() ? -1 : 1;
        });
        ArrayList parentOrgList = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (OrgSubInfo org : orgList) {
            if (HRAdminOrgServiceHelper.isInResult(result, org) || HRAdminOrgServiceHelper.isContained(parentOrgList, org)) continue;
            result.add(org);
            if (!org.isContainsSub()) continue;
            parentOrgList.add(org);
        }
        return result;
    }

    private static boolean isInResult(List<OrgSubInfo> result, OrgSubInfo targetOrg) {
        for (OrgSubInfo org : result) {
            if (!targetOrg.getOrgId().equals(org.getOrgId()) || targetOrg.isContainsSub() != org.isContainsSub()) continue;
            return true;
        }
        return false;
    }

    private static boolean isContained(List<OrgSubInfo> parentOrgList, OrgSubInfo org) {
        if (CollectionUtils.isEmpty(parentOrgList)) {
            return false;
        }
        for (OrgSubInfo parentOrg : parentOrgList) {
            if (!org.getLongStructNumber().startsWith(parentOrg.getLongStructNumber())) continue;
            return true;
        }
        return false;
    }

    private static void pickRoleAdminOrgData(Map<String, List<DimValue>> roleDimValueMap, List<Long> targetStructProjectIds) {
        for (Map.Entry<String, List<DimValue>> entry : roleDimValueMap.entrySet()) {
            List adminDimValues = entry.getValue().stream().filter(dimValue -> targetStructProjectIds.contains(dimValue.getStructProjectId())).collect(Collectors.toList());
            roleDimValueMap.put(entry.getKey(), adminDimValues);
        }
    }

    private static void pickUserAdminOrgData(Map<Long, List<DimValue>> roleDimValueMap, List<Long> targetStructProjectIds) {
        for (Map.Entry<Long, List<DimValue>> entry : roleDimValueMap.entrySet()) {
            List adminDimValues = entry.getValue().stream().filter(dimValue -> targetStructProjectIds.contains(dimValue.getStructProjectId())).collect(Collectors.toList());
            roleDimValueMap.put(entry.getKey(), adminDimValues);
        }
    }

    private static List<OrgSubInfo> dim2OrgSubInfos(List<DimValue> dimValues, Map<String, DynamicObject> structLongNumberMap, Long structId) {
        ArrayList resultWithSub = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dimValues)) {
            return resultWithSub;
        }
        for (DimValue dimValue : dimValues) {
            if (!Objects.equals(dimValue.getStructProjectId(), structId)) continue;
            Long orgId = Long.parseLong(dimValue.getDimVal());
            if (Objects.equals(orgId, 0L)) {
                OrgSubInfo orgSubInfo = new OrgSubInfo(orgId, dimValue.isContainsSub());
                orgSubInfo.setLongStructNumber("");
                orgSubInfo.setStructNumber("");
                orgSubInfo.setStructProjectId(structId);
                resultWithSub.add(orgSubInfo);
                continue;
            }
            DynamicObject dyno = structLongNumberMap.get(structId + "_" + orgId);
            if (Objects.isNull(dyno) || HRStringUtils.isEmpty((String)dyno.getString("structlongnumber"))) continue;
            OrgSubInfo orgSubInfo = new OrgSubInfo(orgId, dimValue.isContainsSub());
            orgSubInfo.setLongStructNumber(dyno.getString("structlongnumber"));
            orgSubInfo.setStructNumber(dyno.getString("structnumber"));
            orgSubInfo.setStructProjectId(structId);
            resultWithSub.add(orgSubInfo);
        }
        return resultWithSub;
    }

    private static boolean isContainRootAndSub(List<Long> structFromParam, List<OrgSubInfo> hasPermOrgsWithSub) {
        if (CollectionUtils.isEmpty(hasPermOrgsWithSub)) {
            return false;
        }
        Map<Long, Long> structRootMap = OrgTeamStructProjectServiceHelper.queryStructRootOrg(structFromParam);
        for (Long structProjectId : structFromParam) {
            if (HRAdminOrgServiceHelper.isSingleStructAll(structProjectId, structRootMap.get(structProjectId), hasPermOrgsWithSub)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSingleStructAll(Long structProjectId, Long rootOrgId, List<OrgSubInfo> hasPermOrgsWithSub) {
        for (OrgSubInfo orgSubInfo : hasPermOrgsWithSub) {
            if (!Objects.equals(structProjectId, orgSubInfo.getStructProjectId()) || !orgSubInfo.isContainsSub() || !Objects.equals(orgSubInfo.getOrgId(), rootOrgId)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> queryCurStructLongNumberByStructAndOrgIds(Map<Long, List<Long>> structOrgIdsGroup) {
        QFilter structQfilter = null;
        for (Map.Entry<Long, List<Long>> entry : structOrgIdsGroup.entrySet()) {
            QFilter singleStructQfilter = new QFilter("structproject.id", "=", (Object)entry.getKey()).and(new QFilter("orgteam.id", "in", entry.getValue()));
            if (structQfilter == null) {
                structQfilter = singleStructQfilter;
                continue;
            }
            structQfilter = structQfilter.or(singleStructQfilter);
        }
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObjectCollection dynaCollection = orgHelper.queryOriginalCollection("structproject.id,orgteam.id,structlongnumber", new QFilter[]{structQfilter, currentFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynaCollection.size());
        for (DynamicObject dyna : dynaCollection) {
            result.put(dyna.getLong("structproject.id") + "#" + dyna.getLong("orgteam.id"), dyna.getString("structlongnumber"));
        }
        HRBaseServiceHelper customOrgHelper = new HRBaseServiceHelper("haos_customotstruct");
        DynamicObjectCollection customOrgCollection = customOrgHelper.queryOriginalCollection("structproject.id,orgteam.id,structlongnumber", new QFilter[]{structQfilter, currentFilter});
        for (DynamicObject dyna : customOrgCollection) {
            result.put(dyna.getLong("structproject.id") + "#" + dyna.getLong("orgteam.id"), dyna.getString("structlongnumber"));
        }
        return result;
    }
}

