/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.structcalc.CalcPermAdminStructService;
import kd.hr.hrcs.bussiness.service.perm.check.structcalc.CalcPermCommonService;
import kd.hr.hrcs.bussiness.service.perm.check.structcalc.CalcPermDependStructService;
import kd.hr.hrcs.bussiness.service.perm.check.structcalc.CalcPermNoAdminStructService;
import kd.hr.hrcs.common.constants.perm.PermissionConstants;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.OrgInfo;
import org.apache.commons.collections.CollectionUtils;

public class HRBaseOrgStructureServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRBaseOrgStructureServiceHelper.class);

    public static Set<Long> getAuthorizedOrgTeams(Map<Long, Long> mapStructProjects, List<DimValue> dimValues, Date effStartDate, Date effEndDate) {
        Map<Long, Set<Long>> mapResult = HRBaseOrgStructureServiceHelper.getAuthorizedOrgTeamsGroup(mapStructProjects, dimValues, effStartDate, effEndDate);
        if (mapResult == null) {
            return Sets.newHashSet();
        }
        HashSet setResult = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, Set<Long>> entry : mapResult.entrySet()) {
            setResult.addAll((Collection)entry.getValue());
        }
        return setResult;
    }

    public static Map<Long, Set<Long>> getAuthorizedOrgTeamsGroup(Map<Long, Long> mapStructProjects, List<DimValue> dimValues, Date effStartDate, Date effEndDate) {
        Long structId;
        if (mapStructProjects == null || mapStructProjects.isEmpty()) {
            LOGGER.info("HRDataPermService getAuthorizedOrgTeamsGroup mapStructProjects is empty,return empty.");
            return Maps.newHashMap();
        }
        if (effStartDate != null) {
            effStartDate = HRDateTimeUtils.splitYYYY_MM_DD((Date)effStartDate);
        }
        if (effEndDate != null) {
            effEndDate = HRDateTimeUtils.splitYYYY_MM_DD((Date)effEndDate);
        }
        if (effStartDate != null && effEndDate != null && effEndDate.getTime() < effStartDate.getTime()) {
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty(dimValues)) {
            return Maps.newHashMap();
        }
        Set<Long> noAdminStructProjectSet = CalcPermNoAdminStructService.getInstance().getNoAdminStructProjectSet(mapStructProjects);
        Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo = CalcPermCommonService.getInstance().getAllOrgTeamList(noAdminStructProjectSet, effStartDate, effEndDate);
        Set dimIdSet = dimValues.stream().map(it -> Long.parseLong(it.getDimVal())).collect(Collectors.toSet());
        Set<Long> structProjectSet = dimValues.stream().map(it -> it.getStructProjectId()).collect(Collectors.toSet());
        Map<Long, Boolean> structCustomMap = CalcPermCommonService.getInstance().queryStructCustom(structProjectSet);
        HashSet dimIdSetStd = Sets.newHashSetWithExpectedSize((int)16);
        HashSet dimIdSetCustom = Sets.newHashSetWithExpectedSize((int)16);
        for (DimValue dimValue : dimValues) {
            if (Objects.equals(structCustomMap.get(dimValue.getStructProjectId()), true)) {
                dimIdSetCustom.add(Long.parseLong(dimValue.getDimVal()));
                continue;
            }
            dimIdSetStd.add(Long.parseLong(dimValue.getDimVal()));
        }
        Map<String, List<OrgInfo>> dimOrgMapWithHis = CalcPermCommonService.getInstance().getOrgTeamListByBoId(dimIdSetStd, dimIdSetCustom, effStartDate, effEndDate);
        HashMap mapResult = Maps.newHashMapWithExpectedSize((int)mapStructProjects.size());
        for (Map.Entry<Long, Long> entry : mapStructProjects.entrySet()) {
            structId = entry.getKey();
            Long dependStructId = entry.getValue();
            if (structId == null || structId == 0L) continue;
            if (dependStructId == null || dependStructId == 0L || dependStructId.longValue() == structId.longValue()) {
                if (structId.longValue() == PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
                    List<OrgInfo> adminOrgInfos = CalcPermAdminStructService.getInstance().buildAdminOrgInfo(dimValues, PermissionConstants.ADMIN_STRUCT_PROJECT, PermissionConstants.ADMIN_STRUCT_PROJECT, effStartDate, effEndDate);
                    if (CollectionUtils.isEmpty(adminOrgInfos)) continue;
                    Set<Long> adminOrgIds = adminOrgInfos.stream().map(orgInfo -> orgInfo.getOrgTeamHisId()).collect(Collectors.toSet());
                    HRBaseOrgStructureServiceHelper.buildResult(mapResult, structId, adminOrgIds);
                    continue;
                }
                Set<Long> noAdminStructResult = CalcPermNoAdminStructService.getInstance().calcStructOrg(noAdminStructProjectOrgInfo, dimValues, structId, dimOrgMapWithHis);
                HRBaseOrgStructureServiceHelper.buildResult(mapResult, structId, noAdminStructResult);
                continue;
            }
            Set<Long> dependStructResult = CalcPermDependStructService.getInstance().calcDependStructOrg(noAdminStructProjectOrgInfo, dimValues, structId, dependStructId, dimOrgMapWithHis, effStartDate, effEndDate);
            HRBaseOrgStructureServiceHelper.buildResult(mapResult, structId, dependStructResult);
        }
        for (Map.Entry<Long, Long> entry : mapResult.entrySet()) {
            structId = entry.getKey();
            if (!HRBaseOrgStructureServiceHelper.isContainZero(dimValues, structId)) continue;
            ((Set)((Object)entry.getValue())).add(0L);
        }
        return mapResult;
    }

    private static boolean isContainZero(List<DimValue> dimValues, Long structId) {
        for (DimValue dimValue : dimValues) {
            if (!Objects.equals(dimValue.getStructProjectId(), structId) || !HRStringUtils.equals((String)dimValue.getDimVal(), (String)"0")) continue;
            return true;
        }
        return false;
    }

    private static void buildResult(Map<Long, Set<Long>> mapResult, Long structId, Set<Long> structOrgIds) {
        if (CollectionUtils.isEmpty(structOrgIds)) {
            return;
        }
        Set<Long> setResult = mapResult.get(structId);
        if (CollectionUtils.isEmpty(setResult)) {
            setResult = new HashSet<Long>(16);
            mapResult.put(structId, setResult);
        }
        setResult.addAll(structOrgIds);
    }
}

