/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.model.DimValueResultWithSub;
import kd.hr.hbp.common.model.DimValueSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.DimService;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.dyna.DynaCondConverter;
import kd.hr.hrcs.bussiness.service.perm.check.helper.EntityPropParser;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRDataPermServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.DimValueGroup;
import kd.hr.hrcs.common.model.RoleRuleInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;
import org.apache.commons.lang3.tuple.Pair;

public class HRBizPermServiceHelper {
    private static Log LOGGER = LogFactory.getLog(HRBizPermServiceHelper.class);

    private static String getRealPropName(String propFullKey) {
        if (!propFullKey.contains(".")) {
            return propFullKey;
        }
        String[] propKeyArr = propFullKey.split("\\.");
        return propKeyArr[propKeyArr.length - 1];
    }

    private static String getPropTargetEntityNumber(String parentEntityNumber, String propFullKey) {
        if (!propFullKey.contains(".")) {
            return null;
        }
        return EntityPropParser.getPropTargetEntityNumber(parentEntityNumber, propFullKey);
    }

    public static List<Long> getAdminOrgsByQFilter(QFilter qFilter, Boolean isEnabled) {
        QFilter[] filters;
        if (isEnabled.booleanValue()) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            filters = new QFilter[]{qFilter, enableFilter};
        } else {
            filters = new QFilter[]{qFilter};
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject[] allOrg = helper.queryOriginalArray("id", filters);
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)allOrg.length);
        for (DynamicObject dyno : allOrg) {
            orgList.add(dyno.getLong("id"));
        }
        return orgList;
    }

    public static List<Long> getAllAdminOrgs(Boolean isEnabled) {
        return HRBizPermServiceHelper.getAdminOrgsByQFilter(null, isEnabled);
    }

    public static List<Object> getAuthorizedF7Range(long userId, String appId, String entityNumber, String permItemId, String propKey) {
        DynamicObject[] f7RangeArr;
        ArrayList resultPkList = Lists.newArrayListWithExpectedSize((int)16);
        String dataRuleKey = EntityPropParser.getDataRuleFieldKey(entityNumber, propKey);
        String propEntityNumber = EntityPropParser.getPropTargetEntityNumber(entityNumber, propKey);
        if (HRStringUtils.isEmpty((String)propEntityNumber)) {
            return resultPkList;
        }
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)16);
        customParam.put("permMserviceSourceKey", "f7");
        customParam.put("propEntityNumberKey", propEntityNumber);
        QFilter dataRuleForBdPropQFilter = PermCheckService.assembleUserPermFilter4BdProp(userId, appId, entityNumber, propEntityNumber, dataRuleKey, propKey, permItemId, customParam);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(propEntityNumber);
        for (DynamicObject dyno : f7RangeArr = helper.queryOriginalArray("id", new QFilter[]{dataRuleForBdPropQFilter})) {
            resultPkList.add(dyno.get("id"));
        }
        return resultPkList;
    }

    public static QFilter assembleUserEntryDataRuleQFilter(Long userId, String appId, String entityNum, String permItemId) {
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNum, permItemId);
        Set<String> roleIdList = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<String>> roleDataRuleMap = DataRangeServiceHelperWithCache.queryRoleDataRuleWithCache(roleIdList, appId, entityNum, permItemId);
        Set<Long> userRoleRelatIdList = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Map<Long, List<String>> userDataRuleMap = DataRangeServiceHelperWithCache.queryUserDataRuleWithCache(userRoleRelatIdList, appId, entityNum, permItemId);
        ArrayList dataRuleQFilterList = Lists.newArrayListWithCapacity((int)16);
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            QFilter singleRoleQFilter = HRDataPermServiceHelper.getSingleUserRoleDataRuleQFilter(entityNum, userRoleInfo, roleDataRuleMap, userDataRuleMap);
            if (Objects.isNull(singleRoleQFilter)) {
                return null;
            }
            dataRuleQFilterList.add(singleRoleQFilter);
        }
        QFilter resultQFilter = null;
        for (QFilter qFilter : dataRuleQFilterList) {
            resultQFilter = HRPermCommonUtil.qFilterOr(resultQFilter, (QFilter)qFilter);
        }
        return resultQFilter;
    }

    public static DimValueResult getEntityDimValue(Long userId, String appId, String entityNumber, String permItemId, Long dimId) {
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNumber, permItemId);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService getEntityDimValue roleList is empty,return all.");
            return new DimValueResult(true);
        }
        if (!HRBizPermServiceHelper.haveRoleDimPropRelat(userRoleInfoList, appId, entityNumber, dimId)) {
            LOGGER.info("HRDataPermService getEntityDimValue roleDimPropRelat is empty,return all.");
            return new DimValueResult(true);
        }
        return HRBizPermServiceHelper.getEntityDimValue(userId, userRoleInfoList, null, appId, entityNumber, null, dimId);
    }

    private static boolean haveRoleDimPropRelat(List<UserRoleInfo> userRoleInfoList, String appId, String entityNumber, Long dimId) {
        Long funcId;
        Set<String> roles = userRoleInfoList.stream().map(info -> info.getRoleId()).collect(Collectors.toSet());
        Map<String, List<RoleRuleInfo>> roleDimPropRelat = DimServiceWithCache.getRoleDimPropRelatWithCache(roles, appId, entityNumber, funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber), null);
        if (CollectionUtils.isEmpty(roleDimPropRelat)) {
            return false;
        }
        boolean haveNoRelat = false;
        for (Map.Entry<String, List<RoleRuleInfo>> entry : roleDimPropRelat.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)entry.getValue())) {
                return false;
            }
            List dimRelatList = entry.getValue().stream().filter(info -> dimId.equals(info.getDimensionId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dimRelatList)) continue;
            return false;
        }
        return true;
    }

    public static DimValueResult getEntityDimValue(Long userId, List<UserRoleInfo> userRoleInfoList, Map<String, List<RoleRuleInfo>> roleDimPropRelat, String appId, String entityNumber, String propKey, Long dimId) {
        Map<Long, List<DimValue>> entityDimValue = HRBizPermServiceHelper.getEntityDimValueByRelation(userId, userRoleInfoList, roleDimPropRelat, appId, entityNumber, dimId);
        HashMap value2Obj = Maps.newHashMapWithExpectedSize((int)16);
        entityDimValue.values().forEach(dimValues -> HRBizPermServiceHelper.unionDimGrpValue(value2Obj, dimValues));
        if (CollectionUtils.isEmpty((Map)value2Obj)) {
            LOGGER.info("getEntityDimValue() result is empty.");
            return new DimValueResult(false);
        }
        ArrayList<DimValue> dimValues2 = new ArrayList<DimValue>(value2Obj.values());
        if (dimValues2.stream().anyMatch(DimValue::isAll)) {
            LOGGER.info("getEntityDimValue() match isAll.");
            return new DimValueResult(true);
        }
        if (PermCheckService.containDynaCondNotNull(dimValues2)) {
            String dimEntityNumber = DimService.getDimEntityTypeById(dimId);
            LOGGER.info("getEntityDimValue() dimValues contain DYNACOND_DIMVAL_NOTNULL_TAG return all ids.dimId:{},dimEntityNumber:{}", (Object)dimId, (Object)dimEntityNumber);
            if (HRStringUtils.isNotEmpty((String)dimEntityNumber)) {
                HRBaseServiceHelper entityServiceHelper = new HRBaseServiceHelper(dimEntityNumber);
                DynamicObjectCollection idDynaColl = entityServiceHelper.queryOriginalCollection("id", new QFilter[0]);
                Set notNullIds = idDynaColl.stream().map(dyna -> dyna.get("id").toString()).collect(Collectors.toSet());
                return new DimValueResult(false, notNullIds);
            }
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        value2Obj.values().forEach(dimValue -> {
            if (!dimValues2.isEmpty()) {
                result.add(dimValue.getDimVal());
            }
        });
        if (CollectionUtils.isEmpty((Collection)result)) {
            LOGGER.info("getEntityDimValue() doIntersect isEmpty.");
        }
        return new DimValueResult(false, (Set)result);
    }

    public static DimValueResultWithSub getEntityDimValueWithSub(Long userId, String appId, String entityNumber, String permItemId, Long dimId) {
        DimValueResultWithSub result = new DimValueResultWithSub();
        List<UserRoleInfo> userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, entityNumber, permItemId);
        if (CollectionUtils.isEmpty(userRoleInfoList)) {
            LOGGER.info("HRDataPermService getEntityDimValueWithSub roleList is empty,return all.");
            return new DimValueResultWithSub(true);
        }
        if (!HRBizPermServiceHelper.haveRoleDimPropRelat(userRoleInfoList, appId, entityNumber, dimId)) {
            LOGGER.info("HRDataPermService getEntityDimValue getEntityDimValueWithSub is empty,return all.");
            return new DimValueResultWithSub(true);
        }
        Map<Long, List<DimValue>> entityDimValue = HRBizPermServiceHelper.getEntityDimValueByRelation(userId, userRoleInfoList, null, appId, entityNumber, dimId);
        HashMap value2Obj = Maps.newHashMapWithExpectedSize((int)16);
        entityDimValue.values().forEach(dimValues -> HRBizPermServiceHelper.unionDimGrpValue(value2Obj, dimValues));
        if (CollectionUtils.isEmpty((Map)value2Obj)) {
            LOGGER.info("HRDataPermService getEntityDimValueWithSub result is empty.");
            result.setAll(false);
            return result;
        }
        ArrayList<DimValue> dimValues2 = new ArrayList<DimValue>(value2Obj.values());
        if (dimValues2.stream().anyMatch(DimValue::isAll)) {
            LOGGER.info("HRDataPermService getEntityDimValueWithSub match all.");
            result.setAll(true);
            return result;
        }
        if (PermCheckService.containDynaCondNotNull(dimValues2)) {
            String dimEntityNumber = DimService.getDimEntityTypeById(dimId);
            LOGGER.info("getEntityDimValue() dimValues contain DYNACOND_DIMVAL_NOTNULL_TAG return all ids.dimId:{},dimEntityNumber:{}", (Object)dimId, (Object)dimEntityNumber);
            if (HRStringUtils.isNotEmpty((String)dimEntityNumber)) {
                HRBaseServiceHelper entityServiceHelper = new HRBaseServiceHelper(dimEntityNumber);
                DynamicObjectCollection idDynaColl = entityServiceHelper.queryOriginalCollection("id", new QFilter[0]);
                Set notNullIds = idDynaColl.stream().map(dyna -> new DimValueSubInfo(dyna.get("id").toString(), false)).collect(Collectors.toSet());
                result.setAll(false);
                result.setDimValues(notNullIds);
                return result;
            }
        }
        HashSet subs = Sets.newHashSetWithExpectedSize((int)dimValues2.size());
        dimValues2.forEach(dimValue -> {
            if (!dimValue.isEmpty()) {
                DimValueSubInfo sub = new DimValueSubInfo();
                sub.setContainSub(dimValue.isContainsSub());
                sub.setValue(dimValue.getDimVal());
                subs.add(sub);
            }
        });
        if (CollectionUtils.isEmpty((Collection)subs)) {
            LOGGER.info("HRDataPermService getEntityDimValueWithSub doIntersect isEmpty.");
        }
        result.setAll(false);
        result.setDimValues((Set)subs);
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<Long, DimValueResult> getEntityDimValue(Long userId, List<UserRoleInfo> userRoleInfoList, String appId, String entityNumber, Long dimId) {
        Map<Long, Long> userRelatMap = userRoleInfoList.stream().collect(Collectors.toMap(UserRoleInfo::getRelatId, UserRoleInfo::getUserId, (oldValue, newValue) -> oldValue));
        Map<Long, List<DimValue>> entityDimValue1 = HRBizPermServiceHelper.getEntityDimValueByRelation(userId, userRoleInfoList, null, appId, entityNumber, dimId);
        HashMap<Long, List> map = new HashMap<Long, List>();
        for (Map.Entry<Long, List<DimValue>> item2 : entityDimValue1.entrySet()) {
            map.computeIfAbsent(userRelatMap.get(item2.getKey()), k -> new ArrayList()).addAll((Collection)item2.getValue());
        }
        return map.entrySet().stream().map(item -> {
            HashMap value2Obj = Maps.newHashMapWithExpectedSize((int)16);
            ((List)item.getValue()).forEach(dimValues -> HRBizPermServiceHelper.unionDimGrpValue(value2Obj, (List)item.getValue()));
            if (CollectionUtils.isEmpty((Map)value2Obj)) {
                LOGGER.info("getEntityDimValue() result is empty.");
                boolean isMust = HRBizPermServiceHelper.isMust(entityNumber, dimId);
                if (isMust) {
                    return Pair.of(item.getKey(), (Object)new DimValueResult(true));
                }
                return Pair.of(item.getKey(), (Object)new DimValueResult(false));
            }
            ArrayList dimValues2 = new ArrayList(value2Obj.values());
            if (dimValues2.stream().anyMatch(DimValue::isAll)) {
                LOGGER.info("getEntityDimValue() match isAll.");
                return Pair.of(item.getKey(), (Object)new DimValueResult(true));
            }
            HashSet result = Sets.newHashSetWithExpectedSize((int)16);
            value2Obj.values().forEach(dimValue -> {
                if (!dimValues2.isEmpty()) {
                    result.add(dimValue.getDimVal());
                }
            });
            if (CollectionUtils.isEmpty((Collection)result)) {
                LOGGER.info("getEntityDimValue() doIntersect isEmpty.");
            }
            return Pair.of(item.getKey(), (Object)new DimValueResult(false, (Set)result));
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue, (oldValue, newValue) -> oldValue));
    }

    public static Map<Long, List<DimValue>> getEntityDimValueByRelation(Long userId, List<UserRoleInfo> userRoleInfoList, Map<String, List<RoleRuleInfo>> roleDimPropRelat, String appId, String entityNumber, Long dimId) {
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNumber);
        HashSet roleIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet relationIds = Sets.newHashSetWithExpectedSize((int)userRoleInfoList.size());
        userRoleInfoList.forEach(userRole -> {
            roleIds.add(userRole.getRoleId());
            relationIds.add(userRole.getRelatId());
        });
        if (roleDimPropRelat == null) {
            // empty if block
        }
        Map<String, List<DimValueGroup>> roleDimGroupMap = DataRangeServiceHelperWithCache.getRoleDimValGroupWithCache(roleIds, funcId, Collections.singleton(dimId));
        LOGGER.info("HRDataPermService getEntityDimValueByRelation dimId:{},roleDimGroupMap:{}", (Object)dimId, roleDimGroupMap);
        Map<Long, List<DimValueGroup>> userRoleDimGroupMap = DataRangeServiceHelperWithCache.getUserRoleDimValGroupWithCache(relationIds, funcId, Collections.singleton(dimId));
        LOGGER.info("HRDataPermService getEntityDimValueByRelation dimId:{},userRoleDimGroupMap:{}", (Object)dimId, userRoleDimGroupMap);
        Map<Long, String> dimPropType = DimServiceWithCache.calCheckPropTypeWithCache(Sets.newHashSet((Object[])new Long[]{dimId}));
        Map<Long, DynamicObject> dynaCondMap = DynaCondConverter.getDynaCondMap();
        roleDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, roleDimGroupMap, dimPropType, dynaCondMap);
        userRoleDimGroupMap = DynaCondConverter.groupDynaCondConvert(userId, userRoleDimGroupMap, dimPropType, dynaCondMap);
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            ArrayList valueByRealtId = Lists.newArrayListWithExpectedSize((int)16);
            HRBizPermServiceHelper.assembleSingleRelateDimValue(userRoleInfo, null, roleDimGroupMap.get(userRoleInfo.getRoleId()), userRoleDimGroupMap.get(userRoleInfo.getRelatId()), valueByRealtId, dimId);
            LOGGER.info("HRDataPermService getEntityDimValueByRelation inloop single role result: dimId:{}, userRoleInfo:{},valueByRealtId:{}", new Object[]{dimId, userRoleInfo, valueByRealtId});
            result.put(userRoleInfo.getRelatId(), valueByRealtId);
        }
        return result;
    }

    private static void assembleSingleRelateDimValue(UserRoleInfo userRoleInfo, List<RoleRuleInfo> roleDimInfos, List<DimValueGroup> roleDimGroupList, List<DimValueGroup> userRoleDimGroupList, List<DimValue> result, Long dimId) {
        if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
            HashMap userValues = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(userRoleDimGroupList)) {
                userRoleDimGroupList.forEach(userRoleDimGrp -> HRBizPermServiceHelper.unionDimGrpValue(userValues, (List)userRoleDimGrp.getDimValuesMap().get(dimId)));
            }
            HashMap roleValues = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(roleDimGroupList)) {
                roleDimGroupList.forEach(roleDimGrp -> HRBizPermServiceHelper.unionDimGrpValue(roleValues, (List)roleDimGrp.getDimValuesMap().get(dimId)));
            } else {
                DimValue allDimValue = new DimValue();
                allDimValue.setAll(true);
                roleValues.put(null, allDimValue);
            }
            Set<DimValue> intersectValue = HRBizPermServiceHelper.intersectUserAndRoleDimValue(userValues, new ArrayList<DimValue>(roleValues.values()));
            LOGGER.info("HRDataPermService assembleSingleRelateDimValue() GetRoleDimValue&&UserDimValue intersectValue:{},dimId:{},userRoleInfo:{}", new Object[]{intersectValue, dimId, userRoleInfo});
            result.addAll(intersectValue);
        } else if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
            HashMap userValues = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(userRoleDimGroupList)) {
                userRoleDimGroupList.forEach(userRoleDimGrp -> HRBizPermServiceHelper.unionDimGrpValue(userValues, (List)userRoleDimGrp.getDimValuesMap().get(dimId)));
                LOGGER.info("HRDataPermService assembleSingleRelateDimValue() GetUserDimValue userValues:{},dimId:{},userRoleInfo:{}", new Object[]{userValues, dimId, userRoleInfo});
                result.addAll(userValues.values());
            }
        } else {
            HashMap roleValues = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(roleDimGroupList)) {
                roleDimGroupList.forEach(roleDimGrp -> HRBizPermServiceHelper.unionDimGrpValue(roleValues, (List)roleDimGrp.getDimValuesMap().get(dimId)));
                LOGGER.info("HRDataPermService assembleSingleRelateDimValue() GetRoleDimValue roleValues:{},dimId:{},userRoleInfo:{}", new Object[]{roleValues, dimId, userRoleInfo});
                result.addAll(roleValues.values());
            }
        }
    }

    private static void unionDimGrpValue(Map<String, DimValue> existValues, List<DimValue> newValues) {
        if (existValues.values().stream().anyMatch(DimValue::isAll) || newValues.stream().anyMatch(DimValue::isAll)) {
            existValues.clear();
            existValues.put(null, new DimValue(true));
            return;
        }
        for (DimValue newValue : newValues) {
            DimValue existValue = existValues.get(newValue.getDimVal());
            if (Objects.isNull(existValue)) {
                existValues.put(newValue.getDimVal(), newValue);
                continue;
            }
            if (existValue.equals((Object)newValue) || !newValue.isContainsSub() && !existValue.isContainsSub()) continue;
            existValue.setContainsSub(true);
        }
    }

    private static Set<DimValue> intersectUserAndRoleDimValue(Map<String, DimValue> userValues, List<DimValue> roleDimValues) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        boolean roleIsAll = roleDimValues.stream().anyMatch(DimValue::isAll);
        boolean userIsAll = userValues.values().stream().anyMatch(DimValue::isAll);
        if (userIsAll && roleIsAll) {
            result.add(new DimValue(true));
        } else if (userIsAll) {
            result.addAll(roleDimValues);
        } else if (roleIsAll) {
            result.addAll(userValues.values());
        } else {
            HRBizPermServiceHelper.doIntersect(userValues, roleDimValues, result);
        }
        return result;
    }

    private static void doIntersect(Map<String, DimValue> userValues, List<DimValue> roleDimValues, Set<DimValue> result) {
        for (DimValue roleDimValue : roleDimValues) {
            String valueKey = roleDimValue.getDimVal();
            DimValue userValue = userValues.get(valueKey);
            if (Objects.isNull(userValue)) continue;
            if (!(userValue.equals((Object)roleDimValue) || roleDimValue.isContainsSub() && userValue.isContainsSub())) {
                userValue.setContainsSub(false);
            }
            result.add(userValue);
        }
        if (CollectionUtils.isEmpty(result)) {
            result.add(new DimValue(false, null, false, true));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean isMust(String entityNumber, long dimId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject item = serviceHelper.queryOriginalOne("entryentity.ismust", new QFilter[]{new QFilter("entitytype.id", "=", (Object)entityNumber), new QFilter("entryentity.dimension.id", "=", (Object)dimId)});
        return Optional.ofNullable(item).map(it -> it.getBoolean("entryentity.ismust")).orElse(Boolean.FALSE);
    }
}

