/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DataRangeServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.UserRoleServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.helper.EntityPropParser;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBaseOrgServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.constants.perm.PermOrgConst;
import kd.hr.hrcs.common.model.OrgInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;
import kd.hr.hrcs.common.util.LoggerStrUtil;

public class HRDataPermServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRDataPermServiceHelper.class);

    @ExcludeFromJacocoGeneratedReport
    public static Set<Long> getSubAdminOrgList(Set<Long> orgIds, Boolean isEnabled) {
        QFilter[] filters;
        QFilter orgIdFilter = new QFilter("adminorg.id", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] longNumberDys = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").query("structlongnumber", new QFilter[]{orgIdFilter, currentFilter, dataStatusFilter});
        HashSet subOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        if (Objects.isNull(longNumberDys) || longNumberDys.length == 0) {
            return subOrgIds;
        }
        HRDataPermServiceHelper.initLongNumberParams(orgIdFilter, longNumberDys);
        if (isEnabled.booleanValue()) {
            QFilter enableFilter = new QFilter("adminorg.enable", "=", (Object)"1");
            filters = new QFilter[]{orgIdFilter, enableFilter, currentFilter};
        } else {
            filters = new QFilter[]{orgIdFilter, currentFilter};
        }
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("adminorg.id adminorg", filters, null);
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            subOrgIds.add(((DynamicObject)dyColl.get(i)).getLong("adminorg"));
        }
        return subOrgIds;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<Long> getSubAdminOrgList(Set<Long> orgIds, Date bsedTime, Date bsledTime) {
        List<OrgInfo> orgList = HRDataPermServiceHelper.getOrgTeamList(orgIds, false, Lists.newArrayList((Object[])new Long[]{PermOrgConst.ADMIN_STRUCT_PROJECT_ID}));
        Set<Long> orgIdSet = orgList.stream().map(OrgInfo::getOrgTeamHisId).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(orgIdSet)) {
            List<OrgInfo> subList = HRDataPermServiceHelper.getOrgTeamList(orgIdSet, true, Lists.newArrayList((Object[])new Long[]{PermOrgConst.ADMIN_STRUCT_PROJECT_ID}));
            return subList.stream().map(it -> HRBaseOrgServiceHelper.getOtOrgId(it, bsedTime, bsledTime)).filter(it -> !it.equals(0L)).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public static Set<Long> getOrgTeamList(Set<Long> allOrgs, Set<Long> orgIds, Long orgTypeId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter orgIdFilter = new QFilter("orgteam.id", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] longNumberDys = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgIdFilter, currentFilter, dataStatusFilter});
        Set orgTeamSet = null;
        if (Objects.nonNull(longNumberDys) && longNumberDys.length > 0) {
            HRDataPermServiceHelper.initLongNumberParams(orgIdFilter, longNumberDys);
            DynamicObjectCollection dyColl = serviceHelper.queryOriginalCollection("orgteam.id orgteam", new QFilter[]{orgIdFilter}, null);
            orgTeamSet = dyColl.stream().map(el -> el.getLong("orgteam")).collect(Collectors.toSet());
        }
        Optional.ofNullable(orgTeamSet).ifPresent(allOrgs::addAll);
        DynamicObject[] orgColl = new HRBaseServiceHelper("haos_adminorgteam").queryOriginalArray("id", new QFilter[]{new QFilter("id", "in", allOrgs), new QFilter("orgtype", "=", (Object)orgTypeId)});
        return Arrays.stream(orgColl).map(el -> el.getLong("id")).collect(Collectors.toSet());
    }

    public static List<OrgInfo> getOrgTeamList(Set<Long> orgIdSet, boolean isContainSub, List<Long> structProjectList) {
        DynamicObject[] longNumberDys;
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return Lists.newArrayList();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter orgIdFilter = new QFilter("orgteam.id", "in", orgIdSet);
        if (isContainSub && Objects.nonNull(longNumberDys = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgIdFilter})) && longNumberDys.length > 0) {
            HRDataPermServiceHelper.initLongNumberParams(orgIdFilter, longNumberDys);
        }
        if (!CollectionUtils.isEmpty(structProjectList)) {
            orgIdFilter.and(new QFilter("structproject", "in", structProjectList));
        }
        DynamicObjectCollection dyColl = serviceHelper.queryOriginalCollection("orgteam.id orgteam,parentorgteam parent,orgteam.otclassify.id otclassify,bsed,bsled,orgteamhisid, structlongnumber", new QFilter[]{orgIdFilter}, null);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        for (DynamicObject dyn : dyColl) {
            OrgInfo orgInfo = new OrgInfo(Long.valueOf(dyn.getLong("orgteam")), Long.valueOf(dyn.getLong("parent")), Long.valueOf(dyn.getLong("otclassify")), dyn.getString("structlongnumber"));
            orgInfo.setOrgTeamHisId(Long.valueOf(dyn.getLong("orgteamhisid")));
            orgInfo.setBsedTime(dyn.getDate("bsed"));
            orgInfo.setBsledTime(dyn.getDate("bsled"));
            result.add(orgInfo);
        }
        return result;
    }

    private static void initLongNumberParams(QFilter orgIdFilter, DynamicObject[] longNumberDys) {
        List longNumList = Arrays.stream(longNumberDys).map(it -> it.getString("structlongnumber")).sorted().collect(Collectors.toList());
        LOGGER.info("initLongNumberParams_before,count:{}", (Object)longNumList.size());
        HashSet longNumSet = Sets.newHashSetWithExpectedSize((int)longNumberDys.length);
        for (String longNumber : longNumList) {
            if (!HRStringUtils.isNotEmpty((String)longNumber)) continue;
            if (!longNumSet.stream().noneMatch(longNumber::startsWith)) continue;
            longNumSet.add(longNumber);
        }
        if (longNumSet.size() > 0) {
            LOGGER.info("initLongNumberParams_after,count:{}", (Object)longNumSet.size());
            for (String longNum : longNumSet) {
                QFilter longNumberFilter = new QFilter("structlongnumber", "like", (Object)(longNum + "!" + "%"));
                orgIdFilter.or(longNumberFilter);
            }
        }
    }

    public static Map<Long, QFilter> assembleUserEntryDataRuleQFilter(Long userId, String appId, String entityNum, String permItemId, List<UserRoleInfo> userRoleInfoList) {
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleQFilter, appId:{},entityNum:{},permItemId:{}", new Object[]{appId, entityNum, permItemId});
        Set<String> roleIdList = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<String>> roleDataRuleMap = DataRangeServiceHelperWithCache.queryRoleDataRuleWithCache(roleIdList, appId, entityNum, permItemId);
        Set<Long> userRoleRelatIdList = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Map<Long, List<String>> userDataRuleMap = DataRangeServiceHelperWithCache.queryUserDataRuleWithCache(userRoleRelatIdList, appId, entityNum, permItemId);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleQFilter, role id:{}", roleIdList);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleQFilter, userRoleInfoList id:{}", userRoleInfoList);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleQFilter, roleDataRuleMap:{}", roleDataRuleMap);
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleQFilter, userDataRuleMap:{}", userDataRuleMap);
        HashMap ruleQfilterMap = Maps.newHashMapWithExpectedSize((int)userRoleInfoList.size());
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            QFilter singleRoleQFilter = HRDataPermServiceHelper.getSingleUserRoleDataRuleQFilter(entityNum, userRoleInfo, roleDataRuleMap, userDataRuleMap);
            ruleQfilterMap.put(userRoleInfo.getRelatId(), singleRoleQFilter);
        }
        LOGGER.info("HRDataPermService assembleUserEntryDataRuleQFilter resultQFilterMap:{}", (Object)LoggerStrUtil.mapToString((Map)ruleQfilterMap));
        return ruleQfilterMap;
    }

    public static QFilter getSingleUserRoleDataRuleQFilter(String entityNum, UserRoleInfo userRoleInfo, Map<String, List<String>> roleDataRuleMap, Map<Long, List<String>> userDataRuleMap) {
        QFilter singleRoleQFilter = null;
        if (userRoleInfo.getCustomenable() && userRoleInfo.isDataIntersection()) {
            List<String> userRuleList = userDataRuleMap.get(userRoleInfo.getRelatId());
            singleRoleQFilter = HRDataPermServiceHelper.getDataRuleQFilter(entityNum, userRuleList);
            List<String> roleRuleList = roleDataRuleMap.get(userRoleInfo.getRoleId());
            singleRoleQFilter = HRPermCommonUtil.qFilterAnd((QFilter)singleRoleQFilter, (QFilter)HRDataPermServiceHelper.getDataRuleQFilter(entityNum, roleRuleList));
        } else if (userRoleInfo.getCustomenable() && !userRoleInfo.isDataIntersection()) {
            List<String> userRuleList = userDataRuleMap.get(userRoleInfo.getRelatId());
            singleRoleQFilter = HRDataPermServiceHelper.getDataRuleQFilter(entityNum, userRuleList);
        } else {
            List<String> roleRuleList = roleDataRuleMap.get(userRoleInfo.getRoleId());
            singleRoleQFilter = HRDataPermServiceHelper.getDataRuleQFilter(entityNum, roleRuleList);
        }
        return singleRoleQFilter;
    }

    private static QFilter getDataRuleQFilter(String entityNum, List<String> roleDataRuleList) {
        if (CollectionUtils.isEmpty(roleDataRuleList)) {
            return null;
        }
        QFilter dataRuleQFilter = null;
        for (String dataRule : roleDataRuleList) {
            if (null == dataRuleQFilter) {
                dataRuleQFilter = HRDataPermServiceHelper.convertJsonToQFilter(entityNum, dataRule);
                continue;
            }
            dataRuleQFilter.or(HRDataPermServiceHelper.convertJsonToQFilter(entityNum, dataRule));
        }
        return dataRuleQFilter;
    }

    private static QFilter convertJsonToQFilter(String entityId, String dataRuleJson) {
        if (HRStringUtils.isEmpty((String)dataRuleJson)) {
            return null;
        }
        return HRPermCommonUtil.getQFilterFromFilterCondition((String)entityId, (String)dataRuleJson);
    }

    public static Map<Long, QFilter> assembleUserBaseDataDataRuleQFilter(Long userId, String appId, String parentEntityNumber, String entityNum, String propKey, String permItemId) {
        List<UserRoleInfo> userRoleInfoList = null;
        if (!HRStringUtils.equals((String)"47150e89000000ac", (String)permItemId)) {
            permItemId = "47156aff000000ac";
            userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, parentEntityNumber, permItemId);
            if (CollectionUtils.isEmpty(userRoleInfoList)) {
                permItemId = "4715a0df000000ac";
                userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, parentEntityNumber, permItemId);
            }
        } else {
            userRoleInfoList = UserRoleServiceHelperWithCache.queryUserRoleSetWithCache(userId, appId, parentEntityNumber, permItemId);
        }
        Set<String> roleIdList = userRoleInfoList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Map<String, List<String>> roleDataRuleMap = DataRangeServiceHelperWithCache.getRoleBDDataRuleJsonWithCache(roleIdList, parentEntityNumber, propKey, appId);
        Set<Long> userRoleRelatIdList = userRoleInfoList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        Map<Long, List<String>> userDataRuleMap = DataRangeServiceHelperWithCache.getUserDBDataRuleJsonWithCache(userRoleRelatIdList, parentEntityNumber, propKey, appId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getDataRuleForBdProp assembleUserBaseDataDataRuleQFilter params roleIdList={}, userRoleRelatIdList={}:", roleIdList, userRoleRelatIdList);
            LOGGER.info("getDataRuleForBdProp assembleUserBaseDataDataRuleQFilter role dataRule :{}", roleDataRuleMap);
            LOGGER.info("getDataRuleForBdProp assembleUserBaseDataDataRuleQFilter user dataRule :{}", userDataRuleMap);
        }
        HashMap dataRuleMap = Maps.newHashMapWithExpectedSize((int)userRoleInfoList.size());
        for (UserRoleInfo userRoleInfo : userRoleInfoList) {
            QFilter singleRoleQFilter = HRDataPermServiceHelper.getSingleUserRoleDataRuleQFilter(entityNum, userRoleInfo, roleDataRuleMap, userDataRuleMap);
            dataRuleMap.put(userRoleInfo.getRelatId(), singleRoleQFilter);
        }
        LOGGER.info("getDataRuleForBdProp assembleUserBaseDataDataRuleQFilter result dataRule:{}", (Object)dataRuleMap);
        return dataRuleMap;
    }

    public static List<String> queryUserDataRulePKValues(List<Object> pkIdList, String entityId, QFilter dataRule) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (entityType instanceof QueryEntityType) {
            QueryEntityType queryEntityType = (QueryEntityType)entityType;
            try (DataSet ds = queryEntityType.getQueryDataSet("id", new QFilter[]{dataRule, new QFilter("id", "in", pkIdList)}, null);){
                DynamicObjectCollection queryCollection = ORM.create().toPlainDynamicObjectCollection(ds);
                List<String> list = queryCollection.stream().map(dym -> dym.getString("id")).collect(Collectors.toList());
                return list;
            }
        }
        HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper(entityId);
        DynamicObject[] dynamicObjects = userDataRuleHelper.queryOriginalArray("id", new QFilter[]{dataRule, new QFilter("id", "in", pkIdList)});
        return Arrays.stream(dynamicObjects).map(dym -> dym.getString("id")).collect(Collectors.toList());
    }

    public static List<String> queryExistedDataId(List<Object> pkIdList, String entityId) {
        HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper(entityId);
        DynamicObject[] dynamicObjects = userDataRuleHelper.queryOriginalArray("id", new QFilter[]{new QFilter("id", "in", pkIdList)});
        return Arrays.stream(dynamicObjects).map(dym -> dym.getString("id")).collect(Collectors.toList());
    }

    public static List<Object> paramQFilterToList(QFilter qfilter) {
        Object value = qfilter.getValue();
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)16);
        if (value.getClass().isArray()) {
            Object[] valueArr = (Object[])value;
            resultList.addAll(Arrays.asList(valueArr));
        } else if (value instanceof List) {
            List valueList = (List)value;
            resultList.addAll(valueList);
        } else {
            resultList.add(value);
        }
        return resultList;
    }

    public static String trimDataPermPropKey(String fullPropKey) {
        if (HRStringUtils.isEmpty((String)fullPropKey)) {
            return fullPropKey;
        }
        String dealedPropFullKey = EntityPropParser.trimMultiBasedata(fullPropKey);
        if (HRStringUtils.isEmpty((String)dealedPropFullKey)) {
            return fullPropKey;
        }
        dealedPropFullKey = EntityPropParser.trimLastNameAndNumberProperty(dealedPropFullKey);
        return dealedPropFullKey;
    }
}

