/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.Conditional;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DynamicFormHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.FieldControlRuleModel;
import kd.hr.hrcs.common.model.FieldPerm;
import kd.hr.hrcs.common.model.UserRoleInfo;

public class HRFieldPermServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRFieldPermServiceHelper.class);
    private static final String BU_FUNC_ID = "bucafunc";
    private static final HRBaseServiceHelper USERROLESERVICEHELPER = new HRBaseServiceHelper("hrcs_userrole");
    private static final HRBaseServiceHelper USERROLERELATSERVICEHELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper ROLESERVICEHELPER = new HRBaseServiceHelper("hrcs_role");
    private static final HRBaseServiceHelper BUCAFUNCSERVICEHELPER = new HRBaseServiceHelper("bos_org_structure");
    private static final HRBaseServiceHelper ROLEFIELDSERVICEHELPER = new HRBaseServiceHelper("hrcs_rolefield");
    private static final HRBaseServiceHelper USERFIELDSERVICEHELPER = new HRBaseServiceHelper("hrcs_userfield");
    private static final HRBaseServiceHelper PERMROLEPERMSERVICEHELPER = new HRBaseServiceHelper("perm_roleperm");
    private static final HRBaseServiceHelper PERMROLESERVICEHELPER = new HRBaseServiceHelper("perm_role");
    private static final String ROLE_ID = "role.id";
    private static final String USERROLEREALT_ID = "userrolerealt.id";
    private static final String FIELDNAME = "fieldname";
    private static final String ISBANREAD = "isbanread";
    private static final String ISBANWRITE = "isbanwrite";

    public static FieldControlRule getFieldControlRule(String appId, String entityNum, Long userId, Long orgId) {
        List roleIdList = Arrays.stream(PERMROLEPERMSERVICEHELPER.query("roleid.id", new QFilter[]{new QFilter("roleperm.bizapp", "=", (Object)appId), new QFilter("roleperm.entity", "=", (Object)entityNum)})).map(role -> role.getString("roleid.id")).collect(Collectors.toList());
        List<String> filterRoleIdList = Arrays.stream(PERMROLESERVICEHELPER.query("id", new QFilter[]{new QFilter("id", "in", roleIdList), new QFilter("enable", "=", (Object)Character.valueOf('1'))})).map(role -> role.getString("id")).collect(Collectors.toList());
        return HRFieldPermServiceHelper.getFieldControlRule(appId, entityNum, userId, orgId, filterRoleIdList);
    }

    private static FieldControlRule getFieldControlRule(String appid, String entityNum, Long userId, Long orgId, List<String> roleIdList) {
        List<DynamicObject> filterUserRoleRealtList = HRFieldPermServiceHelper.listUserRoleRealt(userId, new Date(), roleIdList);
        List<DynamicObject> filterUserRoleList = HRFieldPermServiceHelper.listUserRole(filterUserRoleRealtList.stream().map(role -> role.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> roleList = HRFieldPermServiceHelper.listRole(filterUserRoleRealtList.stream().map(userRoleRealt -> userRoleRealt.getString(ROLE_ID)).collect(Collectors.toList()));
        Map<Long, List<DynamicObject>> userRoletMap = filterUserRoleList.stream().collect(Collectors.groupingBy(userRole -> (Long)userRole.get(USERROLEREALT_ID)));
        Map<String, Boolean> intersectionMap = roleList.stream().collect(Collectors.toMap(role -> role.getString("id"), role -> "1".equals(role.getString("isintersection"))));
        List<FieldControlRuleModel> modelList = HRFieldPermServiceHelper.listFieldControlRuleModel(filterUserRoleRealtList, userRoletMap, intersectionMap);
        HRFieldPermServiceHelper.addBucafuncId(filterUserRoleList, modelList);
        List<DynamicObject> sonBuList = HRFieldPermServiceHelper.listSonBu(filterUserRoleList.stream().filter(userRole -> userRole.getBoolean("includesuborg")).map(userRole -> userRole.getLong(BU_FUNC_ID)).collect(Collectors.toList()));
        HRFieldPermServiceHelper.addSonBu(modelList, sonBuList);
        List<FieldControlRuleModel> newModelList = modelList.stream().filter(model -> model.getBuList().contains(orgId)).collect(Collectors.toList());
        HRFieldPermServiceHelper.handleModelList(appid, entityNum, newModelList);
        return HRFieldPermServiceHelper.getFieldControlRule(newModelList);
    }

    private static void handleModelList(String appid, String entityNum, List<FieldControlRuleModel> modelList) {
        List customenableAndIntersectionList = modelList.stream().filter(model -> model.getCustomenable() != false && model.getIsintersection() != false).collect(Collectors.toList());
        List customenableAndUntersectionList = modelList.stream().filter(model -> model.getCustomenable() != false && model.getIsintersection() == false).collect(Collectors.toList());
        List unCustomnableList = modelList.stream().filter(model -> model.getCustomenable() == false).collect(Collectors.toList());
        Map<Object, List<DynamicObject>> unCustomnableRoleMap = HRFieldPermServiceHelper.listRoleField(appid, unCustomnableList.stream().map(FieldControlRuleModel::getRoleId).collect(Collectors.toList()), entityNum).stream().collect(Collectors.groupingBy(role -> role.getString(ROLE_ID)));
        Map<Object, List<DynamicObject>> customenableAndUntersectionMap = HRFieldPermServiceHelper.listUserField(appid, customenableAndUntersectionList.stream().map(FieldControlRuleModel::getUserRoleRealtId).collect(Collectors.toList()), entityNum).stream().collect(Collectors.groupingBy(role -> role.getLong(USERROLEREALT_ID)));
        Map<Object, List<DynamicObject>> customenableAndIntersectionRoleMap = HRFieldPermServiceHelper.listRoleField(appid, customenableAndIntersectionList.stream().map(FieldControlRuleModel::getRoleId).collect(Collectors.toList()), entityNum).stream().collect(Collectors.groupingBy(role -> role.getString(ROLE_ID)));
        Map<Object, List<DynamicObject>> customenableAndIntersectionUserRoleMap = HRFieldPermServiceHelper.listUserField(appid, customenableAndIntersectionList.stream().map(FieldControlRuleModel::getUserRoleRealtId).collect(Collectors.toList()), entityNum).stream().collect(Collectors.groupingBy(role -> role.getLong(USERROLEREALT_ID)));
        HRFieldPermServiceHelper.handleModelListByField(unCustomnableRoleMap, modelList, true);
        HRFieldPermServiceHelper.handleModelListByField(customenableAndUntersectionMap, modelList, false);
        HRFieldPermServiceHelper.handleModelListByField(customenableAndIntersectionRoleMap, customenableAndIntersectionUserRoleMap, modelList);
    }

    private static void handleModelListByField(Map<Object, List<DynamicObject>> fieldMap, List<FieldControlRuleModel> modelList, boolean isRole) {
        modelList.forEach(model -> {
            Object key = isRole ? model.getRoleId() : model.getUserRoleRealtId();
            String entryentityKey = isRole ? "fieldpermentry" : "entryentity";
            List roleList = (List)fieldMap.get(key);
            if (roleList != null) {
                HashSet canNotReadFields = Sets.newHashSetWithExpectedSize((int)modelList.size());
                HashSet canNotWriteFields = Sets.newHashSetWithExpectedSize((int)modelList.size());
                roleList.forEach(role -> role.getDynamicObjectCollection(entryentityKey).forEach(enryentity -> {
                    String fieldName = enryentity.getString(FIELDNAME);
                    if (enryentity.getBoolean(ISBANREAD)) {
                        canNotReadFields.add(fieldName);
                    }
                    if (enryentity.getBoolean(ISBANWRITE)) {
                        canNotWriteFields.add(fieldName);
                    }
                }));
                model.setCanNotReadFields((Set)canNotReadFields);
                model.setCanNotWriteFields((Set)canNotWriteFields);
            }
        });
    }

    private static void handleModelListByField(Map<Object, List<DynamicObject>> roleFieldMap, Map<Object, List<DynamicObject>> userRoleFieldMap, List<FieldControlRuleModel> modelList) {
        modelList.forEach(model -> {
            List roleList = (List)roleFieldMap.get(model.getRoleId());
            List userRoleList = (List)userRoleFieldMap.get(model.getUserRoleRealtId());
            if (Conditional.getNew(() -> Optional.ofNullable(roleList).isPresent()).and(() -> Optional.ofNullable(userRoleList).isPresent()).getValue()) {
                HashSet canNotReadFields = Sets.newHashSetWithExpectedSize((int)modelList.size());
                HashSet canNotWriteFields = Sets.newHashSetWithExpectedSize((int)modelList.size());
                HashMap intersectionMap = Maps.newHashMapWithExpectedSize((int)roleList.size());
                roleList.forEach(role -> role.getDynamicObjectCollection("fieldpermentry").forEach(fieldpermentry -> {
                    String fieldName = fieldpermentry.getString(FIELDNAME);
                    HashMap banMap = Maps.newHashMapWithExpectedSize((int)2);
                    banMap.put(ISBANREAD, fieldpermentry.getBoolean(ISBANREAD));
                    banMap.put(ISBANWRITE, fieldpermentry.getBoolean(ISBANWRITE));
                    intersectionMap.put(fieldName, banMap);
                }));
                userRoleList.forEach(userRole -> userRole.getDynamicObjectCollection("entryentity").forEach(entryentity -> {
                    String fieldName = entryentity.getString(FIELDNAME);
                    Map banMap = (Map)intersectionMap.get(fieldName);
                    Optional.ofNullable(banMap).ifPresent(map -> {
                        if (Conditional.getNew(() -> (Boolean)map.get(ISBANREAD)).and(() -> entryentity.getBoolean(ISBANREAD)).getValue()) {
                            canNotReadFields.add(fieldName);
                        }
                        if (Conditional.getNew(() -> (Boolean)map.get(ISBANWRITE)).and(() -> entryentity.getBoolean(ISBANWRITE)).getValue()) {
                            canNotWriteFields.add(fieldName);
                        }
                    });
                }));
                model.setCanNotReadFields((Set)canNotReadFields);
                model.setCanNotWriteFields((Set)canNotWriteFields);
            }
        });
    }

    private static FieldControlRule getFieldControlRule(List<FieldControlRuleModel> modelList) {
        HashSet canNotReadFields = Sets.newHashSetWithExpectedSize((int)modelList.size());
        HashSet canNotWriteFields = Sets.newHashSetWithExpectedSize((int)modelList.size());
        modelList.forEach(model -> {
            Set canNotWriteFieldSet;
            Set canNotReadFieldSet = model.getCanNotReadFields() == null ? Sets.newHashSetWithExpectedSize((int)modelList.size()) : model.getCanNotReadFields();
            Set set = canNotWriteFieldSet = model.getCanNotWriteFields() == null ? Sets.newHashSetWithExpectedSize((int)modelList.size()) : model.getCanNotWriteFields();
            if (canNotReadFields.isEmpty() && !canNotReadFieldSet.isEmpty()) {
                canNotReadFields.addAll(canNotReadFieldSet);
            }
            if (canNotWriteFields.isEmpty() && !canNotWriteFieldSet.isEmpty()) {
                canNotWriteFields.addAll(canNotWriteFieldSet);
            }
            canNotReadFields.removeAll(canNotReadFields.stream().filter(canNotReadField -> !canNotReadFieldSet.contains(canNotReadField)).collect(Collectors.toSet()));
            canNotWriteFields.removeAll(canNotWriteFields.stream().filter(canNotWriteField -> !canNotWriteFieldSet.contains(canNotWriteField)).collect(Collectors.toSet()));
        });
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadFields((Set)canNotReadFields);
        fieldControlRule.setCanNotWriteFields((Set)canNotWriteFields);
        return fieldControlRule;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<FieldControlRuleModel> listFieldControlRuleModel(List<DynamicObject> filterUserRoleRealtList, Map<Long, List<DynamicObject>> userRoletMap, Map<String, Boolean> intersectionMap) {
        return filterUserRoleRealtList.stream().map(userRoleRealt -> {
            FieldControlRuleModel fieldControlRuleModel = new FieldControlRuleModel();
            fieldControlRuleModel.setUserRoleRealtId(Long.valueOf(userRoleRealt.getLong("id")));
            fieldControlRuleModel.setRoleId(userRoleRealt.getString(ROLE_ID));
            fieldControlRuleModel.setBuList((List)Lists.newArrayListWithExpectedSize((int)userRoletMap.size()));
            fieldControlRuleModel.setBucafuncIdSet((Set)Sets.newHashSetWithExpectedSize((int)userRoletMap.size()));
            Optional.ofNullable(userRoletMap.get(fieldControlRuleModel.getUserRoleRealtId())).ifPresent(userRoleRealts -> fieldControlRuleModel.setBuList(userRoleRealts.stream().map(userRole -> userRole.getLong("org.id")).collect(Collectors.toList())));
            fieldControlRuleModel.setIsintersection((Boolean)intersectionMap.get(fieldControlRuleModel.getRoleId()));
            fieldControlRuleModel.setCustomenable(Boolean.valueOf("1".equals(userRoleRealt.getString("customenable"))));
            return fieldControlRuleModel;
        }).collect(Collectors.toList());
    }

    private static void addBucafuncId(List<DynamicObject> filterUserRoleList, List<FieldControlRuleModel> modelList) {
        filterUserRoleList.stream().filter(userRole -> userRole.getBoolean("includesuborg")).collect(Collectors.groupingBy(userRole -> (Long)userRole.get(USERROLEREALT_ID))).forEach((key, value) -> modelList.stream().filter(model -> key.equals(model.getUserRoleRealtId())).findAny().ifPresent(model -> model.setBucafuncIdSet(value.stream().map(userRole -> (Long)userRole.get(BU_FUNC_ID)).collect(Collectors.toSet()))));
    }

    private static void addSonBu(List<FieldControlRuleModel> modelList, List<DynamicObject> sonBuList) {
        modelList.forEach(model -> model.getBuList().addAll(sonBuList.stream().filter(sonBu -> model.getBucafuncIdSet().contains(sonBu.getLong("view.id"))).map(sonBu -> sonBu.getLong("org.id")).collect(Collectors.toList())));
    }

    private static List<DynamicObject> listSonBu(List<Long> bucafuncIdlist) {
        return Lists.newArrayList((Object[])BUCAFUNCSERVICEHELPER.query("id,view,org", new QFilter[]{new QFilter("view", "in", bucafuncIdlist)}));
    }

    private static List<DynamicObject> listRoleField(String appid, List<String> roleIdList, String entityNum) {
        return Lists.newArrayList((Object[])ROLEFIELDSERVICEHELPER.query("id,role,entitytype,fieldpermentry,fieldpermentry.fieldname,fieldpermentry.isbanread,fieldpermentry.isbanwrite", new QFilter[]{new QFilter(ROLE_ID, "in", roleIdList), new QFilter("app.id", "=", (Object)appid), new QFilter("entitytype", "=", (Object)entityNum)}));
    }

    private static List<DynamicObject> listUserField(String appid, List<Long> userrolerealtIdList, String entityNum) {
        return Lists.newArrayList((Object[])USERFIELDSERVICEHELPER.query("id,userrolerealt,entitytype,entryentity,entryentity.fieldname,entryentity.isbanread,entryentity.isbanwrite", new QFilter[]{new QFilter(USERROLEREALT_ID, "in", userrolerealtIdList), new QFilter("app.id", "=", (Object)appid), new QFilter("entitytype", "=", (Object)entityNum)}));
    }

    private static List<DynamicObject> listUserRoleRealt(Long userId, Date nowDate, List<String> roleIdList) {
        return Lists.newArrayList((Object[])USERROLERELATSERVICEHELPER.query("id,role,customenable", new QFilter[]{new QFilter("user.id", "=", (Object)userId), new QFilter(ROLE_ID, "in", roleIdList), new QFilter("validstart", "<=", (Object)nowDate), new QFilter("validend", ">=", (Object)nowDate)}));
    }

    private static List<DynamicObject> listUserRole(List<Long> userrolerealtIdList) {
        return Lists.newArrayList((Object[])USERROLESERVICEHELPER.query("org,includesuborg,userrolerealt,bucafunc", new QFilter[]{new QFilter(USERROLEREALT_ID, "in", userrolerealtIdList)}));
    }

    private static List<DynamicObject> listRole(List<String> idList) {
        return Lists.newArrayList((Object[])ROLESERVICEHELPER.query("id,isintersection", new QFilter[]{new QFilter("id", "in", idList)}));
    }

    private static String getDataDimensionField(String entityNum) {
        PermissionControlType permissionControlType;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        if (dataEntityType == null) {
            return null;
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (HRStringUtils.isEmpty((String)mainOrg) && (permissionControlType = dataEntityType.getPermissionControlType()) != null && HRStringUtils.equals((String)"DIM_ORG", (String)permissionControlType.getDimension())) {
            mainOrg = permissionControlType.getDataDimensionField();
        }
        return mainOrg;
    }

    public static FieldControlRules getFieldControlRules(long userId, String appId, String entityNum) {
        String mainOrg = HRFieldPermServiceHelper.getDataDimensionField(entityNum);
        boolean isDynaForm = DynamicFormHelper.isDynamicFormOrReport(entityNum);
        if (HRStringUtils.isEmpty((String)mainOrg) && !isDynaForm) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("getFieldControlRules no mainOrg entity ");
            }
            return HRFieldPermServiceHelper.getFieldControlRules(HRFieldPermServiceHelper.getFieldRulesWithoutMainOrg(userId, appId, entityNum));
        }
        Long funcId = DimServiceWithCache.getCheckFuncIdWithCache(appId, entityNum);
        String permOrgFuncId = funcId.toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getFieldControlRules have mainOrg entity, permOrgFuncId:{}", (Object)permOrgFuncId);
        }
        return HRFieldPermServiceHelper.getFieldRulesWithMainOrg(userId, appId, entityNum, permOrgFuncId);
    }

    private static FieldControlRules getFieldRulesWithMainOrg(long userId, String appId, String entityNum, String permOrgFuncId) {
        DynamicObject[] subOrgDynArrays;
        List<UserRoleInfo> userRoleList = HRFieldPermServiceHelper.queryUserRoleInfoByEntityNum(userId, appId, entityNum);
        Set<String> roleIdSet = userRoleList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Set<Long> userRoleRelateIdList = userRoleList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        FieldPerm roleFieldPerm = HRFieldPermServiceHelper.getRoleFieldPerm(appId, entityNum, roleIdSet);
        FieldPerm userFiledPerm = HRFieldPermServiceHelper.getUserFiledPerm(appId, entityNum, userRoleRelateIdList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getFieldControlRules getFieldRulesWithMainOrg roleIdSet:{}", roleIdSet);
            LOGGER.info("getFieldControlRules getFieldRulesWithMainOrg userRoleRelateIdList:{}", userRoleRelateIdList);
            LOGGER.info("getFieldControlRules getFieldRulesWithMainOrg roleFieldPerm:{}", (Object)roleFieldPerm);
            LOGGER.info("getFieldControlRules getFieldRulesWithMainOrg userFiledPerm:{}", (Object)userFiledPerm);
        }
        DynamicObject[] userRoleBu = HRFieldPermServiceHelper.getUserRoleBu(userRoleRelateIdList, Long.parseLong(permOrgFuncId));
        HashMap buUserRoleMap = Maps.newHashMapWithExpectedSize((int)userRoleBu.length);
        HashMap buFunRoleMap = Maps.newHashMapWithExpectedSize((int)userRoleBu.length);
        ArrayList buFuncList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList parentOrgList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject userRole : userRoleBu) {
            Long userRoleId = userRole.getLong(USERROLEREALT_ID);
            buUserRoleMap.computeIfAbsent(userRole.getLong("org.id"), key -> new HashSet(16)).add(userRoleId);
            Long buFunViewId = userRole.getLong(BU_FUNC_ID);
            buFunRoleMap.computeIfAbsent(buFunViewId, key -> new HashSet(16)).add(userRoleId);
            boolean includeSubOrg = userRole.getBoolean("includesuborg");
            if (!includeSubOrg) continue;
            buFuncList.add(userRole.getLong(BU_FUNC_ID));
            parentOrgList.add(userRole.getLong("org.id"));
        }
        for (DynamicObject org : subOrgDynArrays = HRFieldPermServiceHelper.getBuSubSons(buFuncList, parentOrgList)) {
            buUserRoleMap.computeIfAbsent(org.getLong("org"), key -> new HashSet(16)).addAll((Collection)buFunRoleMap.get(org.getLong("view")));
        }
        LOGGER.info("getFieldControlRules getFieldRulesWithMainOrg buFunRoleMap:{}", (Object)buFunRoleMap);
        return HRFieldPermServiceHelper.getFieldControlRules(userRoleList, roleFieldPerm, userFiledPerm, buUserRoleMap);
    }

    private static FieldControlRules getFieldControlRules(List<UserRoleInfo> userRoleList, FieldPerm roleFieldPerm, FieldPerm userFiledPerm, Map<Long, Set<Long>> buUserRoleMap) {
        FieldControlRules fieldControlRules = new FieldControlRules();
        ArrayList fieldControlRuleDtoList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<Long, Set<Long>> buEntry : buUserRoleMap.entrySet()) {
            List<UserRoleInfo> userRoleInfos = userRoleList.stream().filter(info -> ((Set)buEntry.getValue()).contains(info.getRelatId())).collect(Collectors.toList());
            fieldControlRuleDtoList.add(HRFieldPermServiceHelper.getBuFieldPerm(buEntry.getKey(), userRoleInfos, userFiledPerm, roleFieldPerm));
        }
        fieldControlRules.setFieldControlRuleDtos((List)fieldControlRuleDtoList);
        return fieldControlRules;
    }

    private static DynamicObject[] getBuSubSons(List<Long> buFuncList, List<Long> parentOrgList) {
        DynamicObject[] orgDynArrays = new HRBaseServiceHelper("bos_org_structure").queryOriginalArray("org.id,longnumber", new QFilter[]{new QFilter("org.id", "in", parentOrgList), new QFilter("view.id", "in", buFuncList)});
        HashMap orgNumberMap = Maps.newHashMapWithExpectedSize((int)orgDynArrays.length);
        Arrays.stream(orgDynArrays).forEach(obj -> orgNumberMap.put(obj.getLong("org.id"), obj.getString("longnumber")));
        List<String> orgNumberList = parentOrgList.stream().map(orgNumberMap::get).collect(Collectors.toList());
        return HRFieldPermServiceHelper.querySubOrg(buFuncList, orgNumberList);
    }

    @ExcludeFromJacocoGeneratedReport
    private static FieldControlRuleDto getBuFieldPerm(Long bu, List<UserRoleInfo> userRoleInfos, FieldPerm userFiledPerm, FieldPerm roleFieldPerm) {
        ArrayList banReadFieldPerSets = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList banWriteFieldPerSets = Lists.newArrayListWithExpectedSize((int)16);
        FieldControlRule fieldControlRule = new FieldControlRule();
        FieldControlRuleDto fieldControlRuleDto = new FieldControlRuleDto();
        fieldControlRuleDto.setFieldControlRule(fieldControlRule);
        fieldControlRuleDto.setMainOrgId(bu);
        fieldControlRuleDto.setDimType("DIM_ORG");
        HRFieldPermServiceHelper.handlerPerUserFieldPerm(userRoleInfos, userFiledPerm, roleFieldPerm, banReadFieldPerSets, banWriteFieldPerSets);
        fieldControlRule.setCanNotWriteFields(HRFieldPermServiceHelper.intersectionSet(banWriteFieldPerSets));
        fieldControlRule.setCanNotReadFields(HRFieldPermServiceHelper.intersectionSet(banReadFieldPerSets));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getFieldControlRules buFieldPerm:{},banReadFieldPerSets:{}", (Object)bu, (Object)banReadFieldPerSets);
            LOGGER.info("getFieldControlRules buFieldPerm:{},banWriteFieldPerSets:{}", (Object)bu, (Object)banWriteFieldPerSets);
        }
        return fieldControlRuleDto;
    }

    private static void handlerPerUserFieldPerm(List<UserRoleInfo> userRoleInfos, FieldPerm userFiledPerm, FieldPerm roleFieldPerm, List<Set<String>> banReadFieldPerSets, List<Set<String>> banWriteFieldPerSets) {
        for (UserRoleInfo userRoleInfo : userRoleInfos) {
            if (userRoleInfo.getCustomenable() && userRoleInfo.isFieldIntersection()) {
                Set<String> userNRFieldPermSet = HRFieldPermServiceHelper.getUserFieldValue(userFiledPerm.getUserFieldBanReadPermMap(), userRoleInfo.getRelatId());
                Set<String> userNWFieldPermSet = HRFieldPermServiceHelper.getUserFieldValue(userFiledPerm.getUserFieldBanWritePermMap(), userRoleInfo.getRelatId());
                Set<String> roleNRFieldPermSet = HRFieldPermServiceHelper.getRoleFieldValue(roleFieldPerm.getRoleFieldBanReadPermMap(), userRoleInfo.getRoleId());
                Set<String> roleNWFieldPermSet = HRFieldPermServiceHelper.getRoleFieldValue(roleFieldPerm.getRoleFieldBanWritePermMap(), userRoleInfo.getRoleId());
                userNRFieldPermSet.addAll(roleNRFieldPermSet);
                userNWFieldPermSet.addAll(roleNWFieldPermSet);
                banReadFieldPerSets.add(userNRFieldPermSet);
                banWriteFieldPerSets.add(userNWFieldPermSet);
                continue;
            }
            if (userRoleInfo.getCustomenable() && !userRoleInfo.isFieldIntersection()) {
                banReadFieldPerSets.add(HRFieldPermServiceHelper.getUserFieldValue(userFiledPerm.getUserFieldBanReadPermMap(), userRoleInfo.getRelatId()));
                banWriteFieldPerSets.add(HRFieldPermServiceHelper.getUserFieldValue(userFiledPerm.getUserFieldBanWritePermMap(), userRoleInfo.getRelatId()));
                continue;
            }
            banReadFieldPerSets.add(HRFieldPermServiceHelper.getRoleFieldValue(roleFieldPerm.getRoleFieldBanReadPermMap(), userRoleInfo.getRoleId()));
            banWriteFieldPerSets.add(HRFieldPermServiceHelper.getRoleFieldValue(roleFieldPerm.getRoleFieldBanWritePermMap(), userRoleInfo.getRoleId()));
        }
    }

    private static Set<String> getUserFieldValue(Map<Long, Set<String>> fieldMap, Long key) {
        return Optional.ofNullable(fieldMap.get(key)).orElseGet(Sets::newHashSet);
    }

    private static Set<String> getRoleFieldValue(Map<String, Set<String>> fieldMap, String key) {
        return Optional.ofNullable(fieldMap.get(key)).orElseGet(Sets::newHashSet);
    }

    private static DynamicObject[] querySubOrg(List<Long> buFuncList, List<String> orgNumList) {
        QFilter orgQFilters = HRFieldPermServiceHelper.assembleOrgQFilter(buFuncList, orgNumList);
        DynamicObject[] orgTreeDynArrays = new HRBaseServiceHelper("bos_org_structure").queryOriginalArray("id,view,org", new QFilter[]{orgQFilters});
        buFuncList.clear();
        orgNumList.clear();
        return orgTreeDynArrays;
    }

    private static QFilter assembleOrgQFilter(List<Long> buFuncList, List<String> orgNumList) {
        ArrayList orgQFilter = Lists.newArrayListWithExpectedSize((int)orgNumList.size());
        int size = orgNumList.size();
        for (int index = 0; index < size; ++index) {
            QFilter org = new QFilter("longnumber", "like", (Object)(orgNumList.get(index) + "%"));
            QFilter view = new QFilter("view", "=", (Object)buFuncList.get(index));
            orgQFilter.add(org.and(view));
        }
        QFilter resultQFilter = null;
        for (QFilter qFilter : orgQFilter) {
            if (resultQFilter == null) {
                resultQFilter = qFilter;
                continue;
            }
            resultQFilter = resultQFilter.or(qFilter);
        }
        return Optional.ofNullable(resultQFilter).orElseGet(() -> QFilter.of((String)"1=2", (Object[])new Object[0]));
    }

    public static FieldControlRule getFieldRulesWithoutMainOrg(long userId, String appId, String entityNum) {
        List<UserRoleInfo> userRoleList = HRFieldPermServiceHelper.queryUserRoleInfoByEntityNum(userId, appId, entityNum);
        Set<String> roleIdSet = userRoleList.stream().map(UserRoleInfo::getRoleId).collect(Collectors.toSet());
        Set<Long> userRoleRelateIdList = userRoleList.stream().map(UserRoleInfo::getRelatId).collect(Collectors.toSet());
        FieldPerm roleFieldPerm = HRFieldPermServiceHelper.getRoleFieldPerm(appId, entityNum, roleIdSet);
        FieldPerm userRoleFiledPerm = HRFieldPermServiceHelper.getUserFiledPerm(appId, entityNum, userRoleRelateIdList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getFieldControlRules getFieldRulesWithoutMainOrg roleIdSet:{}", roleIdSet);
            LOGGER.info("getFieldControlRules getFieldRulesWithoutMainOrg userRoleRelateIdList:{}", userRoleRelateIdList);
            LOGGER.info("getFieldControlRules getFieldRulesWithoutMainOrg roleFieldPerm:{}", (Object)roleFieldPerm);
            LOGGER.info("getFieldControlRules getFieldRulesWithoutMainOrg userFiledPerm:{}", (Object)userRoleFiledPerm);
        }
        ArrayList banReadFieldPerSets = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList banWriteFieldPerSets = Lists.newArrayListWithExpectedSize((int)16);
        HRFieldPermServiceHelper.handlerPerUserFieldPerm(userRoleList, userRoleFiledPerm, roleFieldPerm, banReadFieldPerSets, banWriteFieldPerSets);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getFieldControlRules getFieldRulesWithoutMainOrg finally banReadFieldPerSets:{}", (Object)banReadFieldPerSets);
            LOGGER.info("getFieldControlRules getFieldRulesWithoutMainOrg finally banWriteFieldPerSets:{}", (Object)banWriteFieldPerSets);
        }
        return HRFieldPermServiceHelper.getFieldControlRule(banReadFieldPerSets, banWriteFieldPerSets);
    }

    private static FieldControlRule getFieldControlRule(List<Set<String>> banReadFieldPerSets, List<Set<String>> banWriteFieldPerSets) {
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadFields(HRFieldPermServiceHelper.intersectionSet(banReadFieldPerSets));
        fieldControlRule.setCanNotWriteFields(HRFieldPermServiceHelper.intersectionSet(banWriteFieldPerSets));
        return fieldControlRule;
    }

    private static FieldControlRules getFieldControlRules(FieldControlRule fieldControlRule) {
        FieldControlRuleDto fieldControlRuleDto = new FieldControlRuleDto();
        fieldControlRuleDto.setFieldControlRule(fieldControlRule);
        fieldControlRuleDto.setDimType("DIM_ORG");
        FieldControlRules fieldControlRules = new FieldControlRules();
        fieldControlRules.setFieldControlRuleDtos(Collections.singletonList(fieldControlRuleDto));
        return fieldControlRules;
    }

    private static FieldPerm getUserFiledPerm(String appId, String entityNum, Set<Long> userRoleRefs) {
        DynamicObject[] userRoleFieldPerms = new HRBaseServiceHelper("hrcs_userfield").queryOriginalArray("userrolerealt.id,entryentity.fieldname,entryentity.isbanwrite,entryentity.isbanread", new QFilter[]{new QFilter("userrolerealt", "in", userRoleRefs), new QFilter("entitytype", "=", (Object)entityNum), new QFilter("app", "=", (Object)appId)});
        HashMap userFieldBanReadPermMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap userFieldBanWritePermMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject roleDyn : userRoleFieldPerms) {
            Long userRoleId = roleDyn.getLong(USERROLEREALT_ID);
            String filedName = roleDyn.getString("entryentity.fieldname");
            boolean isBanRead = roleDyn.getBoolean("entryentity.isbanread");
            boolean isBanWrite = roleDyn.getBoolean("entryentity.isbanwrite");
            if (isBanRead) {
                userFieldBanReadPermMap.computeIfAbsent(userRoleId, key -> new HashSet(16)).add(filedName);
            }
            if (!isBanWrite) continue;
            userFieldBanWritePermMap.computeIfAbsent(userRoleId, key -> new HashSet(16)).add(filedName);
        }
        FieldPerm fieldPerm = new FieldPerm();
        fieldPerm.setUserFieldBanReadPermMap((Map)userFieldBanReadPermMap);
        fieldPerm.setUserFieldBanWritePermMap((Map)userFieldBanWritePermMap);
        return fieldPerm;
    }

    private static Set<String> intersectionSet(List<Set<String>> permSets) {
        return permSets.stream().reduce((setOne, setTwo) -> {
            setOne.retainAll((Collection<?>)setTwo);
            return setOne;
        }).orElseGet(() -> Sets.newHashSet());
    }

    private static FieldPerm getRoleFieldPerm(String appId, String entityNum, Set<String> roleIdSet) {
        DynamicObject[] roleFieldDynArrays = new HRBaseServiceHelper("hrcs_rolefield").queryOriginalArray("id,role.id,fieldpermentry.fieldname,fieldpermentry.isbanread,fieldpermentry.isbanwrite", new QFilter[]{new QFilter("role", "in", roleIdSet), new QFilter("entitytype", "=", (Object)entityNum), new QFilter("app", "=", (Object)appId)});
        HashMap roleFieldBanReadPermMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap roleFieldBanWritePermMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject roleDyn : roleFieldDynArrays) {
            String roleId = roleDyn.getString(ROLE_ID);
            String filedName = roleDyn.getString("fieldpermentry.fieldname");
            boolean isBanRead = roleDyn.getBoolean("fieldpermentry.isbanread");
            boolean isBanWrite = roleDyn.getBoolean("fieldpermentry.isbanwrite");
            if (isBanRead) {
                roleFieldBanReadPermMap.computeIfAbsent(roleId, key -> new HashSet(16)).add(filedName);
            }
            if (!isBanWrite) continue;
            roleFieldBanWritePermMap.computeIfAbsent(roleId, key -> new HashSet(16)).add(filedName);
        }
        FieldPerm fieldPerm = new FieldPerm();
        fieldPerm.setRoleFieldBanReadPermMap((Map)roleFieldBanReadPermMap);
        fieldPerm.setRoleFieldBanWritePermMap((Map)roleFieldBanWritePermMap);
        return fieldPerm;
    }

    public static List<UserRoleInfo> queryUserRoleInfoByEntityNum(long userId, String appId, String entityNum) {
        List<Object> userRoleInfoList = Lists.newArrayListWithExpectedSize((int)16);
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)16);
        if (enableValidateTime) {
            Date today = new Date();
            qFilterList.add(new QFilter("validstart", "<=", (Object)today).or(QFilter.of((String)"validstart is null", (Object[])new Object[0])));
            qFilterList.add(new QFilter("validend", ">=", (Object)today).or(QFilter.of((String)"validend is null", (Object[])new Object[0])));
        }
        qFilterList.add(new QFilter("user", "=", (Object)userId));
        qFilterList.add(new QFilter("permfile.permfileenable", "=", (Object)"1"));
        DynamicObject[] roleDynoArr = new HRBaseServiceHelper("hrcs_userrolerelat").queryOriginalArray("id,role.id,customenable", HRPermCommonUtil.listToQFilters((List)qFilterList));
        if (roleDynoArr == null || roleDynoArr.length == 0) {
            return userRoleInfoList;
        }
        HashSet hrRoleIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject uRole : roleDynoArr) {
            userRoleInfoList.add(new UserRoleInfo(Long.valueOf(uRole.getLong("id")), uRole.getString(ROLE_ID), uRole.getBoolean("customenable")));
            hrRoleIdSet.add(uRole.getString(ROLE_ID));
        }
        Set roleIdSet = Arrays.stream(new HRBaseServiceHelper("perm_roleperm").query("roleid.id", new QFilter[]{new QFilter("roleperm.bizapp", "=", (Object)appId), new QFilter("roleid.id", "in", (Object)hrRoleIdSet), new QFilter("roleid.enable", "=", (Object)Character.valueOf('1')), new QFilter("roleperm.entity", "=", (Object)entityNum)})).map(role -> role.getString("roleid.id")).collect(Collectors.toSet());
        DynamicObject[] hrRoledynoArr = new HRBaseServiceHelper("hrcs_role").queryOriginalArray("id,isintersection", new QFilter[]{new QFilter("id", "in", roleIdSet)});
        HashMap hrRoleMap = Maps.newHashMapWithExpectedSize((int)16);
        Arrays.stream(hrRoledynoArr).forEach(obj -> hrRoleMap.put(obj.getString("id"), obj));
        userRoleInfoList = userRoleInfoList.stream().filter(obj -> roleIdSet.contains(obj.getRoleId())).collect(Collectors.toList());
        userRoleInfoList.forEach(info -> {
            DynamicObject hrRole = (DynamicObject)hrRoleMap.get(info.getRoleId());
            if (hrRole != null) {
                info.setIntersection(hrRole.getString("isintersection"));
            }
        });
        return userRoleInfoList;
    }

    private static DynamicObject[] getUserRoleBu(Set<Long> userRoleRefIdSet, Long PermOrgFuncId) {
        QFilter[] roleQFilters = new QFilter[]{new QFilter("userrolerealt", "in", userRoleRefIdSet), new QFilter(BU_FUNC_ID, "=", (Object)PermOrgFuncId)};
        return new HRBaseServiceHelper("hrcs_userrole").queryOriginalArray("userrolerealt.id,org.id,includesuborg,bucafunc", roleQFilters);
    }
}

