/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.RoleRuleInfo;

@ExcludeFromJacocoGeneratedReport
public class HRPermDimServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRPermDimServiceHelper.class);

    public static Long getAdminOrgDimId() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject dyno = helper.queryOriginalOne("id", new QFilter("isadminorg", "=", (Object)"1"));
        if (dyno == null) {
            return null;
        }
        return dyno.getLong("id");
    }

    public static Long getDimensionIdByNumber(String dimensionNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject dyno = helper.queryOriginalOne("id", new QFilter("number", "=", (Object)dimensionNumber));
        if (dyno == null) {
            return null;
        }
        return dyno.getLong("id");
    }

    public static Map<String, Set<String>> getRoleDimAdminOrgProp(Set<String> roles, String appId, String entityNum) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)0);
        if (CollectionUtils.isEmpty(roles)) {
            return result;
        }
        Long dimId = HRPermDimServiceHelper.getAdminOrgDimId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject[] relatDynoArr = helper.query("role,entry.propkey,entry.entitytype,entry.app", new QFilter[]{new QFilter("entry.entitytype", "=", (Object)entityNum), new QFilter("entry.app.id", "=", (Object)appId), new QFilter("role", "in", roles), new QFilter("dimension", "=", (Object)dimId)});
        HRPermDimServiceHelper.assembleEntryProps(appId, entityNum, result, relatDynoArr);
        return result;
    }

    private static void assembleEntryProps(String appId, String entityNum, Map<String, Set<String>> rolePropsMap, DynamicObject[] relatDynoArr) {
        for (DynamicObject relatDyno : relatDynoArr) {
            DynamicObjectCollection entryColl = relatDyno.getDynamicObjectCollection("entry");
            String roleId = relatDyno.getString("role.id");
            for (DynamicObject entryDyno : entryColl) {
                if (!HRStringUtils.equals((String)entityNum, (String)entryDyno.getString("entitytype.number")) || !HRStringUtils.equals((String)appId, (String)entryDyno.getString("app.id"))) continue;
                Set propSet = rolePropsMap.computeIfAbsent(roleId, key -> Sets.newLinkedHashSetWithExpectedSize((int)16));
                propSet.add(entryDyno.getString("propkey"));
            }
        }
    }

    public static Long getDimTypeId(String dimTypeNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        enableFilter.and(new QFilter("number", "=", (Object)dimTypeNumber));
        DynamicObject dyno = helper.queryOriginalOne("id", enableFilter);
        return Optional.ofNullable(dyno).map(el -> el.getLong("id")).orElse(0L);
    }

    public static DynamicObjectCollection getEntityPermTypeConfig(String entityNum) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_orgpermconfig");
        QFilter qFilter = new QFilter("entitytype", "=", (Object)entityNum);
        return helper.queryOriginalCollection("id,entitytype,propkey,orgpermtype", new QFilter[]{qFilter});
    }

    public static Set<Long> collectEntityDimIds(Map<String, List<RoleRuleInfo>> roleDimPropRelat) {
        HashSet dimIds = Sets.newHashSetWithExpectedSize((int)16);
        for (List<RoleRuleInfo> roleDimInfos : roleDimPropRelat.values()) {
            for (RoleRuleInfo info : roleDimInfos) {
                dimIds.add(info.getDimensionId());
            }
        }
        return dimIds;
    }
}

