/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.DimValue;

@ExcludeFromJacocoGeneratedReport
public class OrgOptimLongNumberHelper {
    private static final Log LOGGER = LogFactory.getLog(OrgOptimLongNumberHelper.class);
    private static Long ADMIN_STRUCT_ID = 1010L;

    public static QFilter optim2LongNumber(String entityNumber, String propKey, String propEntityNumber, String caller, String methodSource, Map<Long, Long> structProjectMap, List<DimValue> dimValues) {
        QFilter entityQfilter;
        if (!HRStringUtils.equals((String)caller, (String)"sys")) {
            return null;
        }
        LOGGER.info("OrgOptimLongNumberHelper entry entityNumber:{},propKey:{},propEntityNumber:{}", new Object[]{entityNumber, propKey, propEntityNumber});
        Set authorStructs = dimValues.stream().map(dimValue -> dimValue.getStructProjectId()).collect(Collectors.toSet());
        boolean isOnlyAuthorAdminStruct = authorStructs.size() == 1 && authorStructs.contains(ADMIN_STRUCT_ID);
        boolean isConfigAdminStruct = !CollectionUtils.isEmpty(structProjectMap) && structProjectMap.containsKey(ADMIN_STRUCT_ID);
        boolean isOnlyConfigAdminStruct = isConfigAdminStruct && structProjectMap.size() == 1;
        boolean canOptim = isOnlyConfigAdminStruct || isOnlyAuthorAdminStruct && isConfigAdminStruct;
        LOGGER.info("OrgOptimLongNumberHelper entityNumber:{},propKey:{}, canOptim:{}, structProjectMap:{},isConfigAdminStruct:{},isOnlyConfigAdminStruct:{}; authorStructs:{},isOnlyAuthorAdminStruct:{}. ", new Object[]{entityNumber, propKey, canOptim, structProjectMap, isConfigAdminStruct, isOnlyConfigAdminStruct, authorStructs, isOnlyAuthorAdminStruct});
        if (!canOptim) {
            LOGGER.info("OrgOptimLongNumberHelper isOnlyAuthorAdminStruct:{},isOnlyConfigAdminStruct:{},unable to optim,return null. ", (Object)isOnlyAuthorAdminStruct, (Object)isOnlyConfigAdminStruct);
            return null;
        }
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_orgoptimconfig");
        QFilter typeQfilter = new QFilter("optimtype", "=", (Object)methodSource);
        QFilter[] qfilters = null;
        if (HRStringUtils.equals((String)methodSource, (String)"list")) {
            entityQfilter = new QFilter("entitytype", "=", (Object)entityNumber);
            QFilter propQfilter = new QFilter("propkey", "=", (Object)propKey);
            qfilters = new QFilter[]{typeQfilter, entityQfilter, propQfilter};
        } else if (HRStringUtils.equals((String)methodSource, (String)"f7")) {
            entityQfilter = new QFilter("entitytype", "=", (Object)propEntityNumber);
            qfilters = new QFilter[]{typeQfilter, entityQfilter};
        }
        DynamicObject configDyna = configHelper.queryOriginalOne("longnumberprop", qfilters);
        if (configDyna == null) {
            LOGGER.info("OrgOptimLongNumberHelper no optomconfig exist ,return null.");
            return null;
        }
        String longNumberProp = configDyna.getString("longnumberprop");
        List adminOrgDimValues = dimValues.stream().filter(dimValue -> Objects.equals(dimValue.getStructProjectId(), ADMIN_STRUCT_ID) && HRStringUtils.isNotEmpty((String)dimValue.getDimVal())).collect(Collectors.toList());
        List containSubList = adminOrgDimValues.stream().filter(dimValue -> dimValue.isContainsSub()).collect(Collectors.toList());
        List noContainSubList = adminOrgDimValues.stream().filter(dimValue -> !dimValue.isContainsSub()).collect(Collectors.toList());
        Set noContainSubIdSet = noContainSubList.stream().map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
        Set containSubIdSet = containSubList.stream().map(dimValue -> Long.parseLong(dimValue.getDimVal())).collect(Collectors.toSet());
        QFilter resultQfilter = null;
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        HashSet allOrgIds = Sets.newHashSet(noContainSubIdSet);
        allOrgIds.addAll(containSubIdSet);
        DynamicObjectCollection orgTeamHisDynColl = adminOrgHelper.queryOriginalCollection("orgteam.id,structlongnumber,orgteamhisid", new QFilter[]{new QFilter("orgteam.id", "in", (Object)allOrgIds), new QFilter("structproject.id", "=", (Object)ADMIN_STRUCT_ID)});
        if (!CollectionUtils.isEmpty(noContainSubIdSet)) {
            Set orgTeamHisId = orgTeamHisDynColl.stream().filter(dyna -> noContainSubIdSet.contains(dyna.getLong("orgteam.id"))).map(dyna -> dyna.getLong("orgteamhisid")).collect(Collectors.toSet());
            orgTeamHisId.addAll(noContainSubIdSet);
            resultQfilter = new QFilter(propKey, "in", orgTeamHisId);
        }
        if (!CollectionUtils.isEmpty(containSubIdSet)) {
            Set longNumbers = orgTeamHisDynColl.stream().filter(dyna -> containSubIdSet.contains(dyna.getLong("orgteam.id"))).map(dyna -> dyna.getString("structlongnumber")).collect(Collectors.toSet());
            QFilter containSubQfilter = null;
            for (String longNumber : longNumbers) {
                if (HRStringUtils.isEmpty((String)longNumber)) {
                    LOGGER.error("OrgOptimLongNumberHelper longNumberError.longnumber is null");
                    continue;
                }
                if (containSubQfilter == null) {
                    containSubQfilter = new QFilter(longNumberProp, "like", (Object)(longNumber + "%"));
                    continue;
                }
                containSubQfilter.or(new QFilter(longNumberProp, "like", (Object)(longNumber + "%")));
            }
            if (resultQfilter == null) {
                resultQfilter = containSubQfilter;
            } else {
                resultQfilter.or(containSubQfilter);
            }
        }
        return resultQfilter;
    }
}

