/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.RelatePermInfo;
import kd.hr.hrcs.common.model.UserRoleInfo;

public class UserRoleServiceHelper {
    private static Log LOGGER = LogFactory.getLog(UserRoleServiceHelper.class);

    public static List<UserRoleInfo> queryUserRoleSet(Long userId, String appId, String entityNumber, String permItemId) {
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)16);
        if (enableValidateTime) {
            Date today = new Date();
            qFilterList.add(new QFilter("validstart", "<=", (Object)today).or(QFilter.of((String)"validstart is null", (Object[])new Object[0])));
            qFilterList.add(new QFilter("validend", ">=", (Object)today).or(QFilter.of((String)"validend is null", (Object[])new Object[0])));
        }
        qFilterList.add(new QFilter("user", "=", (Object)userId));
        qFilterList.add(new QFilter("permfile.permfileenable", "=", (Object)"1"));
        Object[] roleDynoArr = new HRBaseServiceHelper("hrcs_userrolerelat").queryOriginalArray("id,role.id,user.id,customenable", HRPermCommonUtil.listToQFilters((List)qFilterList));
        ArrayList userRoleList = Lists.newArrayListWithExpectedSize((int)roleDynoArr.length);
        if (ObjectUtils.isEmpty((Object[])roleDynoArr)) {
            LOGGER.info("HRDataPermService queryUserRoleSet roleDynoArr is empty.");
            return userRoleList;
        }
        LinkedHashSet userRoleIdSet = Sets.newLinkedHashSetWithExpectedSize((int)userRoleList.size());
        for (Object roleDyno : roleDynoArr) {
            userRoleList.add(new UserRoleInfo(Long.valueOf(roleDyno.getLong("id")), roleDyno.getString("role.id"), roleDyno.getLong("user.id"), roleDyno.getBoolean("customenable")));
            userRoleIdSet.add(roleDyno.getString("role.id"));
        }
        Set<String> funcRoleIdSet = UserRoleServiceHelper.queryRoleIdSetByPermItem(appId, entityNumber, permItemId, userRoleIdSet);
        DynamicObject[] hrRoledynoArr = new HRBaseServiceHelper("hrcs_role").queryOriginalArray("id,isintersection", new QFilter[]{new QFilter("id", "in", (Object)userRoleIdSet)});
        Map<String, DynamicObject> hrRoleMap = UserRoleServiceHelper.dynoArrToMap(hrRoledynoArr);
        ArrayList resultRoleList = Lists.newArrayListWithExpectedSize((int)roleDynoArr.length);
        for (UserRoleInfo userRoleInfo : userRoleList) {
            if (!funcRoleIdSet.contains(userRoleInfo.getRoleId())) continue;
            DynamicObject hrRole = hrRoleMap.get(userRoleInfo.getRoleId());
            if (hrRole != null) {
                userRoleInfo.setIntersection(hrRole.getString("isintersection"));
            }
            resultRoleList.add(userRoleInfo);
        }
        LOGGER.info("HRDataPermService queryUserRoleSet result:{}", (Object)resultRoleList);
        return resultRoleList;
    }

    public static Set<String> queryRoleIdSetByPermItem(String appId, String entityId, String permItemId, Set<String> userRoleIdSet) {
        DataSet roleDataSet;
        String sql = CollectionUtils.isEmpty(userRoleIdSet) ? "select b.froleid as roleid from t_perm_rolepermdetial a inner join t_perm_roleperm b on a.fid = b.fid  inner join t_perm_role c on b.froleid = c.fid  where a.fbizappid = ? and a.fentitytypeid = ? and c.fenable='1'" : "select b.froleid as roleid from t_perm_rolepermdetial a inner join t_perm_roleperm b on a.fid = b.fid  inner join t_perm_role c on b.froleid = c.fid  where c.fid in " + PermCheckUtil.splitId(userRoleIdSet) + " and a.fbizappid = ? and a.fentitytypeid = ? and c.fenable='1'";
        if (HRStringUtils.isNotEmpty((String)permItemId)) {
            sql = sql + " and a.fpermitemid = '" + permItemId + "'";
        }
        if (Objects.isNull(roleDataSet = HRDBUtil.queryDataSet((String)"hr.queryRoleIdSetByPermItem", (DBRoute)DBRoute.permission, (String)sql, (Object[])PermCheckUtil.assembleParams(userRoleIdSet, appId, entityId))) || !roleDataSet.hasNext()) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet roleIdSet = Sets.newHashSetWithExpectedSize((int)16);
        while (roleDataSet.hasNext()) {
            String roleId = roleDataSet.next().getString("roleid");
            roleIdSet.add(roleId);
        }
        roleDataSet.close();
        return roleIdSet;
    }

    private static Map<String, DynamicObject> dynoArrToMap(DynamicObject[] dynoArr) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dynoArr.length);
        for (DynamicObject dyno : dynoArr) {
            resultMap.put(dyno.getString("id"), dyno);
        }
        return resultMap;
    }

    public static Object[] assembleParams(List list, Object ... otherParams) {
        ArrayList sqlParams = Lists.newArrayList((Iterable)list);
        Arrays.stream(otherParams).map(sqlParams::add).collect(Collectors.toSet());
        return sqlParams.toArray();
    }

    public static List<RelatePermInfo> queryRoleIdSetByPermItemSet(Set<String> appIds, Set<String> entityIds, Set<String> permItemIds, List<RelatePermInfo> mainPermInfoList) {
        mainPermInfoList.removeIf(it -> it.getPermId() == null || it.getmEntityNum() == null || it.getmAppId() == null);
        ArrayList params = Lists.newArrayListWithExpectedSize((int)(appIds.size() + entityIds.size() + permItemIds.size()));
        params.addAll(appIds);
        params.addAll(entityIds);
        params.addAll(permItemIds);
        long start = System.currentTimeMillis();
        String sql = "select froleid roleId,fpermitemid permitem,fentitytypeid entity,fbizappid app from t_perm_rolepermdetial   where fbizappid in" + PermCheckUtil.splitId(appIds) + "and fentitytypeid  in" + PermCheckUtil.splitId(entityIds) + " and fpermitemid in" + PermCheckUtil.splitId(permItemIds);
        DataSet roleDataSet = HRDBUtil.queryDataSet((String)"hr.queryRoleIdSetByPermItemSet", (DBRoute)DBRoute.permission, (String)sql, (Object[])UserRoleServiceHelper.assembleParams(params, new Object[0]));
        if (Objects.isNull(roleDataSet) || !roleDataSet.hasNext()) {
            return Lists.newArrayList();
        }
        Set<String> roleSet = UserRoleServiceHelper.getHrRoles();
        ArrayList roleIdSet = Lists.newArrayListWithExpectedSize((int)16);
        while (roleDataSet.hasNext()) {
            Row next = roleDataSet.next();
            String roleId = next.getString("roleId");
            String entity = next.getString("entity");
            String permItem = next.getString("permitem");
            String bizApp = next.getString("app");
            if (HRStringUtils.isEmpty((String)entity) || HRStringUtils.isEmpty((String)permItem) || HRStringUtils.isEmpty((String)bizApp) || !roleSet.contains(roleId)) continue;
            RelatePermInfo permInfo = new RelatePermInfo(entity, bizApp, permItem, roleId);
            roleIdSet.add(permInfo);
        }
        roleDataSet.close();
        LOGGER.info("queryRoleIdSetByPermItemSet filter queryResult cost time:{}", (Object)(System.currentTimeMillis() - start));
        return roleIdSet;
    }

    private static Set<String> getHrRoles() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection dys = helper.queryOriginalCollection("id", null);
        return dys.stream().map(it -> it.getString("id")).collect(Collectors.toSet());
    }
}

