/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.structcalc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.domain.repository.perm.HROrgTeamStructRepository;
import kd.hr.hrcs.common.model.OrgInfo;

public class CalcPermCommonService {
    private static volatile CalcPermCommonService calcPermCommonService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalcPermCommonService getInstance() {
        if (calcPermCommonService != null) return calcPermCommonService;
        Class<CalcPermCommonService> clazz = CalcPermCommonService.class;
        synchronized (CalcPermCommonService.class) {
            if (calcPermCommonService != null) return calcPermCommonService;
            calcPermCommonService = new CalcPermCommonService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return calcPermCommonService;
        }
    }

    public Map<String, List<OrgInfo>> getOrgTeamListByBoId(Set<Long> boIdSetStd, Set<Long> boIdSetCustom, Date effStartDate, Date effEndDate) {
        if (CollectionUtils.isEmpty(boIdSetStd) && CollectionUtils.isEmpty(boIdSetCustom)) {
            return Maps.newHashMap();
        }
        DynamicObjectCollection dyColl = HROrgTeamStructRepository.getAllOrgTeamListByBoIdStd(boIdSetStd, effStartDate, effEndDate);
        DynamicObjectCollection dyCollCustom = HROrgTeamStructRepository.getAllOrgTeamListByBoIdCustom(boIdSetCustom, effStartDate, effEndDate);
        dyColl.addAll((Collection)dyCollCustom);
        HashMap dimOrgInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyn : dyColl) {
            Long id = dyn.getLong("orgteam");
            String strId = String.valueOf(id);
            OrgInfo orgInfo = new OrgInfo(id, Long.valueOf(dyn.getLong("parent")), Long.valueOf(dyn.getLong("otclassify")), dyn.getString("structlongnumber"));
            orgInfo.setOrgTeamHisId(Long.valueOf(dyn.getLong("orgteamhisid")));
            orgInfo.setBsedTime(dyn.getDate("bsed"));
            orgInfo.setBsledTime(dyn.getDate("bsled"));
            orgInfo.setStructProjectId(Long.valueOf(dyn.getLong("structproject")));
            List orgInfoList = (List)dimOrgInfoMap.get(strId);
            if (CollectionUtils.isEmpty((Collection)orgInfoList)) {
                orgInfoList = Lists.newArrayListWithExpectedSize((int)10);
                dimOrgInfoMap.put(strId, orgInfoList);
            }
            orgInfoList.add(orgInfo);
        }
        return dimOrgInfoMap;
    }

    public List<OrgInfo> getOrgTeamList(Set<Long> orgIdSet, boolean isContainSub, Long structProject, Date effStartDate, Date effEndDate) {
        if (CollectionUtils.isEmpty(orgIdSet)) {
            return Lists.newArrayList();
        }
        DynamicObjectCollection dyColl = HROrgTeamStructRepository.getOrgTeamDyCollection(orgIdSet, isContainSub, structProject, effStartDate, effEndDate);
        if (dyColl == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dyColl.size());
        for (DynamicObject dyn : dyColl) {
            OrgInfo orgInfo = new OrgInfo(Long.valueOf(dyn.getLong("orgteam")), Long.valueOf(dyn.getLong("parent")), Long.valueOf(dyn.getLong("otclassify")), dyn.getString("structlongnumber"));
            orgInfo.setOrgTeamHisId(Long.valueOf(dyn.getLong("orgteamhisid")));
            orgInfo.setBsedTime(dyn.getDate("bsed"));
            orgInfo.setBsledTime(dyn.getDate("bsled"));
            result.add(orgInfo);
        }
        return result;
    }

    public Map<Long, List<OrgInfo>> getAllOrgTeamList(Set<Long> structProjectSet, Date effStartDate, Date EffEndDate) {
        if (CollectionUtils.isEmpty(structProjectSet)) {
            return Maps.newHashMap();
        }
        Map<Long, Boolean> structCustomMap = this.queryStructCustom(structProjectSet);
        HashSet customStructProjectSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet stdStructProjectSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Long structId : structProjectSet) {
            if (Objects.equals(structCustomMap.get(structId), true)) {
                customStructProjectSet.add(structId);
                continue;
            }
            stdStructProjectSet.add(structId);
        }
        DynamicObjectCollection dyColl = HROrgTeamStructRepository.getAllOrgTeamListByStructStd(stdStructProjectSet, effStartDate, EffEndDate);
        DynamicObjectCollection customDyColl = HROrgTeamStructRepository.getAllOrgTeamListByStructCustom(customStructProjectSet, effStartDate, EffEndDate);
        dyColl.addAll((Collection)customDyColl);
        HashMap noAdminStructProjectOrgInfo = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dyn : dyColl) {
            List<OrgInfo> orgInfoList;
            OrgInfo orgInfo = new OrgInfo(Long.valueOf(dyn.getLong("orgteam")), Long.valueOf(dyn.getLong("parent")), Long.valueOf(dyn.getLong("otclassify")), dyn.getString("structlongnumber"));
            Long structProject = dyn.getLong("structproject");
            if (noAdminStructProjectOrgInfo.containsKey(structProject)) {
                orgInfoList = (List)noAdminStructProjectOrgInfo.get(structProject);
            } else {
                orgInfoList = Lists.newArrayListWithExpectedSize((int)10);
                noAdminStructProjectOrgInfo.put(structProject, orgInfoList);
            }
            orgInfo.setOrgTeamHisId(Long.valueOf(dyn.getLong("orgteamhisid")));
            orgInfo.setBsedTime(dyn.getDate("bsed"));
            orgInfo.setBsledTime(dyn.getDate("bsled"));
            orgInfoList.add(orgInfo);
        }
        return noAdminStructProjectOrgInfo;
    }

    public Map<Long, Boolean> queryStructCustom(Set<Long> structProjectSet) {
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObjectCollection structDynaColl = structHelper.queryOriginalCollection("id,otclassify.teamtype.iscustom", new QFilter[]{new QFilter("id", "in", structProjectSet)});
        HashMap structCustomMap = Maps.newHashMap();
        for (DynamicObject dyna : structDynaColl) {
            structCustomMap.put(dyna.getLong("id"), dyna.getBoolean("otclassify.teamtype.iscustom"));
        }
        return structCustomMap;
    }
}

