/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.perm.check.structcalc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.service.perm.check.structcalc.CalcPermAdminStructService;
import kd.hr.hrcs.common.constants.perm.PermissionConstants;
import kd.hr.hrcs.common.model.DimValue;
import kd.hr.hrcs.common.model.OrgInfo;

@ExcludeFromJacocoGeneratedReport
public class CalcPermDependStructService {
    private static volatile CalcPermDependStructService calcPermDependStructService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalcPermDependStructService getInstance() {
        if (calcPermDependStructService != null) return calcPermDependStructService;
        Class<CalcPermDependStructService> clazz = CalcPermDependStructService.class;
        synchronized (CalcPermDependStructService.class) {
            if (calcPermDependStructService != null) return calcPermDependStructService;
            calcPermDependStructService = new CalcPermDependStructService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return calcPermDependStructService;
        }
    }

    public Set<Long> calcDependStructOrg(Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, List<DimValue> dimValues, Long structId, Long dependStructId, Map<String, List<OrgInfo>> dimOrgMapWithHis, Date effStartDate, Date effEndDate) {
        if (noAdminStructProjectOrgInfo == null || dimOrgMapWithHis == null || dimOrgMapWithHis.isEmpty()) {
            return null;
        }
        List structDimValue = dimValues.stream().filter(el -> (el.getStructProjectId() == null ? 0L : el.getStructProjectId()) == structId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(structDimValue)) {
            return null;
        }
        HashSet<Long> setResult = new HashSet<Long>(16);
        ArrayList allSub = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList subAndDependSelf = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList selfAndDependSub = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList allSelf = Lists.newArrayListWithExpectedSize((int)16);
        for (DimValue dv : structDimValue) {
            if (dv.isAdminContainsSub() && dv.isContainsSub()) {
                allSub.add(dv);
                continue;
            }
            if (!dv.isAdminContainsSub() && dv.isContainsSub()) {
                subAndDependSelf.add(dv);
                continue;
            }
            if (dv.isAdminContainsSub() && !dv.isContainsSub()) {
                selfAndDependSub.add(dv);
                continue;
            }
            if (dv.isAdminContainsSub() || dv.isContainsSub()) continue;
            allSelf.add(dv);
        }
        setResult.addAll(this.calcAllSub(allSub, dimOrgMapWithHis, structId, dependStructId, noAdminStructProjectOrgInfo, effStartDate, effEndDate, dimValues));
        setResult.addAll(this.calcSubAndDependSelf(subAndDependSelf, dimOrgMapWithHis, structId, noAdminStructProjectOrgInfo, effStartDate, effEndDate));
        setResult.addAll(this.calcSelfAndDependSub(selfAndDependSub, dimOrgMapWithHis, structId, dependStructId, noAdminStructProjectOrgInfo, effStartDate, effEndDate));
        setResult.addAll(this.calcAllSelf(allSelf, dimOrgMapWithHis, structId, dependStructId, noAdminStructProjectOrgInfo));
        return setResult;
    }

    private Set<Long> calcAllSub(List<DimValue> allSub, Map<String, List<OrgInfo>> dimOrgMapWithHis, Long structId, Long dependStructId, Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, Date effStartDate, Date effEndDate, List<DimValue> dimValues) {
        if (CollectionUtils.isEmpty(allSub)) {
            return Sets.newHashSet();
        }
        HashSet<Long> setResult = new HashSet<Long>(16);
        if (structId.longValue() != PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
            this.getStructAllSubInfo(allSub, dimOrgMapWithHis, structId, noAdminStructProjectOrgInfo, setResult);
            if (dependStructId.longValue() != PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
                this.getStructAllSubInfo(allSub, dimOrgMapWithHis, dependStructId, noAdminStructProjectOrgInfo, setResult);
            }
        } else {
            this.buildAdminOrgAndSub(structId, dimValues, setResult, effStartDate, effEndDate);
            this.getStructAllSubInfo(allSub, dimOrgMapWithHis, dependStructId, noAdminStructProjectOrgInfo, setResult);
        }
        return setResult;
    }

    private Set<Long> calcSubAndDependSelf(List<DimValue> subAndDependSelf, Map<String, List<OrgInfo>> dimOrgMapWithHis, Long structId, Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, Date effStartDate, Date effEndDate) {
        if (CollectionUtils.isEmpty(subAndDependSelf)) {
            return Sets.newHashSet();
        }
        HashSet<Long> setResult = new HashSet<Long>(16);
        List<OrgInfo> structAllOrgInfo = noAdminStructProjectOrgInfo.get(structId);
        if (CollectionUtils.isEmpty(structAllOrgInfo)) {
            return Sets.newHashSet();
        }
        if (structId.longValue() != PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
            Set<Long> dimSubAndDependSelf = this.filterDimOrgId(subAndDependSelf, dimOrgMapWithHis);
            if (CollectionUtils.isEmpty(dimSubAndDependSelf)) {
                return Sets.newHashSet();
            }
            this.addDimSelf(dimSubAndDependSelf, structAllOrgInfo, setResult);
            Set<String> level1SubLongNumber = this.getLevel1SubLongNumber(structAllOrgInfo, dimSubAndDependSelf);
            if (CollectionUtils.isNotEmpty(level1SubLongNumber)) {
                for (String longNumber : level1SubLongNumber) {
                    this.getSubIdWithSelf(structAllOrgInfo, longNumber, setResult);
                }
            }
        } else {
            this.buildAdminOrgAndSub(structId, subAndDependSelf, setResult, effStartDate, effEndDate);
            Set<Long> dimSubAndDependSelf = this.filterDimOrgId(subAndDependSelf, dimOrgMapWithHis);
            this.addDimSelf(dimSubAndDependSelf, structAllOrgInfo, setResult);
        }
        return setResult;
    }

    private Set<Long> calcSelfAndDependSub(List<DimValue> selfAndDependSub, Map<String, List<OrgInfo>> dimOrgMapWithHis, Long structId, Long dependStructId, Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, Date effStartDate, Date effEndDate) {
        if (CollectionUtils.isEmpty(selfAndDependSub)) {
            return Sets.newHashSet();
        }
        if (noAdminStructProjectOrgInfo == null || noAdminStructProjectOrgInfo.size() == 0) {
            return Sets.newHashSet();
        }
        HashSet<Long> setResult = new HashSet<Long>(16);
        Set<Long> dependOrgSubIds = null;
        List<OrgInfo> structAllOrgInfo = null;
        if (structId.longValue() != PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
            if (dependStructId.longValue() == PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
                List<OrgInfo> dependStructOrgInfo = CalcPermAdminStructService.getInstance().buildAdminOrgInfo(selfAndDependSub, structId, PermissionConstants.ADMIN_STRUCT_PROJECT, effStartDate, effEndDate);
                if (CollectionUtils.isEmpty(dependStructOrgInfo)) {
                    return Sets.newHashSet();
                }
                dependOrgSubIds = dependStructOrgInfo.stream().map(orgInfo -> orgInfo.getOrgTeamHisId()).collect(Collectors.toSet());
            } else {
                dependOrgSubIds = this.getDependSubOrgIds(selfAndDependSub, dimOrgMapWithHis, dependStructId, noAdminStructProjectOrgInfo, setResult);
            }
            structAllOrgInfo = noAdminStructProjectOrgInfo.get(structId);
        } else if (dependStructId.longValue() != PermissionConstants.ADMIN_STRUCT_PROJECT.longValue()) {
            dependOrgSubIds = this.getDependSubOrgIds(selfAndDependSub, dimOrgMapWithHis, dependStructId, noAdminStructProjectOrgInfo, setResult);
            structAllOrgInfo = CalcPermAdminStructService.getInstance().buildAdminOrgInfo(selfAndDependSub, structId, PermissionConstants.ADMIN_STRUCT_PROJECT, effStartDate, effEndDate);
        }
        if (structAllOrgInfo == null || structAllOrgInfo.isEmpty()) {
            return Sets.newHashSet();
        }
        if (dependOrgSubIds == null || dependOrgSubIds.isEmpty()) {
            return Sets.newHashSet();
        }
        setResult.addAll(this.getLevel1SubId(structAllOrgInfo, dependOrgSubIds));
        return setResult;
    }

    private Set<Long> getDependSubOrgIds(List<DimValue> selfAndDependSub, Map<String, List<OrgInfo>> dimOrgMapWithHis, Long dependStructId, Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, Set<Long> setResult) {
        List<OrgInfo> dependStructAllOrgInfo = noAdminStructProjectOrgInfo.get(dependStructId);
        if (CollectionUtils.isEmpty(dependStructAllOrgInfo)) {
            return Sets.newHashSet();
        }
        List<OrgInfo> dimOrgInfo = this.filterDimOrgInfo(selfAndDependSub, dimOrgMapWithHis);
        HashSet dependOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgInfo orgInfo : dimOrgInfo) {
            this.getSubIdWithSelf(dependStructAllOrgInfo, orgInfo.getLongNumber(), setResult);
            dependOrgIds.add(orgInfo.getOrgTeamHisId());
        }
        return dependOrgIds;
    }

    private Set<Long> calcAllSelf(List<DimValue> allSelf, Map<String, List<OrgInfo>> dimOrgMapWithHis, Long structId, Long dependStructId, Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo) {
        Set<Long> dependDimValuesOrg;
        if (CollectionUtils.isEmpty(allSelf) || dimOrgMapWithHis == null || dimOrgMapWithHis.size() == 0) {
            return Sets.newHashSet();
        }
        Map<Long, Set<Long>> dimValuesOrgMap = this.getOrgIdMap(allSelf, dimOrgMapWithHis);
        if (dimValuesOrgMap == null || dimValuesOrgMap.size() == 0) {
            return Sets.newHashSet();
        }
        List<OrgInfo> structOrgInfo = noAdminStructProjectOrgInfo.get(structId);
        if (CollectionUtils.isEmpty(structOrgInfo)) {
            return Sets.newHashSet();
        }
        HashSet<Long> setResult = new HashSet<Long>(16);
        Set<Long> dimValuesOrg = dimValuesOrgMap.get(structId);
        if (CollectionUtils.isNotEmpty(dimValuesOrg)) {
            setResult.addAll(dimValuesOrg);
        }
        if (CollectionUtils.isNotEmpty(dependDimValuesOrg = dimValuesOrgMap.get(dependStructId))) {
            setResult.addAll(this.getLevel1SubId(structOrgInfo, dependDimValuesOrg));
        }
        return setResult;
    }

    private void getStructAllSubInfo(List<DimValue> orgSubAndOtSub, Map<String, List<OrgInfo>> dimOrgMapWithHis, Long structId, Map<Long, List<OrgInfo>> noAdminStructProjectOrgInfo, Set<Long> setResult) {
        if (dimOrgMapWithHis == null || dimOrgMapWithHis.isEmpty()) {
            return;
        }
        List<OrgInfo> structOrgInfo = noAdminStructProjectOrgInfo.get(structId);
        if (CollectionUtils.isEmpty(structOrgInfo)) {
            return;
        }
        for (DimValue dimValue : orgSubAndOtSub) {
            String orgId = dimValue.getDimVal();
            List<OrgInfo> dimOrgInfos = dimOrgMapWithHis.get(String.valueOf(orgId));
            if (CollectionUtils.isEmpty(dimOrgInfos)) continue;
            Set longNumberSet = dimOrgInfos.stream().map(orgInfo -> orgInfo.getLongNumber()).collect(Collectors.toSet());
            for (String dimLongNumber : longNumberSet) {
                if (StringUtils.isEmpty((String)dimLongNumber)) continue;
                this.getSubIdWithSelf(structOrgInfo, dimLongNumber, setResult);
            }
        }
    }

    private void getSubIdWithSelf(List<OrgInfo> structAllOrgInfo, String dimLongNumber, Set<Long> setResult) {
        if (StringUtils.isEmpty((String)dimLongNumber)) {
            return;
        }
        if (CollectionUtils.isEmpty(structAllOrgInfo)) {
            return;
        }
        for (OrgInfo orgInfo : structAllOrgInfo) {
            String longNumber = orgInfo.getLongNumber();
            if (longNumber == null || !longNumber.startsWith(dimLongNumber)) continue;
            setResult.add(orgInfo.getOrgTeamHisId());
        }
    }

    private Map<Long, Set<Long>> getOrgIdMap(List<DimValue> allSelf, Map<String, List<OrgInfo>> dimOrgMapWithHis) {
        HashMap dimValuesOrgMap = Maps.newHashMapWithExpectedSize((int)16);
        Set dimSet = allSelf.stream().map(dimValue -> dimValue.getDimVal()).collect(Collectors.toSet());
        for (Map.Entry<String, List<OrgInfo>> entry : dimOrgMapWithHis.entrySet()) {
            Long structProjectId;
            List<OrgInfo> orgInfoList;
            String key = entry.getKey();
            if (key == null || !dimSet.contains(key) || CollectionUtils.isEmpty(orgInfoList = entry.getValue()) || (structProjectId = orgInfoList.get(0).getStructProjectId()) == null || structProjectId == 0L) continue;
            Set dimValuesOrg = (Set)dimValuesOrgMap.get(structProjectId);
            if (CollectionUtils.isEmpty((Collection)dimValuesOrg)) {
                dimValuesOrg = Sets.newHashSetWithExpectedSize((int)16);
                dimValuesOrgMap.put(structProjectId, dimValuesOrg);
            }
            dimValuesOrg.addAll(orgInfoList.stream().map(orgInfo -> orgInfo.getOrgTeamHisId()).collect(Collectors.toSet()));
        }
        return dimValuesOrgMap;
    }

    private void buildAdminOrgAndSub(Long structId, List<DimValue> dimValues, Set<Long> setResult, Date effStartDate, Date effEndDate) {
        List<OrgInfo> dependStructOrgInfo = CalcPermAdminStructService.getInstance().buildAdminOrgInfo(dimValues, structId, PermissionConstants.ADMIN_STRUCT_PROJECT, effStartDate, effEndDate);
        Set adminOrgIds = dependStructOrgInfo.stream().map(orgInfo -> orgInfo.getOrgTeamHisId()).collect(Collectors.toSet());
        if (setResult == null) {
            setResult = Sets.newHashSetWithExpectedSize((int)16);
        }
        setResult.addAll(adminOrgIds);
    }

    private Set<String> getLevel1SubLongNumber(List<OrgInfo> structAllOrgInfo, Set<Long> dimOrgAndHisIds) {
        LinkedHashSet level1SubLongNumber = Sets.newLinkedHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dimOrgAndHisIds) || CollectionUtils.isEmpty(structAllOrgInfo)) {
            return level1SubLongNumber;
        }
        for (OrgInfo orgInfo : structAllOrgInfo) {
            Long parent = orgInfo.getParent();
            if (parent == null || parent == 0L || !dimOrgAndHisIds.contains(parent)) continue;
            level1SubLongNumber.add(orgInfo.getLongNumber());
        }
        return level1SubLongNumber;
    }

    private Set<Long> getLevel1SubId(List<OrgInfo> structAllOrgInfo, Set<Long> dimOrgAndHisIds) {
        HashSet level1Sub = Sets.newHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(dimOrgAndHisIds) || CollectionUtils.isEmpty(structAllOrgInfo)) {
            return level1Sub;
        }
        for (OrgInfo orgInfo : structAllOrgInfo) {
            Long parent = orgInfo.getParent();
            if (parent == null || parent == 0L || !dimOrgAndHisIds.contains(parent)) continue;
            level1Sub.add(orgInfo.getOrgTeamHisId());
        }
        return level1Sub;
    }

    private Set<Long> filterDimOrgId(List<DimValue> typeDimValues, Map<String, List<OrgInfo>> dimOrgMapWithHis) {
        HashSet dimOrg = Sets.newHashSetWithExpectedSize((int)16);
        for (DimValue dimValue : typeDimValues) {
            String strDimValue = dimValue.getDimVal();
            List<OrgInfo> dependStructOrgInfo = dimOrgMapWithHis.get(strDimValue);
            Set dependSet = dependStructOrgInfo.stream().map(info -> info.getOrgTeamHisId()).collect(Collectors.toSet());
            if (!CollectionUtils.isNotEmpty(dependSet)) continue;
            dimOrg.addAll(dependSet);
        }
        if (CollectionUtils.isEmpty((Collection)dimOrg)) {
            return Sets.newHashSet();
        }
        return dimOrg;
    }

    private List<OrgInfo> filterDimOrgInfo(List<DimValue> typeDimValues, Map<String, List<OrgInfo>> dimOrgMapWithHis) {
        ArrayList dimOrgInfo = Lists.newArrayListWithCapacity((int)10);
        for (DimValue dimValue : typeDimValues) {
            String strDimValue = dimValue.getDimVal();
            List<OrgInfo> dependStructOrgInfo = dimOrgMapWithHis.get(strDimValue);
            if (!CollectionUtils.isNotEmpty(dependStructOrgInfo)) continue;
            dimOrgInfo.addAll(dependStructOrgInfo);
        }
        if (CollectionUtils.isEmpty((Collection)dimOrgInfo)) {
            return Lists.newArrayList();
        }
        return dimOrgInfo;
    }

    private void addDimSelf(Set<Long> dimSubAndDependSelf, List<OrgInfo> structAllOrgInfo, Set<Long> setResult) {
        if (CollectionUtils.isEmpty(dimSubAndDependSelf)) {
            return;
        }
        Set structOrgIds = structAllOrgInfo.stream().map(info -> info.getOrgTeamHisId()).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(structOrgIds)) {
            for (Long orgId : dimSubAndDependSelf) {
                if (!structOrgIds.contains(orgId)) continue;
                setResult.add(orgId);
            }
        }
    }
}

